package dressing.ui.etagere;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

import dressing.controller.EtagereCreator;
import dressing.model.EtagereDistances;
import dressing.ui.util.SwtTextFilter;

public class EtagereCompositeSecondPage extends Composite {

	public static final String NAME = "Name";
	public EtagereCreator etgCreator = null;
	public static final String Distance = "Distance";
	public static final String[] PROPS = { NAME, Distance };
	private Table table;
	private TableViewer tableViewer;
	PropertyChangeListener pcl;

	public EtagereCreator getEtgCreator() {
		return etgCreator;
	}

	public void setEtgCreator(EtagereCreator etgCreator) {
		this.etgCreator = etgCreator;
	}

	/**
	 * Create the composite.
	 * 
	 * @param parent
	 * @param style
	 */

	
public EtagereCompositeSecondPage(Composite parent, int style, EtagereCreator etg) {
	super(parent, style);
	setEtgCreator(etg);
	initTable();
	//
	pcl = new PropertyChangeListener() {

		@Override
		public void propertyChange(PropertyChangeEvent evt) {

			if (evt.getPropertyName() == "etagerecount") {
				etgCreator.getListDistance().clear();
				for (int i = 0; i < etgCreator.getEtagerecount(); i++) {
					etgCreator.getListDistance().add(new EtagereDistances("Etagere" + i,  100.0));
				}		
				tableViewer.refresh();
				/**
				 * ce method creer a pour résans à trigerer un virtuelle propertychange 
				 * pour forcer tout listener a faire le calcul a nouveau 
				 * 
				 */
				etgCreator.trigerChangeCalculation();
			}

		}
	};
	etgCreator.addPropertyChangeListener(pcl);
	//

	}
	private void initTable()
	{
		setLayout(new GridLayout(1, false));
		tableViewer = new TableViewer(this, SWT.BORDER | SWT.FULL_SELECTION);
		tableViewer.setContentProvider(new DisatancesContentProvider());
		tableViewer.setLabelProvider(new DistancesLabelProvider());
		tableViewer.setInput(this.etgCreator.getListDistance());
		table = tableViewer.getTable();
		GridData gd_table = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		gd_table.widthHint = 235;
		table.setLayoutData(gd_table);
	    TableColumn tblClmn=   new TableColumn(table, SWT.CENTER);
	    tblClmn.setText(NAME);
	    tblClmn.setWidth(300);
	    TableColumn tblClmn1=  new TableColumn(table, SWT.CENTER);
	    tblClmn1.setText(Distance);
	    tblClmn1.setWidth(300);
		for (int i = 0, n = table.getColumnCount(); i < n; i++) {
			table.getColumn(i).pack();
		}

		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		tableViewer.refresh();

		CellEditor[] editors = new CellEditor[2];
		editors[0] = new TextCellEditor(table);
		editors[1] = new TextCellEditor(table);
		/**
		 * add a listener to the control of the editor with verify flag give us he ability to control it as a textfield 
		 */
	    editors[1].getControl().addListener(SWT.Verify, new Listener() {
			
			@Override
			public void handleEvent(Event event) {
				SwtTextFilter.ASDOUBLE(editors[1].getControl(), event);
				
			}
		});
	    //
		tableViewer.setColumnProperties(PROPS);
		tableViewer.setCellModifier(new DistancesCellModifier(tableViewer));
		tableViewer.setCellEditors(editors);
	
	}
	public EtagereCompositeSecondPage(Composite parent, int style) {
		super(parent, style);

		

	}

	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}
	public void clearlistners() {
		etgCreator.removePropertyChangeListener(pcl);
	}
}

class DisatancesContentProvider implements IStructuredContentProvider {
	/**
	 * Returns the Person objects
	 */
	public Object[] getElements(Object inputElement) {
		return ((List) inputElement).toArray();
	}
}

/**
 * This class provides the content for the FoodList application
 */
class DistancesCellModifier implements ICellModifier {
	private TableViewer viewer;

	public DistancesCellModifier(TableViewer viewer) {
		this.viewer = viewer;
	}

	/**
	 * Returns whether the property can be modified
	 * 
	 * @param element
	 *            the element
	 * @param property
	 *            the property
	 * @return boolean
	 */
	public boolean canModify(Object element, String property) {
		// Allow editing of all values
		return true;
	}

	/**
	 * Returns the value for the property
	 * 
	 * @param element
	 *            the element
	 * @param property
	 *            the property
	 * @return Object
	 */
	public Object getValue(Object element, String property) {
		if (element instanceof Item)
			element = ((Item) element).getData();
		EtagereDistances e = (EtagereDistances) element;
		if (EtagereCompositeSecondPage.NAME.equals(property))
			return e.getEtagereNom();
		else if (EtagereCompositeSecondPage.Distance.equals(property))
			return (e.getEtagereDistance().toString());

		else
			return null;
	}

	/**
	 * Modifies the element
	 * 
	 * @param element
	 *            the element
	 * @param property
	 *            the property
	 * @param value
	 *            the value
	 */
	public void modify(Object element, String property, Object value) {
		if (element instanceof Item)
			element = ((Item) element).getData();

		EtagereDistances e = (EtagereDistances) element;
		if (EtagereCompositeSecondPage.NAME.equals(property))
			e.setEtagereNom((String) value);
		else if (EtagereCompositeSecondPage.Distance.equals(property))
		{
			try {
				e.setEtagereDistance((Double.parseDouble((String) value)));
//				
			}catch(NumberFormatException ex)
			{
				System.out.println("Le nombre entrer est incorrect");
			}
		}
		// Force the viewer to refresh
		viewer.refresh();
		
	}
}

class DistancesLabelProvider implements ITableLabelProvider {
	/**
	 * Returns the image
	 * 
	 * @param element
	 *            the element
	 * @param columnIndex
	 *            the column index
	 * @return Image
	 */
	public Image getColumnImage(Object element, int columnIndex) {
		return null;
	}

	/**
	 * Returns the column text
	 * 
	 * @param element
	 *            the element
	 * @param columnIndex
	 *            the column index
	 * @return String
	 */
	public String getColumnText(Object element, int columnIndex) {
		EtagereDistances p = (EtagereDistances) element;
		switch (columnIndex) {
		case 0:
			return p.getEtagereNom();
		case 1:
			return p.getEtagereDistance().toString();

		}
		return null;
	}

	/**
	 * Adds a listener
	 * 
	 * @param listener
	 *            the listener
	 */
	public void addListener(ILabelProviderListener listener) {
		// Ignore it
	}

	/**
	 * Disposes any created resources
	 */
	public void dispose() {
		// Nothing to dispose
	}

	/**
	 * Returns whether altering this property on this element will affect the label
	 * 
	 * @param element
	 *            the element
	 * @param property
	 *            the property
	 * @return boolean
	 */
	public boolean isLabelProperty(Object element, String property) {
		return false;
	}

	/**
	 * Removes a listener
	 * 
	 * @param listener
	 *            the listener
	 */
	public void removeListener(ILabelProviderListener listener) {
		// Ignore
	}
}
