package dressing.ui.dressing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

import dressing.controller.DressingCreator;
import dressing.model.DesignException;
import dressing.model.Dressing;
import dressing.model.evalutor.GeometricEngineException;

public class DressingWelcomePage extends WizardPage{

	DressingCreator dress ;
	PropertyChangeListener pcl;
	boolean errorfound=false;
	protected DressingWelcomePage(String pageName,DressingCreator dress) {
		super(pageName);
		this.dress = dress;
		setTitle("Créer un nouveau dressing");
		setDescription("Veuillez renseigner les propriétés de votre dressing");		
		// TODO Auto-generated constructor stub
	}


	@Override
	public void createControl(Composite parent) {
		// TODO Auto-generated method stub
		DressingCompositeWizard compo1 = new DressingCompositeWizard(parent, SWT.NONE,dress,UpdateValueStrategy.POLICY_UPDATE);
		setControl(compo1);
		pcl = new PropertyChangeListener() {
			
			@Override
			public void propertyChange(PropertyChangeEvent evt) {
				// TODO Auto-generated method stub
				if(!evt.getPropertyName().startsWith("project.")) //seulemnt les proprietes de javabean
				{
					try {						
						dress.create();
						setErrorMessage(null);	
						errorfound = false;
						setMessage("Vous pouvez ajouter votre dressing est specifier les caisson apr�s", WizardPage.INFORMATION);
					} catch (DesignException  | GeometricEngineException e) {
						setErrorMessage(e.getMessage());	
						errorfound = true;
					}
					getWizard().getContainer().updateButtons();
				}

			}
		};
		dress.addPropertyChangeListener(pcl);
	}
@Override
public boolean isPageComplete() {
	// TODO Auto-generated method stub
	boolean b = !errorfound;
	return b;
}
public void clearlistners() {
	dress.removePropertyChangeListener(pcl);
}
}
