package dressing.ui.caissonciosine;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;

import javax.inject.Inject;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.window.WindowManager;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

import dressing.controller.CaissonCuisineCreator;
import dressing.controller.EtagereCreator;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.ModelProvider;
import dressing.model.Space3D;
import dressing.model.evalutor.GeometricEngineException;
import dressing.ui.etagere.EtagereWizardSecondPage;
import dressing.ui.etagere.EtagereWizardWelcomePage;

public class CaissonCuisineDialog extends Dialog {
	
	CaissonCuisineCreator caisson=new CaissonCuisineCreator();
	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	Space3D space3d;
	Button OkButton;
	PropertyChangeListener pcl;
//	private TableComboViewer tableComboViewerBaseMaterial;
//	private TableComboViewer tableComboViewerBackMaterial;
//	ModelProvider modelProvider=new ModelProvider();
//	
//	private DataBindingContext m_bindingContext;
//	Text Name;
//	Label lblBaseMaterial;
//	Label lblBackMaterial;
//	Spinner longeur;
//	Spinner hauteur;
//	Spinner profondeur;
//	Button btniswithdos;
//	@Inject
//	IEclipseContext  eclipsecontext;
//	
	
	public Space3D getSpace3d() {
		return space3d;
	} @Override
    public void create() {
        super.create();
//        setTitle("caisson cuisine");
//        setMessage("This is a TitleAreaDialog", IMessageProvider.INFORMATION);
        getBlockedHandler();
     
    }

	public void setSpace3d(Space3D space3d) {
		this.space3d = space3d;
		caisson.setParent((DesignObject3D) space3d);
	}
	public CaissonCuisineDialog(Shell parentShell) {
		super(parentShell);
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		  Composite area = (Composite) super.createDialogArea(parent);
		CaissonCuisineDialogComposite container = new CaissonCuisineDialogComposite(area,SWT.BORDER,caisson) ;
		
		pcl = new PropertyChangeListener() {

			@Override
			public void propertyChange(PropertyChangeEvent evt) {
				// TODO Auto-generated method stub
				if (!evt.getPropertyName().startsWith("project.")) // seulemnt les proprietes de javabean
				{
					try {
					

						
						
						if(space3d!= null)
						caisson.setParent((DesignObject3D) space3d);
						caisson.create();
//						space3d.addElement(caisson.getCaissonInstance());
//						super.setErrorMessage(null);
//						setMessage("Vous pouvez ajouter vos Caisson cuisine", WizardPage.INFORMATION);
						getOKButton().setEnabled(true);
					} catch (DesignException | GeometricEngineException e) {
//				        setErrorMessage(e.getMessage());
						System.out.println(e.getMessage());
						getOKButton().setEnabled(true);
					}
				
				}

			}
		};
		caisson.addPropertyChangeListener(pcl);
		return container;
	}

	
	/**
	 * Create contents of the button bar.
	 * @param parent
	 */


	/**
	 * Return the initial size of the dialog.
	 */
	 @Override
	    protected void configureShell(Shell newShell) {
	        super.configureShell(newShell);
	        newShell.setText("Selection dialog");
	    }

	    @Override
	    protected Point getInitialSize() {
	        return new Point(450, 300);
	    }
	@Override
	protected Button getOKButton() {
		// TODO Auto-generated method stub
		return super.getOKButton();
	}

	@Override
	protected void okPressed() {
		// TODO Auto-generated method stub
		try {
			

			
			
			if(space3d!= null)
			caisson.setParent((DesignObject3D) space3d);
			caisson.create();
			space3d.addElement(caisson.getCaissonInstance());
//			super.setErrorMessage(null);
//			setMessage("Vous pouvez ajouter vos Caisson cuisine", WizardPage.INFORMATION);
			getOKButton().setEnabled(true);
		} catch (DesignException | GeometricEngineException e) {
//	        setErrorMessage(e.getMessage());
			getOKButton().setEnabled(true);
			System.out.println(e.getMessage());
		}
	
	}

	

}
