package dressing.model;

import dressing.model.debitage.BandeDebitageFormulas;
import dressing.model.debitage.DebitageFormulas;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.BandeType;

public class Bande extends Piece2D {
	CaissonCuisine parentCaissonCuisine;
	BandeType bandeType;
	
	
	public Bande(CaissonCuisine parentspace) {
		super();
		this.parentCaissonCuisine = parentspace;
	}

	public Bande() {
		// TODO Auto-generated constructor stub
	}

	public Space3D getParentspace() {
		return parentCaissonCuisine;
	}
	
	public void setParentspace(CaissonCuisine parentspace) {
		Space3D oldValue=this.parentCaissonCuisine;
		this.parentCaissonCuisine = parentspace;
		firePropertyChange("parentspace", oldValue,parentspace);	
	}
	
	
	public CaissonCuisine getParentCaissonCuisine() {
		return parentCaissonCuisine;
	}

	public void setParentCaissonCuisine(CaissonCuisine parentCaissonCuisine) {
		Space3D oldValue=this.parentCaissonCuisine;
		this.parentCaissonCuisine = parentCaissonCuisine;
		firePropertyChange("parentCaissonCuisine", oldValue,parentCaissonCuisine);	
	}

	public BandeType getBandeType() {
		return bandeType;
	}

	public void setBandeType(BandeType bandeType) {
		BandeType oldValue=this.bandeType;
		this.bandeType = bandeType;
		firePropertyChange("bandeType", oldValue,bandeType);	
	}
	
	@Override
	public DesignObject3D clone() {
		Bande space=new Bande();
		try {
			space=(Bande) this.copy(space);
		} catch (DesignException | GeometricEngineException | CloneNotSupportedException e) {
			e.printStackTrace();
		}
		return space;
	}
	@Override
	public DesignObject3D copy(DesignObject3D object) throws DesignException, GeometricEngineException, CloneNotSupportedException {
		Bande bande=(Bande) object;
		bande=(Bande) super.copy(bande);
		bande.setBandeType(getBandeType());		
		return bande;
	}
	
	
	@Override
	public DebitageFormulas getDebitageFormulas() {
		if(formulas==null|| !(formulas instanceof BandeDebitageFormulas)) {
			formulas = new BandeDebitageFormulas();
		}
		return formulas; 
	}
}
