package dressing.handlers;

import java.io.File;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

import dressing.config.WorkspaceConfiguration;
import dressing.io.IOUtilities;
import dressing.model.ProjectManager;
import dressing.model.SuperCadProject;

public class importSurpercadProjectHandler {

	@Execute
	public void execute(Shell shell) {
		FileDialog dialog = new FileDialog(shell, SWT.OPEN);
		dialog.setFilterExtensions(new String[] { "*.cad" });
		Preferences preferences = InstanceScope.INSTANCE.getNode("com.dressing");
		Preferences projectpref = preferences.node("SuperCadProject");
		String defaultpath = projectpref.get("SaveAsdirectory", System.getProperty("user.home") + File.separator + "Desktop");
		String dirpath = projectpref.get("directoryread", defaultpath);

		dialog.setFilterPath(dirpath);
		String filepath = dialog.open();
		if (filepath != null && !filepath.isEmpty()) {
			File f = new File(filepath);
			SuperCadProject currentProject = ProjectManager.getManager().getCurrentProject();
			if(currentProject!=null) {
				int answer=MessageDialog.open(MessageDialog.QUESTION_WITH_CANCEL, null, "Confirmation", "Vous les vous enregistrer le projet courant",SWT.NONE , "Oui","Non","Annuler");
				if(answer==0)
				{
					ProjectManager.getManager().saveProject(currentProject,false,false);
				}
				if(answer==2)
				{
					return;
				}
			}
			try {
				String projectName = f.getName();
				int indexextension = projectName.indexOf(".cad");
				if (indexextension > 0) {
					projectName = projectName.substring(0, indexextension);
				}
				String tmpfolder = WorkspaceConfiguration.getProjectsPath() + File.separator + "tmp";
				File fTmpFolder = new File(tmpfolder);
				if (!fTmpFolder.exists()) {
					fTmpFolder.mkdirs();
					System.err.println(fTmpFolder.setExecutable(true));
					System.err.println(fTmpFolder.setReadable(true));
					System.err.println(fTmpFolder.setWritable(true, false));
				}
				String path = tmpfolder + File.separator + projectName;
				File f1 = new File(path);
				if(f1.exists())
				{
					IOUtilities.deleteFolder(f1);
				}
				String DestfilePath = WorkspaceConfiguration.getProjectsPath() ;
				IOUtilities.UnzipFile(filepath, tmpfolder);
				System.err.println("exist "+f1.exists());
					
				String rootDir= WorkspaceConfiguration.getProjectsPath()+ File.separator +projectName;
				File frootDir = new File(rootDir);
				if(frootDir.exists())
				{
					IOUtilities.deleteFolder(frootDir);
				}
				SuperCadProject project=ProjectManager.getManager().readProjectfromDisk(path);
				if(project!=null) {
					project.setProjectDirectory(path);
					ProjectManager.getManager().addProject(project);	
					ProjectManager.getManager().setCurrentProject(project, true);
					
					project.setProjectDirectory(rootDir);

//					boolean resultat = f1.renameTo(new File(DestfilePath, f1.getName()));
					File tmpFilepath=new File(path);
					if(tmpFilepath.exists()) {
						IOUtilities.deleteFolder(tmpFilepath);

					}
					MessageDialog.openInformation(shell,"Succèes", "La projet est créer avec succèes");

				}else {
					MessageDialog.openError(shell,"Projet endommagée ", "La projet selectionner est endommagée ou créer avec la version 1.0\n essayer d'ouvrir avec la version 1.0");

				}
				
			} catch (Exception e) {
				e.printStackTrace();
				MessageDialog.openError(shell,"Projet endommagée ", "La projet selectionner est endommagée ou créer avec la version 1.0 \n essayer d'ouvrir avec la version 1.0");
			}
			
			dirpath = f.getParent();
			projectpref.put("directoryread", dirpath);
			try {
				projectpref.flush();
			} catch (BackingStoreException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
	}

	@CanExecute
	public boolean check() {
		
		return true;
	}

}
