package internal;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.lwjgl.opengl.GL45;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

import api.backend.ApplicationContext;
import api.backend.SWTGLApplication;
import api.input.InputMultiplexer;
import api.input.KeyboardEventHandler;
import api.mep.EditorScene;
import api.provider.ModelProvider;
import api.ui.MepEditorComposite;
import api.ui.RightClickMenuManager;


public class StandAlonelauncher {
	
	private EditorScene scene;
	
	public void activate() {
		String path = "C:\\ProgramData\\supercad\\projects\\test handler 2\\3d plumbing scene";
		activate(path);
	}

	public void activate(String path) {
		
		ModelProvider.getProvider();
	
		Display display = new Display();
		Shell shell = new Shell(display);
		shell.setSize(1024, 1024 * 9/16);
        shell.setLayout(new FillLayout());
		shell.setText("mep standalone");
		MepEditorComposite editor = new MepEditorComposite(shell);
		RightClickMenuManager.getManager().create(shell);
		scene = new EditorScene();
		SWTGLApplication app = new SWTGLApplication(editor.getCanvas(), scene);
		KeyboardEventHandler ekeyboardEventHandler = new KeyboardEventHandler() {
			
			@Override
			public boolean keyReleased(KeyEvent e) {
				switch (e.character) {
				case 'f':
					scene.setMode(GL45.GL_FILL);
					break;
				case 'l':
					scene.setMode(GL45.GL_LINE);
					break;
					default:
						break;
				}
				return false;
			}
			
			@Override
			public boolean keyPressed(KeyEvent e) {
				// TODO Auto-generated method stub
				return false;
			}
		};
		InputMultiplexer.getInstance().insertEventHandler(ekeyboardEventHandler, 0);
		ApplicationContext.setApplication(app);
		scene.loadScene(path);
		shell.open();

		while(!shell.isDisposed()) {
			display.readAndDispatch();
		}
		
		
	}

	public EditorScene getScene() {
		return scene;
	}

	public void setScene(EditorScene scene) {
		this.scene = scene;
	}
	
	

}
