package api.provider;

import com.sandmonkey.ttf_renderer.api.FreeTypeFont;
import com.sandmonkey.ttf_renderer.api.FreeTypeLoader;

public class FontProvider {
	
	private FreeTypeFont smallFont;
	private FreeTypeFont mediumFont;
	private FreeTypeFont largeFont;
	private static FontProvider provider;
	
	private FontProvider() {
		load();
	}

	public void load() {
		String fontPath = "Roboto\\Roboto-Light.ttf";
		smallFont = FreeTypeLoader.getLoader().load(fontPath, 11);
		mediumFont = FreeTypeLoader.getLoader().load(fontPath, 18);
		largeFont = FreeTypeLoader.getLoader().load(fontPath, 24);
	}

	public static FontProvider getProvider() {
		if(provider == null)
			provider = new FontProvider();
		return provider;
	}

	public FreeTypeFont getSmallFont() {
		return smallFont;
	}

	public FreeTypeFont getMediumFont() {
		return mediumFont;
	}

	public FreeTypeFont getLargeFont() {
		return largeFont;
	}
	
	
	
}
