package dressing.ui.util;

import static org.eclipse.swt.events.SelectionListener.widgetSelectedAdapter;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

import gdxapp.assets.AssetsTextures;

public class OpenWizardDialog extends WizardDialog {

	
	public OpenWizardDialog(Shell parentShell, IWizard newWizard) {
		super(parentShell, newWizard);
		newWizard.setContainer(this);
		setDefaultImage(AssetsTextures.getInstance().getSuperCadLogo());
	}

	
	@Override
	public Button getButton(int id) {
		return super.getButton(id);
	}
	
	public void updateButtonsLabels() {
		
		Control ctrl = super.getButtonBar();
		ctrl.getBackground();
		Button next = getButton(IDialogConstants.NEXT_ID);
		Button previous = getButton(IDialogConstants.BACK_ID);
		Button finish = getButton(IDialogConstants.FINISH_ID);
		Button cancel = getButton(IDialogConstants.CANCEL_ID);
		if(next != null)
			next.setText("Suivant");
		if(previous != null)
			previous.setText("Précedent");
		if(finish != null)
			finish.setText("Terminer");
		if(cancel != null)
			cancel.setText("Annuler");
	}


	@Override
	public void updateButtons() {
		super.updateButtons();
		updateButtonsLabels();
	}
	
	
	
	
	
	
	
	
	


	
	
}
