package dressing.ui.separator;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.wb.swt.SWTResourceManager;

import dressing.controller.Piece2DCreator;
import dressing.model.Chant;
import dressing.model.DesignException;
import dressing.model.IUpdateStructure;
import dressing.model.ModelProvider;
import dressing.model.Separator;
import dressing.model.types.PositionCalculationType;
import dressing.model.types.PositionReferenceType;
import dressing.model.types.SeprationAxe;
import dressing.ui.util.SwtTextFilter;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Spinner;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Button;

public class SeparatorCompositeEditor extends Composite implements IUpdateStructure {
	private DataBindingContext m_bindingContext;
	private Text wornZone;
	private Text txtSepName;
	private Separator separator = null;
	private int updatestragey = UpdateValueStrategy.POLICY_UPDATE;
	private Label lblName;
	private Combo comboRefPos;
	private Spinner spnposhorizontal;
	private Spinner spnposverticale;
	private Spinner spnposinterieur;
	private Spinner spnlongpiece;
	private Spinner spnlargeurpiece;
	private ComboViewer comboViewerRefPos;
	private Spinner spEpaisseur;
	private TabFolder tabFolder;
	private TabItem Mesure;
	private Composite composite;
	private Composite composite_1;
	private TabItem Acceuil;
	private MDirtyable dirty;
	ControlDecoration deco;
	private Combo combosepAxe;
	private ComboViewer comboViewersepAxe;
	private Spinner spinnerseppos;
	private Button btnSparateur;
	PropertyChangeListener pcl2;
	private Label lblRetrait;
	private Spinner spnretrait;
	private Label lblTypeDePodition;
	private Combo combo;
	private ComboViewer comboViewer;
	private Label lblRetraitDeriere;
	private Spinner spnRetraitDeriere;
	private TabItem tbtmNewItem;
	private Composite composite_2;
	private Label lblPiece;
	private Label lblNewLabel;
	private Label lblNewLabel_1;
	private Label lblNewLabel_2;
	private Label lblNewLabel_3;
	private Label lblNewLabel_4;
	private Combo combo_Chant1;
	private ComboViewer comboViewerChant1;
	private Combo combo_Chant2;
	private ComboViewer comboViewerChant2;
	private Combo combo_Chant3;
	private ComboViewer comboViewerChant3;
	private Combo combo_Chant4;
	private ComboViewer comboViewerChant4;
	private Label lbllongChant1;
	private Label lbllongChant2;
	private Label lbllongChant3;
	private Label lbllongChant4;
	public SeparatorCompositeEditor(Composite parent, int style, Separator newseparator, int updatestrategy) {
		this(parent, style);
		this.updatestragey = updatestrategy;
		this.setSeparator(newseparator);
		if (separator != null) {
			m_bindingContext = initDataBindings();
			userdatabinding();
		}
	}

	/**
	 * Create the composite.
	 * 
	 * @param parent
	 * @param style
	 */
	public SeparatorCompositeEditor(Composite parent, int style) {
		super(parent, style);
		setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_BACKGROUND_GRADIENT));
		setLayout(new GridLayout(2, false));

		Label lblSparateur = new Label(this, SWT.NONE);
		GridData gd_lblSparateur = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_lblSparateur.widthHint = 122;
		lblSparateur.setLayoutData(gd_lblSparateur);
		lblSparateur.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_BACKGROUND_GRADIENT));
		lblSparateur.setFont(SWTResourceManager.getFont("Segoe UI", 16, SWT.NORMAL));
		lblSparateur.setText("Séparateur");
		
				wornZone = new Text(this, SWT.BORDER);
				GridData gd_wornZone = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
				gd_wornZone.heightHint = 49;
				gd_wornZone.widthHint = 282;
				wornZone.setLayoutData(gd_wornZone);
				wornZone.setFont(SWTResourceManager.getFont("Times New Roman", 10, SWT.NORMAL));
				wornZone.setForeground(SWTResourceManager.getColor(SWT.COLOR_RED));
				wornZone.setBackground(SWTResourceManager.getColor(SWT.COLOR_YELLOW));

		tabFolder = new TabFolder(this, SWT.NONE);
		tabFolder.setFont(SWTResourceManager.getFont("Segoe UI", 9, SWT.NORMAL));
		GridData gd_tabFolder = new GridData(SWT.LEFT, SWT.CENTER, false, false, 2, 1);
		gd_tabFolder.heightHint = 243;
		gd_tabFolder.widthHint = 432;
		tabFolder.setLayoutData(gd_tabFolder);

		Acceuil = new TabItem(tabFolder, SWT.NONE);
		Acceuil.setText("Acceuil");

		composite = new Composite(tabFolder, SWT.NONE);
		Acceuil.setControl(composite);
		composite.setLayout(new GridLayout(2, false));

		lblName = new Label(composite, SWT.NONE);
		GridData gd_lblName = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_lblName.widthHint = 72;
		lblName.setLayoutData(gd_lblName);
		lblName.setBackground(SWTResourceManager.getColor(SWT.COLOR_LIST_BACKGROUND));
		lblName.setText("Nom");

		txtSepName = new Text(composite, SWT.BORDER);
		GridData gd_txtSepName = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_txtSepName.widthHint = 285;
		txtSepName.setLayoutData(gd_txtSepName);

		Label lblNewLabel = new Label(composite, SWT.NONE);
		lblNewLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		lblNewLabel.setText("Axe de séparation");
		
		comboViewersepAxe = new ComboViewer(composite, SWT.NONE);
		combosepAxe = comboViewersepAxe.getCombo();
		combosepAxe.setEnabled(false);
		combosepAxe.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		comboViewersepAxe.setContentProvider((ArrayContentProvider.getInstance()));
		comboViewersepAxe.setInput(SeprationAxe.values());
		Label lblNewLabel_1 = new Label(composite, SWT.NONE);
		lblNewLabel_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_1.setBackground(SWTResourceManager.getColor(SWT.COLOR_LIST_BACKGROUND));
		lblNewLabel_1.setText("Référence de position");

		comboViewerRefPos = new ComboViewer(composite, SWT.NONE);
		comboRefPos = comboViewerRefPos.getCombo();
		GridData gd_comboRefPos = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_comboRefPos.widthHint = 258;
		comboRefPos.setLayoutData(gd_comboRefPos);
		comboViewerRefPos.setContentProvider((ArrayContentProvider.getInstance()));
		comboViewerRefPos.setInput(PositionReferenceType.values());
		Label lblNewLabel_2 = new Label(composite, SWT.NONE);
		lblNewLabel_2.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_2.setBackground(SWTResourceManager.getColor(SWT.COLOR_LIST_BACKGROUND));
		lblNewLabel_2.setText("Position");
		
		spinnerseppos = new Spinner(composite, SWT.BORDER);
		spinnerseppos.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spinnerseppos.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		spinnerseppos.setMaximum(100000);
		
		lblTypeDePodition = new Label(composite, SWT.NONE);
		lblTypeDePodition.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblTypeDePodition.setText("Type de podition");
		
		comboViewer = new ComboViewer(composite, SWT.READ_ONLY);
		combo = comboViewer.getCombo();
		combo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		comboViewer.setContentProvider((ArrayContentProvider.getInstance()));
		comboViewer.setInput(PositionCalculationType.values());
		
		
		lblRetrait = new Label(composite, SWT.NONE);
		lblRetrait.setText("Retrait depuis facade");
		
		spnretrait = new Spinner(composite, SWT.BORDER);
		spnretrait.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spnretrait.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		spnretrait.setMaximum(100000);
		
		lblRetraitDeriere = new Label(composite, SWT.NONE);
		lblRetraitDeriere.setText("Retrait Deriere");
		
		spnRetraitDeriere = new Spinner(composite, SWT.BORDER);
		spnRetraitDeriere.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spnRetraitDeriere.setMaximum(50000);
		btnSparateur = new Button(composite, SWT.CHECK);
		btnSparateur.setText("Séparateur 50%");
		new Label(composite, SWT.NONE);
		Mesure = new TabItem(tabFolder, SWT.NONE);
		Mesure.setText("Mesure");

		composite_1 = new Composite(tabFolder, SWT.NONE);
		Mesure.setControl(composite_1);
		composite_1.setLayout(new GridLayout(2, false));
		Label lblEpaisseur = new Label(composite_1, SWT.NONE);
		lblEpaisseur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblEpaisseur.setBackground(SWTResourceManager.getColor(SWT.COLOR_LIST_BACKGROUND));
		lblEpaisseur.setText("Epaisseur");

		spEpaisseur = new Spinner(composite_1, SWT.BORDER | SWT.READ_ONLY);
		spEpaisseur.setEnabled(false);
		spEpaisseur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		
		spEpaisseur.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		spEpaisseur.setMaximum(100000);
		Label lblPositionHorizontale = new Label(composite_1, SWT.NONE);
		lblPositionHorizontale.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblPositionHorizontale.setBackground(SWTResourceManager.getColor(SWT.COLOR_LIST_BACKGROUND));
		lblPositionHorizontale.setText("Position horizontale");

		spnposhorizontal = new Spinner(composite_1, SWT.BORDER | SWT.READ_ONLY);
		spnposhorizontal.setEnabled(false);
		GridData gd_spnposhorizontal = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_spnposhorizontal.widthHint = 281;
		spnposhorizontal.setLayoutData(gd_spnposhorizontal);
		spnposhorizontal.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		spnposhorizontal.setMaximum(100000);
		Label lblNewLabel_3 = new Label(composite_1, SWT.NONE);
		lblNewLabel_3.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_3.setBackground(SWTResourceManager.getColor(SWT.COLOR_LIST_BACKGROUND));
		lblNewLabel_3.setText("Position verticale");

		spnposverticale = new Spinner(composite_1, SWT.BORDER | SWT.READ_ONLY);
		spnposverticale.setEnabled(false);
		spnposverticale.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spnposverticale.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		spnposverticale.setMaximum(100000);
		Label lblNewLabel_4 = new Label(composite_1, SWT.NONE);
		lblNewLabel_4.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_4.setBackground(SWTResourceManager.getColor(SWT.COLOR_LIST_BACKGROUND));
		lblNewLabel_4.setText("Position interieur");

		spnposinterieur = new Spinner(composite_1, SWT.BORDER | SWT.READ_ONLY);
		spnposinterieur.setEnabled(false);
		spnposinterieur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spnposinterieur.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		spnposinterieur.setMaximum(100000);
		Label lblNewLabel_5 = new Label(composite_1, SWT.NONE);
		lblNewLabel_5.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_5.setBackground(SWTResourceManager.getColor(SWT.COLOR_LIST_BACKGROUND));
		lblNewLabel_5.setText("Longeur pièce");

		spnlongpiece = new Spinner(composite_1, SWT.BORDER | SWT.READ_ONLY);
		spnlongpiece.setEnabled(false);
		spnlongpiece.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spnlongpiece.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		spnlongpiece.setMaximum(100000);
		Label lblNewLabel_6 = new Label(composite_1, SWT.NONE);
		lblNewLabel_6.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_6.setBackground(SWTResourceManager.getColor(SWT.COLOR_LIST_BACKGROUND));
		lblNewLabel_6.setText("Largeur pièce4");

		spnlargeurpiece = new Spinner(composite_1, SWT.BORDER | SWT.READ_ONLY);
		spnlargeurpiece.setEnabled(false);
		spnlargeurpiece.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spnlargeurpiece.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		spnlargeurpiece.setMaximum(100000);
		new Label(this, SWT.NONE);
		tbtmNewItem = new TabItem(tabFolder, SWT.NONE);
		tbtmNewItem.setText("Chants");

		composite_2 = new Composite(tabFolder, SWT.NONE);
		tbtmNewItem.setControl(composite_2);
		composite_2.setLayout(new GridLayout(3, false));

		lblNewLabel_1 = new Label(composite_2, SWT.NONE);
		GridData gd_lblNewLabel_1 = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_lblNewLabel_1.widthHint = 61;
		lblNewLabel_1.setLayoutData(gd_lblNewLabel_1);
		lblNewLabel_1.setText("Chant 1");

		comboViewerChant1 = new ComboViewer(composite_2, SWT.READ_ONLY);
		combo_Chant1 = comboViewerChant1.getCombo();
		combo_Chant1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		comboViewerChant1.setLabelProvider(new LabelProvider() {
		     @Override
		     public String getText(Object element) {
		         if (element instanceof Chant) {
		        	 Chant chnt = (Chant) element;
		             return chnt.getName();
		         }
		         return super.getText(element);
		     }
		 });
		comboViewerChant1.setContentProvider((ArrayContentProvider.getInstance()));
		comboViewerChant1.setInput(ModelProvider.getListChant());
		
		lbllongChant1 = new Label(composite_2, SWT.NONE);
		lblNewLabel_2 = new Label(composite_2, SWT.NONE);
		lblNewLabel_2.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_2.setText("Chant 2");

		comboViewerChant2 = new ComboViewer(composite_2, SWT.READ_ONLY);
		combo_Chant2 = comboViewerChant2.getCombo();
		combo_Chant2.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		comboViewerChant2.setLabelProvider(new LabelProvider() {
		     @Override
		     public String getText(Object element) {
		         if (element instanceof Chant) {
		        	 Chant chnt = (Chant) element;
		             return chnt.getName();
		         }
		         return super.getText(element);
		     }
		 });
		comboViewerChant2.setContentProvider((ArrayContentProvider.getInstance()));
		comboViewerChant2.setInput(ModelProvider.getListChant());
		
		lbllongChant2 = new Label(composite_2, SWT.NONE);
		lblNewLabel_3 = new Label(composite_2, SWT.NONE);
		lblNewLabel_3.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_3.setText("Chant 3");

		comboViewerChant3 = new ComboViewer(composite_2, SWT.READ_ONLY);
		combo_Chant3 = comboViewerChant3.getCombo();
		combo_Chant3.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		comboViewerChant3.setLabelProvider(new LabelProvider() {
		     @Override
		     public String getText(Object element) {
		         if (element instanceof Chant) {
		        	 Chant chnt = (Chant) element;
		             return chnt.getName();
		         }
		         return super.getText(element);
		     }
		 });
		comboViewerChant3.setContentProvider((ArrayContentProvider.getInstance()));
		comboViewerChant3.setInput(ModelProvider.getListChant());
		
		lbllongChant3 = new Label(composite_2, SWT.NONE);
		lblNewLabel_4 = new Label(composite_2, SWT.NONE);
		lblNewLabel_4.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_4.setText("Chant 4");

		comboViewerChant4 = new ComboViewer(composite_2, SWT.READ_ONLY);
		combo_Chant4 = comboViewerChant4.getCombo();
		combo_Chant4.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		lbllongChant4 = new Label(composite_2, SWT.NONE);
		comboViewerChant4.setLabelProvider(new LabelProvider() {
		     @Override
		     public String getText(Object element) {
		         if (element instanceof Chant) {
		        	 Chant chnt = (Chant) element;
		             return chnt.getName();
		         }
		         return super.getText(element);
		     }
		 });
		comboViewerChant4.setContentProvider((ArrayContentProvider.getInstance()));
		comboViewerChant4.setInput(ModelProvider.getListChant());

		if (separator != null) {
			m_bindingContext = initDataBindings();
			userdatabinding();
		}		//Ajouter le controle de dirty
				makedirtycontroller(this);	
				makeerrorhandler(lblSparateur);
				new Label(this, SWT.NONE);
	}
	@Override
	public void cancel() {
		// TODO Auto-generated method stub
		m_bindingContext.updateTargets();
	}

	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}
	public Separator getSeparator() {
		return separator;
	}

	public void setSeparator(Separator separator) {
		setSeparator(separator,true);
	}
	public void setSeparator(Separator newseparator, boolean update) {
		separator = newseparator;
		if (update) {
			if (m_bindingContext != null) {
				m_bindingContext.dispose();
				m_bindingContext = null;
			}
			if (separator != null) {
				m_bindingContext = initDataBindings();
			}
		}
	}
	public void setDirty(MDirtyable dirty) {
		this.dirty = dirty;
	}
	public MDirtyable getDirty() {
		return dirty;
	}
	public void updateDirty()
	{
		if(this.dirty!=null)
		{
			this.dirty.setDirty(true);
		}
	}
	//Pour corriger le Bug de spinner que selctionne tous apres chaque saisie
	private void updateCaretposition(Control ctr)
	{
		Event ke = new Event();
        ke.type = SWT.MENU_KEYBOARD;
        ke.keyCode = SWT.ARROW_RIGHT;
        ctr.getDisplay().post(ke);
	}
	protected void makedirtycontroller(Composite composite)
	{
		//Faire la mise ajour des controel pour qui enregistre le dirty
				Control [] ctrl = this.getChildren();
			
				for(Control ctr : composite.getChildren())
				{	
					if(ctr instanceof Composite &&!((ctr instanceof Text)||(ctr instanceof Spinner)) ) {
						for(Control ctrs : ((Composite)ctr).getChildren()) {
							if(ctrs instanceof Composite) {
								makedirtycontroller((Composite) ctrs);
							}
						}
					}
					
						if(ctr instanceof Text)
						{
							((Text) ctr).addKeyListener(new KeyListener() {
								
								@Override
								public void keyReleased(KeyEvent e) {
									// TODO Auto-generated method stub
									updateDirty();
								}
								
								@Override
								public void keyPressed(KeyEvent e) {
									// TODO Auto-generated method stub
									Event ke = new Event();
							        ke.type = SWT.MENU_MOUSE;
							        ke.keyCode = SWT.MouseDoubleClick;
							        ctr.getDisplay().post(ke);
							        
							         ke = new Event();
							        ke.type = SWT.MENU_KEYBOARD;
							        ke.keyCode = SWT.ARROW_RIGHT;
							        ctr.getDisplay().post(ke);
								}
							});
						}
						else
						{
							ctr.addListener(SWT.Selection, event->updateDirty());//Pour les spinner et les chekbox labada expresseion
						}
						if(ctr instanceof Spinner)
						{
							ctr.addListener(SWT.Selection, event->updateCaretposition(ctr));
						}
					
				}
	}

	protected void makeerrorhandler(Control control)
	{
		
		deco = new ControlDecoration(control, SWT.TOP | SWT.RIGHT);
		// re-use an existing image
		Image image = FieldDecorationRegistry.getDefault().getFieldDecoration(FieldDecorationRegistry.DEC_ERROR)
				.getImage();
		// set description and image
		deco.setImage(image);
		// hide deco if not in focus
		deco.setShowOnlyOnFocus(false);
		deco.hide();
	}
	@Override
	public void run() throws DesignException {
		// TODO Auto-generated method stub
		try
		{
			separator.setErrorexist(false);
			separator.setErrormsg("");
			m_bindingContext.updateModels();
			
			separator.update();
			clearlisteners();
			deco.setDescriptionText("");
			deco.hide();
		}
		catch( Exception e)
		{
			separator.setErrorexist(true);
			separator.setErrormsg(e.getMessage());
			deco.setDescriptionText(e.getMessage());
			deco.show();
		}

	}
	private void userdatabinding() {
		//ajouter un propertychangelistener pour override le seppostion lorsque choisire separator isometrique
		pcl2 =new PropertyChangeListener() {
			
			@Override
			public void propertyChange(PropertyChangeEvent evt) {
				// TODO Auto-generated method stub
				if(evt.getPropertyName().equals("isSepIsometrique")
						&& evt.getSource().getClass().equals(Separator.class)
						&& ((Separator)evt.getSource())!=null) {
						if( evt.getNewValue().equals(false)) {
					
						
						if(separator.getSepaxe().equals(SeprationAxe.YAXIS)) {
							separator.setSepposition((separator.getParentdesign().getHauteurint()-separator.getMaterial().getEpaisseur())/2);
						}else if (separator.getSepaxe().equals(SeprationAxe.XAXIS)) {
							separator.setSepposition((separator.getParentdesign().getLongeurint()-separator.getMaterial().getEpaisseur())/2);
						} else if (separator.getSepaxe().equals(SeprationAxe.ZAXIS)) {
							separator.setSepposition((separator.getParentdesign().getProfondeurint()-separator.getMaterial().getEpaisseur())/2);
						}  
					}
					if( evt.getNewValue().equals(true)) {
						separator.setSepposition(50);	
					}
					if(evt.getOldValue().equals(false)&& evt.getNewValue().equals(true)) {
						separator.setPosclaculationtype(PositionCalculationType.POURCENT);
					}
					if(evt.getOldValue().equals(true)&& evt.getNewValue().equals(false)) {
						separator.setPosclaculationtype(PositionCalculationType.FIX);
					}
				}
				
			}
		};
		separator.addPropertyChangeListener(pcl2);
		
	}
	private void clearlisteners() {
		separator.removePropertyChangeListener(pcl2);
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeTextTxtSepNameObserveWidget = WidgetProperties.text(SWT.Modify).observe(txtSepName);
		IObservableValue nameSeparatorObserveValue = BeanProperties.value("name").observe(separator);
		bindingContext.bindValue(observeTextTxtSepNameObserveWidget, nameSeparatorObserveValue, null, null);
		//
		IObservableValue observeTextWornZoneObserveWidget = WidgetProperties.text(SWT.Modify).observe(wornZone);
		IObservableValue errormsgSeparatorObserveValue = BeanProperties.value("errormsg").observe(separator);
		bindingContext.bindValue(observeTextWornZoneObserveWidget, errormsgSeparatorObserveValue, null, null);
		//
		IObservableValue observeSelectionSpinnerObserveWidget = WidgetProperties.spinnerSelection().observe(spnposhorizontal);
		IObservableValue xposSeparatorObserveValue = BeanProperties.value("xpos").observe(separator);
		bindingContext.bindValue(observeSelectionSpinnerObserveWidget, xposSeparatorObserveValue, null, null);
		//
		IObservableValue observeSelectionSpinner_1ObserveWidget = WidgetProperties.spinnerSelection().observe(spnposverticale);
		IObservableValue yposSeparatorObserveValue = BeanProperties.value("ypos").observe(separator);
		bindingContext.bindValue(observeSelectionSpinner_1ObserveWidget, yposSeparatorObserveValue, null, null);
		//
		IObservableValue observeSelectionSpinner_2ObserveWidget = WidgetProperties.spinnerSelection().observe(spnposinterieur);
		IObservableValue zposSeparatorObserveValue = BeanProperties.value("zpos").observe(separator);
		bindingContext.bindValue(observeSelectionSpinner_2ObserveWidget, zposSeparatorObserveValue, null, null);
		//
		IObservableValue observeSelectionSpinner_3ObserveWidget = WidgetProperties.spinnerSelection().observe(spnlongpiece);
		IObservableValue pieceLSeparatorObserveValue = BeanProperties.value("pieceL").observe(separator);
		bindingContext.bindValue(observeSelectionSpinner_3ObserveWidget, pieceLSeparatorObserveValue, null, null);
		//
		IObservableValue observeSelectionSpinner_4ObserveWidget = WidgetProperties.spinnerSelection().observe(spnlargeurpiece);
		IObservableValue pieceHSeparatorObserveValue = BeanProperties.value("pieceH").observe(separator);
		bindingContext.bindValue(observeSelectionSpinner_4ObserveWidget, pieceHSeparatorObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionComboViewer = ViewerProperties.singleSelection().observe(comboViewerRefPos);
		IObservableValue posRefTypeSeparatorObserveValue = BeanProperties.value("posRefType").observe(separator);
		bindingContext.bindValue(observeSingleSelectionComboViewer, posRefTypeSeparatorObserveValue, null, null);
		//
		IObservableValue observeSelectionSpEpaisseurObserveWidget = WidgetProperties.spinnerSelection().observe(spEpaisseur);
		IObservableValue materialepaisseurSeparatorObserveValue = BeanProperties.value("material.epaisseur").observe(separator);
		bindingContext.bindValue(observeSelectionSpEpaisseurObserveWidget, materialepaisseurSeparatorObserveValue, null, null);
		//
		IObservableValue observeVisibleWornZoneObserveWidget = WidgetProperties.visible().observe(wornZone);
		IObservableValue errorexistSeparatorObserveValue = BeanProperties.value("errorexist").observe(separator);
		bindingContext.bindValue(observeVisibleWornZoneObserveWidget, errorexistSeparatorObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionComboViewersepAxe = ViewerProperties.singleSelection().observe(comboViewersepAxe);
		IObservableValue sepaxeSeparatorObserveValue = BeanProperties.value("sepaxe").observe(separator);
		bindingContext.bindValue(observeSingleSelectionComboViewersepAxe, sepaxeSeparatorObserveValue, null, null);
		//
		IObservableValue observeSelectionSpinnersepposObserveWidget = WidgetProperties.spinnerSelection().observe(spinnerseppos);
		IObservableValue seppositionSeparatorObserveValue = BeanProperties.value("sepposition").observe(separator);
		bindingContext.bindValue(observeSelectionSpinnersepposObserveWidget, seppositionSeparatorObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnSparateurObserveWidget = WidgetProperties.buttonSelection().observe(btnSparateur);
		IObservableValue isSepIsometriqueSeparatorObserveValue = BeanProperties.value("isSepIsometrique").observe(separator);
		bindingContext.bindValue(observeSelectionBtnSparateurObserveWidget, isSepIsometriqueSeparatorObserveValue, null, null);
		//
		IObservableValue observeSelectionSpnretraitObserveWidget = WidgetProperties.spinnerSelection().observe(spnretrait);
		IObservableValue sepRetraitSeparatorObserveValue = BeanProperties.value("sepRetrait").observe(separator);
		bindingContext.bindValue(observeSelectionSpnretraitObserveWidget, sepRetraitSeparatorObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionComboViewer_1 = ViewerProperties.singleSelection().observe(comboViewer);
		IObservableValue posclaculationtypeSeparatorObserveValue = BeanProperties.value("posclaculationtype").observe(separator);
		bindingContext.bindValue(observeSingleSelectionComboViewer_1, posclaculationtypeSeparatorObserveValue, null, null);
		//
		IObservableValue observeSelectionSpnRetraitDeriereObserveWidget = WidgetProperties.spinnerSelection().observe(spnRetraitDeriere);
		IObservableValue sepretraitderiereSeparatorObserveValue = BeanProperties.value("sepretraitderiere").observe(separator);
		bindingContext.bindValue(observeSelectionSpnRetraitDeriereObserveWidget, sepretraitderiereSeparatorObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionComboViewerChant1 = ViewerProperties.singleSelection().observe(comboViewerChant1);
		IObservableValue chant1SeparatorObserveValue = BeanProperties.value("chant1").observe(separator);
		bindingContext.bindValue(observeSingleSelectionComboViewerChant1, chant1SeparatorObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionComboViewerChant2 = ViewerProperties.singleSelection().observe(comboViewerChant2);
		IObservableValue chant2SeparatorObserveValue = BeanProperties.value("chant2").observe(separator);
		bindingContext.bindValue(observeSingleSelectionComboViewerChant2, chant2SeparatorObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionComboViewerChant3 = ViewerProperties.singleSelection().observe(comboViewerChant3);
		IObservableValue chant3SeparatorObserveValue = BeanProperties.value("chant3").observe(separator);
		bindingContext.bindValue(observeSingleSelectionComboViewerChant3, chant3SeparatorObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionComboViewerChant4 = ViewerProperties.singleSelection().observe(comboViewerChant4);
		IObservableValue chant4SeparatorObserveValue = BeanProperties.value("chant4").observe(separator);
		bindingContext.bindValue(observeSingleSelectionComboViewerChant4, chant4SeparatorObserveValue, null, null);
		//
		IObservableValue observeTextLbllongChant1ObserveWidget = WidgetProperties.text().observe(lbllongChant1);
		IObservableValue longchant1SeparatorObserveValue = BeanProperties.value("longchant1").observe(separator);
		bindingContext.bindValue(observeTextLbllongChant1ObserveWidget, longchant1SeparatorObserveValue, null, null);
		//
		IObservableValue observeTextLbllongChant2ObserveWidget = WidgetProperties.text().observe(lbllongChant2);
		IObservableValue longchant2SeparatorObserveValue = BeanProperties.value("longchant2").observe(separator);
		bindingContext.bindValue(observeTextLbllongChant2ObserveWidget, longchant2SeparatorObserveValue, null, null);
		//
		IObservableValue observeTextLbllongChant3ObserveWidget = WidgetProperties.text().observe(lbllongChant3);
		IObservableValue longchant3SeparatorObserveValue = BeanProperties.value("longchant3").observe(separator);
		bindingContext.bindValue(observeTextLbllongChant3ObserveWidget, longchant3SeparatorObserveValue, null, null);
		//
		IObservableValue observeTextLbllongChant4ObserveWidget = WidgetProperties.text().observe(lbllongChant4);
		IObservableValue longchant4SeparatorObserveValue = BeanProperties.value("longchant4").observe(separator);
		bindingContext.bindValue(observeTextLbllongChant4ObserveWidget, longchant4SeparatorObserveValue, null, null);
		//
		return bindingContext;
	}
}
