package dressing.ui.dos;

import javax.inject.Inject;

import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;

import dressing.controller.Piece2DCreator;
import dressing.model.DesignException;
import dressing.model.Space3D;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.DosType;
import dressing.model.types.PieceType;



public class DosWizard extends Wizard{

	//L injection ne peut etre en marche que si on creer l objet avec contextfactory et non pas avec l objet new
	@Inject
	IEclipseContext  eclipsecontext;

	@Inject
	private EHandlerService handlerService;
	
	@Inject
	private ECommandService commandService;

	Space3D space3d;
	Piece2DCreator piecesfactory = new Piece2DCreator();
	DosWelcomePage welcompage;

	public DosWizard () {
		setWindowTitle("Nouvelle porte");		
		//init

	}

	@Override
	public void addPages() {
		welcompage = new DosWelcomePage("WelcomePage",piecesfactory);
		addPage(welcompage);		

	}

	@Override
	public boolean performFinish() {
		for(IWizardPage page :getPages())
		{
			((WizardPage) page).setErrorMessage("");
		}
			try {
				
				if(piecesfactory.getDostype().equals(DosType.DOSINTERIEUR))
				{
					piecesfactory.setPiecetype(PieceType.DOS_INTERIEUR);
				

				}
				else if(piecesfactory.getDostype().equals(DosType.DOSEXTERIEUR))
				{
					piecesfactory.setPiecetype(PieceType.DOS_EXTERIRUR);

				}
				else
				{
					throw new DesignException("Type dos non supporté");
				}		
				piecesfactory.create();
				welcompage.clearlistners();
				this.space3d.addElement(this.piecesfactory.getPiece2DInstance());
				this.space3d.propagateUpdateToChildrens(null);
				if(this.piecesfactory.getPiece2DInstance().getDebitage()!=null)
					this.piecesfactory.getPiece2DInstance().getDebitage().createupdateDebitage();
				else
					this.piecesfactory.getPiece2DInstance().constructDebitage();
				
				this.piecesfactory.getPiece2DInstance().evaluate();	
				this.piecesfactory.getPiece2DInstance().propagateUpdateToChildrens(space3d);
			} catch (DesignException  | GeometricEngineException e) {
				for(IWizardPage page :getPages())
				{
					((WizardPage) page).setErrorMessage(e.getMessage());
				}
					return false;
			}

				
			return true;
	}
	
public void setSpace3D(Space3D space3d) {
	this.space3d = space3d;	
	piecesfactory.setName("Dos");
	piecesfactory.setParent(space3d);
	piecesfactory.setBackmaterial(space3d.getBackmaterial());
	piecesfactory.setBasematerial(space3d.getBasematerial());
	piecesfactory.setMaterial(space3d.getBackmaterial());
	piecesfactory.setPiecetype(PieceType.DOS_INTERIEUR);
	piecesfactory.setDostype(DosType.DOSINTERIEUR);
}
	@Override
public boolean canFinish() {
		IWizardPage[] pages = getPages();
		for (IWizardPage page : pages) {
			if (!page.isPageComplete()) {
				return false;
			}
		}
		return true;
	}
}
