package dressing.ui.charniere;

import java.beans.PropertyChangeListener;

import javax.inject.Inject;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import dressing.controller.BlocTirroirCreator;
import dressing.controller.CharniereCreator;
import dressing.model.ModelProvider;
import dressing.ui.util.SingleImageItemLabelProvider;

import dressing.model.types.*;
public class CharniereWizardComposite extends Composite {
	@Inject
	IEclipseContext eclipsecontext;
	@Inject
	private ESelectionService selectionService;

	@Inject
	private EHandlerService handlerService;

	@Inject
	private ECommandService commandService;
	private DataBindingContext m_bindingContext;
	CharniereCreator creator;
	PropertyChangeListener pcl;
	boolean errorfound=false;
	private ModelProvider modelprovider = new ModelProvider();
	private Spinner spnPRetrait;
	private Spinner spnHRetrait;
	private Label lblNombreTiroir;
	private Spinner spnCharniereCount;
	private TableCombo tableCombo;
	
	public CharniereCreator getCreator() {
		return creator;
	}
	public void SetCreator(CharniereCreator creator) {
		this.creator = creator;
	}

	/**
	 * Create the composite.
	 * @param parent
	 * @param style
	 */
	public CharniereWizardComposite(Composite parent, int style,CharniereCreator creator) {
		this(parent, style);
		SetCreator(creator);
		if(creator!=null) {
			m_bindingContext = initDataBindings();
		}
	}
	public CharniereWizardComposite(Composite parent, int style) {
		super(parent, style);
		setLayout(new GridLayout(2, false));
		
		lblNombreTiroir = new Label(this, SWT.NONE);
		lblNombreTiroir.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNombreTiroir.setText("Nombre Charniere");
		
		spnCharniereCount = new Spinner(this, SWT.BORDER);
		spnCharniereCount.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		spnCharniereCount.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		spnCharniereCount.setMaximum(3);
		spnCharniereCount.setMinimum(2);
		
		Label lblhauteur = new Label(this, SWT.NONE);
		lblhauteur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblhauteur.setText("retrait profondeur");
		
		spnPRetrait = new Spinner(this, SWT.BORDER);
		spnPRetrait.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		spnPRetrait.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		spnPRetrait.setMaximum(1000000);
		
		Label lblprofondeur = new Label(this, SWT.NONE);
		lblprofondeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblprofondeur.setText("retrait hauteur");
		
		spnHRetrait = new Spinner(this, SWT.BORDER);
		spnHRetrait.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		spnHRetrait.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		spnHRetrait.setMaximum(1000000);
		if(creator!=null) {
			m_bindingContext = initDataBindings();
		}
		
	}
	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeSelectionSpnCharniereCountObserveWidget = WidgetProperties.widgetSelection().observe(spnCharniereCount);
		IObservableValue nbCharniereCreatorObserveValue = BeanProperties.value("nbCharniere").observe(creator);
		bindingContext.bindValue(observeSelectionSpnCharniereCountObserveWidget, nbCharniereCreatorObserveValue, null, null);
		//
		IObservableValue observeSelectionSpnPRetraitObserveWidget = WidgetProperties.widgetSelection().observe(spnPRetrait);
		IObservableValue retraitPCreatorObserveValue = BeanProperties.value("retraitP").observe(creator);
		bindingContext.bindValue(observeSelectionSpnPRetraitObserveWidget, retraitPCreatorObserveValue, null, null);
		//
		IObservableValue observeSelectionSpnHRetraitObserveWidget = WidgetProperties.widgetSelection().observe(spnHRetrait);
		IObservableValue retraitHCreatorObserveValue = BeanProperties.value("retraitH").observe(creator);
		bindingContext.bindValue(observeSelectionSpnHRetraitObserveWidget, retraitHCreatorObserveValue, null, null);
		//
		return bindingContext;
	}
}
