package dressing.model.debitage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map.Entry;

import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

import org.eclipse.emf.common.util.EList;

import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.EngineKeys;
import dressing.model.ModelProvider;
import dressing.model.Piece2D;
import dressing.model.Space3D;
import dressing.model.Space3DFree;
import dressing.model.evalutor.Couple;
import dressing.model.evalutor.Equation;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.evalutor.GeomtericEngine;
import param.Cavity;
import param.CondtionalEquation;
import param.FunctionDef;
import param.MechanicDesign;
import param.MechanicDesignElment;
import param.MechanicPrivateParam;
import param.MechanicPublicParam;
import param.Rainure;
import param.UsinageTrou;

public class GenericDebitageFormula extends DebitageFormulas {
	List<MechanicPrivateParam> privateparams ;
	List<MechanicPublicParam> publicparams;
	Object emf;
	protected static ScriptEngine   logicalEngine = GeomtericEngine.getLogicalEngine();
	HashMap<String,String> exportlist ;

	public GenericDebitageFormula() {
		super();
		// TODO Auto-generated constructor stub
	}

	public GenericDebitageFormula(List<MechanicPrivateParam> privateparams, List<MechanicPublicParam> publicparams,Object emf, HashMap<String,String> exportlist) {
		// TODO Auto-generated constructor stub
		this.privateparams = privateparams;
		this.publicparams = publicparams;
		this.emf = emf;
		this.exportlist = exportlist;
	}

	public  void filldebitagesequations(DesignObject3D parent,DesignObject3D child,ArrayList<Equation> equations) throws DesignException
	{
		if(child==null)
			throw new DesignException("Formule de debitage : child null");
		this.parent = parent;
		this.child = child;
		Bindings globalBindings = logicalEngine.getContext().getBindings(ScriptContext.GLOBAL_SCOPE);
		Bindings engineBindings = logicalEngine.getContext().getBindings(ScriptContext.ENGINE_SCOPE);
		if(globalBindings != null)
			globalBindings.clear();
		if(engineBindings != null)
			engineBindings.clear();
		if(parent!=null)
		{
			logicalEngine.put("PARENT",parent);
			logicalEngine.put("CHILD",child);
			for(Entry<Object, Object> prop : parent.entrySet())
			{
				if(prop.getKey().toString().startsWith("$"))
				{
					try {
						logicalEngine.eval(parent.get(prop.getKey()).toString());
						GeomtericEngine.getEngine().eval(parent.get(prop.getKey()).toString());
					} catch (ScriptException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
						throw new DesignException("La fonction "+prop.getKey().toString()+" cannot be evaluated");
					}
				}
				else
				{
					logicalEngine.put((String)prop.getKey(), parent.get(prop.getKey()));					
				}

			}
		}
		//fill depuis child props le cas du child du type Space3DFree ou MechanicDesign
		if(child !=null && child instanceof Space3DFree) {
			for(Entry<Object, Object> prop : child.entrySet())
			{
				if(prop.getKey().toString().startsWith("$"))
				{
					try {
						logicalEngine.eval(child.get(prop.getKey()).toString());
						GeomtericEngine.getEngine().eval(child.get(prop.getKey()).toString());
					} catch (ScriptException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
						throw new DesignException("La fonction "+prop.getKey().toString()+" cannot be evaluated");
					}
				}
				else
				{
					logicalEngine.put((String)prop.getKey(), child.get(prop.getKey()));					
				}

			}
		}
		
	
		//check exist logic
		try {
			 boolean res = true;
			 //evaluer seulement si il ya exist expression
			 if(child.containsKey("EXIST_EXPRESSION"))
			 {
				 res = 	(boolean) logicalEngine.eval(child.get("EXIST_EXPRESSION").toString());
			 }

			 if(!res)
			 {
				 child.put("EXIST", false);
			 }
			 else
			 {
				    child.put("EXIST", true);
				   //les parametres d usine doivent être les premier
					//fillequationsusinage(parent,child,equations); //scho 1953 les parametres d usine doivent etre dans provate params
					fillequationsfromparent(parent, equations);		
					fillequationsfromparentprops(parent,equations);
					fillequationsfromprivateparam(equations,privateparams);	
					fillequationsfrompublicparam( equations,publicparams);	
					fillequationsfromemfmodel(equations,emf);
			 }
			
				 try {
					if(child.containsKey("HAVE_OPPOSITE_EXPRESSION"))
					 {
						 boolean hasOpposite = 	(boolean) logicalEngine.eval(child.get("HAVE_OPPOSITE_EXPRESSION").toString());
						 child.put("HAS_OPPOSITE", hasOpposite);
					 }
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
					 child.put("HAS_OPPOSITE", false);
				}
			} catch (ScriptException e) {
				// TODO Auto-generated catch block				
				e.printStackTrace();
				 child.put("EXIST", false);
				throw new DesignException(" Existence expression cannot be evaluated " + child.get("EXIST_EXPRESSION").toString());
			}
		finally {
			if(globalBindings != null)
				globalBindings.clear();
			if(engineBindings != null)
				engineBindings.clear();
		}		
	}
	

	private void fillequationsfromemfmodel(ArrayList<Equation> equations,Object emf ) throws DesignException {	
		
		//fill default parmeter of the piece
		fillequationsfromchildequations(equations,this.child.getSystemEquation(emf));	
		
		//override with specfic 
		if(emf instanceof MechanicDesign)
		{
			fillequationsfromgenericequations(equations,((MechanicDesign)emf).getEquation());	
		}
		else if(emf instanceof MechanicDesignElment)
		{
			fillequationsfromgenericequations(equations,((MechanicDesignElment)emf).getEquation());	
		}
		else if( emf instanceof UsinageTrou)			
		{
			fillequationsfromgenericequations(equations,((UsinageTrou)emf).getEquation());	
		}
		else if( emf instanceof Rainure)			
		{
			fillequationsfromgenericequations(equations,((Rainure)emf).getEquation());	
		}
		else if( emf instanceof Cavity)			
		{
			fillequationsfromgenericequations(equations,((Cavity)emf).getEquation());	
		}

		
	}
	private void fillequationsfromchildequations(ArrayList<Equation> equations, List<Couple> systemEquation) {
		// TODO Auto-generated method stub
		for(Couple c  : systemEquation)
		{
			if(c.getKey()!=null && !c.getKey().isEmpty() && c.getExpr()!=null && !c.getExpr().isEmpty())
			{
				String tempkey = c.getKey().replace("@", "");
				ADDOrUpdateEquation("@"+tempkey+"@", c.getExpr(), Equation.CALCULATION_MANUAL,equations);	
			}
			
		}
	}


	public static void fillequationsfromgenericequations(ArrayList<Equation> equations,List<param.Equation> list) throws DesignException {		
		List<param.Equation> eListequation2 = list;
		
		for(param.Equation eq : eListequation2)
		{
			boolean foundexpression = false;
			String tempkey=null;
			if(!eq.getCondtionalequation().isEmpty())
			{
				for(CondtionalEquation cond  : eq.getCondtionalequation())
				{
					if(cond.getWhenexpression()!=null)
					{
						try {
						 boolean res = 	(boolean) GeomtericEngine.getLogicalEngine().eval(cond.getWhenexpression());
						 if(res)
						 {
							if(eq.getKey()!=null && !eq.getKey().isEmpty()  )
								{
								    tempkey = "@"+eq.getKey().replace("@", "")+"@";
									ADDOrUpdateEquation(tempkey, cond.getExpression(), Equation.CALCULATION_MANUAL,equations);	
								}
							foundexpression = true;
							break;
						 }
						} catch (ScriptException e) {
							// TODO Auto-generated catch block
							
							e.printStackTrace();
							foundexpression = false;
							throw new DesignException(" When expression cannot be evaluated " + cond.getWhenexpression());
						}
					}

				}
			}
			if(!foundexpression)
			{
				if(eq.getKey()!=null && !eq.getKey().isEmpty() && eq.getExpression()!=null && !eq.getExpression().isEmpty())
				{
					tempkey = "@"+eq.getKey().replace("@", "")+"@";
					ADDOrUpdateEquation(tempkey, eq.getExpression(), Equation.CALCULATION_MANUAL,equations);	
				}
			}
			
		}
		
	}

	protected static void fillequationsfrompublicparam(ArrayList<Equation> equations,List<MechanicPublicParam> publicparams2) {

		for(MechanicPublicParam eq : publicparams2)
		{
			if(eq.getKey()!=null && !eq.getKey().isEmpty())
			{
				if( eq.getDefaultvalue()!=null && !eq.getDefaultvalue().isEmpty())
				{	
				
	 				String tempkey = eq.getKey().replace("@", "");
					if(eq.getKey().contains("_")&&!eq.getKey().contains(".")) {
						GeomtericEngine.getLogicalEngine().put(tempkey, eq.getDefaultvalue());
						tempkey = tempkey.replace('_', '.');			
					}else {
						GeomtericEngine.getLogicalEngine().put(tempkey.replace('.', '_'), eq.getDefaultvalue());
					}
					ADDOrUpdateEquation("@"+tempkey+"@", eq.getDefaultvalue(), Equation.CALCULATION_MANUAL,equations);	
				}else if(eq.getTypedef()!=null && eq.getTypedefelement()!=null) {
					String tempkey = eq.getKey().replace("@", "");
					tempkey=tempkey.replace('.', '_');
					GeomtericEngine.getLogicalEngine().put(tempkey, eq.getTypedefelement().getKey());
				}
			}
		}
	}

	protected static void fillequationsfromprivateparam( ArrayList<Equation> equations,	List<MechanicPrivateParam> privateparams2) {
		// TODO Auto-generated method stub
		for(MechanicPrivateParam eq : privateparams2)
		{
			if(eq.getKey()!=null && !eq.getKey().isEmpty() )
			{
				if(eq.getValue()!=null && !eq.getValue().isEmpty())
				
				{
					String tempkey = eq.getKey().replace("@", "");
					if(eq.getKey().contains("_")&&!eq.getKey().contains(".")) {
						GeomtericEngine.getLogicalEngine().put(tempkey, eq.getValue());
						tempkey = tempkey.replace('_', '.');
					}else {
						GeomtericEngine.getLogicalEngine().put(tempkey.replace('.', '_'), eq.getValue());
					}
					ADDOrUpdateEquation("@"+tempkey+"@", eq.getValue(), Equation.CALCULATION_MANUAL,equations);	
				}else if(eq.getTypedef()!=null && eq.getTypedefelement()!=null) {
					String tempkey = eq.getKey().replace("@", "");
					tempkey=tempkey.replace('.', '_');
					GeomtericEngine.getLogicalEngine().put(tempkey, eq.getTypedefelement().getKey());
				}
				
			}	
			
		}
	}
	private void    fillequationsfromparentprops(Object parent,ArrayList<Equation> equations)
	{
		if(parent!=null && parent instanceof DesignObject3D)
		{
			for(Entry<Object, Object> prop : ((DesignObject3D) parent).entrySet())
			{
				if(prop.getKey()!=null && prop.getKey().toString().startsWith("EXPORTED"))
				{
					ADDOrUpdateEquation("@"+prop.getKey().toString()+"@", ""+prop.getValue(), Equation.CALCULATION_MANUAL,equations) ;
				}
			}

			//SCho 1953 passer les paramètres entre les mechnic design
			//passage seulement entre des espaces 3d
			if(child instanceof Space3DFree)
			{
				// entre deux mechanic design
				for(Equation EQ : ((DesignObject3D) parent).getDebitage().getEquations())
				{
					if(EQ.isEvaluated() &&  !EQ.getKey().startsWith("@MDP_"))
					{
						//@this.h@
						//@MDP_this.h@
						String s = EQ.getKey();
						s= s.substring(1); //remove the first @
						s = "@MDP_"+s;
						try {
							ADDOrUpdateEquation(s, ""+EQ.getEvaluation(null), Equation.CALCULATION_MANUAL,equations) ;
						} catch (GeometricEngineException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
				}
			}

			int debug=0;
			debug++;
		}
	}
	protected static void    fillequationsfromparent(Object parent,ArrayList<Equation> equations)
	{
		if(parent!= null && parent instanceof Space3D)
		{
			Space3D space3d = (Space3D)parent;
			ADDOrUpdateEquation(EngineKeys.parentLongeurExt, ""+space3d.getLongeurext(), Equation.CALCULATION_MANUAL,equations) ;
			ADDOrUpdateEquation(EngineKeys.parentHauteureExt, ""+space3d.getHauteurext(), Equation.CALCULATION_MANUAL,equations);
			ADDOrUpdateEquation(EngineKeys.parentProfondeurExt, ""+space3d.getProfondeurext(), Equation.CALCULATION_MANUAL,equations) ;
			ADDOrUpdateEquation(EngineKeys.parentLongeurint, ""+space3d.getLongeurint(), Equation.CALCULATION_MANUAL,equations) ;
			ADDOrUpdateEquation(EngineKeys.parentHauteureint, ""+space3d.getHauteurint(), Equation.CALCULATION_MANUAL,equations);
			ADDOrUpdateEquation(EngineKeys.parentProfondeurint, ""+space3d.getProfondeurint(), Equation.CALCULATION_MANUAL,equations) ;				
			ADDOrUpdateEquation(EngineKeys.parentposx, ""+space3d.getXpos(), Equation.CALCULATION_MANUAL,equations) ;
			ADDOrUpdateEquation(EngineKeys.parentposy, ""+space3d.getYpos(), Equation.CALCULATION_MANUAL,equations) ;
			ADDOrUpdateEquation(EngineKeys.parentposz, ""+space3d.getZpos(), Equation.CALCULATION_MANUAL,equations) ;
			ADDOrUpdateEquation(EngineKeys.parentEpaisseurPrincipale, ""+space3d.getBasematerial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
			ADDOrUpdateEquation(EngineKeys.parentEpaisseurSecondaire, ""+space3d.getBackmaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;	
//			GeomtericEngine.getLogicalEngine().put(EngineKeys.parentLongeurExt.replaceAll("@", "").replace('.', '_'), space3d.getLongeurext());
//			GeomtericEngine.getLogicalEngine().put(EngineKeys.parentHauteureExt.replaceAll("@", "").replace('.', '_'), space3d.getHauteurext());
//			GeomtericEngine.getLogicalEngine().put(EngineKeys.parentProfondeurExt.replaceAll("@", "").replace('.', '_'), space3d.getProfondeurext());
//			GeomtericEngine.getLogicalEngine().put(EngineKeys.parentLongeurint.replaceAll("@", "").replace('.', '_'), space3d.getLongeurint());
//			GeomtericEngine.getLogicalEngine().put(EngineKeys.parentHauteureint.replaceAll("@", "").replace('.', '_'), space3d.getHauteurint());
//			GeomtericEngine.getLogicalEngine().put(EngineKeys.parentProfondeurint.replaceAll("@", "").replace('.', '_'), space3d.getProfondeurint());
//			GeomtericEngine.getLogicalEngine().put(EngineKeys.parentposx.replaceAll("@", "").replace('.', '_'), space3d.getXpos());
//			GeomtericEngine.getLogicalEngine().put(EngineKeys.parentposy.replaceAll("@", "").replace('.', '_'), space3d.getYpos());
//			GeomtericEngine.getLogicalEngine().put(EngineKeys.parentposz.replaceAll("@", "").replace('.', '_'), space3d.getZpos());
//			GeomtericEngine.getLogicalEngine().put(EngineKeys.parentEpaisseurPrincipale.replaceAll("@", "").replace('.', '_'), space3d.getBasematerial().getEpaisseur());
//			GeomtericEngine.getLogicalEngine().put(EngineKeys.parentEpaisseurSecondaire.replaceAll("@", "").replace('.', '_'), space3d.getBackmaterial().getEpaisseur());

			
		}
		
		if(parent!= null && parent instanceof Piece2D)
		{
			Piece2D piece2d = (Piece2D)parent;
			ADDOrUpdateEquation(EngineKeys.parentLongeurExt, ""+piece2d.getLongeurext(), Equation.CALCULATION_MANUAL,equations) ;
			ADDOrUpdateEquation(EngineKeys.parentProfondeurExt, ""+piece2d.getProfondeurext(), Equation.CALCULATION_MANUAL,equations) ;
			ADDOrUpdateEquation(EngineKeys.parentHauteureExt, ""+piece2d.getHauteurext(), Equation.CALCULATION_MANUAL,equations) ;
			//
			ADDOrUpdateEquation(EngineKeys.parentLongeurint, ""+piece2d.getLongeurext(), Equation.CALCULATION_MANUAL,equations) ;
			ADDOrUpdateEquation(EngineKeys.parentProfondeurint, ""+piece2d.getProfondeurext(), Equation.CALCULATION_MANUAL,equations) ;
			ADDOrUpdateEquation(EngineKeys.parentHauteureint, ""+piece2d.getHauteurext(), Equation.CALCULATION_MANUAL,equations) ;
			//
			ADDOrUpdateEquation(EngineKeys.parentEpaisseurSecondaire, ""+piece2d.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
			ADDOrUpdateEquation(EngineKeys.parentEpaisseurPrincipale, ""+piece2d.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
			//
			ADDOrUpdateEquation(EngineKeys.parentposx, ""+piece2d.getXpos(), Equation.CALCULATION_MANUAL,equations) ;
			ADDOrUpdateEquation(EngineKeys.parentposy, ""+piece2d.getYpos(), Equation.CALCULATION_MANUAL,equations) ;
			ADDOrUpdateEquation(EngineKeys.parentposz, ""+piece2d.getZpos(), Equation.CALCULATION_MANUAL,equations) ;
		}
	}
	
	private  void fillequationsusinage(DesignObject3D parent,DesignObject3D child, ArrayList<Equation> equations)
	{		
	    fillequationsusinage(ModelProvider.getListParam(),equations);		
	}
	private void fillequationsusinage(ArrayList<dressing.model.Parameters> listParam,ArrayList<Equation> equations) {
		if(listParam!=null) {
			for(dressing.model.Parameters param:listParam) {
				if(param!=null&& param.getCode()!=null&& param.getValue()!=null) {
					ADDOrUpdateEquation(param.getCode(),param.getValue() ,Equation.CALCULATION_MANUAL,equations);
				}
				
			}
		}
		
	}
}
