package dressing.model;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;

import javax.imageio.ImageIO;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

import dressing.model.accessoire.SupportBlocTiroir;
import dressing.model.debitage.DebitageFormulas;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.CaissonMontageType;
import dressing.model.types.CaissonType;
import dressing.model.types.PieceType;
import dressing.model.types.PortType;
import dressing.model.usinage.Usinage;
import tech.frsdev.solids.Solide3D;

public class Caisson extends Space3D {

	PortType porttype;
	
	//Parametres wizards
	transient private boolean portinclude=false;
	transient private boolean tirroirinclude=false;	
	transient private boolean etagefixinclude=false;
	transient private double etagefixposition=0;	
	transient private int etagemobilebascount=0; //Les etageres au dessus de l'etager fixe
	transient private int etagemobilehautcount=0; //Les etageres au dessous de l'etager fixe
	transient private boolean verrouslongeur=false;
	private boolean verrous=false;
	CaissonType cuissontype = CaissonType.MILIEU;
	private boolean longeurextfree=false;
	
	
	/* (non-Javadoc)
	 * @see dressing.model.DesignObject3D#getSelected()
	 */
	
	public CaissonMontageType getCaissonMontageType() {
		return super.getCaissonMontageType();
	}

	public void setCaissonMontageType(CaissonMontageType caissonMontageType) {
		super.setCaissonMontageType(caissonMontageType);
	}
	public void setCuissontype(CaissonType cuissontype) {

		CaissonType oldValue = this.cuissontype;
		this.cuissontype = cuissontype;
		firePropertyChange("cuissontype", oldValue, cuissontype);
	}

	public CaissonType getCuissontype() {
		return cuissontype;
	}
	public void setVerrous(boolean verrous) {

		boolean oldValue = this.verrous;
		this.verrous = verrous;
		firePropertyChange("verrous", oldValue, verrous);
	}
	public boolean isVerrous() {
		return verrous;
	}
public void setEtagemobilebascount(int etagemobilebascount) {

	int oldValue = this.etagemobilebascount;
	this.etagemobilebascount = etagemobilebascount;
	firePropertyChange("etagemobilebascount", oldValue, etagemobilebascount);
}
public int getEtagemobilebascount() {
	return etagemobilebascount;
}
public void setEtagemobilehautcount(int etagemobilehautcount) {

	int oldValue = this.etagemobilehautcount;
	this.etagemobilehautcount = etagemobilehautcount;
	firePropertyChange("etagemobilehautcount", oldValue, etagemobilehautcount);
}
public int getEtagemobilehautcount() {
	return etagemobilehautcount;
}
	public void setPortinclude(boolean portinclude) {

		boolean oldValue = this.portinclude;
		this.portinclude = portinclude;
		firePropertyChange("portinclude", oldValue, portinclude);
	}
	public boolean isPortinclude() {
		return portinclude;
	}
	public boolean isTirroirinclude() {
		return tirroirinclude;
	}
	public void setTirroirinclude(boolean tirroirinclude) {

		boolean oldValue = this.tirroirinclude;
		this.tirroirinclude = tirroirinclude;
		firePropertyChange("tirroirinclude", oldValue, tirroirinclude);
	}
public void setVerrouslongeur(boolean verrouslongeur) {

	boolean oldValue = this.verrouslongeur;
	this.verrouslongeur = verrouslongeur;
	firePropertyChange("verrouslongeur", oldValue, verrouslongeur);
}
public boolean isVerrouslongeur() {
	return verrouslongeur;
}
	public void setEtagefixinclude(boolean etagefixinclude) {

		boolean oldValue = this.etagefixinclude;
		this.etagefixinclude = etagefixinclude;
		firePropertyChange("etagefixinclude", oldValue, etagefixinclude);
	}
	public boolean isEtagefixinclude() {
		return etagefixinclude;
	}
	public void setPorttype(PortType porttype) {

		PortType oldValue = this.porttype;
		this.porttype = porttype;
		firePropertyChange("porttype", oldValue, porttype);
	}
	public PortType getPorttype() {
		return porttype;
	}
	public void setEtagefixposition(double etagefixposition) {

		double oldValue = this.etagefixposition;
		this.etagefixposition = etagefixposition;
		firePropertyChange("etagefixposition", oldValue, etagefixposition);
	}
	public double getEtagefixposition() {
		return etagefixposition;
	}
	@Override
	public boolean canHold(DesignObject3D child) {
		// TODO Auto-generated method stub
		if(child instanceof Dressing)
		{
			return false;
		}
		if(getPorttype().equals(PortType.COLISSANT))
		{
			if(child instanceof Piece2D)
			{
				if(((Piece2D) child).getPiecetype().equals(PieceType.PORTE) ||
						((Piece2D) child).getPiecetype().equals(PieceType.PORTE_DROITE)  ||	
						((Piece2D) child).getPiecetype().equals(PieceType.PORTE_GAUCHE)  )
				{
					return false;
				}
						
			}
			else if(child instanceof Tirroir )
			{
				return false;
			}
		}
		return true;
	}

	@Override
	public void clearautomatique() throws DesignException, GeometricEngineException {
		// TODO Auto-generated method stub
		if(!verrous)
		super.clearautomatique();
	}	
	public String printDescription()
	{		
		String s="";
		s+=" 	Cuisson "  + getName() +"\n";
		s+=" 	Type "  + getCuissontype() +"\n";
		s+=" 	Longeur extenre "  + getLongeurext() +" mm \n";
		s+=" 	Hauteur extenre "  + getHauteurext() +" mm \n";
		s+=" 	Profondeur extenre "  + getProfondeurext() +" mm \n";
		
		s+=" 	Longeur interne "  + getLongeurint() +" mm \n";
		s+=" 	Hauteur interne "  + getHauteurint() +" mm \n";
		s+=" 	Profondeur interne "  + getProfondeurint() +" mm \n";
		
		s+=" 	Modele de porte "  + getPorttype() +"  \n";
		s+=" 	Porte inclus "  + isPortinclude() +"  \n";
		s+=" 	Tirroir inclus "  + isTirroirinclude() +"  \n";
		s+=" 	Etage fixe inclus "  + isEtagefixinclude() +"  \n\n";
		s+="	#################### Les sous elements ########## \n";
		System.out.println(s);
		for(DesignObject3D child : getChilds())
		{
			s+=child.printDescription();
		}
		
		return s;
	}
	
	@Override
	public double getXSize() {
		// TODO Auto-generated method stub
		return getLongeurext();
	}
	@Override
	public double getYSize() {
		// TODO Auto-generated method stub
		return getHauteurext();
	}
	@Override
	public double getZSize() {
		// TODO Auto-generated method stub
		return getProfondeurext();
	}
	@Override
	public BufferedImage getImage() {
		// TODO Auto-generated method stub
		try {
		
			Bundle bundle = Platform.getBundle("Dressing");
			Path path = new Path("pictures/bs.jpg");
			URL url = FileLocator.find(bundle, path, null);
			return ImageIO.read(url);
			
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return null;
		}
	}
	
	@Override
	public DesignObject3D clone() {
		Caisson space=new Caisson();
		try {
			space=(Caisson) this.copy((DesignObject3D)space);
		} catch (DesignException | GeometricEngineException | CloneNotSupportedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return space;
	}
	@Override
	public DesignObject3D copy(DesignObject3D object) throws DesignException, GeometricEngineException, CloneNotSupportedException {
		Caisson caisson=(Caisson) object;
		caisson=(Caisson) super.copy((Space3D)caisson);
		caisson.setPorttype(getPorttype());
		caisson.setPortinclude(isPortinclude());
		caisson.setTirroirinclude(isTirroirinclude());
		caisson.setEtagefixinclude(isEtagefixinclude());
		caisson.setEtagefixposition(getEtagefixposition());
		caisson.setEtagemobilebascount(getEtagemobilebascount());
		caisson.setEtagemobilehautcount(getEtagemobilehautcount());
		caisson.setVerrouslongeur(isVerrouslongeur());
		caisson.setVerrous(isVerrous());
		caisson.setCuissontype(getCuissontype());
		caisson.setLongeurextfree(isLongeurextfree());
		
		List<Charniere> charnieres = getcharniere(caisson);
		for (Charniere ch : charnieres) {
			DesignObject3D mother = DesignObject3D.getCharniereMother(ch, caisson.getRootCaisson());
			ch.setMother(mother);
			if (mother != null) {
				mother.addBaby(ch);
			}
		}
		List<SupportBlocTiroir> supportsblocktiroir = getSupportBlocTiroirs(caisson);
		for (SupportBlocTiroir ch : supportsblocktiroir) {
			DesignObject3D mother = DesignObject3D.getSupportBlocTiroirMother(ch, caisson.getRootCaisson());
			ch.setMother((Tirroir) mother);
			if (mother != null) {
				mother.addBaby(mother);
			}
		}
		List<Usinage> usins = getUsinages(caisson);
		for (Usinage usin : usins) {
			DesignObject3D mother = DesignObject3D.getUsinageMother(usin, caisson.getRootCaisson());
			usin.setMother(mother);
			if (mother != null) {
				mother.addBaby(usin);
			}
		}
		return caisson;
	}
}