package dressing.handlers;

import java.util.List;

import javax.inject.Inject;

import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

import dressing.model.Caisson;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Kitchen;
import dressing.model.Piece2D;
import dressing.model.Project3D;
import dressing.model.ProjectManager;
import dressing.model.Separator;
import dressing.model.Space3DFree;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.PieceType;
import dressing.ui.dressing.DressingWizard;
import dressing.ui.parts.ModelPackageTreePart;
import dressing.ui.parts.ProjectExplorerPart;

public class DeleteHandler {

	@Inject ESelectionService selectionService;
	
	@Inject
	IEclipseContext  eclipsecontext;
	@Execute
	public void execute(EPartService partService,Shell shell){
		Object o = null;
		
		MPart part=partService.getActivePart();
		Object activePart = part.getObject();
		 if(activePart instanceof ModelPackageTreePart) {
			 o = selectionService.getSelection("dressing.part.bibliothque");
		 }else if(activePart instanceof ProjectExplorerPart){
		 	o = selectionService.getSelection("dressing.part.projectexplorer");
		 }
		 else {
			o= selectionService.getSelection("dressing.part.tree"); 
		 }
		//Voire l element de l arbre selectionne
		 if(o instanceof List) {
			 for(Object o1:(List)o) {
				 deleteElement(o1, shell); 
			 }
		 }else {
			 deleteElement(o, shell); 
		 }
	}
	@CanExecute
	public boolean check(EPartService partService)
	{
		Object o = null;
		
		MPart part=partService.getActivePart();
		Object activePart = part.getObject();
		 if(activePart instanceof ModelPackageTreePart) {
			 o = selectionService.getSelection("dressing.part.bibliothque");
		 }else if(activePart instanceof ProjectExplorerPart){
			 	o = selectionService.getSelection("dressing.part.projectexplorer");
			 	if( o instanceof Kitchen) {
			 		ProjectManager.getManager().getCurrentProject().removeKitchen((Kitchen)o);
			 	}else if (o instanceof Space3DFree) {
			 		for(Kitchen kitchen: ProjectManager.getManager().getCurrentProject().getKitchens()) {
			 			if(kitchen.containsElement((Space3DFree) o))
			 				kitchen.removeElement((Space3DFree) o);
			 		}
			 	}	
			 	
		 }else {
			o= selectionService.getSelection("dressing.part.tree"); 
		 }	
		 if(o instanceof List) {
			 for(Object o1:(List)o) {
				 if(!check(o1)) {
					 return false;	 
				 }
			 }
			 return true;
		 }else {
			return check(o);
		 }
	}
	
	public boolean check(Object o) {
//		if(o instanceof DesignObject3D)
//		{
//			if(o instanceof Piece2D)
//			{
//				return true;
//			}
//			else if(o instanceof Project3D)
//			{
//				return false;
//			}
//			else
//			{
//				return true;
//			}
//		}
		if(o instanceof Kitchen || o instanceof Space3DFree) {
			return true;
		}
		return false;
	}
	public void deleteElement(Object o,Shell shell) {
		if(o!=null && o instanceof DesignObject3D)
		{
				DesignObject3D child = (DesignObject3D)o;
				if(child!= null && child.getParentdesign()!=null)
				{
					boolean ret = MessageDialog.openConfirm(shell, "Confirmation de supression", "Voulez vous supprimer "+child.getName());
					if (ret) {
						DesignObject3D parent = child.getParentdesign();
						
						/**
						 * tester si le child est une dos interieur il faut ajuster ces frère
						 */
						if(child!=null && child instanceof Piece2D && 
								((Piece2D) child).getPiecetype().equals(PieceType.DOS_INTERIEUR)) {
							try {
								parent.deletechild(child);
							}catch (GeometricEngineException | DesignException e) {					
								parent.setErrorexist(true);
								parent.setErrormsg(e.getMessage());
							}
							for(DesignObject3D piece:parent.getChilds())
								{
									if(piece instanceof Piece2D) {
										try {
											if(piece.getDebitage()!=null)
												piece.getDebitage().createupdateDebitage();
											else
												piece.constructDebitage();
											
											piece.evaluate();	
											piece.propagateUpdateToChildrens(parent);
										} catch (GeometricEngineException | DesignException e) {					
											parent.setErrorexist(true);
											parent.setErrormsg(e.getMessage());
										} finally {
					
										}
									}
								}
							if(parent.getParentdesign() instanceof DesignObject3D ) {
								try {
									if(parent.getDebitage()!=null)
										parent.getDebitage().createupdateDebitage();
									else
										parent.constructDebitage();
									
									parent.evaluate();	
									parent.propagateUpdateToChildrens(parent);
								}catch (GeometricEngineException | DesignException e) {					
									parent.setErrorexist(true);
									parent.setErrormsg(e.getMessage());
								}
							}
							if(parent.getParentdesign()!=null&& parent.getParentdesign() instanceof DesignObject3D ) {
								try {
									if(parent.getParentdesign().getDebitage()!=null)
										parent.getParentdesign().getDebitage().createupdateDebitage();
									else
										parent.getParentdesign().constructDebitage();
									
									parent.getParentdesign().evaluate();	
									parent.getParentdesign().propagateUpdateToChildrens(parent);
								}catch (GeometricEngineException | DesignException e) {					
									parent.setErrorexist(true);
									parent.setErrormsg(e.getMessage());
								}
							}
						} 
						else {
							try {
								
								parent.deletechild(child);
								if(parent!=null&& parent.getParentdesign()!=null &&parent.getParentdesign() instanceof Separator) {
									parent.getParentdesign().propagateUpdateToChildrens(null);
								}
							}catch (GeometricEngineException | DesignException e) {					
								parent.setErrorexist(true);
								parent.setErrormsg(e.getMessage());
							}
						}
						
					}

				}
			

		}		
	}
}
