package dressing.controller;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.Blob;

import dressing.model.BlocTirroir;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Materiaux;
import dressing.model.Tirroir;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.CaissonMontageType;
import dressing.model.types.CaissonType;
import dressing.model.types.DosType;
import dressing.model.types.PieceType;
import dressing.model.types.PortType;
import dressing.model.types.TiroireFacadeType;
import dressing.model.types.TirroirType;

public class TirroirCreator implements Creator {
	Tirroir Tirroir;
	public static double MIN_TIRROIR_HAUTEUR=100;
	String name="Tiroir";
	
	double longeur = 600;
	double hauteur = 720;
	double profondeur = 560;
	Materiaux basematerial=new Materiaux();
	Materiaux backmaterial=new Materiaux();
	Materiaux facadeMaterial=new Materiaux();
	
	DesignObject3D parent;
	private TirroirType tiroirType=TirroirType.TENDENBOX;
	private TiroireFacadeType facadetype=TiroireFacadeType.FACADE_EXTERIEUR_TIROIR;
	
	
	private double yPos=0;

	
	
	public double getyPos() {
		return yPos;
	}

	public void setyPos(double yPos) {
		double oldValue=this.yPos;
		this.yPos = yPos;
		firePropertyChange("yPos", oldValue, this.yPos);
	}

	/**
	 * @return the facadetype
	 */
	public TiroireFacadeType getFacadetype() {
		return facadetype;
	}

	/**
	 * @param facadetype the facadetype to set
	 */
	public void setFacadetype(TiroireFacadeType facadetype) {
		TiroireFacadeType oldValue=this.facadetype;
		this.facadetype = facadetype;
		firePropertyChange("facadetype", oldValue, this.facadetype);
		
	}
	public TirroirType getTiroirType() {
		return tiroirType;
	}
	
	public void setTiroirType(TirroirType tiroirType) {
		TirroirType oldValue=this.tiroirType;
		this.tiroirType = tiroirType;
		firePropertyChange("tiroirType", oldValue, this.tiroirType);	
	}
	
	public Tirroir getTirroir() {
		return Tirroir;
	}

	public void setTirroir(Tirroir blocTirroir) {
		Tirroir oldValue = this.Tirroir;
		this.Tirroir = Tirroir;
		firePropertyChange("Tirroir", oldValue, Tirroir);
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		String oldValue = this.name;
		this.name = name;
		firePropertyChange("name", oldValue, name);

	}

	public double getLongeur() {
		return longeur;
	}

	public void setLongeur(double longeur) {
		double oldValue = this.longeur;
		this.longeur = longeur;
		firePropertyChange("longeur", oldValue, longeur);
	}

	public double getHauteur() {
		return hauteur;
	}

	public void setHauteur(double hauteur) {
		double oldValue = this.hauteur;
		this.hauteur = hauteur;
		firePropertyChange("hauteur", oldValue, hauteur);
	}

	public double getProfondeur() {
		return profondeur;
	}

	public void setProfondeur(double profondeur) {
		double oldValue = this.profondeur;
		this.profondeur = profondeur;
		firePropertyChange("profondeur", oldValue, profondeur);
	}

	public Materiaux getFacadeMaterial() {
		return facadeMaterial;
	}

	public void setFacadeMaterial(Materiaux facadeMaterial) {
		Materiaux oldValue = this.facadeMaterial;
		this.facadeMaterial = facadeMaterial;
		firePropertyChange("facadeMaterial", oldValue, facadeMaterial);
	}

	public Materiaux getBasematerial() {
		return basematerial;
	}

	public void setBasematerial(Materiaux basematerial) {
		Materiaux oldValue = this.basematerial;
		this.basematerial = basematerial;
		firePropertyChange("basematerial", oldValue, basematerial);
	}

	public Materiaux getBackmaterial() {
		return backmaterial;
	}

	public void setBackmaterial(Materiaux backmaterial) {
		Materiaux oldValue = this.backmaterial;
		this.backmaterial = backmaterial;
		firePropertyChange("backmaterial", oldValue, backmaterial);
	}

	public DesignObject3D getParent() {
		return parent;
	}

	public void setParent(DesignObject3D parent) {
		DesignObject3D oldValue = this.parent;
		this.parent = parent;
		firePropertyChange("parent", oldValue, parent);
	}

	@Override
	public void check() throws DesignException {
		if (getName() == null || getName().isEmpty())
			throw new DesignException("Le nom de bloc tirroir est obligatoire");

		if (getBasematerial() == null)
			throw new DesignException("Le matérieaux de base doit être rensigné");

		if (getBackmaterial() == null)
			throw new DesignException("Le matérieaux de dos doit être rensigné");

		if (getBasematerial().getEpaisseur() <= 0)
			throw new DesignException("L'epaisseur de matérieaux de base doit être superieur à 1 mm");

		if (getBackmaterial().getEpaisseur() <= 0)
			throw new DesignException("L'epaisseur de matérieaux de dos doit être superieur à 1 mm");

		if(getFacadetype().equals(TiroireFacadeType.FACADE_INTERIEUR_TIROIR)&& !getTiroirType().equals(TirroirType.CLASSIC)) {
			throw new DesignException("facade de tiroir interieur est non supporter avec les types de tiroir Tandembox et Metabox");
		}

	}

	@Override
	public void create() throws DesignException, GeometricEngineException {
		check();
		this.Tirroir=new Tirroir();
		this.Tirroir.setName(getName());

		
		this.Tirroir.setBackmaterial(getBackmaterial());
		this.Tirroir.setBasematerial(getBasematerial());
		this.Tirroir.setFacadeMaterial(getFacadeMaterial());
		
		this.Tirroir.setHauteurext(getHauteur());
		this.Tirroir.setProfondeurext(getProfondeur());
		this.Tirroir.setLongeurext(getLongeur());
		this.Tirroir.setYpos(getyPos());
		
		this.Tirroir.setTiroireFacadeType(getFacadetype());
		this.Tirroir.setTiroirType(getTiroirType());
		
		this.Tirroir.setParentdesign(getParent());
		this.Tirroir.constructDebitage();
		this.Tirroir.evaluate();
		createSubElements();
	}

	@Override
	public void createSubElements() throws DesignException, GeometricEngineException {
		if(this.Tirroir==null) {
			throw new DesignException("un problème est survenue lors de création de la bloc Tiroir");
		}
		
		if(getTiroirType().equals(TirroirType.CLASSIC)) {
			//creer les pieces necessaires
			Piece2DCreator piececreator = new Piece2DCreator();

			piececreator.setName("Cote Droite");
			piececreator.setPiecetype(PieceType.COTE_DROITE_TIROIR);	
			piececreator.setMaterial(getBasematerial());
			piececreator.setParent(this.Tirroir);	
			piececreator.create();
			this.Tirroir.addElement(piececreator.getPiece2DInstance());

			
			//
			piececreator.setName("Cote Gauche");
			piececreator.setPiecetype(PieceType.COTE_GAUCHE_TIROIR);
			piececreator.setMaterial(getBasematerial());
			piececreator.setParent(this.Tirroir);		
			piececreator.create();
			this.Tirroir.addElement(piececreator.getPiece2DInstance());
			
			//
			piececreator.setName("Bas");
			piececreator.setPiecetype(PieceType.BAS_TIROIR);
			piececreator.setMaterial(getBasematerial());
			piececreator.setParent(this.Tirroir);		
			piececreator.create();
			this.Tirroir.addElement(piececreator.getPiece2DInstance());
			//
			
			piececreator.setName("Facade");
			if(getFacadetype().equals(TiroireFacadeType.FACADE_EXTERIEUR_TIROIR)) {
				piececreator.setPiecetype(PieceType.FACADE_EXTERIEUR_TIROIR);
			}else if(getFacadetype().equals(TiroireFacadeType.FACADE_INTERIEUR_TIROIR)) {
				piececreator.setPiecetype(PieceType.FACADE_INTERIEUR_TIROIR);
			}
			piececreator.setMaterial(getFacadeMaterial());
			piececreator.setParent(this.Tirroir);		
			piececreator.create();
			this.Tirroir.addElement(piececreator.getPiece2DInstance());
			
			//
			piececreator.setName("Dos");
			piececreator.setPiecetype(PieceType.DERIERE_TIROIR);
			piececreator.setMaterial(getBasematerial());
			piececreator.setParent(this.Tirroir);		
			piececreator.create();
			this.Tirroir.addElement(piececreator.getPiece2DInstance());
			
		}else {
			Piece2DCreator piececreator = new Piece2DCreator();
			piececreator.setName("Facade" +getName());
			if(getFacadetype().equals(TiroireFacadeType.FACADE_EXTERIEUR_TIROIR)) {
				piececreator.setPiecetype(PieceType.FACADE_EXTERIEUR_TIROIR);
			}else if(getFacadetype().equals(TiroireFacadeType.FACADE_INTERIEUR_TIROIR)) {
				piececreator.setPiecetype(PieceType.FACADE_INTERIEUR_TIROIR);
			}		
			piececreator.setBackmaterial(getBackmaterial());
			piececreator.setBasematerial(getBasematerial());
			piececreator.setMaterial(getFacadeMaterial());
			piececreator.setParent(this.Tirroir);		
			piececreator.create();
			this.Tirroir.addElement(piececreator.getPiece2DInstance());		
			
			piececreator.setName("Deriere " + getName());
			piececreator.setPiecetype(PieceType.DERIERE_TIROIR);
			piececreator.setMaterial(getBasematerial());
			piececreator.setParent(this.Tirroir);	
			piececreator.create();
			this.Tirroir.addElement(piececreator.getPiece2DInstance());
			
			piececreator.setName("Bas " + getName());
			piececreator.setPiecetype(PieceType.BAS_TIROIR);
			piececreator.setMaterial(getBasematerial());
			piececreator.setParent(this.Tirroir);	
			piececreator.create();
			this.Tirroir.addElement(piececreator.getPiece2DInstance());
		}
		
		
	}
	
	public Tirroir getInstance() {
		return Tirroir;
	}
	
	
	
	transient protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

	public void addPropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(listener);
	}

	public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
	}

	public void removePropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(listener);
	}

	public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
	}

	protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
		propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
	}

}
