/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package tech.frsdev.graphunit;
import javax.swing.*; // For JPanel, etc.

import dressing.cam.model.DXF_STATIC_VALUE;
import dressing.cam.model.Rotationangle;

import java.awt.*;           // For Graphics, etc.
import java.awt.geom.*;      // For Ellipse2D, etc.
import java.io.Serializable;
import java.util.Vector;  // load Vector package
import java.lang.Double;  // load Vector package
 
/**
 *
 * @author Administrateur
 */
public class PFill2DShape  extends PGraph implements Serializable{
    private static final long serialVersionUID = 352L;
    String textcenterd;
    private final PointDXF Startpoint;
    private final float Width;
    private final float Height;
    private final Color color;
    private PointDXF temppoint;
    private int textsize = 15;
    private Font f;
    //352-0
    public PFill2DShape(PointDXF ipoint,float iWidth,float iHeight,Color icolor)
    {

     Startpoint = ipoint;
     Width = iWidth;
     Height = iHeight;
     color = icolor;
     textcenterd=" ";

    }


     public PFill2DShape(PointDXF ipoint,float iWidth,float iHeight,Color icolor,String text,double sizescalefactor)
    {

     Startpoint = ipoint;
     Width = iWidth;
     Height = iHeight;
     color = icolor;
     textcenterd = text;

     textsize = (int)(sizescalefactor/(double)textsize)+1;
     


    }

    public void draw(Graphics g)
    {
     Graphics2D g2d = (Graphics2D)g;
     g2d.setColor(color);
     g2d.fillRect((int)Startpoint.x,(int)Startpoint.y,(int)Width, (int)Height);
     drawCenteredString(textcenterd, (int)Width, (int)Height, g2d);
    }


     public void drawCenteredString(String s, float w, float h, Graphics g)
	  {
		 Graphics2D g2d = (Graphics2D)g;
	     temppoint=new PointDXF();
	     temppoint.x = this.Startpoint.x;
	     temppoint.y = this.Startpoint.y;
             g2d.setColor(Color.black);
	    // System.out.println(temppoint.x);

		  

                  f = new Font("SansSerif", Font.ROMAN_BASELINE, textsize); //mise � jour du fond
                  g2d.setFont(f); //adapter nouveau fond au graphic
                  FontMetrics fm = g2d.getFontMetrics();
		  while((w - fm.stringWidth(s))<0)  //difference entre w et largeur du texte
		  {
		    	  this.textsize--;
		    	  f = new Font("SansSerif",Font.ROMAN_BASELINE, textsize); //mise � jour du fond
		    	  g2d.setFont(f); //adapter nouveau fond au graphic
		    	  fm = g2d.getFontMetrics();  //mise � jour de la taille du texte
		  }

		  this.textsize--;
    	  f = new Font("SansSerif",Font.ROMAN_BASELINE, textsize);
    	  g2d.setFont(f);
    	  fm = g2d.getFontMetrics();

		  float x = ((w - fm.stringWidth(s)) / 2)+temppoint.x;
		  float y = ((fm.getAscent() + (h - (fm.getAscent() + fm.getDescent())) / 2))+temppoint.y;
		  g2d.drawString(s, x, y);
	  }
    
    @Override
    public String getDXFLineEntetity()
    {
 
    String s="";
        if(!isDrawDXFLine())
        {
            return s;
        }
        PLineDXFEntity line1 = null;
        PLineDXFEntity line2 = null;
        PLineDXFEntity line3 = null;
        PLineDXFEntity line4 = null;
        PointDXF origin = new PointDXF(this.Startpoint.getLocation());

        //ligne 1 
        PointDXF p1 = origin.getLocation();
        PointDXF p2 = p1.getLocation();
        p2.x += this.Width;

        //ligne2
        PointDXF p3 = p2.getLocation();
        p3.y += this.Height;

        //ligne 3 
        PointDXF p4 = p1.getLocation();
        p4.y += this.Height;

          //ligne 4
        if(DXF_STATIC_VALUE.INVERT_CORDENATE)
        {
            InvertCodanate(p1);
            InvertCodanate(p2);
            InvertCodanate(p3);
            InvertCodanate(p4);
        }
        if (DXF_STATIC_VALUE.USE_POLYLINE == false) {
            line1 = new PLineDXFEntity(p1, p2);
            line2 = new PLineDXFEntity(p2, p3);
            line3 = new PLineDXFEntity(p1, p4);
            line4 = new PLineDXFEntity(p4, p3);

            //Create String seintity
            s += line1.getDXFLineEntetity();
            s += line2.getDXFLineEntetity();
            s += line3.getDXFLineEntetity();
            s += line4.getDXFLineEntetity();
        }
        else
        {
            PolyLineDXFEntity poly = new PolyLineDXFEntity(true);
            poly.addVertices(p1);
            poly.addVertices(p2);
            poly.addVertices(p3);
            poly.addVertices(p4);
            poly.addVertices(p1);
            s +=  poly.getDXFEntity(Rotationangle.angleRotation0);
        }
        return s;
    }
}
