package dressing.ui.util;

import org.eclipse.swt.widgets.Shell;

import dressing.model.ModelProvider;
import dressing.ui.CommandStack;
import dressing.ui.parts.GdxPart;
import param.DesignClasse;
import param.Equation;
import param.MechanicDesign;
import param.MechanicDesignElment;
import param.MechanicDesignGroup;
import param.MechanicPrivateParam;
import param.MechanicPublicParam;
import param.TypeDef;
import param.TypeDefElement;
import param.impl.MechanicPrivateParamImpl;
import param.impl.MechanicPublicParamImpl;
import param.impl.ParamFactoryImpl;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;

import java.util.List;

import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;

import dressing.ui.emf.MechanicdesignLibrary.ModelEMFLabelProvider;
import org.eclipse.swt.widgets.Group;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;

public class ParamManagerHelper extends org.eclipse.jface.window.Window{
	private DataBindingContext m_bindingContext;

	public ParamManagerHelper(Shell parentShell) {
		super(parentShell);
		setShellStyle(SWT.SHELL_TRIM| SWT.APPLICATION_MODAL);
		setBlockOnOpen(true);
	}
	
	public Shell shell;
	paramManagerModel model=new paramManagerModel();
	private static ParamManagerHelper instance;
	private ListViewer lV_includedClasses;
	private Button removeClassButton;
	private ListViewer lv_ExcludedClasses;
	private Button addClassButton;
	private ListViewer lv_IncludedFamilies;
	private Button removefamilyButton;
	private ListViewer lv_ExcludedFamilies;
	private Button addfamilyButton;
	private ListViewer lv_IncludedDesigns;
	private Button removeDesignButton;
	private Button addDesignButton;
	private ListViewer lv_ExcludedDesigns;
	private Text text;
	private Text text_1;
	private Text text_2;
	private Text text_3;
	private Text text_4;
	private Text text_5;
	private Text text_6;
	private org.eclipse.swt.widgets.List includedClasses;
	private org.eclipse.swt.widgets.List excludedClasses;
	private org.eclipse.swt.widgets.List includedFamilies;
	private org.eclipse.swt.widgets.List excludedFamilies;
	private org.eclipse.swt.widgets.List includedDesigns;
	private org.eclipse.swt.widgets.List excludedDesigns;
	private ListViewer privateParamsListViewer_1;
	private org.eclipse.swt.widgets.List privateParamsList_1;
	private ListViewer publicParamsListViewer;
	private org.eclipse.swt.widgets.List publicParamsList;
	private Combo comboPrivateTypeDef;
	private Combo comboPrivateTypeDefElement;
	private Combo comboPublicTypeDef;
	private Combo comboPublicTypeDefElment;
	private Button btnChangable;
	private ComboViewer cbVPublicTypeDef;
	private ComboViewer cbVPublicTypeDefElment;
	private ComboViewer cbVPrivateTypeDef;
	private ComboViewer cbvPrivateTypeDefElement;
	private MechanicPrivateParamImpl privateParam=(MechanicPrivateParamImpl) ParamFactoryImpl.eINSTANCE.createMechanicPrivateParam();
	private MechanicPublicParamImpl publicParam=(MechanicPublicParamImpl) ParamFactoryImpl.eINSTANCE.createMechanicPublicParam();
	private Button btnPrivate;
	private Button btnPublic;
	private Button btnType;
	private Button btnValue;
	private Button btnLabel;
	private ListViewer lv_IncludedDesignElements;
	private org.eclipse.swt.widgets.List includedDesignElementsList;
	private Button removeDesignElementsButton_1;
	private ListViewer lv_ExcludedDesignElements_1;
	private org.eclipse.swt.widgets.List excludedDesignElementsList;
	private Button addDesignElementsButton_1;
	private Text txtKey;
	private Text textExpression;
	private ListViewer listViewerEquations;
	private ListViewer lv_excludedPieceTypes;
	private org.eclipse.swt.widgets.List excludedPieceTypes;
	private ListViewer lv_IncludedPieceTypes;
	private org.eclipse.swt.widgets.List includedPieceTypes;
	private Button AddPieceTypeButton;
	private Button RemovePieceTypeButton;
	private Button btnParamters;
	private Button btnEquations;

	public static ParamManagerHelper getInstance() {
	 		synchronized(ParamManagerHelper.class) {
	 			if (instance == null) {
	 				instance = new ParamManagerHelper(GdxPart.parentShell);
	 				instance.create();
	 				instance.constrainShellSize();
	 			}
	 			return instance;
	 		}
	 }


	@Override
	protected boolean canHandleShellCloseEvent() {
		return true;
	}
	@Override
	protected void handleShellCloseEvent() {
		setReturnCode(CANCEL);
		hide();
//		close();
	}
	

	/**  
	 * Create contents of the window.
	 * @return 
	 */
	protected Control createContents(Composite parent) {
		parent.setTouchEnabled(true);
		this.shell=parent.getShell();
		parent.getShell().setText("Param Handler Helper");
		shell.addShellListener(getShellListener());

		Composite composite = new Composite(parent, SWT.FILL);
		composite.setTouchEnabled(true);
		composite.setLayout(new GridLayout(1, false));
		
		Group grpGrer = new Group(composite, SWT.NONE);
		grpGrer.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 1, 1));
		grpGrer.setText("Gérer");
		grpGrer.setLayout(new GridLayout(2, false));
		
		btnParamters = new Button(grpGrer, SWT.RADIO);
		btnParamters.setSelection(true);
		btnParamters.setText("Paramters");
		
		btnEquations = new Button(grpGrer, SWT.RADIO);
		btnEquations.setText("Equations");
		
		Composite composite_1 = new Composite(composite, SWT.FILL);
		GridData gd_composite_1 = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		gd_composite_1.widthHint = 685;
		gd_composite_1.heightHint = 410;
		composite_1.setLayoutData(gd_composite_1);
		composite_1.setLayout(new GridLayout(1, false));
		
		ExpandBar expandBar = new ExpandBar(composite_1, SWT.V_SCROLL);
		expandBar.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		
		ExpandItem xpndtmClass = new ExpandItem(expandBar, SWT.NONE);
		xpndtmClass.setText("Class");
		
		ScrolledComposite scrolledComposite = new ScrolledComposite(expandBar, SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
		xpndtmClass.setControl(scrolledComposite);
		scrolledComposite.setExpandHorizontal(true);
		scrolledComposite.setExpandVertical(true);
		xpndtmClass.setHeight(100);
		
		Composite composite_3 = new Composite(scrolledComposite, SWT.NONE);
		composite_3.setLayout(new GridLayout(3, false));
		
		lV_includedClasses = new ListViewer(composite_3, SWT.BORDER | SWT.V_SCROLL | SWT.MULTI);
		includedClasses = lV_includedClasses.getList();
		includedClasses.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 2));
		lV_includedClasses.setLabelProvider(ModelEMFLabelProvider.getInstance());
		lV_includedClasses.setContentProvider(ArrayContentProvider.getInstance());
		
		removeClassButton = new Button(composite_3, SWT.NONE);
		removeClassButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {

				IStructuredSelection selection = lV_includedClasses.getStructuredSelection();
				if (selection.size() >= 1) {
					List select = selection.toList();
					if (select != null && select.get(0) instanceof DesignClasse) {
						model.removeClasses(select);
						update();
					}
				}
				
			}
		});
		removeClassButton.setLayoutData(new GridData(SWT.FILL, SWT.BOTTOM, false, false, 1, 1));
		removeClassButton.setImage(ResourceManager.getPluginImage("Dressing", "icons/forward_nav.png"));
		
		lv_ExcludedClasses = new ListViewer(composite_3, SWT.BORDER | SWT.V_SCROLL | SWT.MULTI);
		excludedClasses = lv_ExcludedClasses.getList();
		excludedClasses.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 2));
		lv_ExcludedClasses.setLabelProvider(ModelEMFLabelProvider.getInstance());
		lv_ExcludedClasses.setContentProvider(ArrayContentProvider.getInstance());
		
		addClassButton = new Button(composite_3, SWT.NONE);
		addClassButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {

				IStructuredSelection selection = lv_ExcludedClasses.getStructuredSelection();
				if (selection.size() >= 1) {
					List select = selection.toList();
					if (select != null && select.get(0) instanceof DesignClasse) {
						model.addClasses(select);
						update();
					}
				}
				
			}
		});
		addClassButton.setImage(ResourceManager.getPluginImage("Dressing", "icons/backward_nav.png"));
		addClassButton.setLayoutData(new GridData(SWT.FILL, SWT.TOP, false, false, 1, 1));
		scrolledComposite.setContent(composite_3);
		scrolledComposite.setMinSize(composite_3.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		
		ExpandItem xpndtmFamille = new ExpandItem(expandBar, SWT.NONE);
		xpndtmFamille.setText("family");
		
		Composite composite_3_1 = new Composite(expandBar, SWT.NONE);
		xpndtmFamille.setControl(composite_3_1);
		xpndtmFamille.setHeight(200);
		composite_3_1.setLayout(new GridLayout(3, false));
		
		lv_IncludedFamilies = new ListViewer(composite_3_1, SWT.BORDER | SWT.V_SCROLL | SWT.MULTI);
		includedFamilies = lv_IncludedFamilies.getList();
		GridData gd_includedFamilies = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 2);
		gd_includedFamilies.heightHint = 54;
		includedFamilies.setLayoutData(gd_includedFamilies);
		lv_IncludedFamilies.setLabelProvider(ModelEMFLabelProvider.getInstance());
		lv_IncludedFamilies.setContentProvider(ArrayContentProvider.getInstance());
		removefamilyButton = new Button(composite_3_1, SWT.NONE);
		removefamilyButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection selection = lv_IncludedFamilies.getStructuredSelection();
				if (selection.size() >= 1) {
					List select = selection.toList();
					if (select != null && select.get(0) instanceof MechanicDesignGroup) {
						model.removeFamilies(select);
						update();
					}
				}
			}
		});
		removefamilyButton.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		removefamilyButton.setImage(ResourceManager.getPluginImage("Dressing", "icons/forward_nav.png"));
		
		lv_ExcludedFamilies = new ListViewer(composite_3_1, SWT.BORDER | SWT.V_SCROLL | SWT.MULTI);
		excludedFamilies = lv_ExcludedFamilies.getList();
		GridData gd_excludedFamilies = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 2);
		gd_excludedFamilies.heightHint = 54;
		excludedFamilies.setLayoutData(gd_excludedFamilies);
		lv_ExcludedFamilies.setLabelProvider(ModelEMFLabelProvider.getInstance());
		lv_ExcludedFamilies.setContentProvider(ArrayContentProvider.getInstance());
		
		addfamilyButton = new Button(composite_3_1, SWT.NONE);
		addfamilyButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection selection = lv_ExcludedFamilies.getStructuredSelection();
				if (selection.size() >= 1) {
					List select = selection.toList();
					if (select != null && select.get(0) instanceof MechanicDesignGroup) {
						model.addFamilies(select);
						update();
					}
				}
			}
		});
		addfamilyButton.setLayoutData(new GridData(SWT.FILL, SWT.TOP, false, false, 1, 1));
		addfamilyButton.setImage(ResourceManager.getPluginImage("Dressing", "icons/backward_nav.png"));
		
		ExpandItem xpndtmDesigns = new ExpandItem(expandBar, SWT.NONE);
		xpndtmDesigns.setText("designs");
		
		Composite composite_3_1_1 = new Composite(expandBar, SWT.NONE);
		xpndtmDesigns.setControl(composite_3_1_1);
		xpndtmDesigns.setHeight(500);
		composite_3_1_1.setLayout(new GridLayout(3, false));
		
		lv_IncludedDesigns = new ListViewer(composite_3_1_1, SWT.BORDER | SWT.V_SCROLL | SWT.MULTI);
		includedDesigns = lv_IncludedDesigns.getList();
		includedDesigns.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 2));
		lv_IncludedDesigns.setLabelProvider(ModelEMFLabelProvider.getInstance());
		lv_IncludedDesigns.setContentProvider(ArrayContentProvider.getInstance());
		lv_IncludedDesigns.addSelectionChangedListener(new ISelectionChangedListener() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				Object select=lv_IncludedDesigns.getStructuredSelection().getFirstElement();
				if(select!=null&&select instanceof MechanicDesign) {
					MechanicDesign design=(MechanicDesign) select;
					model.setDesigntoRemove(design);
					updateParams();
				}
			}

		});
		removeDesignButton = new Button(composite_3_1_1, SWT.NONE);
		removeDesignButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection selection = lv_IncludedDesigns.getStructuredSelection();
				if (selection.size() >= 1) {
					List select = selection.toList();
					if (select != null && select.get(0) instanceof MechanicDesign) {
						model.removeDesigns(select);
						update();
					}
				}
			}
		});
		removeDesignButton.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		removeDesignButton.setImage(ResourceManager.getPluginImage("Dressing", "icons/forward_nav.png"));
		
		lv_ExcludedDesigns = new ListViewer(composite_3_1_1, SWT.BORDER | SWT.V_SCROLL | SWT.MULTI);
		excludedDesigns = lv_ExcludedDesigns.getList();
		GridData gd_excludedDesigns = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 2);
		gd_excludedDesigns.heightHint = 58;
		excludedDesigns.setLayoutData(gd_excludedDesigns);
		lv_ExcludedDesigns.setLabelProvider(ModelEMFLabelProvider.getInstance());
		lv_ExcludedDesigns.setContentProvider(ArrayContentProvider.getInstance());
		
		addDesignButton = new Button(composite_3_1_1, SWT.NONE);
		addDesignButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection selection = lv_ExcludedDesigns.getStructuredSelection();
				if (selection.size() >= 1) {
					List select = selection.toList();
					if (select != null && select.get(0) instanceof MechanicDesign) {
						model.addDesigns(select);
						update();
					}
				}
			}
		});
		addDesignButton.setLayoutData(new GridData(SWT.FILL, SWT.TOP, false, false, 1, 1));
		addDesignButton.setImage(ResourceManager.getPluginImage("Dressing", "icons/backward_nav.png"));
		
		ExpandItem xpndtmPublicParams = new ExpandItem(expandBar, SWT.NONE);
		xpndtmPublicParams.setText("Public params");
		
		Composite composite_6 = new Composite(expandBar, SWT.NONE);
		xpndtmPublicParams.setControl(composite_6);
		xpndtmPublicParams.setHeight(400);
		composite_6.setLayout(new GridLayout(1, false));
		
		publicParamsListViewer = new ListViewer(composite_6, SWT.BORDER | SWT.V_SCROLL);
		publicParamsList = publicParamsListViewer.getList();
		publicParamsList.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		publicParamsListViewer.setLabelProvider(ModelEMFLabelProvider.getInstance());
		publicParamsListViewer.setContentProvider(TypeDefContentProvider.getInstance());
		publicParamsListViewer.addSelectionChangedListener(new ISelectionChangedListener() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				Object select=publicParamsListViewer.getStructuredSelection().getFirstElement();
				if(select!=null&&select instanceof MechanicPublicParamImpl) {
					MechanicPublicParamImpl param=(MechanicPublicParamImpl) select;
					if(param.getTypedef()!=null) {
						cbVPublicTypeDefElment.setInput(param.getTypedef().getTypedefelement());
					}
					publicParam.set(EcoreUtil.copy(param));
				}
			}

		});
		ExpandItem xpndtmPricvateParams = new ExpandItem(expandBar, SWT.NONE);
		xpndtmPricvateParams.setText("Private Params");
		
		Composite composite_7 = new Composite(expandBar, SWT.NONE);
		xpndtmPricvateParams.setControl(composite_7);
		xpndtmPricvateParams.setHeight(250);
		composite_7.setLayout(new GridLayout(1, false));
		
		privateParamsListViewer_1 = new ListViewer(composite_7, SWT.BORDER | SWT.V_SCROLL);
		privateParamsList_1 = privateParamsListViewer_1.getList();
		privateParamsList_1.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		privateParamsListViewer_1.setLabelProvider(ModelEMFLabelProvider.getInstance());
		privateParamsListViewer_1.setContentProvider(ArrayContentProvider.getInstance());
		privateParamsListViewer_1.addSelectionChangedListener(new ISelectionChangedListener() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				Object select=privateParamsListViewer_1.getStructuredSelection().getFirstElement();
				if(select!=null&&select instanceof MechanicPrivateParamImpl) {
					MechanicPrivateParamImpl param=(MechanicPrivateParamImpl) select;
					if(param.getTypedef()!=null) {
						cbvPrivateTypeDefElement.setInput(param.getTypedef().getTypedefelement());
					}
					privateParam.set(EcoreUtil.copy(param));

				}
			}

		});
		ExpandItem xpndtmParamManger = new ExpandItem(expandBar, SWT.NONE);
		xpndtmParamManger.setText("param manger");
		
		Composite composite_4 = new Composite(expandBar, SWT.NONE);
		xpndtmParamManger.setControl(composite_4);
		xpndtmParamManger.setHeight(250);
		composite_4.setLayout(new GridLayout(2, false));
		
		Group grpParamType = new Group(composite_4, SWT.NONE);
		GridData gd_grpParamType = new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1);
		gd_grpParamType.heightHint = 43;
		gd_grpParamType.widthHint = 140;
		grpParamType.setLayoutData(gd_grpParamType);
		grpParamType.setText("param type");
		grpParamType.setLayout(new GridLayout(2, false));
		
		btnPrivate = new Button(grpParamType, SWT.RADIO);
		btnPrivate.setSelection(true);
		btnPrivate.setText("Private");
		
		btnPublic = new Button(grpParamType, SWT.RADIO);
		btnPublic.setText("public");
		
		ExpandBar expandBar_1 = new ExpandBar(composite_4, SWT.NONE);
		expandBar_1.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 4));
		
		ExpandItem xpndtmPrivateParam = new ExpandItem(expandBar_1, SWT.NONE);
		xpndtmPrivateParam.setText("private param");
		
		Composite composite_5 = new Composite(expandBar_1, SWT.NONE);
		xpndtmPrivateParam.setControl(composite_5);
		composite_5.setLayout(new GridLayout(2, false));
		
		Label lblName = new Label(composite_5, SWT.NONE);
		lblName.setText("Name");
		
		text = new Text(composite_5, SWT.BORDER);
		text.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblKey = new Label(composite_5, SWT.NONE);
		lblKey.setText("Key");
		
		text_1 = new Text(composite_5, SWT.BORDER);
		text_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblValue = new Label(composite_5, SWT.NONE);
		lblValue.setText("Value");
		
		text_2 = new Text(composite_5, SWT.BORDER);
		text_2.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblTypeDef = new Label(composite_5, SWT.NONE);
		lblTypeDef.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblTypeDef.setText("Type def");
		
		cbVPrivateTypeDef = new ComboViewer(composite_5, SWT.READ_ONLY);
		comboPrivateTypeDef = cbVPrivateTypeDef.getCombo();
		comboPrivateTypeDef.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		cbVPrivateTypeDef.setContentProvider(TypeDefContentProvider.getInstance());
		cbVPrivateTypeDef.setLabelProvider(ModelEMFLabelProvider.getInstance());
		
				cbVPrivateTypeDef.addSelectionChangedListener(new ISelectionChangedListener() {
					
					@Override
					public void selectionChanged(SelectionChangedEvent event) {
						Object select=cbVPrivateTypeDef.getStructuredSelection().getFirstElement();
						if(select!=null&&select instanceof TypeDef) {
							TypeDef param=(TypeDef) select;
							cbvPrivateTypeDefElement.setInput(param.getTypedefelement());
						}
					}
		
				});
				Label lblType = new Label(composite_5, SWT.NONE);
				lblType.setText("Type");
				
				cbvPrivateTypeDefElement = new ComboViewer(composite_5, SWT.READ_ONLY);
				cbvPrivateTypeDefElement.setContentProvider(ArrayContentProvider.getInstance());
				cbvPrivateTypeDefElement.setLabelProvider(ModelEMFLabelProvider.getInstance());
				
				comboPrivateTypeDefElement = cbvPrivateTypeDefElement.getCombo();
				comboPrivateTypeDefElement.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
				xpndtmPrivateParam.setHeight(200);
				
				ExpandItem xpndtmPublicParam = new ExpandItem(expandBar_1, SWT.NONE);
				xpndtmPublicParam.setText("public param");
				
				Composite composite_5_1 = new Composite(expandBar_1, SWT.NONE);
				xpndtmPublicParam.setControl(composite_5_1);
				composite_5_1.setSize(498, 200);
				composite_5_1.setLayout(new GridLayout(2, false));
				
				Label lblName_1 = new Label(composite_5_1, SWT.NONE);
				lblName_1.setText("Name");
				
				text_3 = new Text(composite_5_1, SWT.BORDER);
				text_3.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
				
				Label lblLabel = new Label(composite_5_1, SWT.NONE);
				lblLabel.setText("Label");
				
				text_6 = new Text(composite_5_1, SWT.BORDER);
				text_6.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
				
				Label lblKey_1 = new Label(composite_5_1, SWT.NONE);
				lblKey_1.setText("Key");
				
				text_4 = new Text(composite_5_1, SWT.BORDER);
				text_4.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
				
				Label lblValue_1 = new Label(composite_5_1, SWT.NONE);
				lblValue_1.setText("Value");
				
				text_5 = new Text(composite_5_1, SWT.BORDER);
				text_5.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
				
				Label lblTypeDef_1 = new Label(composite_5_1, SWT.NONE);
				lblTypeDef_1.setText("Type def");
				
				cbVPublicTypeDef = new ComboViewer(composite_5_1, SWT.READ_ONLY);
				comboPublicTypeDef = cbVPublicTypeDef.getCombo();
				comboPublicTypeDef.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
				
				cbVPublicTypeDef.setContentProvider(ArrayContentProvider.getInstance());
				cbVPublicTypeDef.setLabelProvider(ModelEMFLabelProvider.getInstance());
				cbVPublicTypeDef.addSelectionChangedListener(new ISelectionChangedListener() {
					
					@Override
					public void selectionChanged(SelectionChangedEvent event) {
						Object select=cbVPublicTypeDef.getStructuredSelection().getFirstElement();
						if(select!=null&&select instanceof TypeDef) {
							TypeDef param=(TypeDef) select;
							cbVPublicTypeDefElment.setInput(param.getTypedefelement());
						}
					}

				});
				Label lblType_1 = new Label(composite_5_1, SWT.NONE);
				lblType_1.setText("Type");
				
				cbVPublicTypeDefElment = new ComboViewer(composite_5_1, SWT.READ_ONLY);
				comboPublicTypeDefElment = cbVPublicTypeDefElment.getCombo();
				comboPublicTypeDefElment.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
				xpndtmPublicParam.setHeight(220);
				cbVPublicTypeDefElment.setContentProvider(TypeDefContentProvider.getInstance());
				cbVPublicTypeDefElment.setLabelProvider(ModelEMFLabelProvider.getInstance());
				btnChangable = new Button(composite_5_1, SWT.CHECK);
				btnChangable.setText("Changable");
				new Label(composite_5_1, SWT.NONE);
				cbVPublicTypeDef.setInput(ModelProvider.getModelroot().getCategorie().getTypedef());
				cbVPrivateTypeDef.setInput(ModelProvider.getModelroot().getCategorie().getTypedef());
		
		Group grpModificationType = new Group(composite_4, SWT.NONE);
		grpModificationType.setLayout(new GridLayout(3, false));
		GridData gd_grpModificationType = new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1);
		gd_grpModificationType.widthHint = 164;
		grpModificationType.setLayoutData(gd_grpModificationType);
		grpModificationType.setText("modification Type");
		
		btnType = new Button(grpModificationType, SWT.RADIO);
		btnType.setText("Type");
		
		btnValue = new Button(grpModificationType, SWT.RADIO);
		btnValue.setText("Value");
		
		btnLabel = new Button(grpModificationType, SWT.RADIO);
		btnLabel.setText("Label");
		
		Group grpOperation = new Group(composite_4, SWT.NONE);
		grpOperation.setLayout(new GridLayout(1, false));
		grpOperation.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		grpOperation.setText("Operation");
		
		Button btnAdd = new Button(grpOperation, SWT.RADIO);
		btnAdd.setText("Add");
		btnAdd.setSelection(true);
		Button btnModify = new Button(grpOperation, SWT.RADIO);
		btnModify.setText("Modify");
		
		Button btnRemove = new Button(grpOperation, SWT.RADIO);
		btnRemove.setText("remove");
		new Label(composite_4, SWT.NONE);
		
		ExpandItem xpndtmElementsTypes = new ExpandItem(expandBar, SWT.NONE);
		xpndtmElementsTypes.setExpanded(true);
		xpndtmElementsTypes.setText("Elements Types");
		
		Composite composite_9 = new Composite(expandBar, SWT.NONE);
		xpndtmElementsTypes.setControl(composite_9);
		xpndtmElementsTypes.setHeight(400);
		composite_9.setLayout(new GridLayout(3, false));
		
		lv_IncludedPieceTypes = new ListViewer(composite_9, SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL | SWT.MULTI);
		includedPieceTypes = lv_IncludedPieceTypes.getList();
		includedPieceTypes.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 2));
		lv_IncludedPieceTypes.setLabelProvider(ModelEMFLabelProvider.getInstance());
		lv_IncludedPieceTypes.setContentProvider(ArrayContentProvider.getInstance());
		
		RemovePieceTypeButton = new Button(composite_9, SWT.NONE);
		RemovePieceTypeButton.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 1, 1));
		RemovePieceTypeButton.setImage(ResourceManager.getPluginImage("Dressing", "icons/forward_nav.png"));
		lv_excludedPieceTypes = new ListViewer(composite_9, SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL | SWT.MULTI);
		excludedPieceTypes = lv_excludedPieceTypes.getList();
		excludedPieceTypes.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 2));
		lv_excludedPieceTypes.setLabelProvider(ModelEMFLabelProvider.getInstance());
		lv_excludedPieceTypes.setContentProvider(ArrayContentProvider.getInstance());
		AddPieceTypeButton = new Button(composite_9, SWT.NONE);
		AddPieceTypeButton.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 1, 1));
		AddPieceTypeButton.setImage(ResourceManager.getPluginImage("Dressing", "icons/backward_nav.png"));
		AddPieceTypeButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection selection = lv_excludedPieceTypes.getStructuredSelection();
				if (selection.size() >= 1) {
					List select = selection.toList();
					if (select != null && select.get(0) instanceof TypeDefElement) {
						model.addPieceTypes(select);
						update();
					}
				}
			}
		});
		RemovePieceTypeButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection selection = lv_IncludedPieceTypes.getStructuredSelection();
				if (selection.size() >= 1) {
					List select = selection.toList();
					if (select != null && select.get(0) instanceof TypeDefElement) {
						model.removePieceTypes(select);
						update();
					}
				}
			}
		});
		ExpandItem xpndtmDesignElments = new ExpandItem(expandBar, 0);
		xpndtmDesignElments.setText("Design Elments");
		
		Composite composite_DesignElments = new Composite(expandBar, SWT.NONE);
		xpndtmDesignElments.setControl(composite_DesignElments);
		composite_DesignElments.setLayout(new GridLayout(3, false));
		
		lv_IncludedDesignElements = new ListViewer(composite_DesignElments, SWT.BORDER | SWT.V_SCROLL | SWT.MULTI);
		includedDesignElementsList = lv_IncludedDesignElements.getList();
		includedDesignElementsList.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 2));
		lv_IncludedDesignElements.setLabelProvider(ModelEMFLabelProvider.getInstance());
		lv_IncludedDesignElements.setContentProvider(ArrayContentProvider.getInstance());
		
		removeDesignElementsButton_1 = new Button(composite_DesignElments, SWT.NONE);
		removeDesignElementsButton_1.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		removeDesignElementsButton_1.setImage(ResourceManager.getPluginImage("Dressing", "icons/forward_nav.png"));
		removeDesignElementsButton_1.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection selection=lv_IncludedDesignElements.getStructuredSelection();
				if(selection.size()>=1) {
					List select=selection.toList();
					if(select!=null&&select.get(0) instanceof MechanicDesignElment ) {
						model.removeDesignElements(select);
						update();
					}
				}
				
			}
		});
		lv_ExcludedDesignElements_1 = new ListViewer(composite_DesignElments, SWT.BORDER | SWT.V_SCROLL | SWT.MULTI);
		excludedDesignElementsList = lv_ExcludedDesignElements_1.getList();
		GridData gd_excludedDesignElements = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 2);
		gd_excludedDesignElements.heightHint = 58;
		excludedDesignElementsList.setLayoutData(gd_excludedDesignElements);
		lv_ExcludedDesignElements_1.setLabelProvider(ModelEMFLabelProvider.getInstance());
		lv_ExcludedDesignElements_1.setContentProvider(ArrayContentProvider.getInstance());
		
		addDesignElementsButton_1 = new Button(composite_DesignElments, SWT.NONE);
		addDesignElementsButton_1.setLayoutData(new GridData(SWT.FILL, SWT.TOP, false, false, 1, 1));
		addDesignElementsButton_1.setImage(ResourceManager.getPluginImage("Dressing", "icons/backward_nav.png"));
		xpndtmDesignElments.setHeight(200);
		
		ExpandItem xpndtmEquations = new ExpandItem(expandBar, SWT.NONE);
		xpndtmEquations.setText("Equations");
		
		Composite composite_8 = new Composite(expandBar, SWT.NONE);
		xpndtmEquations.setControl(composite_8);
		xpndtmEquations.setHeight(xpndtmEquations.getControl().computeSize(SWT.DEFAULT, SWT.DEFAULT).y*4);
		composite_8.setLayout(new FillLayout(SWT.HORIZONTAL));
		
		SashForm sashForm = new SashForm(composite_8, SWT.NONE);
		
		listViewerEquations = new ListViewer(sashForm, SWT.BORDER | SWT.V_SCROLL);
		listViewerEquations.setContentProvider(ArrayContentProvider.getInstance());
		listViewerEquations.setLabelProvider(ModelEMFLabelProvider.getInstance());
		Composite compositeEquation = new Composite(sashForm, SWT.NONE);
		compositeEquation.setLayout(new GridLayout(2, false));
		
		Label lblkey = new Label(compositeEquation, SWT.NONE);
		lblkey.setBounds(0, 0, 55, 15);
		lblkey.setText("Key");
		
		txtKey = new Text(compositeEquation, SWT.BORDER);
		txtKey.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		txtKey.setBounds(0, 0, 76, 21);
		
		Label lblExpression = new Label(compositeEquation, SWT.NONE);
		lblExpression.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblExpression.setText("Expression");
		
		textExpression = new Text(compositeEquation, SWT.BORDER);
		textExpression.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		sashForm.setWeights(new int[] {1, 1});
		addDesignElementsButton_1.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection selection=lv_ExcludedDesignElements_1.getStructuredSelection();
				if(selection.size()>=1) {
					List select=selection.toList();
					if(select!=null&&select.get(0) instanceof MechanicDesignElment ) {
						model.addDesignElements(select);
						update();
					}
				}
			}
		});
		lv_IncludedDesignElements.addSelectionChangedListener(new ISelectionChangedListener() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				Object select=lv_IncludedDesignElements.getStructuredSelection().getFirstElement();
				if(select!=null&&select instanceof MechanicDesignElment) {
					listViewerEquations.setInput(((MechanicDesignElment)select).getEquation());
				}
			}

		});
		listViewerEquations.addSelectionChangedListener(new ISelectionChangedListener() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				Object select=listViewerEquations.getStructuredSelection().getFirstElement();
				if(select!=null&&select instanceof Equation) {
					txtKey.setText(((Equation) select).getKey());
					textExpression.setText(((Equation) select).getExpression());

				}
			}

		});
		Composite composite_2 = new Composite(composite, SWT.NONE);
		GridData gd_composite_2 = new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1);
		gd_composite_2.heightHint = 38;
		composite_2.setLayoutData(gd_composite_2);
		GridLayout gl_composite_2 = new GridLayout(2, false);
		gl_composite_2.horizontalSpacing = 0;
		composite_2.setLayout(gl_composite_2);
		
		Button btnRun = new Button(composite_2, SWT.NONE);
		btnRun.setImage(ResourceManager.getPluginImage("Dressing", "icons/Calculer.png"));
		GridData gd_btnRun = new GridData(SWT.FILL, SWT.BOTTOM, true, true, 1, 1);
		gd_btnRun.heightHint = 31;
		btnRun.setLayoutData(gd_btnRun);
		
		btnRun.setText("Execute");
		
		Button btnFermer = new Button(composite_2, SWT.NONE);
		GridData gd_btnFermer = new GridData(SWT.FILL, SWT.BOTTOM, true, true, 1, 1);
		gd_btnFermer.heightHint = 31;
		btnFermer.setLayoutData(gd_btnFermer);
		btnFermer.setText("Fermer");
		composite.setTabList(new Control[]{composite_1, composite_2});
		
		btnFermer.addSelectionListener(new SelectionAdapter() {
		
					@Override
					public void widgetSelected(SelectionEvent e) {
						// TODO Auto-generated method stub
						ParamManagerHelper.this.hide();
					}
					
				});
		btnRun.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(SelectionEvent e) {
						if(btnParamters.getSelection()) {
							if(btnAdd.getSelection()) {
								addParams();
							}else if(btnRemove.getSelection()) {
								removeParams();
							}else {
								modifyParams();
							}
						}else {
							UpdateEquations();
						}
						
					}
					
				});
	
		ControlAdapter adaptor=new ControlAdapter() {

			@Override
			public void controlResized(ControlEvent e) {
				 Rectangle area2= ParamManagerHelper.this.getShell().getClientArea();
			     composite.setBounds(area2);
			}
			
		};
		parent.addControlListener(adaptor);
		composite.addControlListener(adaptor);
		getShell().addControlListener(adaptor);	
		update();			
		m_bindingContext = initDataBindings();
		return composite;

	}
	private void UpdateEquations() {
		if(model.getIncludeddesignElemnts()!=null && !model.getIncludeddesignElemnts().isEmpty())
		{
			for (MechanicDesignElment element : model.getIncludeddesignElemnts()) {
				try {
					if(element.getEquation()!=null && element.getEquation().size()>0) {
						for( Equation eq:element.getEquation()) {
							if(eq.getKey()!=null && !textExpression.isDisposed() &&textExpression.getText()!=null 
									&& !txtKey.isDisposed() && txtKey.getText()!=null
									&&eq.getKey().contentEquals(txtKey.getText())) {
								
								eq.setExpression(textExpression.getText());
							}
						}
					}
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}
	}
	private void addParams() {
		if(model.getIncludeddesign()!=null && !model.getIncludeddesign().isEmpty())
		{
			for (MechanicDesign design : model.getIncludeddesign()) {
				try {
					if (model.isIspublic()) {
					
						MechanicPublicParamImpl publicParam = EcoreUtil.copy(this.publicParam);

						if (model.isValue()) {
							publicParam.setTypedef(null);
							publicParam.setTypedefelement(null);
						}else if(model.isType()) {
							publicParam.setDefaultvalue(null);
							
						}else {
							continue;
						}
						try {
							MechanicPublicParam old = design.getPublicParam(publicParam.getKey());
							if (old != null) {
								old.set(publicParam);
							}
							else {
								design.getPublicparamgroup().getMechanicpublicparam().add(publicParam);
							}
						} catch (Exception e) {
							design.getPublicparamgroup().getMechanicpublicparam().add(publicParam);
							e.printStackTrace();
						}
					} else {
						
						MechanicPrivateParamImpl privateParam = EcoreUtil.copy(this.privateParam);

						if (model.isValue()) {
							privateParam.setTypedef(null);
							privateParam.setTypedefelement(null);
						}else if(model.isType()) {
							privateParam.setValue(null);
						}else {
							continue;
						}
						try {
							MechanicPrivateParam old = design.getPrivateParam(privateParam.getKey());
							if (old != null) {
								old.set(privateParam);
							}else {
								design.getPrivateparamgroup().getMechanicprivateparam().add(privateParam);
							}
						} catch (Exception e) {
							design.getPrivateparamgroup().getMechanicprivateparam().add(privateParam);
							e.printStackTrace();
						}

					}
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}
		
	}
	private void modifyParams() {
		if(model.getIncludeddesign()!=null && !model.getIncludeddesign().isEmpty())
		{
			for (MechanicDesign design : model.getIncludeddesign()) {
				try {
					if (model.isIspublic()) {
					
						MechanicPublicParamImpl publicParam = EcoreUtil.copy(this.publicParam);

						if (model.isValue()) {
							publicParam.setTypedef(null);
							publicParam.setTypedefelement(null);
						}else if(model.isType()) {
							publicParam.setDefaultvalue(null);
							
						}
						try {
							MechanicPublicParam old = design.getPublicParam(publicParam.getKey());
							if (old != null) {
								if(!model.isLabel()) {
									old.set(publicParam);
								}else {
									old.setUserlabel(publicParam.getUserlabel());

								}
							}				
						} catch (Exception e) {
							e.printStackTrace();
						}
					} else {
						
						MechanicPrivateParamImpl privateParam = EcoreUtil.copy(this.privateParam);

						if (!model.isType()) {
							privateParam.setTypedef(null);
							privateParam.setTypedefelement(null);
						}else if(model.isType()) {
							privateParam.setValue(null);
						}
						try {
							MechanicPrivateParam old = design.getPrivateParam(privateParam.getKey());
							if (old != null) {
								if(!model.isLabel()) {
									old.set(privateParam);
								}
							}
						} catch (Exception e) {
							e.printStackTrace();
						}

					}
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}
		
	}
	private void removeParams() {
		if(model.getIncludeddesign()!=null && !model.getIncludeddesign().isEmpty())
		{
			for (MechanicDesign design : model.getIncludeddesign()) {
				try {
					if (model.isIspublic()) {
						try {
							MechanicPublicParam old = design.getPublicParam(publicParam.getKey());
							if (old != null) {
								design.getPublicparamgroup().getMechanicpublicparam().remove(old);
							}
						} catch (Exception e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					
					} else {
						try {
							MechanicPrivateParam old = design.getPrivateParam(privateParam.getKey());
							if (old != null) {
								design.getPrivateparamgroup().getMechanicprivateparam().remove(old);

							}
						} catch (Exception e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
						

					}
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}
		
	}
	public void update() {
		lV_includedClasses.setInput(model.getIncludedclasses());
		lv_IncludedFamilies.setInput(model.getIncludedfamily());
		lv_IncludedDesigns.setInput(model.getIncludeddesign());
		lv_ExcludedClasses.setInput(model.getExcludedclasses());
		lv_ExcludedFamilies.setInput(model.getExcludedfamily());
		lv_ExcludedDesigns.setInput(model.getExcludeddesign());
		lv_ExcludedDesignElements_1.setInput(model.getExcludeddesignElemnts());
		lv_IncludedDesignElements.setInput(model.getIncludeddesignElemnts());
		lv_IncludedPieceTypes.setInput(model.getIncludedPieceTypes());
		lv_excludedPieceTypes.setInput(model.getExcludedPieceTypes());
	}
	private void updateParams() {
		if(model.getDesigntoRemove()!=null) {
			publicParamsListViewer.setInput(model.getDesigntoRemove().getPublicparamgroup().getMechanicpublicparam());
			privateParamsListViewer_1.setInput(model.getDesigntoRemove().getPrivateparamgroup().getMechanicprivateparam());
		}
		
	}
	public synchronized void  show() {
		if(!shell.isDisposed())
		{
			ParamManagerHelper.this.shell.setVisible(true);
			ParamManagerHelper.this.shell.setActive();

		}

	}
	public synchronized void hide() {
		if(!shell.isDisposed())
		{
			
			ParamManagerHelper.this.shell.setVisible(false);
		}

	}
	public CommandStack updateObject(){
		
		return null;
	}
	public void createController() {
		
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeTextTextObserveWidget = WidgetProperties.text(SWT.Modify).observe(text);
		IObservableValue privateParamnameModelObserveValue = BeanProperties.value("name").observe(privateParam);
		bindingContext.bindValue(observeTextTextObserveWidget, privateParamnameModelObserveValue, null, null);
		//
		IObservableValue observeTextText_1ObserveWidget = WidgetProperties.text(SWT.Modify).observe(text_1);
		IObservableValue privateParamkeyModelObserveValue = BeanProperties.value("key").observe(privateParam);
		bindingContext.bindValue(observeTextText_1ObserveWidget, privateParamkeyModelObserveValue, null, null);
		//
		IObservableValue observeTextText_2ObserveWidget = WidgetProperties.text(SWT.Modify).observe(text_2);
		IObservableValue privateParamvalueModelObserveValue = BeanProperties.value("value").observe(privateParam);
		bindingContext.bindValue(observeTextText_2ObserveWidget, privateParamvalueModelObserveValue, null, null);
		//
		IObservableValue observeTextText_3ObserveWidget = WidgetProperties.text(SWT.Modify).observe(text_3);
		IObservableValue publicParamnameModelObserveValue = BeanProperties.value("name").observe(publicParam);
		bindingContext.bindValue(observeTextText_3ObserveWidget, publicParamnameModelObserveValue, null, null);
		//
		IObservableValue observeTextText_6ObserveWidget = WidgetProperties.text(SWT.Modify).observe(text_6);
		IObservableValue publicParamuserlabelModelObserveValue = BeanProperties.value("userlabel").observe(publicParam);
		bindingContext.bindValue(observeTextText_6ObserveWidget, publicParamuserlabelModelObserveValue, null, null);
		//
		IObservableValue observeTextText_4ObserveWidget = WidgetProperties.text(SWT.Modify).observe(text_4);
		IObservableValue publicParamkeyModelObserveValue = BeanProperties.value("key").observe(publicParam);
		bindingContext.bindValue(observeTextText_4ObserveWidget, publicParamkeyModelObserveValue, null, null);
		//
		IObservableValue observeTextText_5ObserveWidget = WidgetProperties.text(SWT.Modify).observe(text_5);
		IObservableValue publicParamdefaultvalueModelObserveValue = BeanProperties.value("defaultvalue").observe(publicParam);
		bindingContext.bindValue(observeTextText_5ObserveWidget, publicParamdefaultvalueModelObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnChangableObserveWidget = WidgetProperties.widgetSelection().observe(btnChangable);
		IObservableValue publicParamchangeableModelObserveValue = BeanProperties.value("changeable").observe(publicParam);
		bindingContext.bindValue(observeSelectionBtnChangableObserveWidget, publicParamchangeableModelObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionCbVPrivateTypeDef = ViewerProperties.singleSelection().observe(cbVPrivateTypeDef);
		IObservableValue privateParamtypedefModelObserveValue = BeanProperties.value("typedef").observe(privateParam);
		bindingContext.bindValue(observeSingleSelectionCbVPrivateTypeDef, privateParamtypedefModelObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionCbVPublicTypeDefElment = ViewerProperties.singleSelection().observe(cbVPublicTypeDefElment);
		IObservableValue publicParamtypedefelementModelObserveValue = BeanProperties.value("typedefelement").observe(publicParam);
		bindingContext.bindValue(observeSingleSelectionCbVPublicTypeDefElment, publicParamtypedefelementModelObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionCbVPublicTypeDef = ViewerProperties.singleSelection().observe(cbVPublicTypeDef);
		IObservableValue publicParamtypedefModelObserveValue = BeanProperties.value("typedef").observe(publicParam);
		bindingContext.bindValue(observeSingleSelectionCbVPublicTypeDef, publicParamtypedefModelObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionCbvPrivateTypeDefElement = ViewerProperties.singleSelection().observe(cbvPrivateTypeDefElement);
		IObservableValue typedefelementPrivateParamObserveValue = BeanProperties.value("typedefelement").observe(privateParam);
		bindingContext.bindValue(observeSingleSelectionCbvPrivateTypeDefElement, typedefelementPrivateParamObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnPrivateObserveWidget = WidgetProperties.widgetSelection().observe(btnPrivate);
		IObservableValue isprivateModelObserveValue = BeanProperties.value("isprivate").observe(model);
		bindingContext.bindValue(observeSelectionBtnPrivateObserveWidget, isprivateModelObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnPublicObserveWidget = WidgetProperties.widgetSelection().observe(btnPublic);
		IObservableValue ispublicModelObserveValue = BeanProperties.value("ispublic").observe(model);
		bindingContext.bindValue(observeSelectionBtnPublicObserveWidget, ispublicModelObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnTypeObserveWidget = WidgetProperties.widgetSelection().observe(btnType);
		IObservableValue typeModelObserveValue = BeanProperties.value("type").observe(model);
		bindingContext.bindValue(observeSelectionBtnTypeObserveWidget, typeModelObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnValueObserveWidget = WidgetProperties.widgetSelection().observe(btnValue);
		IObservableValue valueModelObserveValue = BeanProperties.value("value").observe(model);
		bindingContext.bindValue(observeSelectionBtnValueObserveWidget, valueModelObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnLabelObserveWidget = WidgetProperties.widgetSelection().observe(btnLabel);
		IObservableValue labelModelObserveValue = BeanProperties.value("label").observe(model);
		bindingContext.bindValue(observeSelectionBtnLabelObserveWidget, labelModelObserveValue, null, null);
		//
		return bindingContext;
	}
}
