package dressing.ui.separator;

import java.awt.print.Pageable;
import java.util.HashMap;

import javax.inject.Inject;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;

import dressing.controller.DressingCreator;
import dressing.controller.Piece2DCreator;
import dressing.model.Caisson;
import dressing.model.DesignException;
import dressing.model.Dressing;
import dressing.model.Materiaux;
import dressing.model.Project3D;
import dressing.model.Space3D;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.PieceType;
import dressing.model.types.PortType;



public class SeparatorWizard extends Wizard{

	//L injection ne peut etre en marche que si on creer l objet avec contextfactory et non pas avec l objet new
	@Inject
	IEclipseContext  eclipsecontext;

	@Inject
	private EHandlerService handlerService;
	
	@Inject
	private ECommandService commandService;

	Space3D space3d;
	Piece2DCreator piece = new Piece2DCreator();
	SeparatorWelcomePage welcompage;

	public SeparatorWizard () {
		setWindowTitle("Nouveau separateur");		
		//init

	}

	@Override
	public void addPages() {
		welcompage = new SeparatorWelcomePage("WelcomePage",piece);
		addPage(welcompage);		

	}

	@Override
	public boolean performFinish() {
		for(IWizardPage page :getPages())
		{
			((WizardPage) page).setErrorMessage("");
		}
			try {
				if(this.piece.isSepratortransversal())
				{
					this.piece.setPiecetype(PieceType.SEPRATEUR_TRANSVERSANT);
				}
				else
				{
					this.piece.setPiecetype(PieceType.SEPRATEUR_NORMAL);
				}
				this.piece.create();
				welcompage.clearlistners();
				piece.clearlisteners();
				this.space3d.addElement(this.piece.getPiece2DInstance());	
			} catch (DesignException  | GeometricEngineException e) {
				for(IWizardPage page :getPages())
				{
					((WizardPage) page).setErrorMessage(e.getMessage());
				}
					return false;
			}

				
			return true;
	}
	
public void setSpace3D(Space3D space3d) {
	this.space3d = space3d;	
	piece.setName("Separateur");
	piece.setParent(space3d);
	piece.setWithseprator(true);
	piece.setBackmaterial(space3d.getBackmaterial());
	piece.setBasematerial(space3d.getBasematerial());
	piece.setMaterial(space3d.getBasematerial());
}
	@Override
public boolean canFinish() {
		IWizardPage[] pages = getPages();
		for (IWizardPage page : pages) {
			if (!page.isPageComplete()) {
				return false;
			}
		}
		return true;
	}
}
