package dressing.ui.editorWindows;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import param.URL;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;

public class UrlEditorWindow extends EditorWindow {
	private DataBindingContext m_bindingContext;

	private ScrolledComposite container;
	private Composite root;
	private URL url;
	private URL urlOrigin;

	private Text txtName;
	private Text txtPath;
	public UrlEditorWindow(Shell parentShell,int update,URL url) {
		super(parentShell,update);
		this.url=url;
		this.urlOrigin=EcoreUtil.copy(this.url);
	}

	@Override
	protected Composite createClientArea(Composite parent) {
		
		container = new ScrolledComposite(parent, SWT.V_SCROLL);
		container.setExpandHorizontal(true);
		GridData gd_container = new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1);
		gd_container.heightHint = 72;
		container.setLayoutData(gd_container);
		container.setExpandVertical(true);
		
		root = new Composite(container, SWT.NONE);
		root.setLayout(new GridLayout(2, false));
		
		Label lblNom = new Label(root, SWT.NONE);
		lblNom.setText("Nom");
		
		txtName = new Text(root, SWT.BORDER);
		GridData gd_txtName = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_txtName.minimumWidth = 300;
		txtName.setLayoutData(gd_txtName);
		
		Label lblPrenom = new Label(root, SWT.NONE);
		lblPrenom.setText("Adresse");
		
		txtPath = new Text(root, SWT.BORDER);
		txtPath.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		if(this.url!=null)
		{
			m_bindingContext = initDataBindings();
		}
		
		container.setContent(root);
		container.setMinSize(new Point(-1, 0));
		this.shell.setSize(container.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		Point preferedSize = container.computeSize(SWT.DEFAULT, SWT.DEFAULT);
		int frameX = shell.getSize().x - shell.getClientArea().width;
		int frameY = shell.getSize().y - shell.getClientArea().height;
		shell.setSize(preferedSize.x + frameX + 50, preferedSize.y + frameY + 50);
		shell.setLocation((shell.getParent().getSize().x - shell.getSize().x) / 2 + shell.getParent().getLocation().x,
				(shell.getParent().getSize().y - shell.getSize().y) / 2 + shell.getParent().getLocation().y);
		
		this.shell.setText("Editeur d'URL" );
		parent.requestLayout();
		ControlAdapter adaptor=new ControlAdapter() {

			@Override
			public void controlResized(ControlEvent e) {
				 Rectangle area2= UrlEditorWindow.this.getShell().getClientArea();
				 container.setBounds(area2);
			}
			
		};
		parent.addControlListener(adaptor);
		root.addControlListener(adaptor);
		getShell().addControlListener(adaptor);
		
		parent.requestLayout();
		return container;
	}

	@Override
	public boolean terminer() {
		if(!super.terminer()) {
			return false;
		}
		finish();
		return true;
	}
	
	@Override
	public boolean check() {
		errorMessage="";
		if(url.getName()==null || url.getName().isEmpty()) {
			errorMessage+="Le nom ne peur pas étre vide \n";
		}
		if(url.getPath()==null || url.getPath().isEmpty()) {
			errorMessage+="L'Adresse ne peur pas étre vide \n";
		}
		if(!errorMessage.isEmpty()) {
			return false;
		}
		return true;
	}
	public ScrolledComposite getContainer() {
		return container;
	}

	public void setContainer(ScrolledComposite container) {
		this.container = container;
	}

	public Composite getRoot() {
		return root;
	}

	public void setRoot(Composite root) {
		this.root = root;
	}
	
	@Override
	protected void cancel() {
		url.setName(urlOrigin.getName());
		url.setPath(urlOrigin.getPath());		
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeTextTxtNameObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtName);
		IObservableValue nameUrlObserveValue = PojoProperties.value("name").observe(url);
		bindingContext.bindValue(observeTextTxtNameObserveWidget, nameUrlObserveValue, null, null);
		//
		IObservableValue observeTextTxtPathObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtPath);
		IObservableValue pathUrlObserveValue = PojoProperties.value("path").observe(url);
		bindingContext.bindValue(observeTextTxtPathObserveWidget, pathUrlObserveValue, null, null);
		//
		return bindingContext;
	}
}
