package dressing.ui.cuisine;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.inject.Inject;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import dressing.controller.CuisineCreator;
import dressing.model.DesignException;
import dressing.model.ModelProvider;
import dressing.model.evalutor.GeometricEngineException;
import dressing.ui.util.SingleImageItemLabelProvider;
import dressing.ui.util.StaticUiObjects;
import dressing.ui.util.SwtTextFilter;
import org.eclipse.swt.widgets.Spinner;

public class CuisineWizardComposite extends Composite {
	@Inject
	IEclipseContext eclipsecontext;
	@Inject
	private ESelectionService selectionService;

	@Inject
	private EHandlerService handlerService;

	@Inject
	private ECommandService commandService;
	private DataBindingContext m_bindingContext;
	Text Name;
	private TableComboViewer tableComboViewermatprincipale;
	private TableComboViewer tableComboViewer_matdos;
	CuisineCreator cuisine;
	PropertyChangeListener pcl;
	boolean errorfound=false;
	Label lblNewLabel;
	private ModelProvider modelprovider = new ModelProvider();
	private Spinner spnhauteur;
	private Spinner spnprofondeur;
	
	public CuisineCreator getCuisine() {
		return cuisine;
	}

	public void setCuisine(CuisineCreator cuisine) {
		this.cuisine = cuisine;
	}

	/**
	 * Create the composite.
	 * @param parent
	 * @param style
	 */
	public CuisineWizardComposite(Composite parent, int style,CuisineCreator cuisine) {
		this(parent, style);
		setCuisine(cuisine);
		if (cuisine != null) {
			m_bindingContext = initDataBindings();
		}
		
	}
	public CuisineWizardComposite(Composite parent, int style) {
		super(parent, style);
		setLayout(new GridLayout(2, false));
		 lblNewLabel = new Label(this, SWT.NONE);
		lblNewLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel.setText("Name");
		
		 Name = new Text(this, SWT.BORDER);
		Name.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		
		Label lblNewLabel_2 = new Label(this, SWT.NONE);
		lblNewLabel_2.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_2.setText("Matérieaux principale");
		//
		tableComboViewermatprincipale = new TableComboViewer(this, SWT.READ_ONLY | SWT.BORDER);
		tableComboViewermatprincipale.getTableCombo().setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableComboViewermatprincipale.getTableCombo().setShowTableHeader(true);
		tableComboViewermatprincipale.getTableCombo().defineColumns(StaticUiObjects.MaterialColumns);
		tableComboViewermatprincipale.getTableCombo().getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		// do not allow editable
		tableComboViewermatprincipale.getTableCombo().setEditable(false);
		// set the content provider
		tableComboViewermatprincipale.setContentProvider(ArrayContentProvider.getInstance());
		// set the label provider
		tableComboViewermatprincipale.setLabelProvider(new SingleImageItemLabelProvider(this));
		// load the data
		tableComboViewermatprincipale.setInput(modelprovider.getMateriallist());
		
		//
		
		
		//
		 lblNewLabel_2 = new Label(this, SWT.NONE);
		lblNewLabel_2.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_2.setText("Matérieaux dos");
		

		//
		tableComboViewer_matdos = new TableComboViewer(this, SWT.READ_ONLY | SWT.BORDER);
		tableComboViewer_matdos.getTableCombo().setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableComboViewer_matdos.getTableCombo().setShowTableHeader(true);
		tableComboViewer_matdos.getTableCombo().defineColumns(StaticUiObjects.MaterialColumns);

		tableComboViewer_matdos.getTableCombo().setDisplayColumnIndex(0);
		tableComboViewer_matdos.getTableCombo().getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		// do not allow editable
		tableComboViewer_matdos.getTableCombo().setEditable(false);
		// set the content provider
		tableComboViewer_matdos.setContentProvider(ArrayContentProvider.getInstance());
		
		// set the label provider
		tableComboViewer_matdos.setLabelProvider(new SingleImageItemLabelProvider(this));

		// load the data
		tableComboViewer_matdos.setInput(modelprovider.getMateriallist());
		
		Label lblhauteur = new Label(this, SWT.NONE);
		lblhauteur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblhauteur.setText("hauteur");
		
		spnhauteur = new Spinner(this, SWT.BORDER);
		spnhauteur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spnhauteur.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		spnhauteur.setMaximum(1000000);
		
		Label lblprofondeur = new Label(this, SWT.NONE);
		lblprofondeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblprofondeur.setText("profondeur");
		
		spnprofondeur = new Spinner(this, SWT.BORDER);
		spnprofondeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spnprofondeur.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		spnprofondeur.setMaximum(1000000);
		if(cuisine!=null) {
			m_bindingContext = initDataBindings();
		}
		
	}
	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observetextNameObserveWidget = WidgetProperties.text(SWT.Modify).observe(Name);
		IObservableValue etagerecountEtgCreatorObserveValue = BeanProperties.value("name").observe(cuisine);
		bindingContext.bindValue(observetextNameObserveWidget, etagerecountEtgCreatorObserveValue, null, null);
		//
		IObservableValue observeSingleSelectiontTableComboViewermatprincipale = ViewerProperties.singleSelection().observe(tableComboViewermatprincipale);
		IObservableValue basematerialDressingObserveValue = BeanProperties.value("basematerial").observe(cuisine);
		bindingContext.bindValue(observeSingleSelectiontTableComboViewermatprincipale, basematerialDressingObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), null);
		//
		IObservableValue observeSingleSelectiontableComboViewer_matdos = ViewerProperties.singleSelection().observe(tableComboViewer_matdos);
		IObservableValue backmaterialDressingObserveValue = BeanProperties.value("backmaterial").observe(cuisine);
		bindingContext.bindValue(observeSingleSelectiontableComboViewer_matdos, backmaterialDressingObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), null);
		//
		IObservableValue observeSelectionSpnhauteurObserveWidget = WidgetProperties.spinnerSelection().observe(spnhauteur);
		IObservableValue hauteurCuisineObserveValue = BeanProperties.value("hauteur").observe(cuisine);
		bindingContext.bindValue(observeSelectionSpnhauteurObserveWidget, hauteurCuisineObserveValue, null, null);
		//
		IObservableValue observeSelectionSpnprofondeurObserveWidget = WidgetProperties.spinnerSelection().observe(spnprofondeur);
		IObservableValue profondeurCuisineObserveValue = BeanProperties.value("profondeur").observe(cuisine);
		bindingContext.bindValue(observeSelectionSpnprofondeurObserveWidget, profondeurCuisineObserveValue, null, null);
		//
		return bindingContext;
	}
}
