package dressing.ui.cuisine;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import dressing.model.Cuisine;
import dressing.model.DesignException;
import dressing.model.IUpdateStructure;
import dressing.model.ModelProvider;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import dressing.model.Materiaux;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.wb.swt.SWTResourceManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class CuisineCompositeEditor extends Composite implements IUpdateStructure{

	private DataBindingContext m_bindingContext;
	private Cuisine cuisine = new Cuisine();
	private ModelProvider modelprovider = new ModelProvider();

	Text nameText;
	private Text etagetxt;
	private Text apptxt;
	private Label lblMatrieauxPrincipale;
	private Label lblMatrieauxDos;
	private Combo combomatprincipale;
	//
	private TableComboViewer tableComboViewermatprincipale;
	//
	private ComboViewer comboViewermatprincipale;
	private Combo combomatdos;
	private ComboViewer comboViewer_matdos;
	//
	private TableComboViewer tableComboViewer_matdos;
	private Label lblHauteur;
	private Spinner spinner_hauteur;
	private Label lblProfondeur;
	private Spinner spinner_profondeur;
	private Label lblNewLabel_1;
	private MDirtyable dirty;
	ControlDecoration deco;
	private StyledText styledText;
	private int updatestragey = UpdateValueStrategy.POLICY_UPDATE;
	private TabFolder tabFolder;
	private TabItem tbtmAcceuil;
	private Composite composite;
	private Composite composite1;
	private TableComboViewer tcv;
	private TabItem tbtmMesure;
	private Label lblNewLabel_2;
	private Text text;
	private Label lblLongeur;
	private Spinner spinner_longeur;
	public CuisineCompositeEditor(Composite parent, int style, Cuisine newDressing,int updatestrategy) {
		this(parent, style|SWT.V_SCROLL);
		this.updatestragey = updatestrategy;
		setCuisine(newDressing);
	}

	public CuisineCompositeEditor(Composite parent, int style) {
		super(parent, SWT.NONE);
		setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT));
		setLayout(new GridLayout(3, false));
		
		lblNewLabel_1 = new Label(this, SWT.NONE);
		lblNewLabel_1.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT));
		lblNewLabel_1.setForeground(SWTResourceManager.getColor(SWT.COLOR_DARK_GREEN));
		lblNewLabel_1.setFont(SWTResourceManager.getFont("Segoe UI", 16, SWT.BOLD));
		lblNewLabel_1.setText("Cuisine");
		
		styledText = new StyledText(this, SWT.BORDER);
		styledText.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 2, 1));
		styledText.setForeground(SWTResourceManager.getColor(SWT.COLOR_RED));
		styledText.setEditable(false);
		styledText.setDoubleClickEnabled(false);
		styledText.setBackground(SWTResourceManager.getColor(SWT.COLOR_YELLOW));
		styledText.setAlwaysShowScrollBars(false);
		
		tabFolder = new TabFolder(this, SWT.NONE);
		tabFolder.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 3, 1));
		
		tbtmAcceuil = new TabItem(tabFolder, SWT.NONE);
		tbtmAcceuil.setText("Acceuil");
		
		composite = new Composite(tabFolder, SWT.NONE);
		
		tbtmAcceuil.setControl(composite);
		composite.setLayout(new GridLayout(2, false));
		
		Label label_4 = new Label(composite, SWT.NONE);
		label_4.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_BACKGROUND_GRADIENT));
		label_4.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		label_4.setText("Nom");
						
		nameText = new Text(composite, SWT.BORDER | SWT.SINGLE);
		nameText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		nameText.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		//
		Label lblEtage = new Label(composite, SWT.NONE);
		lblEtage.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT));
		lblEtage.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		lblEtage.setText("Etage");
								
		etagetxt = new Text(composite, SWT.BORDER);
		etagetxt.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		etagetxt.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));				
		Label lblapp = new Label(composite, SWT.NONE);
		lblapp.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT));
		lblapp.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		lblapp.setText("Appartement");
								
		apptxt = new Text(composite, SWT.BORDER);
		apptxt.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		apptxt.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		//
														
		lblMatrieauxPrincipale = new Label(composite, SWT.NONE);
		lblMatrieauxPrincipale.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT));
		lblMatrieauxPrincipale.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		lblMatrieauxPrincipale.setText("Mat\u00E9rieaux principale");
		//
		comboViewermatprincipale = new ComboViewer(composite, SWT.READ_ONLY);
		combomatprincipale = comboViewermatprincipale.getCombo();
		combomatprincipale.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		comboViewermatprincipale.setContentProvider(ArrayContentProvider.getInstance());
		comboViewermatprincipale.setLabelProvider(new LabelProvider() {
		     @Override
		     public String getText(Object element) {
		         if (element instanceof Materiaux) {
		        	 Materiaux mat = (Materiaux) element;
		             return mat.getName();
		         }
		         return super.getText(element);
		     }
		 });
		comboViewermatprincipale.setInput(ModelProvider.getMateriallist());
		//	
		lblMatrieauxDos = new Label(composite, SWT.NONE);
		lblMatrieauxDos.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT));
		lblMatrieauxDos.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		lblMatrieauxDos.setText("Mat\u00E9rieaux Dos");
		comboViewer_matdos = new ComboViewer(composite, SWT.READ_ONLY);
		combomatdos = comboViewer_matdos.getCombo();
		combomatdos.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		comboViewer_matdos.setContentProvider(ArrayContentProvider.getInstance());
		comboViewer_matdos.setLabelProvider(new LabelProvider() {
		     @Override
		     public String getText(Object element) {
		         if (element instanceof Materiaux) {
		        	 Materiaux mat = (Materiaux) element;
		             return mat.getName();
		         }
		         return super.getText(element);
		     }
		 });
		comboViewer_matdos.setInput(ModelProvider.getMateriallist());
		
	
		
		tbtmMesure = new TabItem(tabFolder, SWT.NONE);
		tbtmMesure.setText("Mesure");
		composite1 = new Composite(tabFolder, SWT.NONE);
		tbtmMesure.setControl(composite1);
		new Label(composite1, SWT.NONE);
		new Label(composite1, SWT.NONE);
		
		lblLongeur = new Label(composite1, SWT.NONE);
		lblLongeur.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		lblLongeur.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_BACKGROUND_GRADIENT));
		lblLongeur.setText("Longeur (mm)");
		
		spinner_longeur = new Spinner(composite1, SWT.BORDER);
		spinner_longeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		spinner_longeur.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		spinner_longeur.setMaximum(1000000);
		
		lblHauteur = new Label(composite1, SWT.NONE);
		lblHauteur.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_BACKGROUND_GRADIENT));
		lblHauteur.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		lblHauteur.setText("Hauteur (mm)");
		
		spinner_hauteur = new Spinner(composite1, SWT.BORDER);
		spinner_hauteur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		spinner_hauteur.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		spinner_hauteur.setMaximum(1000000);
		
		lblProfondeur = new Label(composite1, SWT.NONE);
		lblProfondeur.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_BACKGROUND_GRADIENT));
		lblProfondeur.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		lblProfondeur.setText("Profondeur (mm)");
		
		spinner_profondeur = new Spinner(composite1, SWT.BORDER);
		spinner_profondeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		spinner_profondeur.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		spinner_profondeur.setMaximum(10000000);
		composite1.setLayout(new GridLayout(2, false));
		m_bindingContext = initDataBindings();
		 
		//Ajouter le controle de dirty
		makedirtycontroller(this);
		makeerrorhandler(lblNewLabel_1);
		
		}
	

	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}

	
	public Cuisine getCuisine() {
		return cuisine;
	}

	public void setCuisine(Cuisine cuisine) {
		setCuisine(cuisine, true);
	}

public ModelProvider getModelprovider() {
	return modelprovider;
}
public void setModelprovider(ModelProvider modelprovider) {
	this.modelprovider = modelprovider;
}
	public void setCuisine(Cuisine newcuisine, boolean update) {
		this.cuisine = newcuisine;
		if (update) {
			if (m_bindingContext != null) {
				m_bindingContext.dispose();
				m_bindingContext = null;
			}
			if (this.cuisine != null) {
				m_bindingContext = initDataBindings();
			}
		}
	}
	
	private DataBindingContext custominitDataBindings() {

		//
		return null;
	}
	
	public void setDirty(MDirtyable dirty) {
		this.dirty = dirty;
	}
	public MDirtyable getDirty() {
		return dirty;
	}
	public void updateDirty()
	{
		if(this.dirty!=null)
		{
			this.dirty.setDirty(true);
		}
	}
	//Pour corriger le Bug de spinner que selctionne tous apres chaque saisie
	private void updateCaretposition(Control ctr)
	{
		Event ke = new Event();
        ke.type = SWT.MENU_KEYBOARD;
        ke.keyCode = SWT.ARROW_RIGHT;
        ctr.getDisplay().post(ke);
	}
	protected void makedirtycontroller(Composite comp)
	{

		//Faire la mise ajour des controel pour qui enregistre le dirty
				Control [] ctrl = comp.getChildren();
				for(Control ctr : comp.getChildren())
				{
					if(ctr instanceof Text)
					{
						((Text) ctr).addKeyListener(new KeyListener() {
							
							@Override
							public void keyReleased(KeyEvent e) {
								// TODO Auto-generated method stub
								updateDirty();
							}
							
							@Override
							public void keyPressed(KeyEvent e) {
								// TODO Auto-generated method stub
								
							}
						});
					}
					else
					{
						ctr.addListener(SWT.Selection, event->updateDirty());//Pour les spinner et les chekbox labada expresseion
					}
					if(ctr instanceof Spinner)
					{
						ctr.addListener(SWT.Selection, event->updateCaretposition(ctr));
					}

					if(ctr instanceof Composite)
					{
						makedirtycontroller((Composite)ctr);
					}
				}
	}

	@Override
	public void run() throws DesignException {
		// TODO Auto-generated method stub
		try
		{
			m_bindingContext.updateModels();

				cuisine.update();

			deco.setDescriptionText("");
			deco.hide();
		}
		catch( Exception e)
		{
			deco.setDescriptionText(e.getMessage());
			deco.show();
		}

	}

	@Override
	public void cancel() {
		// TODO Auto-generated method stub
		m_bindingContext.updateTargets();
	}
	protected void makeerrorhandler(Control control)
	{
		deco = new ControlDecoration(control, SWT.TOP | SWT.RIGHT);
		// re-use an existing image
		Image image = FieldDecorationRegistry.getDefault().getFieldDecoration(FieldDecorationRegistry.DEC_ERROR)
				.getImage();
		// set description and image
		deco.setImage(image);
		// hide deco if not in focus
		deco.setShowOnlyOnFocus(false);
		deco.hide();
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		
	
		
		IObservableValue nameObserveWidget = WidgetProperties.text().observe(nameText);
		IObservableValue nameObserveValue = BeanProperties.value("name").observe(cuisine);
		bindingContext.bindValue(nameObserveWidget, nameObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), null);
		//
		IObservableValue observeSingleSelectionComboViewermatprincipale = ViewerProperties.singleSelection().observe(comboViewermatprincipale);
		IObservableValue basematerialDressingObserveValue = BeanProperties.value("basematerial").observe(cuisine);
		bindingContext.bindValue(observeSingleSelectionComboViewermatprincipale, basematerialDressingObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), null);
		//
		IObservableValue observeSingleSelectionComboViewer_matdos = ViewerProperties.singleSelection().observe(comboViewer_matdos);
		IObservableValue backmaterialDressingObserveValue = BeanProperties.value("backmaterial").observe(cuisine);
		bindingContext.bindValue(observeSingleSelectionComboViewer_matdos, backmaterialDressingObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), null);
		//
		IObservableValue observeSelectionSpinner_longeurObserveWidget = WidgetProperties.spinnerSelection().observe(spinner_longeur);
		IObservableValue longeurextCuisineObserveValue = BeanProperties.value("longeurext").observe(cuisine);
		bindingContext.bindValue(observeSelectionSpinner_longeurObserveWidget, longeurextCuisineObserveValue, null, null);
		//
		IObservableValue observeSelectionSpinner_1ObserveWidget = WidgetProperties.spinnerSelection().observe(spinner_hauteur);
		IObservableValue hauteurextDressingObserveValue = BeanProperties.value("hauteurext").observe(cuisine);
		bindingContext.bindValue(observeSelectionSpinner_1ObserveWidget, hauteurextDressingObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), null);
		//
		IObservableValue observeSelectionSpinner_2ObserveWidget = WidgetProperties.spinnerSelection().observe(spinner_profondeur);
		IObservableValue profondeurextDressingObserveValue = BeanProperties.value("profondeurext").observe(cuisine);
		bindingContext.bindValue(observeSelectionSpinner_2ObserveWidget, profondeurextDressingObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), null);
		//
		IObservableValue observeTextStyledTextObserveWidget = WidgetProperties.text(SWT.Modify).observe(styledText);
		IObservableValue errormsgDressingObserveValue = BeanProperties.value("errormsg").observe(cuisine);
		bindingContext.bindValue(observeTextStyledTextObserveWidget, errormsgDressingObserveValue, null, null);
		//
		IObservableValue observeVisibleStyledTextObserveWidget = WidgetProperties.visible().observe(styledText);
		IObservableValue errorexistDressingObserveValue = BeanProperties.value("errorexist").observe(cuisine);
		bindingContext.bindValue(observeVisibleStyledTextObserveWidget, errorexistDressingObserveValue, null, null);
		//
		IObservableValue observeTextEtagetxtObserveWidget = WidgetProperties.text(SWT.FocusOut).observe(etagetxt);
		IObservableValue etageDressingObserveValue = BeanProperties.value("etage").observe(cuisine);
		bindingContext.bindValue(observeTextEtagetxtObserveWidget, etageDressingObserveValue, null, null);
		//
		IObservableValue observeTextApptxtObserveWidget = WidgetProperties.text(SWT.FocusOut).observe(apptxt);
		IObservableValue appartementDressingObserveValue = BeanProperties.value("appartement").observe(cuisine);
		bindingContext.bindValue(observeTextApptxtObserveWidget, appartementDressingObserveValue, null, null);
		//
		return bindingContext;
	}
}
