package dressing.model.debitage;

import java.util.ArrayList;

import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Piece2D;
import dressing.model.Space3D;
import dressing.model.Tirroir;
import dressing.model.evalutor.Equation;
import dressing.model.types.PieceType;
import dressing.model.types.TiroireFacadeType;
import dressing.model.types.TirroirType;

public class TiroirPieceDebitageFormulas extends DebitageFormulas {

	
	@Override
	public void FILL_DEBITAGE_FORMULAS(DesignObject3D parent,DesignObject3D child,ArrayList<Equation> equations) throws DesignException {
		if(parent==null || child==null)
			throw new DesignException("Formule de debitage : Parent ou child null");
		this.parent = parent;
		this.child = child;
		
		FILL_USINAGE(parent,child,equations); //les parametres d usine doivent être les premier
		if(parent instanceof Tirroir && child instanceof Piece2D ) {
			Tirroir tiroir=(Tirroir)parent;
			Piece2D piece=(Piece2D)child;
			TirroirType tiroirType=	tiroir.getTiroirType();
			TiroireFacadeType facadeType = tiroir.getTiroireFacadeType();
			PieceType piecetype=piece.getPiecetype();
			FILL_PIECE2D_FROM_TIRROIR(tiroir, equations);
			switch (tiroirType) {
			case CLASSIC:
				switch (piecetype) {
				case COTE_GAUCHE_TIROIR:
					ADDOrUpdateEquation("@this.e@", ""+piece.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;		
				
					//Fromules de debitage
					ADDOrUpdateEquation("@this.h@", "@Parent.h@ - 2*@usin.tiroirjeuFacadeBH@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.p@", "@Parent.pi@ - @usin.tiroirjeuDeriere@", Equation.CALCULATION_AUTO,equations) ;
	
					ADDOrUpdateEquation("@this.l@", "@this.e@", Equation.CALCULATION_AUTO,equations) ;
					
					ADDOrUpdateEquation("@this.posx@", "  @Parent.posxi@ + @usin.tiroirJeuCote@ + @usin.tiroirjeuFacadeCote@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posy@", "  @usin.tiroirjeuFacadeBH@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "  @usin.tiroirjeuDeriere@ ", Equation.CALCULATION_AUTO,equations) ;
					
					ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.h@,@this.p@)", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.h@,@this.p@)", Equation.CALCULATION_AUTO,equations) ;
					FILL_CHANT_DIM("@this.h@","@this.p@","@this.h@","@this.p@",equations);
					FILL_CHANT_EPAISSEUR("0","0","0","0",equations);
					
					FILL_PIECE2D(piece, equations);
					
					break;
				case COTE_DROITE_TIROIR:
					ADDOrUpdateEquation("@this.e@", ""+piece.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;		
				
					//Fromules de debitage
					ADDOrUpdateEquation("@this.h@", "@Parent.h@ - 2*@usin.tiroirjeuFacadeBH@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.p@", "@Parent.pi@ - @usin.tiroirjeuDeriere@", Equation.CALCULATION_AUTO,equations) ;
	
					ADDOrUpdateEquation("@this.l@", "@this.e@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posx@", " @Parent.posxi@ + @Parent.li@ - @usin.tiroirJeuCote@ - @this.e@ - @usin.tiroirjeuFacadeCote@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posy@", "  @usin.tiroirjeuFacadeBH@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "  @usin.tiroirjeuDeriere@ ", Equation.CALCULATION_AUTO,equations) ;
					
					ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.h@,@this.p@)", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.h@,@this.p@)", Equation.CALCULATION_AUTO,equations) ;
					
					FILL_CHANT_DIM("@this.h@","@this.p@","@this.h@","@this.p@",equations);
					FILL_CHANT_EPAISSEUR("0","0","0","0",equations);
	
					FILL_PIECE2D(piece, equations);
					
					
					break;
				case DERIERE_TIROIR:
					ADDOrUpdateEquation("@this.e@",  ""+piece.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;		
				
					//Fromules de debitage
					ADDOrUpdateEquation("@this.h@", "@Parent.h@-2*@usin.tiroirjeuFacadeBH@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.p@", "@this.e@", Equation.CALCULATION_AUTO,equations) ;
	
					ADDOrUpdateEquation("@this.l@", "@Parent.li@-2*@usin.tiroirJeuCote@-2*@this.e@ - 2* @usin.tiroirjeuFacadeCote@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posx@", "@Parent.posxi@ + @usin.tiroirJeuCote@+@Parent.epaisseurprincipale@ + @usin.tiroirjeuFacadeCote@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posy@", " @usin.tiroirjeuFacadeBH@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", " @usin.tiroirjeuDeriere@ ", Equation.CALCULATION_AUTO,equations) ;
	
					ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.h@,@this.p@)", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.h@,@this.p@)", Equation.CALCULATION_AUTO,equations) ;
					
					FILL_CHANT_DIM("@this.h@","@this.l@","@this.h@","@this.l@",equations);
					FILL_CHANT_EPAISSEUR("0","0","0","0",equations);
					
					FILL_PIECE2D(piece, equations);
					
					
					break;
					
				case BAS_TIROIR:
					ADDOrUpdateEquation("@this.e@",  ""+piece.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;		
				
					//Fromules de debitage
					ADDOrUpdateEquation("@this.h@", "@this.e@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.p@", "@Parent.pi@ - @usin.tiroirjeuDeriere@-@Parent.epaisseurprincipale@+@usin.tiroirderiereRainure@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.l@", "@Parent.li@ - 2*@usin.tiroirJeuCote@ - 2*@Parent.epaisseurprincipale@ - 2* @usin.tiroirjeuFacadeCote@ + 2 *@usin.tiroirRainureCote@", Equation.CALCULATION_AUTO,equations) ;
	
					ADDOrUpdateEquation("@this.posx@", " @Parent.posxi@ + @usin.tiroirJeuCote@ + @usin.tiroirjeuFacadeCote@ + @Parent.epaisseurprincipale@ - @usin.tiroirRainureCote@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posy@", "  @usin.tiroirjeuFacadeBH@ + @usin.dosRainurePositionOffset@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "  @usin.tiroirjeuDeriere@ + @Parent.epaisseurprincipale@ - @usin.tiroirderiereRainure@ ", Equation.CALCULATION_AUTO,equations) ;
	
					ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.h@,@this.p@)", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.h@,@this.p@)", Equation.CALCULATION_AUTO,equations) ;
					FILL_CHANT_DIM("0","0","0","0",equations);
					FILL_CHANT_EPAISSEUR("0","0","0","0",equations);
					
					
					FILL_PIECE2D(piece, equations);
					
					
					break;
				case FACADE_EXTERIEUR_TIROIR:
			
					ADDOrUpdateEquation("@this.e@",  ""+piece.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;		
				
					//Fromules de debitage
					ADDOrUpdateEquation("@this.h@", "@Parent.h@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.p@", "@Parent.epaisseurfacade@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.l@", "@Parent.l@", Equation.CALCULATION_AUTO,equations) ;//
					
					ADDOrUpdateEquation("@this.posx@", "@Parent.posx@ ", Equation.CALCULATION_AUTO,equations) ;//
					ADDOrUpdateEquation("@this.posy@", "0 ", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "  @Parent.pi@  ", Equation.CALCULATION_AUTO,equations) ;
					
					ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.h@,@this.p@)", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.h@,@this.p@)", Equation.CALCULATION_AUTO,equations) ;
					
					FILL_CHANT_DIM("@this.l@","@this.h@","@this.l@","@this.h@",equations);
					FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","@ep.quatdixieme@","@ep.quatdixieme@","@ep.quatdixieme@",equations);
				
					FILL_PIECE2D(piece, equations);
					
					
					break;	
				case FACADE_INTERIEUR_TIROIR:
			
					ADDOrUpdateEquation("@this.e@",  ""+piece.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;		
				
					//Fromules de debitage
					ADDOrUpdateEquation("@this.h@", "@Parent.h@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.p@", "@Parent.epaisseurfacade@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.l@", "@Parent.li@ - 2 * @usin.tiroirjeuFacade@", Equation.CALCULATION_AUTO,equations) ;//
					
					ADDOrUpdateEquation("@this.posx@", "@PParent.epaisseurprincipale@ + @usin.tiroirjeuFacade@ ", Equation.CALCULATION_AUTO,equations) ;//
					ADDOrUpdateEquation("@this.posy@", "0 ", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "  @Parent.pi@", Equation.CALCULATION_AUTO,equations) ;
					
					ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.h@,@this.p@)", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.h@,@this.p@)", Equation.CALCULATION_AUTO,equations) ;
					
					FILL_CHANT_DIM("@this.l@","@this.h@","@this.l@","@this.h@",equations);
					FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","@ep.quatdixieme@","@ep.quatdixieme@","@ep.quatdixieme@",equations);
				
					FILL_PIECE2D(piece, equations);
					
					
					break;	
				default:
					throw new DesignException(piecetype+" not found in debitage formula");
				}
				
				break;	
			case METABOX:
				switch (piecetype) {
				case BAS_TIROIR:
					ADDOrUpdateEquation("@this.e@",  ""+piece.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;		
					
					//Fromules de debitage
					ADDOrUpdateEquation("@this.h@", "@Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.p@", "@Parent.p@ - @Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.l@", "@Parent.l@ - 2* @PParent.epaisseurprincipale@ - 2*@usin.tiroirJeuCote@", Equation.CALCULATION_AUTO,equations) ;//
					
					ADDOrUpdateEquation("@this.posx@", "@PParent.epaisseurprincipale@ + @usin.tiroirJeuCote@", Equation.CALCULATION_AUTO,equations) ;//
					ADDOrUpdateEquation("@this.posy@", "@usin.tiroirjeuFacadeBas@ ", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "@Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
					
					ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.h@,@this.p@)", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.h@,@this.p@)", Equation.CALCULATION_AUTO,equations) ;
					
					FILL_CHANT_DIM("@this.l@","@this.h@","@this.l@","@this.h@",equations);
					FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","@ep.quatdixieme@","@ep.quatdixieme@","@ep.quatdixieme@",equations);
				
					FILL_PIECE2D(piece, equations);	
					break;
				case COTE_DROITE_TIROIR:
					
					break;
				case COTE_GAUCHE_TIROIR:
						
					break;
				case DERIERE_TIROIR:
					ADDOrUpdateEquation("@this.e@",  ""+piece.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;		
					
					//Fromules de debitage
					ADDOrUpdateEquation("@this.h@", "@Parent.h@ - @usin.tiroirjeuFacadeHaut@ - @usin.tiroirjeuFacadeBas@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.p@", "@this.e@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.l@", "@Parent.l@ - 2* @PParent.epaisseurprincipale@ - 2*@usin.tiroirJeuCote@ ", Equation.CALCULATION_AUTO,equations) ;//
					
					ADDOrUpdateEquation("@this.posx@", "@PParent.epaisseurprincipale@ + @usin.tiroirJeuCote@ ", Equation.CALCULATION_AUTO,equations) ;//
					ADDOrUpdateEquation("@this.posy@", "@usin.tiroirjeuFacadeBas@ ", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "0  ", Equation.CALCULATION_AUTO,equations) ;
					
					ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.h@,@this.p@)", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.h@,@this.p@)", Equation.CALCULATION_AUTO,equations) ;
					
					FILL_CHANT_DIM("@this.l@","@this.h@","@this.l@","@this.h@",equations);
					FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","@ep.quatdixieme@","@ep.quatdixieme@","@ep.quatdixieme@",equations);
				
					FILL_PIECE2D(piece, equations);			
					break;
				case FACADE_EXTERIEUR_TIROIR:
					ADDOrUpdateEquation("@this.e@",  ""+piece.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;		
					
					//Fromules de debitage
					ADDOrUpdateEquation("@this.h@", "@Parent.h@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.p@", "@Parent.epaisseurfacade@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.l@", "@Parent.l@", Equation.CALCULATION_AUTO,equations) ;//
					
					ADDOrUpdateEquation("@this.posx@", "@Parent.posx@ ", Equation.CALCULATION_AUTO,equations) ;//
					ADDOrUpdateEquation("@this.posy@", "0 ", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "@Parent.pi@  ", Equation.CALCULATION_AUTO,equations) ;
					
					ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.h@,@this.p@)", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.h@,@this.p@)", Equation.CALCULATION_AUTO,equations) ;
					
					FILL_CHANT_DIM("@this.l@","@this.h@","@this.l@","@this.h@",equations);
					FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","@ep.quatdixieme@","@ep.quatdixieme@","@ep.quatdixieme@",equations);
				
					FILL_PIECE2D(piece, equations);
					break;	
				case FACADE_INTERIEUR_TIROIR:
					ADDOrUpdateEquation("@this.e@",  ""+piece.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;		
					
					//Fromules de debitage
					ADDOrUpdateEquation("@this.h@", "@Parent.h@ - @usin.porteJeu@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.p@", "@Parent.epaisseurfacade@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.l@", "@Parent.l@ - 2* @PParent.epaisseurprincipale@ - @usin.porteJeu@", Equation.CALCULATION_AUTO,equations) ;//
					
					ADDOrUpdateEquation("@this.posx@", "@usin.porteJeu@/2", Equation.CALCULATION_AUTO,equations) ;//
					ADDOrUpdateEquation("@this.posy@", "@usin.porteJeu@/2 ", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "@Parent.p@ - @this.p@ ", Equation.CALCULATION_AUTO,equations) ;
					
					ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.h@,@this.p@)", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.h@,@this.p@)", Equation.CALCULATION_AUTO,equations) ;
					
					FILL_CHANT_DIM("@this.l@","@this.h@","@this.l@","@this.h@",equations);
					FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","@ep.quatdixieme@","@ep.quatdixieme@","@ep.quatdixieme@",equations);
				
					FILL_PIECE2D(piece, equations);
					break;
				default:
					break;
				}
				break;
				
				
			case TENDENBOX:
				switch (piecetype) {
				case BAS_TIROIR:
					ADDOrUpdateEquation("@this.e@",  ""+piece.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;		
					
					//Fromules de debitage
					ADDOrUpdateEquation("@this.h@", "@Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.p@", "@Parent.p@ - @Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.l@", "@Parent.l@ - 2* @PParent.epaisseurprincipale@ - 2*@usin.tiroirJeuCote@ ", Equation.CALCULATION_AUTO,equations) ;//
					
					ADDOrUpdateEquation("@this.posx@", "@PParent.epaisseurprincipale@ + @usin.tiroirJeuCote@ ", Equation.CALCULATION_AUTO,equations) ;//
					ADDOrUpdateEquation("@this.posy@", "@usin.tiroirjeuFacadeBas@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "@Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
					
					ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.h@,@this.p@)", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.h@,@this.p@)", Equation.CALCULATION_AUTO,equations) ;
					
					FILL_CHANT_DIM("@this.l@","@this.h@","@this.l@","@this.h@",equations);
					FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","@ep.quatdixieme@","@ep.quatdixieme@","@ep.quatdixieme@",equations);
				
					FILL_PIECE2D(piece, equations);	
					break;
				case COTE_DROITE_TIROIR:
					
					break;
				case COTE_GAUCHE_TIROIR:
						
					break;
				case DERIERE_TIROIR:
					ADDOrUpdateEquation("@this.e@",  ""+piece.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;		
					
					//Fromules de debitage
					ADDOrUpdateEquation("@this.h@", "@Parent.h@ - @usin.tiroirjeuFacadeHaut@ - @usin.tiroirjeuFacadeBas@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.p@", "@this.e@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.l@", "@Parent.l@ - 2* @PParent.epaisseurprincipale@ - 2*@usin.tiroirJeuCote@ ", Equation.CALCULATION_AUTO,equations) ;//
					
					ADDOrUpdateEquation("@this.posx@", "@PParent.epaisseurprincipale@ + @usin.tiroirJeuCote@ ", Equation.CALCULATION_AUTO,equations) ;//
					ADDOrUpdateEquation("@this.posy@", "@usin.tiroirjeuFacadeBas@ ", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "0  ", Equation.CALCULATION_AUTO,equations) ;
					
					ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.h@,@this.p@)", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.h@,@this.p@)", Equation.CALCULATION_AUTO,equations) ;
					
					FILL_CHANT_DIM("@this.l@","@this.h@","@this.l@","@this.h@",equations);
					FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","@ep.quatdixieme@","@ep.quatdixieme@","@ep.quatdixieme@",equations);
				
					FILL_PIECE2D(piece, equations);	
					break;
				case FACADE_EXTERIEUR_TIROIR:
					ADDOrUpdateEquation("@this.e@",  ""+piece.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;		
					
					//Fromules de debitage
					ADDOrUpdateEquation("@this.h@", "@Parent.h@ - @usin.porteJeu@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.p@", "@Parent.epaisseurfacade@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.l@", "@Parent.l@ - @usin.porteJeu@", Equation.CALCULATION_AUTO,equations) ;//
					
					ADDOrUpdateEquation("@this.posx@", "@usin.porteJeu@/2", Equation.CALCULATION_AUTO,equations) ;//
					ADDOrUpdateEquation("@this.posy@", "@usin.porteJeu@/2 ", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "@Parent.p@  ", Equation.CALCULATION_AUTO,equations) ;
					
					ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.h@,@this.p@)", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.h@,@this.p@)", Equation.CALCULATION_AUTO,equations) ;
					
					FILL_CHANT_DIM("@this.l@","@this.h@","@this.l@","@this.h@",equations);
					FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","@ep.quatdixieme@","@ep.quatdixieme@","@ep.quatdixieme@",equations);
				
					FILL_PIECE2D(piece, equations);
					break;	
				case FACADE_INTERIEUR_TIROIR:
					ADDOrUpdateEquation("@this.e@",  ""+piece.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;		
					
					//Fromules de debitage
					ADDOrUpdateEquation("@this.h@", "@Parent.h@ - @usin.porteJeu@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.p@", "@Parent.epaisseurfacade@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.l@", "@Parent.l@ - 2* @PParent.epaisseurprincipale@ - @usin.porteJeu@", Equation.CALCULATION_AUTO,equations) ;//
					
					ADDOrUpdateEquation("@this.posx@", "@usin.porteJeu@/2 + @PParent.epaisseurprincipale@ ", Equation.CALCULATION_AUTO,equations) ;//
					ADDOrUpdateEquation("@this.posy@", "@usin.porteJeu@/2 @PParent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "@Parent.p@ - @this.p@ ", Equation.CALCULATION_AUTO,equations) ;
					
					ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.h@,@this.p@)", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.h@,@this.p@)", Equation.CALCULATION_AUTO,equations) ;
					
					FILL_CHANT_DIM("@this.l@","@this.h@","@this.l@","@this.h@",equations);
					FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","@ep.quatdixieme@","@ep.quatdixieme@","@ep.quatdixieme@",equations);
				
					FILL_PIECE2D(piece, equations);
					break;
				default:
					break;
				}
				
				break;
			}
			
			
		}
	
	}
	
	private void FILL_PIECE2D_FROM_TIRROIR(Tirroir tiroir,ArrayList<Equation> equations) {

		ADDOrUpdateEquation("@Parent.l@", ""+tiroir.getLongeurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.h@", ""+tiroir.getHauteurext(), Equation.CALCULATION_MANUAL,equations);
		ADDOrUpdateEquation("@Parent.p@", ""+tiroir.getProfondeurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.li@", ""+tiroir.getLongeurint(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.hi@", ""+tiroir.getHauteurint(), Equation.CALCULATION_MANUAL,equations);
		ADDOrUpdateEquation("@Parent.pi@", ""+tiroir.getProfondeurint(), Equation.CALCULATION_MANUAL,equations) ;				
		ADDOrUpdateEquation("@Parent.posx@", ""+tiroir.getXpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.posy@", ""+tiroir.getYpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.posz@", ""+tiroir.getZpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.epaisseurprincipale@", ""+tiroir.getBasematerial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.epaisseursecondaire@", ""+tiroir.getBackmaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;		
		ADDOrUpdateEquation("@Parent.epaisseurfacade@", ""+tiroir.getFacadeMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;		
		ADDOrUpdateEquation("@PParent.epaisseursecondaire@", ""+tiroir.getParentdesign().getBackmaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@PParent.epaisseurprincipale@", ""+tiroir.getParentdesign().getBasematerial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
	
		ADDOrUpdateEquation("@Parent.posxi@", ""+ tiroir.getParentdesign().getBasematerial().getEpaisseur(), Equation.CALCULATION_AUTO,equations) ;

	}	
}
