package dressing.controller;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;

import dressing.model.BlocTirroir;
import dressing.model.Caisson;
import dressing.model.Charniere;
import dressing.model.DesignException;
import dressing.model.Piece2D;
import dressing.model.Space3D;
import dressing.model.Tirroir;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.CharniereType;
import dressing.model.types.PieceType;
import dressing.model.usinage.Direction;

public class CharniereCreator implements Creator {
	Space3D space;
	double retraitH=120;
	double retraitP=37;
	short nbCharniere=2;
	List<Charniere> listCharniere=new ArrayList<Charniere>();
	
	public Space3D getSpace() {
		return space;
	}

	public void setSpace(Space3D space) {
		Space3D oldValue = this.space;
		this.space = space;
		firePropertyChange("space", oldValue, space);
	}

	public double getRetraitH() {
		return retraitH;
	}

	public void setRetraitH(double retraitH) {
		double oldValue = this.retraitH;
		this.retraitH = retraitH;
		firePropertyChange("retraitH", oldValue, retraitH);
	}

	public double getRetraitP() {
		return retraitP;
	}

	public void setRetraitP(double retraitP) {
		double oldValue = this.retraitP;
		this.retraitP = retraitP;
		firePropertyChange("retraitP", oldValue, retraitP);
	}

	public short getNbCharniere() {
		return nbCharniere;
	}

	public void setNbCharniere(short nbCharniere) {
		short oldValue = this.nbCharniere;
		this.nbCharniere = nbCharniere;
		firePropertyChange("nbCharniere", oldValue, nbCharniere);
	}
		
	public List<Charniere> getListCharniere() {
		return listCharniere;
	}

	@Override
	public void check() throws DesignException {
		if(getSpace() == null) {
			throw new DesignException("il faut sélectionner un espace 3d valide ");
		}
		if(getSpace() instanceof Tirroir || getSpace() instanceof BlocTirroir) {
			throw new DesignException("on ne peut pas créer des charniere pour des tiroirs ou des bloc tiroirs");
		}
		if(getNbCharniere()<2 || getNbCharniere()>3) {
			throw new DesignException("on supporte que 2 ou 3 charnière par porte");
		}
	}

	@Override
	public void create() throws DesignException, GeometricEngineException {
		check();
		createSubElements();
	}

	@Override
	public void createSubElements() throws DesignException, GeometricEngineException {
		this.listCharniere.clear();
		Caisson  rootCaisson=(Caisson) getSpace().getRootCaisson();
		if(rootCaisson==null) {
			throw new DesignException("impossible d'ajouter des charniere sur espace autre que d'un caisson ou un des ces fisses");
		}
		List<Piece2D> pieces = getSpace().getIntersectedPieces(getSpace(),rootCaisson );
		for(Piece2D cote:pieces) {
			if(cote.getPiecetype().equals(PieceType.GAUCHE_CUISSON)||cote.getPiecetype().equals(PieceType.DROITE_CUISSON))
			{
				for(int i=0;i<getNbCharniere();i++) {
					Charniere ch=new Charniere();
					ch.setMother(getSpace());
					ch.setParentdesign(cote);
					ch.setName("charniere "+space.getName()+i + " " +" "+cote.getName());
					ch.setRetraitH(getRetraitH());
					ch.setRetraitP(getRetraitP());
					if(cote.getPiecetype().equals(PieceType.GAUCHE_CUISSON)){
						ch.setDirection(Direction.XMINUS);
					}else if(cote.getPiecetype().equals(PieceType.DROITE_CUISSON)){
						ch.setDirection(Direction.XPLUS);
					}
					if(i==0) {
						ch.setCharniereType(CharniereType.BAS);
					}else if(i==1){
						ch.setCharniereType(CharniereType.HAUT);

					}else {
						ch.setCharniereType(CharniereType.MILIEU);
					}
					ch.setCalculAuto(false);
					

					ch.constructDebitage();
					ch.evaluate();
					
//					ch.createUsinage();
					this.listCharniere.add(ch);
				}
			}
			
		}
		
	}
	
	
	
	transient protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

	public void addPropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(listener);
	}

	public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
	}

	public void removePropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(listener);
	}

	public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
	}

	protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
		propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
	}
}
