package dressing.config;

import java.io.File;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.frs.resources.downloder.DownloaderUI;
import org.frs.supercad.config.ConfigurationManager;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import javax.swing.*;

public class Activator implements BundleActivator {
	
	private static BundleContext context;
	private String requiredResource;
	static BundleContext getContext() {
		return context;
	}

	@Override
	public void start(BundleContext context) throws Exception {
		loadRequiredResourceFromConfig();
	
		if (!checkResource()) {
			DownloaderUI downloaderUI = new DownloaderUI();
			downloaderUI.open();

			while (!checkResource() || !downloaderUI.isDownloadCompleted()) {
				Thread.sleep(1000);
			}
			SwingUtilities.invokeLater(() -> downloaderUI.dispose());
		}

	}

	@Override
	public void stop(BundleContext context) throws Exception {
		// TODO Auto-generated method stub

	}

	private void loadRequiredResourceFromConfig() {
		String dataPath = ConfigurationManager.getProperty("DATA_PATH");
		String dataVersion = ConfigurationManager.getProperty("DATA_VERSION");

		if (dataPath != null) {
			if (dataVersion == null || dataVersion.isEmpty()) {
				requiredResource = dataPath;
			} else {
				requiredResource = dataPath + File.separator + dataVersion;
			}

		} else {
			JOptionPane.showMessageDialog(null,
					"Les chemins de ressources ne sont pas définis dans le fichier de configuration.", "Attention",
					JOptionPane.WARNING_MESSAGE);
		}
	}
	
	private boolean checkResource() {
		if (requiredResource == null) return false;
		File resFile = new File(requiredResource);
		return resFile.exists();
	}
}
