package dressing.cam.model;

import java.util.HashMap;
import java.util.Map;

import dressing.model.ModelProvider;
import gdxapp.Commun.MeasuresTaker;
import param.MachineEngine;
import param.impl.ModelRootImpl;

public class MachineCodeHandler {

	public Map<String, GcodeGenerator>generators = new HashMap<String,GcodeGenerator>();
	public static MachineCodeHandler instance;
	public static final String GCODE_EXTENSION=".gcode";
	public static final String TCN=".TCN";
	public GcodeGenerator generator;
	public String extension;
	public static MachineCodeHandler getInstance() {
 		synchronized(MachineCodeHandler.class) {
 			if (instance == null) {
 				instance = new MachineCodeHandler();
 			}
 			return instance;
 		}
	}
	public MachineCodeHandler() {
		super();
		init();
	}
	private void init() {
		generators.put(MachineCodeHandler.GCODE_EXTENSION, HoleMasterGcodeGenerator.getInstance());
		generators.put(MachineCodeHandler.TCN, GriggioCodeGenerator.getInstance());
		MachineEngine engine=ModelProvider.getModelroot().getConfig().getEngine();
		if(engine!=null) {
			String code=engine.getCode();
			generator =getMachieCodeGenerator(code);	
			extension=engine.getExtension();
		}
		if(generator==null) {
			generator =getMachieCodeGenerator(MachineCodeHandler.GCODE_EXTENSION);
		}
	}
	
	public Map<String, GcodeGenerator> getGenerators() {
		return generators;
	}
	public void setGenerators(Map<String, GcodeGenerator> generators) {
		this.generators = generators;
	}
	public GcodeGenerator getGenerator() {
		MachineEngine engine=ModelProvider.getModelroot().getConfig().getEngine();
		if(engine!=null) {
			String code=engine.getCode();
			generator =getMachieCodeGenerator(code);	
			extension=engine.getExtension();
		}
		if(generator==null) {
			generator =getMachieCodeGenerator(MachineCodeHandler.GCODE_EXTENSION);
		}
		return generator;
	}
	public void refresh() {
		MachineEngine engine=ModelProvider.getModelroot().getConfig().getEngine();
		if(engine!=null) {
			String code=engine.getCode();
			generator =getMachieCodeGenerator(code);	
			extension=engine.getExtension();
		}
			generator =getMachieCodeGenerator(MachineCodeHandler.GCODE_EXTENSION);
		
		
	}
	public void setGenerator(GcodeGenerator generator) {
		this.generator = generator;
	}
	public String getExtension() {
		return extension;
	}
	public void setExtension(String extension) {
		this.extension = extension;
	}
	public GcodeGenerator getMachieCodeGenerator(String code) {
		return generators.get(code);
	}
}
