package supercad.p2.update;

import org.eclipse.e4.ui.workbench.IWorkbench;

import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import java.util.Timer;
import java.util.TimerTask;

public class UpdateDialog extends Dialog {

	private Text resultArea;
	private String resultMessage;
	private Button updateButton;
	private static final int DEFAULT_WIDTH = 600;
	private static final int DEFAULT_HEIGHT = 600;
	private IWorkbench workbench;
	private static final String USERNAME = "updator";
	private static final String PASSWORD = "updator";
	private Timer loadingTimer;
	private String[] loadingFrames = { "Téléchargement en cours.", "Téléchargement en cours..", "Téléchargement en cours..." };
	private int currentFrame = 0;

	private IProvisioningAgent agent;

	public UpdateDialog(Shell parentShell, IWorkbench workbench, IProvisioningAgent agent) {
		super(parentShell);
		this.workbench = workbench;
		this.agent = agent;
	}

	@Override
	protected Control createDialogArea(Composite parent) {
		Composite container = (Composite) super.createDialogArea(parent);
		GridLayout layout = new GridLayout(1, false);
		layout.marginHeight = 20;
		layout.marginWidth = 20;
		container.setLayout(layout);
		Button testButton = new Button(container, SWT.PUSH);
		testButton.setText("Vérifier les mises à jour");
		GridData buttonData = new GridData(SWT.FILL, SWT.CENTER, true, false);
		buttonData.heightHint = 45;
		testButton.setLayoutData(buttonData);

		resultArea = new Text(container, SWT.MULTI | SWT.BORDER | SWT.WRAP | SWT.V_SCROLL);
		GridData textData = new GridData(SWT.FILL, SWT.FILL, true, true);
		textData.minimumHeight = 300;

		resultArea.setLayoutData(textData);
		resultArea.setEditable(false);
		resultArea.setBackground(Display.getDefault().getSystemColor(SWT.COLOR_INFO_BACKGROUND));
		resultArea.setForeground(Display.getDefault().getSystemColor(SWT.COLOR_INFO_FOREGROUND));

		updateButton = new Button(container, SWT.PUSH);
		updateButton.setText("Télécharger la mise à jour");
		updateButton.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		updateButton.setVisible(false);
		updateButton.setFont(new Font(Display.getDefault(), "Arial", 10, SWT.BOLD));

		testButton.addListener(SWT.Selection, e -> {
			resultArea.setText("Vérification des mises à jour en cours...");
			updateButton.setVisible(false);
			checkForUpdates();
		});

		return container;
	}

	@Override
	protected Point getInitialSize() {
		// Taille initiale plus grande
		return new Point(DEFAULT_WIDTH, DEFAULT_HEIGHT);
	}

	@Override
	protected boolean isResizable() {
		// Permet le redimensionnement par l'utilisateur
		return true;
	}

	private void checkForUpdates() {
		UpdateService service = new UpdateService();
		String username = USERNAME;
		String password = PASSWORD;

		try {
			// Étape 1: Authentification
			String token = service.getAccessToken(username, password);

			Display.getDefault().asyncExec(() -> {
				resultMessage = "Connexion réussie";
				resultArea.setText(resultMessage);
			});

			if (!service.isAuthenticationSuccessful(token)) {
				Display.getDefault().asyncExec(() -> {
					resultArea.setText("Échec de connexion\n\n" + token);

				});
				return;
			}

			System.out.println("Token obtenu: " + token);

			// Étape 2: Enregistrement du build
			String buildNumber = VersionBundle.getBuildNumber();
			// String buildNumber = "12";

			String registrationResponse = service.registerBuild(token, buildNumber);
			String registrationMessage = extractJsonValue(registrationResponse, "message");

			Display.getDefault().asyncExec(() -> {
				if (registrationResponse.contains("\"etat\":\"OK\"")) {
					resultMessage += "\n\nEnregistrement réussi\n" + registrationMessage;
				} else {
					resultMessage += "\n\nÉchec enregistrement\n" + registrationMessage;
				}
				resultArea.setText(resultMessage);
			});

			// Étape 3: Vérification des mises à jour (uniquement si l'enregistrement a
			// réussi)
			if (registrationResponse.contains("\"etat\":\"OK\"")) {
				String lastReleaseResponse = service.checkLastRelease(token, buildNumber);
				String updateStatus = service.interpretLastReleaseResponse(lastReleaseResponse, buildNumber);

				Display.getDefault().asyncExec(() -> {
					resultMessage += "\n\n" + updateStatus;
					resultArea.setText(resultMessage);
					// Affiche le bouton seulement si une mise à jour est disponible
					boolean updateAvailable = lastReleaseResponse.contains("\"etat\":\"OK\"")
							&& !lastReleaseResponse.contains("\"code\":\"NOEWBUILD\"");
					updateButton.setVisible(updateAvailable);
					if (updateAvailable) {
						updateButton.setToolTipText("Cliquez pour télécharger la version "
								+ extractJsonValue(lastReleaseResponse, "value"));
						String lastbuildnumber = extractJsonValue(lastReleaseResponse, "value");
						updateButton.addListener(SWT.Selection, event -> {
							UpdateHandler handler = new UpdateHandler();
							handler.setBuildNumber(lastbuildnumber);
							startLoadingAnimation();
							handler.execute(agent, workbench,this::stopLoadingAnimation);
						});
					}
				});
			}

		} catch (Exception e) {
			Display.getDefault().asyncExec(() -> {
				resultMessage = "ERREUR CRITIQUE\n" + e.getMessage();
				resultArea.setText(resultMessage);
			});
			e.printStackTrace();
		} finally {
			Display.getDefault().asyncExec(() -> {
				resultArea.setTopIndex(0); // Défilement vers le haut
			});
		}

	}

	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		Button okButton = createButton(parent, IDialogConstants.OK_ID, "Fermer", true);
		// Personnalisation du bouton Fermer
		okButton.setLayoutData(new GridData(SWT.CENTER, SWT.CENTER, false, false));
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText("Mise à jour");
		newShell.setMinimumSize(500, 350); // Taille minimale
	}

	private String extractJsonValue(String json, String key) {
		String keyPattern = "\"" + key + "\":\"";
		int start = json.indexOf(keyPattern);
		if (start == -1)
			return "";
		start += keyPattern.length();
		int end = json.indexOf("\"", start);
		return end > start ? json.substring(start, end) : "";
	}
	private void startLoadingAnimation() {
	    loadingTimer = new Timer();
	    loadingTimer.scheduleAtFixedRate(new TimerTask() {
	        @Override
	        public void run() {
	            Display.getDefault().asyncExec(() -> {
	                if (resultArea != null && !resultArea.isDisposed()) {
	                    resultArea.setText(loadingFrames[currentFrame]);
	                    currentFrame = (currentFrame + 1) % loadingFrames.length;
	                }
	            });
	        }
	    }, 0, 500); // Changer de frame toutes les 500 ms
	}

	private void stopLoadingAnimation() {
	    if (loadingTimer != null) {
	        loadingTimer.cancel();
	        loadingTimer = null;
	    }
	}
}
