package reporting.htmlReporting;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;


import dressing.model.DesignObject3D;
import dressing.model.ModelProvider;
import dressing.model.Piece2D;
import dressing.model.SuperCadProject;
import reporting.data.handle.PieceCoupe;
import reporting.htmlReporting.model.HtmlNodeImpl;
import reporting.htmlReporting.model.HtmlTableElement;
import reporting.htmlReporting.model.HtmlTableRowElement;

public class FicheDebitageHtmlReportGenerator  extends ReportHtmlGenerator{

	private static FicheDebitageHtmlReportGenerator instance;
	public static String tableHeader=getInstance().getTemplate("src/reporting/htmlReporting/templates/ficheDebitTableHeader.txt");
	public static String tableRowElement=getInstance().getTemplate("src/reporting/htmlReporting/templates/ficheDebitRowElement.txt");
	public static String tableRowPiece=getInstance().getTemplate("src/reporting/htmlReporting/templates/ficheDebitRowPiece.txt");

	/**
	 * Returns an instance of FicheDebitageHtmlReportGenerator. Since instances of this
	 * class do not maintain any state, they can be shared between multiple
	 * clients.
	 *
	 * @return an instance of ArrayContentProvider
	 *
	 * @since 3.5
	 */
	public static FicheDebitageHtmlReportGenerator getInstance() {
		synchronized(FicheDebitageHtmlReportGenerator.class) {
			if (instance == null) {
				instance = new FicheDebitageHtmlReportGenerator();
			}
			return instance;
		}
	}


	@Override
	protected String generateDocumentBody(SuperCadProject project) {
		String body="";
		String listeDebit="";
			{
				HtmlNodeImpl content=new HtmlNodeImpl("content");
				content.setOrder(2);
				content.appendAttribute("class", "content");
				HtmlTableElement table1=new HtmlTableElement();
				content.appendNode(table1);
				table1.setTitle("Liste du debit");
				table1.setProperties(new String[]{ "Number","elementName","qte","longeur","hauteur" ,"profondeur","Mat"},
						new String[]{"N°", "Element","QTE","Longeur","Hauteur" ,"Prof/Ep","Materieaux"});
				table1.appendColumnClasses("elementName", "text");
				table1.appendColumnClasses("qte", "number colored");
				table1.appendColumnClasses("longeur", "number");
				table1.appendColumnClasses("hauteur", "number");
				table1.appendColumnClasses("profondeur", "number");
				table1.appendColumnClasses("Mat", "text");
				table1.appendColumnClasses("Number", "order");

				int i=1;
				int j=1;
				List<Piece2D> fausseFacade=new ArrayList<Piece2D>();
				for(DesignObject3D el:project.getCurrentKitchen().getElements()) {
//					if(el.getDesignCaissonType().contentEquals("FAUSSE_FACADE")) {
//						fausseFacade.addAll(el.getListPieces());
//						continue;
//					}
					Map<String,String> row=new HashMap<String, String>();
					row.put("Number", String.valueOf((int)i));
					row.put("elementName", el.getName());
					row.put("qte", String.valueOf((int)1));
					row.put("longeur", String.valueOf((int)el.getLongeurext()));
					row.put("hauteur", String.valueOf((int)el.getHauteurext()));
					row.put("profondeur", String.valueOf((int)el.getProfondeurext()));
					HtmlTableRowElement elementRow=table1.appendRow(row);
					elementRow.appendClass("element");
//					for(Piece2D piece:el.getListPieces()) {
//						Map<String,String> rowPiece=new HashMap<String, String>();
//						rowPiece.put("elementName", piece.getName());
//						rowPiece.put("qte", String.valueOf((int)i));
//						rowPiece.put("longeur", String.valueOf((int)piece.getPieceL()));
//						rowPiece.put("hauteur", String.valueOf((int)piece.getPieceH()));
//						rowPiece.put("profondeur", String.valueOf((int)piece.getEpaisseur()));
//						rowPiece.put("Mat", piece.getMaterial().getName());
//						HtmlTableRowElement elementRowPiece=table1.appendRow(rowPiece);
//						elementRowPiece.appendClass("piece");
//						elementRowPiece.setHeader(false);
//						i++;
//					}
					List<PieceCoupe> pieces=compactPieces2D(el.getListPieces());
					if(!pieces.isEmpty()) {
						j=1;
						for(PieceCoupe piece:pieces) {
							Map<String,String> rowPiece=new HashMap<String, String>();
							rowPiece.put("Number", i+"/"+j);
							rowPiece.put("elementName", piece.getName());
							rowPiece.put("qte", String.valueOf(piece.getQty()));
							rowPiece.put("longeur", String.valueOf((int)piece.getPieceL()));
							rowPiece.put("hauteur", String.valueOf((int)piece.getPieceH()));
							rowPiece.put("profondeur", String.valueOf((int)piece.getEpaisseur()));
							rowPiece.put("Mat", piece.getMaterial());
							HtmlTableRowElement elementRowPiece=table1.appendRow(rowPiece);
							elementRowPiece.appendClass("piece");
							elementRowPiece.setHeader(false);
							j++;
						}
					}
					i++;
				}
//				if(!fausseFacade.isEmpty())
//				{
//					List<PieceCoupe> pieces=compactPieces2D(fausseFacade);
//					Map<String,String> row=new HashMap<String, String>();
//					row.put("Number", String.valueOf((int)i));
//					row.put("elementName", "Fausse Facade");
//					row.put("qte", String.valueOf((int)fausseFacade.size()));
//					row.put("longeur", "");
//					row.put("hauteur", "");
//					row.put("profondeur","");
//					HtmlTableRowElement elementRow=table1.appendRow(row);
//					elementRow.appendClass("element");
//					if(!pieces.isEmpty()) {
//						j=1;
//						for(PieceCoupe piece:pieces) {
//							Map<String,String> rowPiece=new HashMap<String, String>();
//							rowPiece.put("Number", i+"/"+j);
//							rowPiece.put("elementName", piece.getName());
//							rowPiece.put("qte", String.valueOf(piece.getQty()));
//							rowPiece.put("longeur", String.valueOf((int)piece.getPieceL()));
//							rowPiece.put("hauteur", String.valueOf((int)piece.getPieceH()));
//							rowPiece.put("profondeur", String.valueOf((int)piece.getEpaisseur()));
//							rowPiece.put("Mat", piece.getMaterial());
//							HtmlTableRowElement elementRowPiece=table1.appendRow(rowPiece);
//							elementRowPiece.appendClass("piece");
//							elementRowPiece.setHeader(false);
//							j++;
//						}
//					}
//				}

				table1.setFirstPageRowscount((short) 40);
				table1.setRowsPerPage((short) 50);

				listeDebit =content.getContent();
			}
		body+=generateReportHeader(project);
		body+=listeDebit;
//		String table=getTemplate("src/reporting/htmlReporting/templates/tabletest.txt");;
//		body+="<div class=\"content\">\r\n" + 
//				"    <table>\r\n" + 
//				"            <tr>\r\n" + 
//				"                <th colspan=\"5\" class=\"tableTitle\">Liste du debit</th>\r\n" + 
//				"            </tr >";
//		body+=tableHeader;
//		int i=0;
//		int page =1;
//		for(DesignObject3D el:project.getCurrentKitchen().getElements()) {
//			String row=tableRowElement;
//			row=row.replace("@elementName@", el.getName());
//			row=row.replace("@qte@", String.valueOf((int)i));
//			row=row.replace("@longeur@", String.valueOf((int)el.getLongeurext()));
//			row=row.replace("@hauteur@", String.valueOf((int)el.getHauteurext()));
//			row=row.replace("@profondeur@", String.valueOf((int)el.getProfondeurext()));
//			body+=row;
//			i++;
//			
//			for(Piece2D piece:el.getListPieces()) {
//				String rowpiece=getInstance().getTemplate("src/reporting/htmlReporting/templates/ficheDebitRowPiece.txt");;
//				rowpiece=rowpiece.replace("@elementName@", piece.getName());
//				rowpiece=rowpiece.replace("@qte@",  String.valueOf((int)i));
//				rowpiece=rowpiece.replace("@longeur@", String.valueOf((int)piece.getPieceL()));
//				rowpiece=rowpiece.replace("@hauteur@", String.valueOf((int)piece.getPieceH()));
//				rowpiece=rowpiece.replace("@profondeur@", String.valueOf((int)piece.getEpaisseur()));
//				body+=rowpiece;
//				i++;
//				if((page==1 && i>=40)|| (page>1 && i>=(40+((page-1)*40) ) )) {
//					body+="        </table>\r\n" + 
//							"\r\n" + 
//							"    </div>";
//					body+="<div style=\"visibility: hidden; height: 0px; overflow: hidden; page-break-after: always;\">page separator</div>";
//					body+="    <table>\r\n";
//					body+=tableHeader;
//					page++;
//				}
//			
//			}
//			if((page==1 && i>=40)|| (page>1 && i>=(40+((page-1)*40) ) )) {
//				body+="        </table>\r\n" + 
//						"\r\n" + 
//						"    </div>";
//				body+="<div style=\"visibility: hidden; height: 0px; overflow: hidden; page-break-after: always;\">page separator</div>";
//				body+="    <table>\r\n";
//				body+=tableHeader;
//				page++;
//			}
//		}
//		body+="        </table>\r\n" + 
//				"\r\n" + 
//				"    </div>";
//		body+=table;
		return body;
	}
	public List<PieceCoupe> compactPieces2D(List<Piece2D> pieces){
		List<PieceCoupe> coupePieces=new ArrayList<PieceCoupe>();
		for(Piece2D piece:pieces) {
			boolean found=false;
			if(!coupePieces.isEmpty()) {
				for(PieceCoupe coupe:coupePieces ) {
					if(coupe.contains(piece)) {
						coupe.addPiece(piece);
						found=true;
						break;
					}
				}
			}
			
			if(!found) {
				PieceCoupe coupe=new PieceCoupe(piece.getName(),piece);
				coupePieces.add(coupe);
			}
		}
		
		
		return coupePieces;
	}
	public Map<String, List<DesignObject3D>> collectElements(List<DesignObject3D> elements) {
		Map<String,List<DesignObject3D>> caissonType_Elements=new HashMap<String,List<DesignObject3D>>(); 
		for(DesignObject3D el :elements) {
			String designType=el.getDesignCaissonType();
			if(caissonType_Elements.containsKey(designType)) {
				List<DesignObject3D> designelements=caissonType_Elements.get(designType);
				if(designelements==null) {
					designelements=new ArrayList<DesignObject3D>();
				}
				designelements.add(el);
			}else {
				List<DesignObject3D> designelements=new ArrayList<DesignObject3D>();
				designelements.add(el);
				caissonType_Elements.put(designType, designelements);
			}
		}
		return caissonType_Elements;
	}
	
	public void collectPieces(Map<String, List<DesignObject3D>> elements) {
		Map<String,List<Map<String,Piece2D>>> pieces=new HashMap<String, List<Map<String,Piece2D>>>();
		for(Entry<String, List<DesignObject3D>> entry: elements.entrySet()) {
			List<Map<String,Piece2D>> pieceEntrylist=new ArrayList<Map<String,Piece2D>>();
			String elementkey=entry.getKey();
			List<DesignObject3D> elementval=entry.getValue();
			for(DesignObject3D element:elementval) {
				
			}
		}
	}
	
	@Override
	protected String generateReportHeader(SuperCadProject project) {
		String logoPath=ModelProvider.getModelroot().getConfig().getLogoPath();
		if(logoPath!=null) {
			File file1 = new File(logoPath);
    		logoPath = "file://" + file1.getAbsolutePath();
		} 
		String template=getTemplate("src/reporting/htmlReporting/templates/ficheDebitheader.html");
		template=template.replace("@logoSRC@", logoPath);
		template=template.replace("@ProjectName@", project.getName());
		template=template.replace("@LabelProjet@", "Projet");

		template=template.replace("@Labelkitchen@", "Cuisine");
		template=template.replace("@kitchen@", project.getCurrentKitchen().getName());
		
		template=template.replace("@LabelClient@", "Client");
		template=template.replace("@client@", project.getClient());
		
		template=template.replace("@LabelCommercial@", "Commercial");
		template=template.replace("@commercial@", project.getCommercial());

		template=template.replace("@LabelSite@", "ShowRoom");
		template=template.replace("@Site@", project.getSite());
		
		template=template.replace("@date@", project.getCreationDate().toLocalDate().toString());
		return template;
		
	}


	@Override
	protected String generateReportFooter(SuperCadProject project) {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	protected String generateReportLastPageFooter(SuperCadProject project) {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	protected String getReportTitle() {
		return "Fiche du Débit";
	}
	
	

}
