package gdxapp.screens.ObjectEditor;

import java.util.ArrayList;
import java.util.HashMap;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;

import dressing.events.Event;
import dressing.events.EventDriver;
import dressing.events.EventHandler;
import gdxapp.object3d.Object3D;
import gdxapp.scenes.SceneEvent;

public class ObjectSelector implements InputProcessor, EventHandler{
	
	private ArrayList<Object3D> objects;
	
	private Camera camera;
	
	private Object3D selection;
	
	public ObjectSelector(Camera camera, ArrayList<Object3D> list) {
		this.camera = camera;
		objects = list;
		subscribe(SceneEvent.TARGET_CAMERA_CHANGED.name());
	}
	
	
	public Object3D selectAt(Vector3 point) {
		selection = null;
		for(Object3D object: objects) {
			if(object.getPosition().dst(point) < object.getRadius() ) {
				if(object.contains(point)) {
					selection = object;
					break;
				}
			}
		}
		if(selection != null) {
			EventDriver.getDriver().deliverEvent(new Event(SceneEvent.OBJECT_SELECTED.name(), selection));
			ObjectEditorController.setSelection(selection);
		}
		return selection;
	}

	@Override
	public boolean keyDown(int keycode) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean keyUp(int keycode) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean keyTyped(char character) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean touchDown(int screenX, int screenY, int pointer, int button) {
		Vector3 worldPoint = ScreenUtilities.getRealWorldPoint(screenX, screenY, camera);
		System.err.println("touch down at: " + worldPoint);
		//slightly move inside the surface for better accuaracy
		Vector3 v = worldPoint.cpy().sub(camera.position);
		v.nor().scl(0.05f);
		worldPoint.add(v);
		selectAt(worldPoint);
		if(button == Input.Buttons.RIGHT) {
			if(selection != null) {
				HashMap<String, Object> eventInfo = new HashMap<String, Object>();
				eventInfo.put("location", new Vector2(screenX, Gdx.graphics.getHeight() - screenY));
				eventInfo.put("object", selection);
				EventDriver.getDriver().deliverEvent(new Event(SceneEvent.OBJECT3D_RIGHT_CLICKED.name(), eventInfo));
			}
		}
		return (selection != null);

	}

	@Override
	public boolean touchUp(int screenX, int screenY, int pointer, int button) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean touchDragged(int screenX, int screenY, int pointer) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean mouseMoved(int screenX, int screenY) {
		float z = ScreenUtilities.getDepthFromBuffer(screenX, Gdx.graphics.getHeight() - screenY);
		Vector3 realWorldPoint = camera.unproject(new Vector3(screenX, screenY, z));
		EventDriver.getDriver().deliverEvent(new Event(SceneEvent.MSG.name(), realWorldPoint.toString()));
		return false;
	}

	@Override
	public boolean scrolled(int amount) {
		// TODO Auto-generated method stub
		return false;
	}


	public Camera getCamera() {
		return camera;
	}


	public void setCamera(Camera camera) {
		this.camera = camera;
	}


	@Override
	public void handle(Event event) {
		SceneEvent sceneEvent = SceneEvent.valueOf(event.getTopic());
		switch(sceneEvent) {
			case TARGET_CAMERA_CHANGED:
			cameraChanged(event);
		}
	}


	private void cameraChanged(Event event) {
		if(event.getData() instanceof Camera) {
			setCamera((Camera) event.getData());
		}
	}
	
	

}
