package dressing.ui.dressing;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;


import dressing.model.ModelProvider;
import dressing.model.types.CaissonMontageType;
import dressing.model.types.DosType;
import dressing.model.types.PortType;
import dressing.model.types.PositionCalculationType;
import dressing.model.types.PositionReferenceType;
import dressing.model.types.SeprationAxe;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.wb.swt.SWTResourceManager;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Group;

public class DressingCompositeWizard2 extends Composite {

	private DataBindingContext m_bindingContext;
	private dressing.controller.DressingCreator dressing = new dressing.controller.DressingCreator();
	private ModelProvider modelprovider = new ModelProvider();
	private MDirtyable dirty;
	private int updatestragey = UpdateValueStrategy.POLICY_UPDATE;
	private Group grpCaissons;
	private Label lblNombreDesCaissons;
	private Spinner spinnercaissoncount;
	private Button checkwithsepartor;
	private Label lblAxeDeSparation;
	private Combo combosperationaxe;
	private ComboViewer comboViewer;
	private Group grpSparateurFixe;
	private Label lblPositionDeSparation;
	private Spinner spinner_separationposition;
	private Label lblTypeDePosition;
	private Combo combo_positiontype;
	private ComboViewer comboViewer_1;
	private Label lblTypeDePorte;
	private Combo comboporte;
	private ComboViewer comboViewer_2;
	private Label lblTypeDeDos;
	private Button checktraversantseperator;
	private Combo combodostype;
	private ComboViewer comboViewer_3;
	private Button checkportinclude;
	private TableComboViewer tableComboViewerCaissonMontageType;
	private Label lblCaissonMontageType;
	private Button btnSparateurIsomtrique;
	private Label lblRfrenceDePosition;
	private Combo comboSepPosRefType;
	private ComboViewer comboViewer_sepPosRefType;
	private Combo combo;
	private ComboViewer comboViewer_typemontage;
	private Label lblRetraitDepuisFacade;
	private Label lblRetraitDeriere;
	private Spinner spnRetraitFacade;
	private Spinner spnRetraitDeriere;
	public DressingCompositeWizard2(Composite parent, int style, dressing.controller.DressingCreator newDressing,int updatestrategy) {
		this(parent, style);
		this.updatestragey = updatestrategy;
		setDressing(newDressing);
	}

	public DressingCompositeWizard2(Composite parent, int style) {
		super(parent, style);
		setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		setLayout(new GridLayout(1, false));
		
		grpCaissons = new Group(this, SWT.NONE);
		grpCaissons.setText("Caissons");
		grpCaissons.setLayout(new GridLayout(2, false));
		GridData gd_grpCaissons = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_grpCaissons.widthHint = 440;
		grpCaissons.setLayoutData(gd_grpCaissons);
		
		lblNombreDesCaissons = new Label(grpCaissons, SWT.NONE);
		lblNombreDesCaissons.setText("Nombre des caissons");
		
		spinnercaissoncount = new Spinner(grpCaissons, SWT.BORDER);
		spinnercaissoncount.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		
		lblTypeDePorte = new Label(grpCaissons, SWT.NONE);
		lblTypeDePorte.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblTypeDePorte.setText("Type de porte");
		
		comboViewer_2 = new ComboViewer(grpCaissons, SWT.READ_ONLY);
		comboporte = comboViewer_2.getCombo();
		comboporte.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		comboViewer_2.setContentProvider((ArrayContentProvider.getInstance()));
		comboViewer_2.setInput(PortType.values());
		
		lblTypeDeDos = new Label(grpCaissons, SWT.NONE);
		lblTypeDeDos.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblTypeDeDos.setText("Type de dos");
		
		comboViewer_3 = new ComboViewer(grpCaissons, SWT.READ_ONLY);
		combodostype = comboViewer_3.getCombo();
		combodostype.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		 
		comboViewer_3.setContentProvider((ArrayContentProvider.getInstance()));
		comboViewer_3.setInput(DosType.values());
		//
		lblCaissonMontageType  = new Label(grpCaissons, SWT.NONE);
		lblCaissonMontageType .setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblCaissonMontageType .setText("Type de montage du caisson");
		
		comboViewer_typemontage = new ComboViewer(grpCaissons, SWT.READ_ONLY);
		combo = comboViewer_typemontage.getCombo();
		combo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		comboViewer_typemontage.setContentProvider((ArrayContentProvider.getInstance()));
		comboViewer_typemontage.setInput(CaissonMontageType.values());

		//
//		tableComboViewerCaissonMontageType = new TableComboViewer(grpCaissons, SWT.READ_ONLY | SWT.BORDER);
//		tableComboViewerCaissonMontageType.getTableCombo().setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
//		tableComboViewerCaissonMontageType.getTableCombo().setShowTableHeader(true);
//		tableComboViewerCaissonMontageType.getTableCombo().defineColumns(new String[] { "Caisson Montage Type" });
//
//		tableComboViewerCaissonMontageType.getTableCombo().setDisplayColumnIndex(0);
//		tableComboViewerCaissonMontageType.getTableCombo().getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
//		// do not allow editable
//		tableComboViewerCaissonMontageType.getTableCombo().setEditable(false);
//		// set the content provider
//		tableComboViewerCaissonMontageType.setContentProvider(ArrayContentProvider.getInstance());
//		
//		// set the label provider
//		tableComboViewerCaissonMontageType.setLabelProvider(new SingleImageItemTypeMontageLabelProvider(grpCaissons));
//
//		// load the data
//		tableComboViewerCaissonMontageType.setInput(CaissonMontageType.values());	

		//
		checkportinclude = new Button(grpCaissons, SWT.CHECK);
		checkportinclude.setText("Créer les portes");
		new Label(grpCaissons, SWT.NONE);
		
		grpSparateurFixe = new Group(this, SWT.NONE);
		grpSparateurFixe.setLayout(new GridLayout(2, false));
		GridData gd_grpSparateurFixe = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_grpSparateurFixe.heightHint = 227;
		gd_grpSparateurFixe.widthHint = 445;
		grpSparateurFixe.setLayoutData(gd_grpSparateurFixe);
		grpSparateurFixe.setText("Séparateur Fixe");
		
		checkwithsepartor = new Button(grpSparateurFixe, SWT.CHECK);
		checkwithsepartor.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		checkwithsepartor.setText("Avec séparateur fixe");
		
		checktraversantseperator = new Button(grpSparateurFixe, SWT.CHECK);
		checktraversantseperator.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		checktraversantseperator.setText("Séparateur traversant le dos");
		
		lblAxeDeSparation = new Label(grpSparateurFixe, SWT.NONE);
		lblAxeDeSparation.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblAxeDeSparation.setText("Axe de séparation");
		
		comboViewer = new ComboViewer(grpSparateurFixe, SWT.READ_ONLY);
		combosperationaxe = comboViewer.getCombo();
		combosperationaxe.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		
		lblRfrenceDePosition = new Label(grpSparateurFixe, SWT.NONE);
		lblRfrenceDePosition.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblRfrenceDePosition.setText("Référence du position");
		
		comboViewer_sepPosRefType = new ComboViewer(grpSparateurFixe, SWT.READ_ONLY);
		comboSepPosRefType = comboViewer_sepPosRefType.getCombo();
		comboSepPosRefType.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		lblPositionDeSparation = new Label(grpSparateurFixe, SWT.NONE);
		lblPositionDeSparation.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblPositionDeSparation.setText("Position de séparation");
		
		spinner_separationposition = new Spinner(grpSparateurFixe, SWT.BORDER);
		spinner_separationposition.setMaximum(50000);
		spinner_separationposition.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblTypeDePosition = new Label(grpSparateurFixe, SWT.NONE);
		lblTypeDePosition.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblTypeDePosition.setText("Type de position");
		
		comboViewer_1 = new ComboViewer(grpSparateurFixe, SWT.READ_ONLY);
		combo_positiontype = comboViewer_1.getCombo();
		combo_positiontype.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		lblRetraitDepuisFacade = new Label(grpSparateurFixe, SWT.NONE);
		lblRetraitDepuisFacade.setText("Retrait Depuis Facade");
		
		spnRetraitFacade = new Spinner(grpSparateurFixe, SWT.BORDER);
		spnRetraitFacade.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spnRetraitFacade.setMaximum(50000);

		lblRetraitDeriere = new Label(grpSparateurFixe, SWT.NONE);
		lblRetraitDeriere.setText("Retrait Deriere");
		
		spnRetraitDeriere = new Spinner(grpSparateurFixe, SWT.BORDER);
		spnRetraitDeriere.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spnRetraitDeriere.setMaximum(50000);
		btnSparateurIsomtrique = new Button(grpSparateurFixe, SWT.CHECK);
		btnSparateurIsomtrique.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnSparateurIsomtrique.setText("Séparateur 50% ");
		new Label(grpSparateurFixe, SWT.NONE);
		m_bindingContext = initDataBindings();
		
		comboViewer.setContentProvider((ArrayContentProvider.getInstance()));
		comboViewer.setInput(SeprationAxe.values());
		
		comboViewer_1.setContentProvider((ArrayContentProvider.getInstance()));
		comboViewer_1.setInput(PositionCalculationType.values());
		comboViewer_sepPosRefType.setContentProvider((ArrayContentProvider.getInstance()));
		comboViewer_sepPosRefType.setInput(PositionReferenceType.values());
		
		//Ajouter le controle de dirty
		makedirtycontroller();
		}
	
	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}

	public dressing.controller.DressingCreator getDressing() {
		return dressing;
	}

	public void setDressing(dressing.controller.DressingCreator newDressing) {
		setDressing(newDressing, true);
	}
public ModelProvider getModelprovider() {
	return modelprovider;
}
public void setModelprovider(ModelProvider modelprovider) {
	this.modelprovider = modelprovider;
}
	public void setDressing(dressing.controller.DressingCreator newDressing, boolean update) {
		dressing = newDressing;
		if (update) {
			if (m_bindingContext != null) {
				m_bindingContext.dispose();
				m_bindingContext = null;
			}
			if (dressing != null) {
				m_bindingContext = initDataBindings();
			}
//			//
//			FocusListener focus = new FocusListener() {
//				
//				@Override
//				public void focusLost(FocusEvent e) {
//					// TODO Auto-generated method stub
//					m_bindingContext.updateModels();
//				}
//				
//				@Override
//				public void focusGained(FocusEvent e) {
//					// TODO Auto-generated method stub
//					
//				}
//			};
//			spinner_hauteur.addFocusListener(focus);
//			spinner_profondeur.addFocusListener(focus);
//			spinnerlongeur.addFocusListener(focus);
		}
	}
	
	private DataBindingContext custominitDataBindings() {

		//
		return null;
	}
	
	public void setDirty(MDirtyable dirty) {
		this.dirty = dirty;
	}
	public MDirtyable getDirty() {
		return dirty;
	}
	public void updateDirty()
	{
		if(this.dirty!=null)
		{
			this.dirty.setDirty(true);
		}
	}
	protected void makedirtycontroller()
	{
		//Faire la mise ajour des controel pour qui enregistre le dirty
				Control [] ctrl = this.getChildren();
				for(Control ctr : this.getChildren())
				{
					if(ctr instanceof Text)
					{
						((Text) ctr).addKeyListener(new KeyListener() {
							
							@Override
							public void keyReleased(KeyEvent e) {
								// TODO Auto-generated method stub
								updateDirty();
							}
							
							@Override
							public void keyPressed(KeyEvent e) {
								// TODO Auto-generated method stub
								
							}
						});
					}
					else
					{
						ctr.addListener(SWT.Selection, event->updateDirty());//Pour les spinner et les chekbox labada expresseion
					}
				}
	}

	protected void makeerrorhandler(Control control)
	{
		// re-use an existing image
		Image image = FieldDecorationRegistry.getDefault().getFieldDecoration(FieldDecorationRegistry.DEC_ERROR)
				.getImage();
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeSelectionSpinnercaissoncountObserveWidget = WidgetProperties.widgetSelection().observe(spinnercaissoncount);
		IObservableValue caissoncountDressingObserveValue = BeanProperties.value("caissoncount").observe(dressing);
		bindingContext.bindValue(observeSelectionSpinnercaissoncountObserveWidget, caissoncountDressingObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionComboViewer_2 = ViewerProperties.singleSelection().observe(comboViewer_2);
		IObservableValue porttypeDressingObserveValue = BeanProperties.value("porttype").observe(dressing);
		bindingContext.bindValue(observeSingleSelectionComboViewer_2, porttypeDressingObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionComboViewer_3 = ViewerProperties.singleSelection().observe(comboViewer_3);
		IObservableValue dostypeDressingObserveValue = BeanProperties.value("dostype").observe(dressing);
		bindingContext.bindValue(observeSingleSelectionComboViewer_3, dostypeDressingObserveValue, null, null);
		//
		IObservableValue observeSelectionCheckwithsepartorObserveWidget = WidgetProperties.widgetSelection().observe(checkwithsepartor);
		IObservableValue withsepratorDressingObserveValue = BeanProperties.value("withseprator").observe(dressing);
		bindingContext.bindValue(observeSelectionCheckwithsepartorObserveWidget, withsepratorDressingObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionComboViewer = ViewerProperties.singleSelection().observe(comboViewer);
		IObservableValue seprationaxeDressingObserveValue = BeanProperties.value("seprationaxe").observe(dressing);
		bindingContext.bindValue(observeSingleSelectionComboViewer, seprationaxeDressingObserveValue, null, null);
		//
		IObservableValue observeSelectionSpinner_separationpositionObserveWidget = WidgetProperties.widgetSelection().observe(spinner_separationposition);
		IObservableValue separationpositionDressingObserveValue = BeanProperties.value("separationposition").observe(dressing);
		bindingContext.bindValue(observeSelectionSpinner_separationpositionObserveWidget, separationpositionDressingObserveValue, null, null);
		//
		IObservableValue observeVisibleCombo_positiontypeObserveWidget = WidgetProperties.visible().observe(combo_positiontype);
		bindingContext.bindValue(observeVisibleCombo_positiontypeObserveWidget, withsepratorDressingObserveValue, null, null);
		//
		IObservableValue observeVisibleLblTypeDePositionObserveWidget = WidgetProperties.visible().observe(lblTypeDePosition);
		bindingContext.bindValue(observeVisibleLblTypeDePositionObserveWidget, withsepratorDressingObserveValue, null, null);
		//
		IObservableValue observeVisibleSpinner_separationpositionObserveWidget = WidgetProperties.visible().observe(spinner_separationposition);
		bindingContext.bindValue(observeVisibleSpinner_separationpositionObserveWidget, withsepratorDressingObserveValue, null, null);
		//
		IObservableValue observeVisibleLblPositionDeSparationObserveWidget = WidgetProperties.visible().observe(lblPositionDeSparation);
		bindingContext.bindValue(observeVisibleLblPositionDeSparationObserveWidget, withsepratorDressingObserveValue, null, null);
		//
		IObservableValue observeVisibleCombosperationaxeObserveWidget = WidgetProperties.visible().observe(combosperationaxe);
		bindingContext.bindValue(observeVisibleCombosperationaxeObserveWidget, withsepratorDressingObserveValue, null, null);
		//
		IObservableValue observeVisibleLblAxeDeSparationObserveWidget = WidgetProperties.visible().observe(lblAxeDeSparation);
		bindingContext.bindValue(observeVisibleLblAxeDeSparationObserveWidget, withsepratorDressingObserveValue, null, null);
		//
		IObservableValue observeVisibleChecktraversantseperatorObserveWidget = WidgetProperties.visible().observe(checktraversantseperator);
		bindingContext.bindValue(observeVisibleChecktraversantseperatorObserveWidget, withsepratorDressingObserveValue, null, null);
		//
		IObservableValue observeSelectionCheckportincludeObserveWidget = WidgetProperties.widgetSelection().observe(checkportinclude);
		IObservableValue withporteDressingObserveValue = BeanProperties.value("withporte").observe(dressing);
		bindingContext.bindValue(observeSelectionCheckportincludeObserveWidget, withporteDressingObserveValue, null, null);
		//
		IObservableValue observeSelectionChecktraversantseperatorObserveWidget = WidgetProperties.widgetSelection().observe(checktraversantseperator);
		IObservableValue sepratortransversalDressingObserveValue = BeanProperties.value("sepratortransversal").observe(dressing);
		bindingContext.bindValue(observeSelectionChecktraversantseperatorObserveWidget, sepratortransversalDressingObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnSparateurIsomtriqueObserveWidget = WidgetProperties.widgetSelection().observe(btnSparateurIsomtrique);
		IObservableValue separatorisometriqueDressingObserveValue = BeanProperties.value("separatorisometrique").observe(dressing);
		bindingContext.bindValue(observeSelectionBtnSparateurIsomtriqueObserveWidget, separatorisometriqueDressingObserveValue, null, null);
		//
		IObservableValue observeVisibleBtnSparateurIsomtriqueObserveWidget = WidgetProperties.visible().observe(btnSparateurIsomtrique);
		bindingContext.bindValue(observeVisibleBtnSparateurIsomtriqueObserveWidget, withsepratorDressingObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionComboViewer_sepPosRefType = ViewerProperties.singleSelection().observe(comboViewer_sepPosRefType);
		IObservableValue sepPosRefTypeDressingObserveValue = BeanProperties.value("sepPosRefType").observe(dressing);
		bindingContext.bindValue(observeSingleSelectionComboViewer_sepPosRefType, sepPosRefTypeDressingObserveValue, null, null);
		//
		IObservableValue observeVisibleComboSepPosRefTypeObserveWidget = WidgetProperties.visible().observe(comboSepPosRefType);
		bindingContext.bindValue(observeVisibleComboSepPosRefTypeObserveWidget, withsepratorDressingObserveValue, null, null);
		//
		IObservableValue observeVisibleLblRfrenceDePositionObserveWidget = WidgetProperties.visible().observe(lblRfrenceDePosition);
		bindingContext.bindValue(observeVisibleLblRfrenceDePositionObserveWidget, withsepratorDressingObserveValue, null, null);
		//
		IObservableValue observeEnabledSpinner_separationpositionObserveWidget = WidgetProperties.enabled().observe(spinner_separationposition);
		IObservableValue sepnotisometriqueDressingObserveValue = BeanProperties.value("sepnotisometrique").observe(dressing);
		bindingContext.bindValue(observeEnabledSpinner_separationpositionObserveWidget, sepnotisometriqueDressingObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionComboViewer_typemontage = ViewerProperties.singleSelection().observe(comboViewer_typemontage);
		IObservableValue caissonMontageTypeDressingObserveValue = BeanProperties.value("caissonMontageType").observe(dressing);
		bindingContext.bindValue(observeSingleSelectionComboViewer_typemontage, caissonMontageTypeDressingObserveValue, null, null);
		//
		IObservableValue observeEnabledCombo_positiontypeObserveWidget = WidgetProperties.enabled().observe(combo_positiontype);
		bindingContext.bindValue(observeEnabledCombo_positiontypeObserveWidget, sepnotisometriqueDressingObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionComboViewer_1 = ViewerProperties.singleSelection().observe(comboViewer_1);
		IObservableValue positionCalculationtypeDressingObserveValue = BeanProperties.value("positionCalculationtype").observe(dressing);
		bindingContext.bindValue(observeSingleSelectionComboViewer_1, positionCalculationtypeDressingObserveValue, null, null);
		//
		IObservableValue observeSelectionSpnRetraitFacadeObserveWidget = WidgetProperties.widgetSelection().observe(spnRetraitFacade);
		IObservableValue sepRetraitDressingObserveValue = BeanProperties.value("sepRetrait").observe(dressing);
		bindingContext.bindValue(observeSelectionSpnRetraitFacadeObserveWidget, sepRetraitDressingObserveValue, null, null);
		//
		IObservableValue observeSelectionSpnRetraitDeriereObserveWidget = WidgetProperties.widgetSelection().observe(spnRetraitDeriere);
		IObservableValue sepretraitderiereDressingObserveValue = BeanProperties.value("sepretraitderiere").observe(dressing);
		bindingContext.bindValue(observeSelectionSpnRetraitDeriereObserveWidget, sepretraitderiereDressingObserveValue, null, null);
		//
		IObservableValue observeVisibleSpnRetraitFacadeObserveWidget = WidgetProperties.visible().observe(spnRetraitFacade);
		bindingContext.bindValue(observeVisibleSpnRetraitFacadeObserveWidget, withsepratorDressingObserveValue, null, null);
		//
		IObservableValue observeVisibleSpnRetraitDeriereObserveWidget = WidgetProperties.visible().observe(spnRetraitDeriere);
		bindingContext.bindValue(observeVisibleSpnRetraitDeriereObserveWidget, withsepratorDressingObserveValue, null, null);
		//
		IObservableValue observeVisibleLblRetraitDeriereObserveWidget = WidgetProperties.visible().observe(lblRetraitDeriere);
		bindingContext.bindValue(observeVisibleLblRetraitDeriereObserveWidget, withsepratorDressingObserveValue, null, null);
		//
		IObservableValue observeVisibleLblRetraitDepuisFacadeObserveWidget = WidgetProperties.visible().observe(lblRetraitDepuisFacade);
		bindingContext.bindValue(observeVisibleLblRetraitDepuisFacadeObserveWidget, withsepratorDressingObserveValue, null, null);
		//
		return bindingContext;
	}
}
