package dressing.model.stock;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;

import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.debitage.ArticleGenericDebitage;
import dressing.model.debitage.GenericDebitageFormula;
import dressing.model.evalutor.Equation;
import dressing.model.evalutor.GeometricEngineException;
import param.AccessoireInstance;
import param.ArticleInstance;
import param.MechanicPrivateParam;
import param.MechanicPublicParam;
import param.QuincaillerieInstance;

public class Article {
	transient protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
	transient private boolean notificationon=true;
	protected String name="";
	protected UUID id=null;
	protected Double number=1.0;
	Properties props=new Properties();
	protected ArticleInstance articleInstance;
	protected param.Article article;
	public Article(ArticleInstance articleInstance) {
		this.articleInstance=articleInstance;
		this.article=this.articleInstance instanceof AccessoireInstance ?((AccessoireInstance)this.articleInstance).getAccessoire():((QuincaillerieInstance)this.articleInstance).getQuincaillerie();
	}

	/**
	 * cette methode est utilise pour le debiotage dynamique
	 * @param eList 
	 * @param publicparams 
	 * @param privateparams 
	 * @throws DesignException
	 * @throws GeometricEngineException 
	 */
	public void constructGenericDebitage(List<MechanicPrivateParam> privateparams, List<MechanicPublicParam> publicparams, Object emf,DesignObject3D parent) throws DesignException, GeometricEngineException
	{
		//faire passer tous les variables categoriques dans les proprotes de design object
		// avnat de lancer le calcul de debitage et passer la resolutions
		//
	
		if(emf instanceof AccessoireInstance)
		{
			AccessoireInstance elment = ((AccessoireInstance)emf);
			if(elment.getExistexpression()!=null && !elment.getExistexpression().isEmpty())
			{
				this.put("EXIST_EXPRESSION", elment.getExistexpression());
			}
		}
		if(emf instanceof QuincaillerieInstance)
		{
			QuincaillerieInstance elment = ((QuincaillerieInstance)emf);
			if(elment.getExistexpression()!=null && !elment.getExistexpression().isEmpty())
			{
				this.put("EXIST_EXPRESSION", elment.getExistexpression());
			}
		}
		
		ArrayList<Equation> equations = new ArrayList<Equation>();
		ArticleGenericDebitage.createupdateDebitage(parent , this,privateparams,publicparams,emf,equations);
		evaluategeneric(equations);
		equations.clear();
	}

	/**
	 * Cette methode est utilsie pour le debitage generique
	 * @param equations 
	 * @throws GeometricEngineException
	 * @throws DesignException
	 */
	public void evaluategeneric(ArrayList<Equation> equations) throws GeometricEngineException, DesignException
	{
		if(equations!=null)
		{
			GenericDebitageFormula.EVALUATE(equations);
			updateproperties(equations);
		}
		else
		{
			throw new DesignException("Debitage object is null");
		}
	}
	protected void updateproperties(ArrayList<Equation> equations) throws GeometricEngineException
	{
		setNotificationon(false);
		Equation eq=null;
		try {
			if(equations!=null)
			{
				
				eq  = Equation.FIND_EQUATION("@this.number@", equations);
				if(eq!=null)
				{
					setNumber(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException(this.name + " @this.number@ not found to update");
				}
				
			}
		} catch (GeometricEngineException e) {
			// TODO: handle exception
			e.printStackTrace();
			throw e;
		}
		finally {
			setNotificationon(true);
		}
		
	}
	
	public String getName() {
		return name;
	}

	public void setName(String name) {
		String oldValue = this.name;
		this.name = name;
		firePropertyChange("name", oldValue, name);
	}

	public UUID getId() {
		return id;
	}

	public void setId(UUID id) {
		UUID oldValue = this.id;
		this.id = id;
		firePropertyChange("id", oldValue, id);
	}

	public Double getNumber() {
		return number;
	}

	public void setNumber(Double double1) {
		Double oldValue = this.number;
		this.number = double1;
		firePropertyChange("number", oldValue, double1);
	}
	
	public ArticleInstance getArticleInstance() {
		return articleInstance;
	}

	public void setArticleInstance(ArticleInstance articleInstance) {
		this.articleInstance = articleInstance;
	}

	public param.Article getArticle() {
		return article;
	}

	public void setArticle(param.Article article) {
		this.article = article;
	}

	public void addPropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(listener);
	}

	public void addPropertyChangeListener(String propertyName,
			PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(propertyName,
				listener);
	}

	public void removePropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(listener);
	}

	public void removePropertyChangeListener(String propertyName,
			PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(propertyName,
				listener);
	}

	protected void firePropertyChange(String propertyName, Object oldValue,
			Object newValue) {
		if(isNotificationon())
		{
			propertyChangeSupport.firePropertyChange(propertyName, oldValue,
					newValue);
		}
					
	}
	public PropertyChangeListener[] getListeners() {
		if(propertyChangeSupport==null) {
			return null;
		}
		return	propertyChangeSupport.getPropertyChangeListeners();
	}
	public void removeAllLsteners() {
		PropertyChangeListener[] listeners=getListeners();
		if(listeners==null) {
			return;
		}
		for(PropertyChangeListener listener:listeners) {
			propertyChangeSupport.removePropertyChangeListener(listener);
		}
	}

	public void setNotificationon(boolean notificationon) {
		this.notificationon = notificationon;
	}
	public boolean isNotificationon() {
		return notificationon;
	}

	public Properties getProps() {
		return props;
	}
	public void setProps(Properties props) {
		this.props = props;
	}
	
	public Object put(Object key, Object value) {
//		Object oldvalue=this.getProperty((String) key);
//		firePropertyChange((String) key, oldvalue, value);
		return this.props.put(key, value);
	}
	
	
	public String getProperty(String key) {
		return this.props.getProperty(key);
	}
	
	public String getProperty(String key, String defaultValue) {
		return this.props.getProperty(key, defaultValue);
	}
	
	public synchronized boolean isEmpty() {
		return this.props.isEmpty();
	}
	
	public synchronized Enumeration<Object> keys() {
		return this.props.keys();
	}
	
	public synchronized Enumeration<Object> elements() {
		return this.props.elements();
	}
	
	public synchronized Object get(Object key) {
		return this.props.get(key);
	}
	
	public synchronized void clear() {
		this.props.clear();
	}
	
	public Set<Object> keySet() {
		return this.props.keySet();
	}
	
	public Collection<Object> values() {
		return this.props.values();
	}
	
	public synchronized Object getOrDefault(Object key, Object defaultValue) {
		return this.props.getOrDefault(key, defaultValue);
	}
	
	public synchronized boolean remove(Object key, Object value) {
		return this.props.remove(key, value);
	}
	
	public synchronized boolean replace(Object key, Object oldValue, Object newValue) {
		return this.props.replace(key, oldValue, newValue);
		
	}
	  
	public Set<Map.Entry<Object,Object>> entrySet() {
		return  this.props.entrySet();
	}
	  
	public synchronized boolean containsKey(Object key) {
		return  this.props.containsKey(key);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((id == null) ? 0 : id.hashCode());
		result = prime * result + ((name == null) ? 0 : name.hashCode());
		result = prime * result + ((number == null) ? 0 : number.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Article other = (Article) obj;
		if (id == null) {
			if (other.id != null)
				return false;
		} else if (!id.equals(other.id))
			return false;
		if (name == null) {
			if (other.name != null)
				return false;
		} else if (!name.equals(other.name))
			return false;
		if (number == null) {
			if (other.number != null)
				return false;
		} else if (!number.equals(other.number))
			return false;
		return true;
	}
	
	
}
