package dressing.model.debitage;

import java.util.ArrayList;

import dressing.model.Bande;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Piece2D;
import dressing.model.evalutor.Equation;
import dressing.model.types.ParentDirection;
import dressing.model.types.PieceType;
import dressing.model.types.TrouType;
import dressing.model.usinage.Direction;
import dressing.model.usinage.Trou;

public class TrouDebitageFormulas extends DebitageFormulas {

	@Override
	public void FILL_DEBITAGE_FORMULAS(DesignObject3D parent,DesignObject3D child,ArrayList<Equation> equations) throws DesignException {
		if(parent==null || child==null)
			throw new DesignException("Formule de debitage : Parent ou child null");
		this.parent = parent;
		this.child = child;
		FILL_USINAGE(parent,child,equations); //les parametres d usine doivent être les premier
		if(parent instanceof Piece2D && child instanceof Trou)	{
			
			Trou trou  = (Trou)child;
			Piece2D piece2d = (Piece2D)parent;
			PieceType piecetype = piece2d.getPiecetype();
			TrouType trouType=trou.getTrouType();
			FILL_TROU_FROM_PARENTS(trou, equations);
			Direction dir=trou.getDirection(); 
			ParentDirection parentDirection =trou.getParentDirection();
			DesignObject3D mother=	trou.getMother();
			Piece2D father= piece2d;
			switch (trouType) {
			
				case ETAGERE_MOBILE_BACK:
					FILL_TROU_FROM_ETAGERE_PARENTS(trou, equations);
					ADDOrUpdateEquation("@this.troudiametre@", "@usin.etageretroudiametre@" , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.troudepth@","@usin.etageretroudepth@" , Equation.CALCULATION_AUTO,equations) ;
					
					ADDOrUpdateEquation("@this.posy@","@EParent.posy@ - @Parent.posyABS@ " , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@","@usin.etageretrouretrait@ " , Equation.CALCULATION_AUTO,equations) ;

					if(((Piece2D)parent).getPiecetype().equals(PieceType.GAUCHE_CUISSON)) {
						ADDOrUpdateEquation("@this.posx@", " @Parent.l@", Equation.CALCULATION_MANUAL,equations) ;
					}else if(((Piece2D)parent).getPiecetype().equals(PieceType.DROITE_CUISSON)) {
						ADDOrUpdateEquation("@this.posx@", "0", Equation.CALCULATION_MANUAL,equations) ;
					}else {
						throw new DesignException(" trou d'unisnage de l'etagere ne pas supproter sur de piece autre que cote doite et gauche de la caisson");
					}
					break;
				case ETAGERE_MOBILE_FRONT:
					FILL_TROU_FROM_ETAGERE_PARENTS(trou, equations);
					ADDOrUpdateEquation("@this.troudiametre@", "@usin.etageretroudiametre@" , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.troudepth@","@usin.etageretroudepth@" , Equation.CALCULATION_AUTO,equations) ;
					
					ADDOrUpdateEquation("@this.posy@","@EParent.posy@ - @Parent.posyABS@ " , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@","@Parent.p@ - @usin.etageretrouretrait@ " , Equation.CALCULATION_AUTO,equations) ;

					if(((Piece2D)parent).getPiecetype().equals(PieceType.GAUCHE_CUISSON)) {
						ADDOrUpdateEquation("@this.posx@", " @Parent.l@", Equation.CALCULATION_MANUAL,equations) ;
					}else if(((Piece2D)parent).getPiecetype().equals(PieceType.DROITE_CUISSON)) {
						ADDOrUpdateEquation("@this.posx@", "0", Equation.CALCULATION_MANUAL,equations) ;
					}else {
						throw new DesignException(" trou d'unisnage de l'etagere ne pas supproter sur de piece autre que cote doite et gauche de la caisson");
					}				
					break;
				case PERSAGE_BAS:
					ADDOrUpdateEquation("@this.troudiametre@", "@usin.persagetroudiametre@" , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.troudepth@","@usin.persagetroudepth@" , Equation.CALCULATION_AUTO,equations) ;
					
					
					if(((Piece2D)parent).getPiecetype().equals(PieceType.GAUCHE_CUISSON)) {
						ADDOrUpdateEquation("@this.posx@", " @Parent.l@", Equation.CALCULATION_MANUAL,equations) ;
					}else if(((Piece2D)parent).getPiecetype().equals(PieceType.DROITE_CUISSON)) {
						ADDOrUpdateEquation("@this.posx@", "0", Equation.CALCULATION_MANUAL,equations) ;
					}else {
						throw new DesignException(" trou d'unisnage de l'etagere ne pas supproter sur de piece autre que cote doite et gauche de la caisson");
					}
					
					ADDOrUpdateEquation("@this.posz@","@Parent.p@ -@usin.persageptrouretrait@ " , Equation.CALCULATION_AUTO,equations) ;

					ADDOrUpdateEquation("@this.posy@","@Parent.posy@ +@usin.persagehtrouretrait@ " , Equation.CALCULATION_AUTO,equations) ;

					
					break;
				case PERSAGE_HAUT:
					ADDOrUpdateEquation("@this.troudiametre@", "@usin.persagetroudiametre@" , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.troudepth@","@usin.persagetroudepth@" , Equation.CALCULATION_AUTO,equations) ;
					
					
					if(((Piece2D)parent).getPiecetype().equals(PieceType.GAUCHE_CUISSON)) {
						ADDOrUpdateEquation("@this.posx@", " @Parent.l@", Equation.CALCULATION_MANUAL,equations) ;
					}else if(((Piece2D)parent).getPiecetype().equals(PieceType.DROITE_CUISSON)) {
						ADDOrUpdateEquation("@this.posx@", "0", Equation.CALCULATION_MANUAL,equations) ;
					}else {
						throw new DesignException(" trou d'unisnage de l'etagere ne pas supproter sur de piece autre que cote doite et gauche de la caisson");
					}
					
					ADDOrUpdateEquation("@this.posz@","@Parent.p@ -@usin.persageptrouretrait@ " , Equation.CALCULATION_AUTO,equations) ;

					
					ADDOrUpdateEquation("@this.posy@","@Parent.h@ - @usin.persagehtrouretrait@ " , Equation.CALCULATION_AUTO,equations) ;

					break;
				case CHARNIERE_BAS:
					FILL_TROU_FROM_CHARNIERE_PARENTS(trou, equations);
					ADDOrUpdateEquation("@this.troudiametre@", "@usin.charnieretroudiametre@" , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.troudepth@","@usin.charnieretroudepth@" , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posx@", "@CParent.posx@", Equation.CALCULATION_MANUAL,equations) ;			
					ADDOrUpdateEquation("@this.posy@","@CParent.posy@ - ( @usin.charnieredistintertrou@ /2)" , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@","@CParent.posz@" , Equation.CALCULATION_AUTO,equations) ;
					break;
				case CHARNIERE_HAUT:
					FILL_TROU_FROM_CHARNIERE_PARENTS(trou, equations);
					ADDOrUpdateEquation("@this.troudiametre@", "@usin.charnieretroudiametre@" , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.troudepth@","@usin.charnieretroudepth@" , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posx@", "@CParent.posx@", Equation.CALCULATION_MANUAL,equations) ;			
					ADDOrUpdateEquation("@this.posy@","@CParent.posy@ + ( @usin.charnieredistintertrou@ /2)" , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@","@CParent.posz@" , Equation.CALCULATION_AUTO,equations) ;
					break;	
				case USINGAGE:
					ADDOrUpdateEquation("@this.troudiametre@", "@usin.troudiametre@" , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.troudepth@","@usin.troudepth@" , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posy@",""+trou.getYcenter() , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@",""+trou.getZcenter() , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posx@", ""+trou.getXcenter(), Equation.CALCULATION_MANUAL,equations) ;
					break;
					//Imed bug 0001866 ajouter les support pour les caisson bas : Begin;
				case SUPPORT_BAS_BACK_LEFT:
					FILL_TROU_FROM_SUPPORTMEUBLEBAS_PARENTS(trou, equations);
					ADDOrUpdateEquation("@this.troudiametre@", "@usin.supportbastroudiametre@" , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.troudepth@","@usin.supportbastroudepth@" , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posx@", "@Mother.posx@", Equation.CALCULATION_MANUAL,equations) ;			
					ADDOrUpdateEquation("@this.posy@","@Mother.posy@" , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@","@Mother.posz@" , Equation.CALCULATION_AUTO,equations) ;
					
					break;
					
				case SUPPORT_BAS_BACK_RIGHT:
					FILL_TROU_FROM_SUPPORTMEUBLEBAS_PARENTS(trou, equations);
					ADDOrUpdateEquation("@this.troudiametre@", "@usin.supportbastroudiametre@" , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.troudepth@","@usin.supportbastroudepth@" , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posx@", "@Mother.posx@ + @Mother.l@", Equation.CALCULATION_MANUAL,equations) ;			
					ADDOrUpdateEquation("@this.posy@", "@Mother.posy@ " , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "@Mother.posz@" , Equation.CALCULATION_AUTO,equations) ;
					break;
					
				case SUPPORT_BAS_FRONT_LEFT:
					FILL_TROU_FROM_SUPPORTMEUBLEBAS_PARENTS(trou, equations);
					ADDOrUpdateEquation("@this.troudiametre@", "@usin.supportbastroudiametre@" , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.troudepth@","@usin.supportbastroudepth@" , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posx@", "@Mother.posx@", Equation.CALCULATION_MANUAL,equations) ;			
					ADDOrUpdateEquation("@this.posy@", "@Mother.posy@ " , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "@Mother.posz@ + @Mother.p@" , Equation.CALCULATION_AUTO,equations) ;
					break;
					
				case SUPPORT_BAS_FRONT_RIGHT:
					FILL_TROU_FROM_SUPPORTMEUBLEBAS_PARENTS(trou, equations);
					ADDOrUpdateEquation("@this.troudiametre@", "@usin.supportbastroudiametre@" , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.troudepth@","@usin.supportbastroudepth@" , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posx@", "@Mother.posx@ + @Mother.l@", Equation.CALCULATION_MANUAL,equations) ;			
					ADDOrUpdateEquation("@this.posy@", "@Mother.posy@ " , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "@Mother.posz@ + @Mother.p@" , Equation.CALCULATION_AUTO,equations) ;
					break;	
					//Imed bug 0001866 End;
				case SUPPORT_BLOC_TIROIR_BACK:	
					FILL_TROU_FROM_SUPPORT_PORTE_BOTEILLE(trou, equations);
					ADDOrUpdateEquation("@this.troudiametre@", "@usin.SupportBlocTiroirtroudiametre@" , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.troudepth@","@usin.SupportBlocTiroirtroudepth@" , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posx@", "@Mother.posx@", Equation.CALCULATION_MANUAL,equations) ;			
					ADDOrUpdateEquation("@this.posy@", "@Mother.posy@" , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "@Mother.posz@" , Equation.CALCULATION_AUTO,equations) ;
					break;
				case SUPPORT_BLOC_TIROIR_FRONT:	
					FILL_TROU_FROM_SUPPORT_PORTE_BOTEILLE(trou, equations);
					ADDOrUpdateEquation("@this.troudiametre@", "@usin.SupportBlocTiroirtroudiametre@" , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.troudepth@","@usin.SupportBlocTiroirtroudepth@" , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posx@", "@Mother.posx@", Equation.CALCULATION_MANUAL,equations) ;			
					ADDOrUpdateEquation("@this.posy@", "@Mother.posy@" , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "@Mother.posz@ + @Mother.p@" , Equation.CALCULATION_AUTO,equations) ;
					break;	
				case SUPPORT_PORTE_BOTEILLE_BACK:
					FILL_TROU_FROM_SUPPORT_PORTE_BOTEILLE(trou, equations);
					ADDOrUpdateEquation("@this.troudiametre@", "@usin.SupportPorteBoteilletroudiametre@" , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.troudepth@","@usin.SupportPorteBoteilletroudepth@" , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posx@", "@Mother.posx@", Equation.CALCULATION_MANUAL,equations) ;			
					ADDOrUpdateEquation("@this.posy@", "@Mother.posy@" , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "@Mother.posz@" , Equation.CALCULATION_AUTO,equations) ;
					break;
				case SUPPORT_PORTE_BOTEILLE_FRONT: 
					FILL_TROU_FROM_SUPPORT_PORTE_BOTEILLE(trou, equations);
					ADDOrUpdateEquation("@this.troudiametre@", "@usin.SupportPorteBoteilletroudiametre@" , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.troudepth@","@usin.SupportPorteBoteilletroudepth@" , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posx@", "@Mother.posx@", Equation.CALCULATION_MANUAL,equations) ;			
					ADDOrUpdateEquation("@this.posy@", "@Mother.posy@" , Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "@Mother.posz@ + @Mother.p@" , Equation.CALCULATION_AUTO,equations) ;
				 break;	
				case GENERIC:
					break;
				case USINGAGE_FRONT:	
				case USINGAGE_BACK:
				case USINGAGE_MIDDLE:	
					FILL_TROU_USINAGE_FROM_PARENTS(trou, equations);
					ADDOrUpdateEquation("@this.troudiametre@", "@usin.usinagetroudiametre@" , Equation.CALCULATION_AUTO,equations) ;					
					ADDOrUpdateEquation("@this.troudepth@","@usin.usinagetroudepth@" , Equation.CALCULATION_AUTO,equations) ;
					switch (dir) {
					case XMINUS:
						ADDOrUpdateEquation("@this.posx@", "@Parent.l@", Equation.CALCULATION_MANUAL,equations) ;

						
						switch (parentDirection) {
						case Y:
							
							//calculer le position z
							if(father.getProfondeurext() <= mother.getProfondeurext()) {
								ADDOrUpdateEquation("@this.posz@", "@Parent.p@ /2 ", Equation.CALCULATION_MANUAL,equations) ;
							}else {
								ADDOrUpdateEquation("@this.posz@", "(@Mother.p@ /2) + @Mother.poszABS@ - @Parent.poszABS@", Equation.CALCULATION_MANUAL,equations) ;
							}
							
							//trouver le distance de retrait pour calculer la posy
							if((isBandeCoteBasFour(mother)&& !father.getPiecetype().equals(PieceType.BANDE_FOUR_BAS_FACE))
									||(isBandeCoteBasFour(father)&&!((Piece2D) mother).getPiecetype().equals(PieceType.BANDE_FOUR_BAS_FACE))) {
								ADDOrUpdateEquation("@this.retrait@", "@usin.retraitbandecotebasfour@",Equation.CALCULATION_MANUAL, equations);	
							}
							else if (mother instanceof Bande) {							
								ADDOrUpdateEquation("@this.retrait@", "(@Mother.h@ -  @usin.troubandeinterdist@  )/2 ",	Equation.CALCULATION_MANUAL, equations);
		
							} else if (father instanceof Bande) {
								ADDOrUpdateEquation("@this.retrait@", "(@Parent.h@ -  @usin.troubandeinterdist@  )/2 ",Equation.CALCULATION_MANUAL, equations);
		
							} else {
								ADDOrUpdateEquation("@this.retrait@", "@usin.usinagetroupieceretrait@ ",Equation.CALCULATION_MANUAL, equations);
							}
								
							//calculuer la posy 
							if(trouType.equals(TrouType.USINGAGE_FRONT)) {
									
								if(father.getYPosABS()+father.getHauteurext()> mother.getYPosABS()+mother.getHauteurext()) {
									ADDOrUpdateEquation("@this.posy@", "@Mother.h@ - @this.retrait@ + @Mother.posyABS@ - @Parent.posyABS@", Equation.CALCULATION_MANUAL,equations) ;
								}else {
									ADDOrUpdateEquation("@this.posy@", "@Parent.h@ - @this.retrait@", Equation.CALCULATION_MANUAL,equations) ;
								}
							}else if(trouType.equals(TrouType.USINGAGE_BACK)) {
									
								if(father.getYPosABS() < mother.getYPosABS() ) {
									ADDOrUpdateEquation("@this.posy@", "@this.retrait@ + @Mother.posyABS@ - @Parent.posyABS@", Equation.CALCULATION_MANUAL,equations) ;
			
								}else {
									ADDOrUpdateEquation("@this.posy@", "@this.retrait@", Equation.CALCULATION_MANUAL,equations) ;
			
								} 
							}	
							else if(trouType.equals(TrouType.USINGAGE_MIDDLE)) {
								
								if(father.getHauteurext() < mother.getHauteurext() ) {
									ADDOrUpdateEquation("@this.posy@", "@Parent.h@ /2", Equation.CALCULATION_MANUAL,equations) ;
			
								}else {
									ADDOrUpdateEquation("@this.posy@", "@Mother.h@ /2 + @Mother.posyABS@ - @Parent.posyABS@", Equation.CALCULATION_MANUAL,equations) ;
			
								} 
							}	
								
								
								
							break;
						case Z:
								if (father.getHauteurext() <= mother.getHauteurext()) {
									ADDOrUpdateEquation("@this.posy@", "@Parent.h@ /2 ", Equation.CALCULATION_MANUAL, equations);
								} else {
									ADDOrUpdateEquation("@this.posy@", "(@Mother.h@ /2) + @Mother.posyABS@ - @Parent.posyABS@",Equation.CALCULATION_MANUAL, equations);
								}
								if((isBandeCoteBasFour(mother)&& !father.getPiecetype().equals(PieceType.BANDE_FOUR_BAS_FACE))
										||(isBandeCoteBasFour(father)&&!((Piece2D) mother).getPiecetype().equals(PieceType.BANDE_FOUR_BAS_FACE))) {
									ADDOrUpdateEquation("@this.retrait@", "@usin.retraitbandecotebasfour@",Equation.CALCULATION_MANUAL, equations);	
								}
								else
								if (mother instanceof Bande) {
									ADDOrUpdateEquation("@this.retrait@", "(@Mother.p@ -  @usin.troubandeinterdist@  )/2 ",	Equation.CALCULATION_MANUAL, equations);
			
								} else if (father instanceof Bande) {
									ADDOrUpdateEquation("@this.retrait@", "(@Parent.p@ -  @usin.troubandeinterdist@  )/2 ",Equation.CALCULATION_MANUAL, equations);
			
								} else {
									ADDOrUpdateEquation("@this.retrait@", "@usin.usinagetroupieceretrait@ ",Equation.CALCULATION_MANUAL, equations);
								}
			
								if (trouType.equals(TrouType.USINGAGE_FRONT)) {
			
									if (father.getZPosABS() + father.getProfondeurext() > mother.getZPosABS()+ mother.getProfondeurext()) {
										ADDOrUpdateEquation("@this.posz@","@Mother.p@ - @this.retrait@ + @Mother.poszABS@ - @Parent.poszABS@",Equation.CALCULATION_MANUAL, equations);
									} else {
										ADDOrUpdateEquation("@this.posz@", "@Parent.p@ - @this.retrait@",Equation.CALCULATION_MANUAL, equations);
									}
								} else if (trouType.equals(TrouType.USINGAGE_BACK)) {
			
									if (father.getZPosABS() < mother.getZPosABS()) {
										ADDOrUpdateEquation("@this.posz@","@this.retrait@ + @Mother.poszABS@ - @Parent.poszABS@",Equation.CALCULATION_MANUAL, equations);
			
									} else {
										ADDOrUpdateEquation("@this.posz@", "@this.retrait@",Equation.CALCULATION_MANUAL, equations);
			
									}
								}else if(trouType.equals(TrouType.USINGAGE_MIDDLE)) {
									
									if(father.getProfondeurext() < mother.getProfondeurext() ) {
										ADDOrUpdateEquation("@this.posz@", "@Parent.p@ /2", Equation.CALCULATION_MANUAL,equations) ;
				
									}else {
										ADDOrUpdateEquation("@this.posz@", "@Mother.p@ /2 + @Mother.poszABS@ - @Parent.poszABS@", Equation.CALCULATION_MANUAL,equations) ;
				
									} 
								}	
							
							break;
						default:
							throw new DesignException("cas impossible");
						}
						
						break;
					case XPLUS:
						ADDOrUpdateEquation("@this.posx@", "0", Equation.CALCULATION_MANUAL,equations) ;
						
						switch (parentDirection) {
						case Y:
							if(father.getProfondeurext() <= mother.getProfondeurext()) {
								ADDOrUpdateEquation("@this.posz@", "@Parent.p@ /2 ", Equation.CALCULATION_MANUAL,equations) ;
							}else {
								ADDOrUpdateEquation("@this.posz@", "(@Mother.p@ /2) + @Mother.poszABS@ - @Parent.poszABS@", Equation.CALCULATION_MANUAL,equations) ;
							}
							
							//trouver le distance de retrait pour calculer la posy
							if((isBandeCoteBasFour(mother)&& !father.getPiecetype().equals(PieceType.BANDE_FOUR_BAS_FACE))
									||(isBandeCoteBasFour(father)&&!((Piece2D) mother).getPiecetype().equals(PieceType.BANDE_FOUR_BAS_FACE))) {
								ADDOrUpdateEquation("@this.retrait@", "@usin.retraitbandecotebasfour@",Equation.CALCULATION_MANUAL, equations);	
							}
							else if (mother instanceof Bande) {
								ADDOrUpdateEquation("@this.retrait@", "(@Mother.h@ -  @usin.troubandeinterdist@  )/2 ",	Equation.CALCULATION_MANUAL, equations);
		
							} else if (father instanceof Bande) {
								ADDOrUpdateEquation("@this.retrait@", "(@Parent.h@ -  @usin.troubandeinterdist@  )/2 ",Equation.CALCULATION_MANUAL, equations);
		
							} else {
								ADDOrUpdateEquation("@this.retrait@", "@usin.usinagetroupieceretrait@ ",Equation.CALCULATION_MANUAL, equations);
							}
								
							//calculuer la posy 
							if(trouType.equals(TrouType.USINGAGE_FRONT)) {
									
								if(father.getYPosABS()+father.getHauteurext()> mother.getYPosABS()+mother.getHauteurext()) {
									ADDOrUpdateEquation("@this.posy@", "@Mother.h@ - @this.retrait@ + @Mother.posyABS@ - @Parent.posyABS@", Equation.CALCULATION_MANUAL,equations) ;
								}else {
									ADDOrUpdateEquation("@this.posy@", "@Parent.h@ - @this.retrait@", Equation.CALCULATION_MANUAL,equations) ;
								}
							}else if(trouType.equals(TrouType.USINGAGE_BACK)) {
									
								if(father.getYPosABS() < mother.getYPosABS() ) {
									ADDOrUpdateEquation("@this.posy@", "@this.retrait@ + @Mother.posyABS@ - @Parent.posyABS@", Equation.CALCULATION_MANUAL,equations) ;
			
								}else {
									ADDOrUpdateEquation("@this.posy@", "@this.retrait@", Equation.CALCULATION_MANUAL,equations) ;
			
								} 
							}else if(trouType.equals(TrouType.USINGAGE_MIDDLE)) {
								
								if(father.getHauteurext() < mother.getHauteurext() ) {
									ADDOrUpdateEquation("@this.posy@", "@Parent.h@ /2", Equation.CALCULATION_MANUAL,equations) ;
			
								}else {
									ADDOrUpdateEquation("@this.posy@", "@Mother.h@ /2 + @Mother.posyABS@ - @Parent.posyABS@", Equation.CALCULATION_MANUAL,equations) ;
			
								} 
							}																	
								
							
							
							break;
						case Z:
							
							//
							if(father.getHauteurext() <= mother.getHauteurext()) {
								ADDOrUpdateEquation("@this.posy@", "@Parent.h@ /2 ", Equation.CALCULATION_MANUAL,equations) ;
							}else {
								ADDOrUpdateEquation("@this.posy@", "(@Mother.h@ /2) + @Mother.posyABS@ - @Parent.posyABS@", Equation.CALCULATION_MANUAL,equations) ;
							}
							
							//
							if((isBandeCoteBasFour(mother)&& !father.getPiecetype().equals(PieceType.BANDE_FOUR_BAS_FACE))
									||(isBandeCoteBasFour(father)&&!((Piece2D) mother).getPiecetype().equals(PieceType.BANDE_FOUR_BAS_FACE))) {
								ADDOrUpdateEquation("@this.retrait@", "@usin.retraitbandecotebasfour@",Equation.CALCULATION_MANUAL, equations);	
							}
							else
							if (mother instanceof Bande) {
								ADDOrUpdateEquation("@this.retrait@", "(@Mother.p@ -  @usin.troubandeinterdist@  )/2 ",	Equation.CALCULATION_MANUAL, equations);
		
							} else if (father instanceof Bande) {
								ADDOrUpdateEquation("@this.retrait@", "(@Parent.p@ -  @usin.troubandeinterdist@  )/2 ",Equation.CALCULATION_MANUAL, equations);
		
							} else {
								ADDOrUpdateEquation("@this.retrait@", "@usin.usinagetroupieceretrait@ ",Equation.CALCULATION_MANUAL, equations);
							}
		
							//
							if (trouType.equals(TrouType.USINGAGE_FRONT)) {
		
								if (father.getZPosABS() + father.getProfondeurext() > mother.getZPosABS()+ mother.getProfondeurext()) {
									ADDOrUpdateEquation("@this.posz@","@Mother.p@ - @this.retrait@ + @Mother.poszABS@ - @Parent.poszABS@",Equation.CALCULATION_MANUAL, equations);
								} else {
									ADDOrUpdateEquation("@this.posz@", "@Parent.p@ - @this.retrait@",Equation.CALCULATION_MANUAL, equations);
								}
							} else if (trouType.equals(TrouType.USINGAGE_BACK)) {
		
								if (father.getZPosABS() < mother.getZPosABS()) {
									ADDOrUpdateEquation("@this.posz@","@this.retrait@ + @Mother.poszABS@ - @Parent.poszABS@",Equation.CALCULATION_MANUAL, equations);
		
								} else {
									ADDOrUpdateEquation("@this.posz@", "@this.retrait@",Equation.CALCULATION_MANUAL, equations);
		
								}
							}else if(trouType.equals(TrouType.USINGAGE_MIDDLE)) {
								
								if(father.getProfondeurext() < mother.getProfondeurext() ) {
									ADDOrUpdateEquation("@this.posz@", "@Parent.p@ /2", Equation.CALCULATION_MANUAL,equations) ;
			
								}else {
									ADDOrUpdateEquation("@this.posz@", "@Mother.p@ /2 + @Mother.poszABS@ - @Parent.poszABS@", Equation.CALCULATION_MANUAL,equations) ;
			
								} 
							}
							
							break;
						default:
							throw new DesignException("cas impossible");
						}
						break;
					case YMINUS:
						ADDOrUpdateEquation("@this.posy@", "@Parent.h@", Equation.CALCULATION_MANUAL,equations) ;

						
						switch (parentDirection) {
						case X:
							if(father.getProfondeurext() <= mother.getProfondeurext()) {
								ADDOrUpdateEquation("@this.posz@", "@Parent.p@ /2 ", Equation.CALCULATION_MANUAL,equations) ;
							}else {
								ADDOrUpdateEquation("@this.posz@", "(@Mother.p@ /2) + @Mother.poszABS@ -  @Parent.poszABS@", Equation.CALCULATION_MANUAL,equations) ;
							}
							//trouver le distance de retrait pour calculer la posx
							if((isBandeCoteBasFour(mother)&& !father.getPiecetype().equals(PieceType.BANDE_FOUR_BAS_FACE))
									||(isBandeCoteBasFour(father)&&!((Piece2D) mother).getPiecetype().equals(PieceType.BANDE_FOUR_BAS_FACE))) {
								ADDOrUpdateEquation("@this.retrait@", "@usin.retraitbandecotebasfour@",Equation.CALCULATION_MANUAL, equations);	
							}
							else if (mother instanceof Bande) {
								ADDOrUpdateEquation("@this.retrait@", "(@Mother.l@ -  @usin.troubandeinterdist@  )/2 ",	Equation.CALCULATION_MANUAL, equations);
		
							} else if (father instanceof Bande) {
								ADDOrUpdateEquation("@this.retrait@", "(@Parent.l@ -  @usin.troubandeinterdist@  )/2 ",Equation.CALCULATION_MANUAL, equations);
		
							} else {
								ADDOrUpdateEquation("@this.retrait@", "@usin.usinagetroupieceretrait@ ",Equation.CALCULATION_MANUAL, equations);
							}
								
							//calculuer la posx
							if(trouType.equals(TrouType.USINGAGE_FRONT)) {
									
								if(father.getXPosABS()+father.getLongeurext()> mother.getXPosABS()+mother.getLongeurext()) {
									ADDOrUpdateEquation("@this.posx@", "@Mother.l@ - @this.retrait@ + @Mother.posxABS@ - @Parent.posxABS@", Equation.CALCULATION_MANUAL,equations) ;
								}else {
									ADDOrUpdateEquation("@this.posx@", "@Parent.l@ - @this.retrait@", Equation.CALCULATION_MANUAL,equations) ;
								}
							}else if(trouType.equals(TrouType.USINGAGE_BACK)) {
									
								if(father.getXPosABS() < mother.getXPosABS() ) {
									ADDOrUpdateEquation("@this.posx@", "@this.retrait@ + @Mother.posxABS@ - @Parent.posxABS@", Equation.CALCULATION_MANUAL,equations) ;
			
								}else {
									ADDOrUpdateEquation("@this.posx@", "@this.retrait@", Equation.CALCULATION_MANUAL,equations) ;
			
								} 
							}else if(trouType.equals(TrouType.USINGAGE_MIDDLE)) {
								
								if(father.getLongeurext() < mother.getLongeurext() ) {
									ADDOrUpdateEquation("@this.posx@", "@Parent.l@ /2", Equation.CALCULATION_MANUAL,equations) ;
			
								}else {
									ADDOrUpdateEquation("@this.posx@", "@Mother.l@ /2 + @Mother.posxABS@ - @Parent.posxABS@", Equation.CALCULATION_MANUAL,equations) ;
			
								} 
							}
							
							
							break;
						case Z:
							
							if(father.getLongeurext() <= mother.getLongeurext()) {
								ADDOrUpdateEquation("@this.posx@", "@Parent.l@ /2 ", Equation.CALCULATION_MANUAL,equations) ;
							}else {
								ADDOrUpdateEquation("@this.posx@", "(@Mother.l@ /2) + @Mother.posxABS@ - @Parent.posxABS@", Equation.CALCULATION_MANUAL,equations) ;
							}
							
//
							if((isBandeCoteBasFour(mother)&& !father.getPiecetype().equals(PieceType.BANDE_FOUR_BAS_FACE))
									||(isBandeCoteBasFour(father)&&!((Piece2D) mother).getPiecetype().equals(PieceType.BANDE_FOUR_BAS_FACE))) {
								ADDOrUpdateEquation("@this.retrait@", "@usin.retraitbandecotebasfour@",Equation.CALCULATION_MANUAL, equations);	
							}
							else
							if (mother instanceof Bande) {
								ADDOrUpdateEquation("@this.retrait@", "(@Mother.p@ -  @usin.troubandeinterdist@  )/2 ",	Equation.CALCULATION_MANUAL, equations);
		
							} else if (father instanceof Bande) {
								ADDOrUpdateEquation("@this.retrait@", "(@Parent.p@ -  @usin.troubandeinterdist@  )/2 ",Equation.CALCULATION_MANUAL, equations);
		
							} else {
								ADDOrUpdateEquation("@this.retrait@", "@usin.usinagetroupieceretrait@ ",Equation.CALCULATION_MANUAL, equations);
							}
		
							//
							if (trouType.equals(TrouType.USINGAGE_FRONT)) {
		
								if (father.getZPosABS() + father.getProfondeurext() > mother.getZPosABS()+ mother.getProfondeurext()) {
									ADDOrUpdateEquation("@this.posz@","@Mother.p@ - @this.retrait@ + @Mother.poszABS@ - @Parent.poszABS@",Equation.CALCULATION_MANUAL, equations);
								} else {
									ADDOrUpdateEquation("@this.posz@", "@Parent.p@ - @this.retrait@",Equation.CALCULATION_MANUAL, equations);
								}
							} else if (trouType.equals(TrouType.USINGAGE_BACK)) {
		
								if (father.getZPosABS() < mother.getZPosABS()) {
									ADDOrUpdateEquation("@this.posz@","@this.retrait@ + @Mother.poszABS@ - @Parent.poszABS@",Equation.CALCULATION_MANUAL, equations);
		
								} else {
									ADDOrUpdateEquation("@this.posz@", "@this.retrait@",Equation.CALCULATION_MANUAL, equations);
		
								}
							}else if(trouType.equals(TrouType.USINGAGE_MIDDLE)) {
								
								if(father.getProfondeurext() < mother.getProfondeurext() ) {
									ADDOrUpdateEquation("@this.posz@", "@Parent.p@ /2", Equation.CALCULATION_MANUAL,equations) ;
			
								}else {
									ADDOrUpdateEquation("@this.posz@", " @Mother.p@/2   + @Mother.poszABS@ - @Parent.poszABS@", Equation.CALCULATION_MANUAL,equations) ;
			
								} 
							}
							
							break;
						default:
							throw new DesignException("cas impossible");
						}
						
						break;
					case YPLUS:
						ADDOrUpdateEquation("@this.posy@", "0", Equation.CALCULATION_MANUAL,equations) ;

						switch (parentDirection) {
						case X:
							if(father.getProfondeurext() <= mother.getProfondeurext()) {
								ADDOrUpdateEquation("@this.posz@", "@Parent.p@ /2 ", Equation.CALCULATION_MANUAL,equations) ;
							}else {
								ADDOrUpdateEquation("@this.posz@", "(@Mother.p@ /2) + @Mother.poszABS@ -  @Parent.poszABS@", Equation.CALCULATION_MANUAL,equations) ;
							}
							
							//trouver le distance de retrait pour calculer la posx
							if((isBandeCoteBasFour(mother)&& !father.getPiecetype().equals(PieceType.BANDE_FOUR_BAS_FACE))
									||(isBandeCoteBasFour(father)&&!((Piece2D) mother).getPiecetype().equals(PieceType.BANDE_FOUR_BAS_FACE))) {
								ADDOrUpdateEquation("@this.retrait@", "@usin.retraitbandecotebasfour@",Equation.CALCULATION_MANUAL, equations);	
							}
							else if (mother instanceof Bande) {
								ADDOrUpdateEquation("@this.retrait@", "(@Mother.l@ -  @usin.troubandeinterdist@  )/2 ",	Equation.CALCULATION_MANUAL, equations);
		
							} else if (father instanceof Bande) {
								ADDOrUpdateEquation("@this.retrait@", "(@Parent.l@ -  @usin.troubandeinterdist@  )/2 ",Equation.CALCULATION_MANUAL, equations);
		
							} else {
								ADDOrUpdateEquation("@this.retrait@", "@usin.usinagetroupieceretrait@ ",Equation.CALCULATION_MANUAL, equations);
							}
								
							//calculuer la posx
							if(trouType.equals(TrouType.USINGAGE_FRONT)) {
									
								if(father.getXPosABS()+father.getLongeurext()>=mother.getXPosABS()+mother.getLongeurext()) {
									ADDOrUpdateEquation("@this.posx@", "@Mother.l@ - @this.retrait@ + @Mother.posxABS@ - @Parent.posxABS@", Equation.CALCULATION_MANUAL,equations) ;
								}else {
									ADDOrUpdateEquation("@this.posx@", "@Parent.l@ - @this.retrait@", Equation.CALCULATION_MANUAL,equations) ;
								}
							}else if(trouType.equals(TrouType.USINGAGE_BACK)) {
									
								if(father.getXPosABS() <=mother.getXPosABS() ) {
									ADDOrUpdateEquation("@this.posx@", "@this.retrait@ + @Mother.posxABS@ - @Parent.posxABS@", Equation.CALCULATION_MANUAL,equations) ;
			
								}else {
									ADDOrUpdateEquation("@this.posx@", "@this.retrait@", Equation.CALCULATION_MANUAL,equations) ;
			
								} 
							}else if(trouType.equals(TrouType.USINGAGE_MIDDLE)) {
								
								if(father.getLongeurext() < mother.getLongeurext() ) {
									ADDOrUpdateEquation("@this.posx@", "@Parent.l@ /2", Equation.CALCULATION_MANUAL,equations) ;
			
								}else {
									ADDOrUpdateEquation("@this.posx@", " @Mother.l@/2  + @Mother.posxABS@ - @Parent.posxABS@", Equation.CALCULATION_MANUAL,equations) ;
			
								} 
							}
							
							break;
						case Z:
							if(father.getLongeurext() <= mother.getLongeurext()) {
								ADDOrUpdateEquation("@this.posx@", "@Parent.l@ /2 ", Equation.CALCULATION_MANUAL,equations) ;
							}else {
								ADDOrUpdateEquation("@this.posx@", "(@Mother.l@ /2) + @Mother.posxABS@ - @Parent.posxABS@", Equation.CALCULATION_MANUAL,equations) ;
							}
							
//
							if((isBandeCoteBasFour(mother)&& !father.getPiecetype().equals(PieceType.BANDE_FOUR_BAS_FACE))
									||(isBandeCoteBasFour(father)&&!((Piece2D) mother).getPiecetype().equals(PieceType.BANDE_FOUR_BAS_FACE))) {
								ADDOrUpdateEquation("@this.retrait@", "@usin.retraitbandecotebasfour@",Equation.CALCULATION_MANUAL, equations);	
							}
							else
							if (mother instanceof Bande) {
								ADDOrUpdateEquation("@this.retrait@", "(@Mother.p@ -  @usin.troubandeinterdist@  )/2 ",	Equation.CALCULATION_MANUAL, equations);
		
							} else if (father instanceof Bande) {
								ADDOrUpdateEquation("@this.retrait@", "(@Parent.p@ -  @usin.troubandeinterdist@  )/2 ",Equation.CALCULATION_MANUAL, equations);
		
							} else {
								ADDOrUpdateEquation("@this.retrait@", "@usin.usinagetroupieceretrait@ ",Equation.CALCULATION_MANUAL, equations);
							}
		
							//
							if (trouType.equals(TrouType.USINGAGE_FRONT)) {
		
								if (father.getZPosABS() + father.getProfondeurext() > mother.getZPosABS()+ mother.getProfondeurext()) {
									ADDOrUpdateEquation("@this.posz@","@Mother.p@ - @this.retrait@ + @Mother.poszABS@ - @Parent.poszABS@",Equation.CALCULATION_MANUAL, equations);
								} else {
									ADDOrUpdateEquation("@this.posz@", "@Parent.p@ - @this.retrait@",Equation.CALCULATION_MANUAL, equations);
								}
							} else if (trouType.equals(TrouType.USINGAGE_BACK)) {
		
								if (father.getZPosABS() < mother.getZPosABS()) {
									ADDOrUpdateEquation("@this.posz@","@this.retrait@ + @Mother.poszABS@ - @Parent.poszABS@",Equation.CALCULATION_MANUAL, equations);
		
								} else {
									ADDOrUpdateEquation("@this.posz@", "@this.retrait@",Equation.CALCULATION_MANUAL, equations);
		
								}
							}else if(trouType.equals(TrouType.USINGAGE_MIDDLE)) {
								
								if(father.getProfondeurext() < mother.getProfondeurext() ) {
									ADDOrUpdateEquation("@this.posz@", "@Parent.p@ /2", Equation.CALCULATION_MANUAL,equations) ;
			
								}else {
									ADDOrUpdateEquation("@this.posz@", " @Mother.p@/2 + @Mother.poszABS@ - @Parent.poszABS@", Equation.CALCULATION_MANUAL,equations) ;
			
								} 
							}
							
							break;
						default:
							throw new DesignException("cas impossible");
						}
						
						break;
					case ZMINUS:
						ADDOrUpdateEquation("@this.posz@", "@Parent.p@", Equation.CALCULATION_MANUAL,equations) ;

						switch (parentDirection) {
						case Y:
							if(father.getLongeurext() <= mother.getLongeurext()) {
								ADDOrUpdateEquation("@this.posx@", "@Parent.l@ /2 ", Equation.CALCULATION_MANUAL,equations) ;
							}else {
								ADDOrUpdateEquation("@this.posx@", "(@Mother.l@ /2) + @Mother.posxABS@ - @Parent.posxABS@", Equation.CALCULATION_MANUAL,equations) ;
							}
							
							//trouver le distance de retrait pour calculer la posy
							if((isBandeCoteBasFour(mother)&& !father.getPiecetype().equals(PieceType.BANDE_FOUR_BAS_FACE))
									||(isBandeCoteBasFour(father)&&!((Piece2D) mother).getPiecetype().equals(PieceType.BANDE_FOUR_BAS_FACE))) {
								ADDOrUpdateEquation("@this.retrait@", "@usin.retraitbandecotebasfour@",Equation.CALCULATION_MANUAL, equations);	
							}
							else if (mother instanceof Bande) {
								ADDOrUpdateEquation("@this.retrait@", "(@Mother.h@ -   @usin.troubandeinterdist@   )/2 ",	Equation.CALCULATION_MANUAL, equations);
		
							} else if (father instanceof Bande) {
								ADDOrUpdateEquation("@this.retrait@", "(@Parent.h@ -   @usin.troubandeinterdist@   )/2 ",Equation.CALCULATION_MANUAL, equations);
		
							} else {
								ADDOrUpdateEquation("@this.retrait@", "@usin.usinagetroupieceretrait@ ",Equation.CALCULATION_MANUAL, equations);
							}
								
							//calculuer la posy 
							if(trouType.equals(TrouType.USINGAGE_FRONT)) {
									
								if(father.getYPosABS()+father.getHauteurext()>=mother.getYPosABS()+mother.getHauteurext()) {
									ADDOrUpdateEquation("@this.posy@", "@Mother.h@ - @this.retrait@ + @Mother.posyABS@ - @Parent.posyABS@", Equation.CALCULATION_MANUAL,equations) ;
								}else {
									ADDOrUpdateEquation("@this.posy@", "@Parent.h@ - @this.retrait@", Equation.CALCULATION_MANUAL,equations) ;
								}
							}else if(trouType.equals(TrouType.USINGAGE_BACK)) {
									
								if(father.getYPosABS() <=mother.getYPosABS() ) {
									ADDOrUpdateEquation("@this.posy@", "@this.retrait@ + @Mother.posyABS@ - @Parent.posyABS@", Equation.CALCULATION_MANUAL,equations) ;
			
								}else {
									ADDOrUpdateEquation("@this.posy@", "@this.retrait@", Equation.CALCULATION_MANUAL,equations) ;
			
								} 
							}else if(trouType.equals(TrouType.USINGAGE_MIDDLE)) {
								
								if(father.getHauteurext() < mother.getHauteurext() ) {
									ADDOrUpdateEquation("@this.posy@", "@Parent.h@ /2", Equation.CALCULATION_MANUAL,equations) ;
			
								}else {
									ADDOrUpdateEquation("@this.posy@", " @Mother.h@/2 + @Mother.posyABS@ - @Parent.posyABS@", Equation.CALCULATION_MANUAL,equations) ;
			
								} 
							}	
							
							break;
						case X:
							if(father.getHauteurext() <= mother.getHauteurext()) {
								ADDOrUpdateEquation("@this.posy@", "@Parent.h@ /2 ", Equation.CALCULATION_MANUAL,equations) ;
							}else {
								ADDOrUpdateEquation("@this.posy@", "(@Mother.h@ /2) + @Mother.posyABS@ - @Parent.posyABS@", Equation.CALCULATION_MANUAL,equations) ;
							}
							
							//trouver le distance de retrait pour calculer la posx
							if((isBandeCoteBasFour(mother)&& !father.getPiecetype().equals(PieceType.BANDE_FOUR_BAS_FACE))
									||(isBandeCoteBasFour(father)&&!((Piece2D) mother).getPiecetype().equals(PieceType.BANDE_FOUR_BAS_FACE))) {
								ADDOrUpdateEquation("@this.retrait@", "@usin.retraitbandecotebasfour@",Equation.CALCULATION_MANUAL, equations);	
							}
							else
							if (mother instanceof Bande) {
								ADDOrUpdateEquation("@this.retrait@", "(@Mother.l@ -  @usin.troubandeinterdist@  )/2 ",	Equation.CALCULATION_MANUAL, equations);
		
							} else if (father instanceof Bande) {
								ADDOrUpdateEquation("@this.retrait@", "(@Parent.l@ -  @usin.troubandeinterdist@  )/2 ",Equation.CALCULATION_MANUAL, equations);
		
							} else {
								ADDOrUpdateEquation("@this.retrait@", "@usin.usinagetroupieceretrait@ ",Equation.CALCULATION_MANUAL, equations);
							}
								
							//calculuer la posx
							if(trouType.equals(TrouType.USINGAGE_FRONT)) {
									
								if(father.getXPosABS()+father.getLongeurext()>=mother.getXPosABS()+mother.getLongeurext()) {
									ADDOrUpdateEquation("@this.posx@", "@Mother.l@ - @this.retrait@ + @Mother.posxABS@ - @Parent.posxABS@", Equation.CALCULATION_MANUAL,equations) ;
								}else {
									ADDOrUpdateEquation("@this.posx@", "@Parent.l@ - @this.retrait@", Equation.CALCULATION_MANUAL,equations) ;
								}
							}else if(trouType.equals(TrouType.USINGAGE_BACK)) {
									
								if(father.getXPosABS() <=mother.getXPosABS() ) {
									ADDOrUpdateEquation("@this.posx@", "@this.retrait@ + @Mother.posxABS@ - @Parent.posxABS@", Equation.CALCULATION_MANUAL,equations) ;
			
								}else {
									ADDOrUpdateEquation("@this.posx@", "@this.retrait@", Equation.CALCULATION_MANUAL,equations) ;
			
								} 
							}else if(trouType.equals(TrouType.USINGAGE_MIDDLE)) {
								
								if(father.getLongeurext() < mother.getLongeurext() ) {
									ADDOrUpdateEquation("@this.posx@", "@Parent.l@ /2", Equation.CALCULATION_MANUAL,equations) ;
			
								}else {
									ADDOrUpdateEquation("@this.posx@", " @Mother.l@/2 + @Mother.posxABS@ - @Parent.posxABS@", Equation.CALCULATION_MANUAL,equations) ;
			
								} 
							}	
							
							break;
						default:
							throw new DesignException("cas impossible");
						}
						
						break;
					case ZPLUS:
						ADDOrUpdateEquation("@this.posz@", "0", Equation.CALCULATION_MANUAL,equations) ;

						switch (parentDirection) {
						case Y:
							if(father.getLongeurext() <= mother.getLongeurext()) {
								ADDOrUpdateEquation("@this.posx@", "@Parent.l@ /2 ", Equation.CALCULATION_MANUAL,equations) ;
							}else {
								ADDOrUpdateEquation("@this.posx@", "(@Mother.l@ /2) + @Mother.posxABS@ - @Parent.posxABS@", Equation.CALCULATION_MANUAL,equations) ;
							}
							
							//trouver le distance de retrait pour calculer la posy
							if((isBandeCoteBasFour(mother)&& !father.getPiecetype().equals(PieceType.BANDE_FOUR_BAS_FACE))
									||(isBandeCoteBasFour(father)&&!((Piece2D) mother).getPiecetype().equals(PieceType.BANDE_FOUR_BAS_FACE))) {
								ADDOrUpdateEquation("@this.retrait@", "@usin.retraitbandecotebasfour@",Equation.CALCULATION_MANUAL, equations);	
							}
							else if (mother instanceof Bande) {
								ADDOrUpdateEquation("@this.retrait@", "(@Mother.h@ -  @usin.troubandeinterdist@  )/2 ",	Equation.CALCULATION_MANUAL, equations);
		
							} else if (father instanceof Bande) {
								ADDOrUpdateEquation("@this.retrait@", "(@Parent.h@ -  @usin.troubandeinterdist@  )/2 ",Equation.CALCULATION_MANUAL, equations);
		
							} else {
								ADDOrUpdateEquation("@this.retrait@", "@usin.usinagetroupieceretrait@ ",Equation.CALCULATION_MANUAL, equations);
							}
								
							//calculuer la posy 
							if(trouType.equals(TrouType.USINGAGE_FRONT)) {
									
								if(father.getYPosABS()+father.getHauteurext()> mother.getYPosABS()+mother.getHauteurext()) {
									ADDOrUpdateEquation("@this.posy@", "@Mother.h@ - @this.retrait@ + @Mother.posyABS@ - @Parent.posyABS@", Equation.CALCULATION_MANUAL,equations) ;
								}else {
									ADDOrUpdateEquation("@this.posy@", "@Parent.h@ - @this.retrait@", Equation.CALCULATION_MANUAL,equations) ;
								}
							}else if(trouType.equals(TrouType.USINGAGE_BACK)) {
									
								if(father.getYPosABS() < mother.getYPosABS() ) {
									ADDOrUpdateEquation("@this.posy@", "@this.retrait@ + @Mother.posyABS@ - @Parent.posyABS@", Equation.CALCULATION_MANUAL,equations) ;
			
								}else {
									ADDOrUpdateEquation("@this.posy@", "@this.retrait@", Equation.CALCULATION_MANUAL,equations) ;
			
								} 
							}else if(trouType.equals(TrouType.USINGAGE_MIDDLE)) {
								
								if(father.getHauteurext() < mother.getHauteurext() ) {
									ADDOrUpdateEquation("@this.posy@", "@Parent.h@ /2", Equation.CALCULATION_MANUAL,equations) ;
			
								}else {
									ADDOrUpdateEquation("@this.posy@", " @Mother.h@/2 + @Mother.posyABS@ - @Parent.posyABS@", Equation.CALCULATION_MANUAL,equations) ;
			
								} 
							}		
							
							break;
						case X:
							if(father.getHauteurext() <= mother.getHauteurext()) {
								ADDOrUpdateEquation("@this.posy@", "@Parent.h@ /2 ", Equation.CALCULATION_MANUAL,equations) ;
							}else {
								ADDOrUpdateEquation("@this.posy@", "(@Mother.h@ /2) + @Mother.posyABS@ - @Parent.posyABS@", Equation.CALCULATION_MANUAL,equations) ;
							}
							
							//trouver le distance de retrait pour calculer la posx
							if((isBandeCoteBasFour(mother)&& !father.getPiecetype().equals(PieceType.BANDE_FOUR_BAS_FACE))
									||(isBandeCoteBasFour(father)&&!((Piece2D) mother).getPiecetype().equals(PieceType.BANDE_FOUR_BAS_FACE))) {
								ADDOrUpdateEquation("@this.retrait@", "@usin.retraitbandecotebasfour@",Equation.CALCULATION_MANUAL, equations);	
							}
							else if (mother instanceof Bande) {
								ADDOrUpdateEquation("@this.retrait@", "(@Mother.l@ -  @usin.troubandeinterdist@  )/2 ",	Equation.CALCULATION_MANUAL, equations);
		
							} else if (father instanceof Bande) {
								ADDOrUpdateEquation("@this.retrait@", "(@Parent.l@ -  @usin.troubandeinterdist@  )/2 ",Equation.CALCULATION_MANUAL, equations);
		
							} else {
								ADDOrUpdateEquation("@this.retrait@", "@usin.usinagetroupieceretrait@ ",Equation.CALCULATION_MANUAL, equations);
							}
								
							//calculuer la posx
							if(trouType.equals(TrouType.USINGAGE_FRONT)) {
									
								if(father.getXPosABS()+father.getLongeurext() > mother.getXPosABS()+mother.getLongeurext()) {
									ADDOrUpdateEquation("@this.posx@", "@Mother.l@ - @this.retrait@ + @Mother.posxABS@ - @Parent.posxABS@", Equation.CALCULATION_MANUAL,equations) ;
								}else {
									ADDOrUpdateEquation("@this.posx@", "@Parent.l@ - @this.retrait@", Equation.CALCULATION_MANUAL,equations) ;
								}
							}else if(trouType.equals(TrouType.USINGAGE_BACK)) {
									
								if(father.getXPosABS() < mother.getXPosABS() ) {
									ADDOrUpdateEquation("@this.posx@", "@this.retrait@ + @Mother.posxABS@ - @Parent.posxABS@", Equation.CALCULATION_MANUAL,equations) ;
			
								}else {
									ADDOrUpdateEquation("@this.posx@", "@this.retrait@", Equation.CALCULATION_MANUAL,equations) ;
			
								} 
							}else if(trouType.equals(TrouType.USINGAGE_MIDDLE)) {
								
								if(father.getLongeurext() < mother.getLongeurext() ) {
									ADDOrUpdateEquation("@this.posx@", "@Parent.l@ /2", Equation.CALCULATION_MANUAL,equations) ;
			
								}else {
									ADDOrUpdateEquation("@this.posx@", " @Mother.l@/2 + @Mother.posxABS@ - @Parent.posxABS@", Equation.CALCULATION_MANUAL,equations) ;
			
								} 
							}
							break;
						default:
							throw new DesignException("cas impossible");
						}
						
						break;
					default:
						throw new DesignException("cas impossible");
					}
					
					break;
				default:
					throw new DesignException("cas impossible");
				
						
			}
			
			
		}		
			
		
	}
	
	
	protected void FILL_TROU_USINAGE_FROM_PARENTS( Trou tr,ArrayList<Equation> equations) {
		DesignObject3D father=tr.getParentdesign();
		DesignObject3D mother=tr.getMother();
		
		
		ADDOrUpdateEquation("@Parent.l@", ""+father.getLongeurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.h@", ""+father.getHauteurext(), Equation.CALCULATION_MANUAL,equations);
		ADDOrUpdateEquation("@Parent.p@", ""+father.getProfondeurext(), Equation.CALCULATION_MANUAL,equations) ;
		
		ADDOrUpdateEquation("@Parent.posx@", ""+father.getXpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.posy@", ""+father.getYpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.posz@", ""+father.getZpos(), Equation.CALCULATION_MANUAL,equations) ;
		
		ADDOrUpdateEquation("@Parent.posxABS@", ""+father.getXPosABS(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.posyABS@", ""+father.getYPosABS(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.poszABS@", ""+father.getZPosABS(), Equation.CALCULATION_MANUAL,equations) ;
		
		ADDOrUpdateEquation("@Parent.epaisseursecondaire@", ""+father.getBackmaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.epaisseurprincipale@", ""+father.getBasematerial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
		
		ADDOrUpdateEquation("@Mother.l@", ""+mother.getLongeurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Mother.h@", ""+mother.getHauteurext(), Equation.CALCULATION_MANUAL,equations);
		ADDOrUpdateEquation("@Mother.p@", ""+mother.getProfondeurext(), Equation.CALCULATION_MANUAL,equations) ;
		
		ADDOrUpdateEquation("@Mother.posx@", ""+mother.getXpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Mother.posy@", ""+mother.getYpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Mother.posz@", ""+mother.getZpos(), Equation.CALCULATION_MANUAL,equations) ;
		
		ADDOrUpdateEquation("@Mother.posxABS@", ""+mother.getXPosABS(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Mother.posyABS@", ""+mother.getYPosABS(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Mother.poszABS@", ""+mother.getZPosABS(), Equation.CALCULATION_MANUAL,equations) ;
		
		ADDOrUpdateEquation("@Mother.epaisseursecondaire@", ""+mother.getBackmaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Mother.epaisseurprincipale@", ""+mother.getBasematerial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;

	}
	private void FILL_TROU_FROM_PARENTS(DesignObject3D child2, ArrayList<Equation> equations) {
		Trou tr=(Trou) child2;
		DesignObject3D parentCote=tr.getParentdesign();
		ADDOrUpdateEquation("@Parent.l@", ""+parentCote.getLongeurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.h@", ""+parentCote.getHauteurext(), Equation.CALCULATION_MANUAL,equations);
		ADDOrUpdateEquation("@Parent.p@", ""+parentCote.getProfondeurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.posx@", ""+parentCote.getXpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.posy@", ""+parentCote.getYpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.posz@", ""+parentCote.getZpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.posyABS@", ""+parentCote.getYPosABS(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.epaisseursecondaire@", ""+parentCote.getBackmaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.epaisseurprincipale@", ""+parentCote.getBasematerial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
	
	}
	private void FILL_TROU_FROM_SUPPORT_PORTE_BOTEILLE(DesignObject3D child2, ArrayList<Equation> equations) {
		Trou tr=(Trou) child2;
		DesignObject3D parentCote=tr.getParentdesign();
		DesignObject3D mother=tr.getMother();
		 
		ADDOrUpdateEquation("@Parent.l@", ""+parentCote.getLongeurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.h@", ""+parentCote.getHauteurext(), Equation.CALCULATION_MANUAL,equations);
		ADDOrUpdateEquation("@Parent.p@", ""+parentCote.getProfondeurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.posx@", ""+parentCote.getXpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.posy@", ""+parentCote.getYpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.posz@", ""+parentCote.getZpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.epaisseursecondaire@", ""+parentCote.getBackmaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.epaisseurprincipale@", ""+parentCote.getBasematerial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Mother.l@", ""+mother.getLongeurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Mother.h@", ""+mother.getHauteurext(), Equation.CALCULATION_MANUAL,equations);
		ADDOrUpdateEquation("@Mother.p@", ""+mother.getProfondeurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Mother.posx@", ""+mother.getXpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Mother.posy@", ""+mother.getYpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Mother.posz@", ""+mother.getZpos(), Equation.CALCULATION_MANUAL,equations) ;
	}
	/**
	 * @Bug 0001866
	 * @param child le trous a calculer
	 * @param equations
	 */
	private void FILL_TROU_FROM_SUPPORTMEUBLEBAS_PARENTS(DesignObject3D child, ArrayList<Equation> equations) {
		Trou tr=(Trou) child;
		DesignObject3D mother=tr.getMother();
		ADDOrUpdateEquation("@Mother.l@", ""+mother.getLongeurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Mother.h@", ""+mother.getHauteurext(), Equation.CALCULATION_MANUAL,equations);
		ADDOrUpdateEquation("@Mother.p@", ""+mother.getProfondeurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Mother.posx@", ""+mother.getXpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Mother.posy@", ""+mother.getYpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Mother.posz@", ""+mother.getZpos(), Equation.CALCULATION_MANUAL,equations) ;
	}
	private void FILL_TROU_FROM_ETAGERE_PARENTS(DesignObject3D child2, ArrayList<Equation> equations) {
		Trou tr=(Trou) child2;
		DesignObject3D parentEtagere=tr.getMother();
		ADDOrUpdateEquation("@EParent.posy@", ""+parentEtagere.getYPosABS(), Equation.CALCULATION_MANUAL,equations) ;	
	}
	private void FILL_TROU_FROM_CHARNIERE_PARENTS(DesignObject3D child2, ArrayList<Equation> equations) {
		Trou tr=(Trou) child2;
		DesignObject3D parentCharniere=tr.getMother();
		ADDOrUpdateEquation("@CParent.posx@", ""+parentCharniere.getXpos(), Equation.CALCULATION_MANUAL,equations) ;	
		ADDOrUpdateEquation("@CParent.posy@", ""+parentCharniere.getYpos(), Equation.CALCULATION_MANUAL,equations) ;	
		ADDOrUpdateEquation("@CParent.posz@", ""+parentCharniere.getZpos(), Equation.CALCULATION_MANUAL,equations) ;	


	}
	//Imed bug 0001217 tester si un piece est un bande four bas cote 
	private boolean isBandeCoteBasFour(DesignObject3D mother) {
		if(mother instanceof Bande ) {
			Bande bande=(Bande) mother;
			if(bande.getPiecetype().equals(PieceType.BANDE_FOUR_BAS_DROITE1)
					||bande.getPiecetype().equals(PieceType.BANDE_FOUR_BAS_DROITE2)
					||bande.getPiecetype().equals(PieceType.BANDE_FOUR_BAS_GAUCHE1)
					||bande.getPiecetype().equals(PieceType.BANDE_FOUR_BAS_GAUCHE2)
						) {
				return true;
				
			}
		}
		
		
		return false;
	}
}
