package dressing.model;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.imageio.ImageIO;

import org.frs.svg.Box;
import com.badlogic.gdx.math.Vector3;

import dressing.config.ReportingPreferences;
import dressing.config.WorkspaceConfiguration;
import dressing.model.accessoire.SupportBlocTiroir;
import dressing.model.accessoire.SupportPorteBoteille;
import dressing.cam.model.MachineCodeHandler;
import dressing.model.debitage.DebitageFormulas;
import dressing.model.debitage.TiroirPieceDebitageFormulas;
import dressing.model.evalutor.Couple;
import dressing.model.evalutor.Equation;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.CharniereType;
import dressing.model.types.CuisineCaissonType;
import dressing.model.types.IntersectionType;
import dressing.model.types.Orientation;
import dressing.model.types.ParentDirection;
import dressing.model.types.ParentType;
import dressing.model.types.PieceType;
import dressing.model.types.SupportMeubleBasType;
import dressing.model.types.SupportMeubleHautType;
import dressing.model.types.SupportPorteBoteilleType;
import dressing.model.types.TrouType;
import dressing.model.types.Zone3DType;
import dressing.model.usinage.Direction;
import dressing.cam.model.PlanUsinage;
import dressing.cam.model.Rotationangle;
import dressing.model.usinage.Rainure;
import dressing.model.usinage.Trou;
import dressing.model.usinage.Usinage;
import param.MaterialTypeInstance;
import param.MechanicDesignElment;
import dressing.cam.model.DXF_STATIC_VALUE;
import tech.frsdev.graphunit.PLineDXFEntity;
import tech.frsdev.graphunit.PointDXF;
import tech.frsdev.graphunit.PolyLineDXFEntity;

public class Piece2D extends DesignObject3D {

	private PieceType piecetype;
	transient private double position=0;
	Materiaux material;
	//Pour les pieces 2D
	private double epaisseur;
	private double pieceL;
	private double pieceH;
	transient private double positionetagere;
	private double longchant1;
	private double longchant2;
	private double longchant3;
	private double longchant4;
	private Chant chant1;
	private Chant chant2;
	private Chant chant3;
	private Chant chant4;
	private String chants="";
	private MechanicDesignElment mechanicDesignElementDefinition;
	private MaterialTypeInstance materialType;
	private MaterialTypeInstance vitreMaterialType;

	transient private String gcode;

	public String getChants() {
		return chants;
	}
	public void setChants(String chants) {
		String oldValue = this.chants;
		this.chants = chants;
		firePropertyChange("chants", oldValue, chants);
	}
	
	public double getLongchant1() {
		return longchant1;
	}
	public void setLongchant1(double longchant1) {
		double oldValue = this.longchant1;
		this.longchant1 = longchant1;
		firePropertyChange("longchant1", oldValue, longchant1);
	}
	public double getLongchant2() {
		return longchant2;
	}
	public void setLongchant2(double longchant2) {
		double oldValue = this.longchant2;
		this.longchant2 = longchant2;
		firePropertyChange("longchant2", oldValue, longchant2);
	}
	public double getLongchant3() {
		return longchant3;
	}
	public void setLongchant3(double longchant3) {
		double oldValue = this.longchant3;
		this.longchant3 = longchant3;
		firePropertyChange("longchant3", oldValue, longchant3);
	}
	public double getLongchant4() {
		return longchant4;
	}
	public void setLongchant4(double longchant4) {
		double oldValue = this.longchant4;
		this.longchant4 = longchant4;
		firePropertyChange("longchant4", oldValue, longchant4);
	}
	
	public MechanicDesignElment getMechanicDesignElementDefinition() {
		return mechanicDesignElementDefinition;
	}
	public void setMechanicDesignElementDefinition(MechanicDesignElment mechanicDesignElementDefinition) {
		Object old=this.mechanicDesignElementDefinition;				
		this.mechanicDesignElementDefinition = mechanicDesignElementDefinition;
		firePropertyChange("mechanicDesignElementDefinition", old, mechanicDesignElementDefinition);
	}
	
	public MaterialTypeInstance getMaterialType() {
		return materialType;
	}
	public void setMaterialType(MaterialTypeInstance materialType) {
		Object old=this.materialType;				
		this.materialType = materialType;
		firePropertyChange("materialType", old, materialType);
	}
	
	public MaterialTypeInstance getVitreMaterialType() {
		return vitreMaterialType;
	}
	public void setVitreMaterialType(MaterialTypeInstance vitreMaterialType) {
		Object old=this.vitreMaterialType;				
		this.vitreMaterialType = vitreMaterialType;
		firePropertyChange("vitreMaterialType", old, vitreMaterialType);
	}
	public String getGcode() {
		return gcode;
	}
	public void setGcode(String gcode) {
		String oldValue = this.gcode;
		this.gcode = gcode;
		firePropertyChange("gcode", oldValue, gcode);
	}
	
//	public HashMap<String, String> getGcodes() {
//		if(this.gcodes==null) {
//			this.gcodes=new HashMap<String, String>();
//		}
//		return gcodes;
//	}
//	public void setGcodes(HashMap<String, String> gcodes) {
//		HashMap<String, String> oldValue = this.gcodes;
//		this.gcodes = gcodes;
//		firePropertyChange("gcodes", oldValue, gcodes);
//	}
	public Chant getChant1() {
		return chant1;
	}
	public void setChant1(Chant chant1) {
		Chant oldValue = this.chant1;
		this.chant1 = chant1;
		firePropertyChange("chant1", oldValue, chant1);
	}
	public Chant getChant2() {
		return chant2;
	}
	public void setChant2(Chant chant2) {
		Chant oldValue = this.chant2;
		this.chant2 = chant2;
		firePropertyChange("chant2", oldValue, chant2);
	}
	public Chant getChant3() {
		return chant3;
	}
	public void setChant3(Chant chant3) {
		Chant oldValue = this.chant3;
		this.chant3 = chant3;
		firePropertyChange("chant3", oldValue, chant3);
	}
	public Chant getChant4() {
		return chant4;
	}
	public void setChant4(Chant chant4) {
		Chant oldValue = this.chant4;
		this.chant4 = chant4;
		firePropertyChange("chant4", oldValue, chant4);
	}
	public void setPositionetagere(double positionetagere) {

		double oldValue = this.positionetagere;
		this.positionetagere = positionetagere;
		firePropertyChange("positionetagere", oldValue, positionetagere);
	}
	public double getPositionetagere() {
		return positionetagere;
	}
	public void setPieceH(double pieceH) {

		double oldValue = this.pieceH;
		this.pieceH = pieceH;
		firePropertyChange("pieceH", oldValue, pieceH);
	}
	public double getPieceL() {
		return pieceL;
	}
	public void setPieceL(double pieceL) {

		double oldValue = this.pieceL;
		this.pieceL = pieceL;
		firePropertyChange("pieceL", oldValue, pieceL);
	}
	public double getPieceH() {
		return pieceH;
	}
	public void setMaterial(Materiaux material) {

		Materiaux oldValue = this.material;
		this.material = material;
		firePropertyChange("material", oldValue, material);
	}
	public Materiaux getMaterial() {
		return material;
	}
	public void setPosition(double position) {

		double oldValue = this.position;
		this.position = position;
		firePropertyChange("position", oldValue, position);
	}
//	public double getPosition() {
//		return position;
//	}
	public void setEpaisseur(double epaisseur) {

		double oldValue = this.epaisseur;
		this.epaisseur = epaisseur;
		firePropertyChange("epaisseur", oldValue, epaisseur);
	}
	public double getEpaisseur() {
		return epaisseur;
	}
	public void setPiecetype(PieceType droiteCuisson) {

		PieceType oldValue = this.piecetype;
		this.piecetype = droiteCuisson;
		firePropertyChange("piecetype", oldValue, droiteCuisson);
	}
	public PieceType getPiecetype() {
		return piecetype;
	}
	@Override
	public boolean canHold(DesignObject3D child) {
		// TODO Auto-generated method stub
		if(child instanceof Accessoire || child instanceof Usinage || child instanceof Piece2D)
		{
			return true;
		}
		return false;
	}
	
	public String printDescription()
	{		
		String s="";
		s+=" 		Piece "  + getName() +"\n";
		s+=" 		Type "  + getPiecetype() +"\n";
		/*
		s+=" 		Longeur extenre "  + getLongeurext() +" mm \n";
		s+=" 		Hauteur extenre "  + getHauteurext() +" mm \n";
		s+=" 		Profondeur extenre "  + getProfondeurext() +" mm \n";
		
		s+=" 		Longeur interne "  + getLongeurint() +" mm \n";
		s+=" 		Hauteur interne "  + getHauteurint() +" mm \n";
		s+=" 		Profondeur interne "  + getProfondeurint() +" mm \n";
		*/
		s+=" 		L "  + getPieceL() +"  \n";
		s+=" 		H "  + getPieceH() +"  \n";
		s+=" 		Epaisseur"  + getEpaisseur() +"  \n";
		s+=" 		Matreieaux "  + getMaterial().getName() +"  \n\n";
		s+="		------Les sous elements ------\n";
		System.out.println(s);
		for(DesignObject3D child : getChilds())
		{
			s+=child.printDescription();
		}
		
		return s;
	}
	public Piece2DCoupe createPieceCoupe()
	{
		Piece2DCoupe p = new Piece2DCoupe();
		p.setPieceH(getPieceH());
		p.setPieceL(getPieceL());
		p.setMaterial(getMaterial().getName());
		p.setChants(getChants());
		p.setQty(1);
		
		p.setPiecename(getName());
		
		if (getParentdesign() != null && getParentdesign() instanceof Caisson) {
			p.setParentname(getParentdesign().getName());
			p.setCaissonname(getParentdesign().getName());
			if (getParentdesign().getParentdesign() != null
					&& getParentdesign().getParentdesign() instanceof Dressing) {
				p.setDressingname(getParentdesign().getParentdesign().getName());
				p.setAppartementname(((Dressing)getParentdesign().getParentdesign()).getAppartement());
				p.setEtagename(((Dressing)getParentdesign().getParentdesign()).getEtage());

				if (getParentdesign().getParentdesign().getParentdesign() != null
						&& getParentdesign().getParentdesign().getParentdesign() instanceof Project3D) {
					p.setProjetname(getParentdesign().getParentdesign().getParentdesign().getName());
				}
			}
		}
		if(getParentdesign() != null && getParentdesign() instanceof Space3D &&getParentdesign() != null && getParentdesign().getParentdesign() instanceof Separator) {
			DesignObject3D parent=getParentdesign().getParentdesign();
			while( parent !=null && !(parent instanceof Project3D))
			{	
					if(parent instanceof Space3D&& !(parent instanceof Caisson)&& !(parent instanceof Dressing)) {
						parent =parent.getParentdesign();
					}
					
					if(parent instanceof Dressing) {

						
						p.setDressingname(parent.getName());
						p.setAppartementname(((Dressing)parent).getAppartement());
						p.setEtagename(((Dressing)parent).getEtage());
						parent =parent.getParentdesign();

						}
					if(parent instanceof Caisson) {
						p.setCaissonname(parent.getName());
						p.setParentname(parent.getName());
						parent =parent.getParentdesign();
					}if(parent instanceof Separator) {
						parent =parent.getParentdesign();
						
					}
				
			}	

			if( parent !=null && parent instanceof Project3D) {
				p.setProjetname(parent.getName());
			}
		}
		
		if (getParentdesign() != null && getParentdesign() instanceof Dressing) {
			p.setParentname(getParentdesign().getName());
			p.setDressingname(getParentdesign().getParentdesign().getName());
			//
			p.setEtagename(((Dressing)getParentdesign().getParentdesign()).getEtage());
			p.setAppartementname(((Dressing)getParentdesign().getParentdesign()).getAppartement());
			//
			if (getParentdesign().getParentdesign() != null
					&& getParentdesign().getParentdesign() instanceof Project3D) {
				p.setProjetname(getParentdesign().getParentdesign().getName());
			}
		}

		
		if (getParentdesign() != null && getParentdesign() instanceof Project3D) {
			p.setParentname(getParentdesign().getName());
			p.setProjetname(getParentdesign().getName());
		}
			
		
		return p;
	}
	@Override
	public double getXSize() {
		// TODO Auto-generated method stub
		return getLongeurext();
	}
	@Override
	public double getYSize() {
		// TODO Auto-generated method stub
		return getHauteurext();
	}
	@Override
	public double getZSize() {
		// TODO Auto-generated method stub
		return getProfondeurext();
	}
	@Override
	public BufferedImage getImage() {
		// TODO Auto-generated method stub
		
			String filename = "";
			if(getMaterial().getMotif()!=null) {
				filename="pictures/"+getMaterial().getMotif();
		}else {
			
			if(getPiecetype()==PieceType.BAS_CUISSON || getPiecetype()==PieceType.HAUT_CUISSON)
			{
				filename="pictures/texture1.png";
			}
			else if(getPiecetype()==piecetype.GAUCHE_CUISSON ||  getPiecetype()==piecetype.DROITE_CUISSON)
			{
				filename="pictures/texture1.png";
			}
			else if(getPiecetype()==piecetype.HAUT_CUISSON)
			{
				filename="pictures/texture1.png";
			}	
			else if(getPiecetype()==piecetype.ETAGERE_MOBILE 
					|| getPiecetype()==piecetype.PORTE 
					||  getPiecetype()==piecetype.PORTE_DROITE
					||  getPiecetype()==piecetype.PORTE_HAUT)
			{
				filename="pictures/texture1.png";
			}	
			else if(getPiecetype()==piecetype.ETAGERE_FIXE|| getPiecetype()==piecetype.PORTE_GAUCHE|| getPiecetype()==piecetype.PORTE_BAS )
			{
				filename="pictures/texture1.png";
			}	
			else if(getPiecetype()==piecetype.SEPRATEUR_TRANSVERSANT || getPiecetype()==piecetype.SEPRATEUR_NORMAL)
			{
				filename="pictures/texture1.png";
			}
			else if(getPiecetype()==piecetype.DOS_INTERIEUR ||getPiecetype()==piecetype.DOS_EXTERIRUR)
			{
				filename="pictures/back.jpg";
			}else if(getPiecetype()==piecetype.BAS_TIROIR) {
				filename="pictures/back.jpg";
			}else if(getPiecetype()==piecetype.COTE_DROITE_TIROIR || getPiecetype()==piecetype.COTE_GAUCHE_TIROIR)
			{
				filename="pictures/texture1.png";
			}else if(getPiecetype()==piecetype.DERIERE_TIROIR||getPiecetype()==piecetype.FACADE_EXTERIEUR_TIROIR||getPiecetype()==piecetype.FACADE_INTERIEUR_TIROIR)
			{
				filename="pictures/texture1.png";
			}else {
				filename="pictures/texture1.png";
			}
			
		}
			FileInputStream fis = null;
			BufferedImage bufferedImage = null;
			if(getMaterial().getName().contentEquals("generic")&& getMaterial().getMotif()!=null && !getMaterial().getMotif().isEmpty()) {
				try {
					bufferedImage = ModelProvider.getBufferedImagesHashMap().get(getMaterial().getMotif());
					if(bufferedImage == null) {
						File file=new File(getMaterial().getMotif());
						fis=new FileInputStream(file);
						bufferedImage =  ImageIO.read(fis);
						ModelProvider.getBufferedImagesHashMap().putIfAbsent(getMaterial().getMotif(), bufferedImage);
					}
					
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}finally {
					if(fis != null)
						try {
							fis.close();
						} catch (IOException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					return bufferedImage;
				}
			}else {
				
				try {
					bufferedImage = ModelProvider.getBufferedImagesHashMap().get(filename);
					if(bufferedImage == null) {
						File im= WorkspaceConfiguration.getimage(filename, true);
						if(im == null || !im.exists()) {
							filename = "pictures/royale-blanc-hanstone-slab.jpg";
							bufferedImage = ModelProvider.getBufferedImagesHashMap().get(filename);
							if(bufferedImage != null) {
								return bufferedImage;
							}
							im =  WorkspaceConfiguration.getimage(filename, true);
						}
						fis=new FileInputStream(im);
						bufferedImage =  ImageIO.read(fis);
						ModelProvider.getBufferedImagesHashMap().putIfAbsent(filename, bufferedImage);
						fis.close();
					}
					
				} catch (IOException e) {
					e.printStackTrace();
				} finally {
					if(fis != null)
						try {
							fis.close();
						} catch (IOException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					return bufferedImage;
				}
			}
	}
	@Override
	public boolean isdrawable() {
		// TODO Auto-generated method stub
			return true;		
	}
	@Override
	public double gettransparency() {
		// TODO Auto-generated method stub
		 if(getPiecetype()==PieceType.PORTE || getPiecetype()==PieceType.PORTE_DROITE || getPiecetype()==PieceType.PORTE_GAUCHE
				 || getPiecetype()==PieceType.PORTE_HAUT || getPiecetype()==PieceType.PORTE_BAS)
		 {
			 return 0.1; 
		 }
		return 0;
	}
	@Override
	protected void updateMaterialFromParent(DesignObject3D parent) {
		// TODO Auto-generated method stub
		if(parent!=null)
		{
			if(!isBackmaterialfree())
			{
				setBackmaterial(parent.getBackmaterial());
			}
			if(!isBasematerialfree())
			{
				setBasematerial(parent.getBasematerial());
			}
			if(piecetype.equals(PieceType.DOS_EXTERIRUR) || piecetype.equals(PieceType.DOS_INTERIEUR))
			{
				setMaterial(parent.getBackmaterial());
			}
			else if(getPiecetype().equals(PieceType.PORTE)
					||getPiecetype().equals(PieceType.PORTE_DROITE)
					||getPiecetype().equals(PieceType.PORTE_GAUCHE)) {
				return;
			}
			else 
			{
				setMaterial(parent.getBasematerial());
			}
		}		
			
	}
	@Override
	protected void updateproperties() throws GeometricEngineException {
		// TODO Auto-generated method stub
		super.updateproperties();
		setNotificationon(false);
		Equation eq=null;
		try {
			if(debitage!=null)
			{
				eq  = Equation.FIND_EQUATION("@this.pieceL@", debitage.getEquations());
				if(eq!=null)
				{
					setPieceL(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException("@this.pieceL@ not found to update");
				}
				eq  = Equation.FIND_EQUATION("@this.pieceH@", debitage.getEquations());
				if(eq!=null)
				{
					setPieceH(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException("@this.pieceH@ not found to update");
				}
				eq  = Equation.FIND_EQUATION("@this.e@", debitage.getEquations());
				if(eq!=null)
				{
					setEpaisseur(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException("@this.e@ not found to update");
				}
				eq  = Equation.FIND_EQUATION("@this.chant1@", debitage.getEquations());
				if(eq!=null)
				{
					setLongchant1(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException("@this.chant1@ not found to update");
				}
				eq  = Equation.FIND_EQUATION("@this.chant2@", debitage.getEquations());
				if(eq!=null)
				{
					setLongchant2(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException("@this.chant2@ not found to update");
				}
				eq  = Equation.FIND_EQUATION("@this.chant3@", debitage.getEquations());
				if(eq!=null)
				{
					setLongchant3(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException("@this.chant3@ not found to update");
				}
				eq  = Equation.FIND_EQUATION("@this.chant4@", debitage.getEquations());
				if(eq!=null)
				{
					setLongchant4(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException("@this.chant4@ not found to update");
				}
//				eq  = Equation.FIND_EQUATION("@this.epaisseur1@", debitage.getEquations());
//				if(eq!=null)
//				{
//					getChant1().setEpaisseur(eq.getEvaluation(null));
//				}
//				else
//				{
//					throw new GeometricEngineException("@this.epaisseur1@ not found to update");
//				}
//				eq  = Equation.FIND_EQUATION("@this.epaisseur2@", debitage.getEquations());
//				if(eq!=null)
//				{
//					getChant2().setEpaisseur(eq.getEvaluation(null));
//				}
//				else
//				{
//					throw new GeometricEngineException("@this.epaisseur2@ not found to update");
//				}
//				eq  = Equation.FIND_EQUATION("@this.epaisseur3@", debitage.getEquations());
//				if(eq!=null)
//				{
//					getChant3().setEpaisseur(eq.getEvaluation(null));
//				}
//				else
//				{
//					throw new GeometricEngineException("@this.epaisseur3@ not found to update");
//				}
//				eq  = Equation.FIND_EQUATION("@this.epaisseur4@", debitage.getEquations());
//				if(eq!=null)
//				{
//					getChant4().setEpaisseur(eq.getEvaluation(null));
//				}
//				else
//				{
//					throw new GeometricEngineException("@this.epaisseur4@ not found to update");
//				}
				if(chant1!=null && chant2!=null && chant3!=null && chant4!=null) {
					convertwritablechantstest();
				}
				
			}
		} catch (GeometricEngineException e) {
			// TODO: handle exception
			e.printStackTrace();
			throw e;
		}
		finally {
			setNotificationon(true);
		}
		
	
	}
	public void generateElementsGcode() {
		if(getMaterialType()!=null &&getMaterialType().getMaterial()!=null
				&& getMaterialType().getMaterial().isProduction())
		{
			MachineCodeHandler.getInstance().getGenerator().generateCode(this);
		}
	}


	public void setWizardcreated(boolean b) {
		// TODO Auto-generated method stub
		
	}
	
	public void convertwritablechants()
	{
		double l1=0;
		double l2=0;
		String chant1="";
		String chant2="";
		//
		double ep1=getChant1().getEpaisseur();
		double ep2=getChant2().getEpaisseur();
		if(getChant1().getEpaisseur()==getChant2().getEpaisseur()||getChant2().getEpaisseur()==0) {
			if(getChant2().getEpaisseur()!=getChant3().getEpaisseur()&&getChant3().getEpaisseur()!=0) {
				ep2=getChant3().getEpaisseur();
			}else if(getChant2().getEpaisseur()!=getChant4().getEpaisseur()&&getChant4().getEpaisseur()!=0) {
				ep2=getChant4().getEpaisseur();
			}
		}
		if(ep1==0&& ep2==0) {
			return;
		}else if(ep1==0 && ep2!=0) {
			ep1=ep2;
		}else if(ep2==0 && ep1!=0) {
			ep2=ep1;
		}
		//
		String epaisseur1="";
		String epaisseur2="";
		//
		
		l1=getLongchant1();
		l2=getLongchant2();
		//
		if(l1>l2) {
			chant1="L";
			chant2="l";
		}else {
			chant1="l";
			chant2="L";
		}
		//
		
			if(getChant1().getEpaisseur()==getChant3().getEpaisseur()) {
				if(getChant1().getEpaisseur()==ep1) {
					epaisseur1="2"+chant1;
				}else if(getChant1().getEpaisseur()==ep2) {
					epaisseur2="2"+chant1;
				}
				
			}else {
				if(getChant1().getEpaisseur()==ep1) {
					epaisseur1="1"+chant1;
				}else if(getChant1().getEpaisseur()==ep2) {
					epaisseur2="1"+chant1;
				}
				if(getChant3().getEpaisseur()==ep1) {
					epaisseur1="1"+chant1;
				}else if(getChant3().getEpaisseur()==ep2) {
					epaisseur2="1"+chant1;
				}
			}
			//
			if(getChant2().getEpaisseur()==getChant4().getEpaisseur()) {
				if(getChant2().getEpaisseur()==ep1) {
					epaisseur1+="+2"+chant2;
				}else if(getChant2().getEpaisseur()==ep2) {
					epaisseur2+="+2"+chant2;
				}
				
			}else {
				if(getChant2().getEpaisseur()==ep1) {
					epaisseur1+="+1"+chant2;
				}else if(getChant2().getEpaisseur()==ep2) {
					epaisseur2+="+1"+chant2;
				}
				if(getChant4().getEpaisseur()==ep1) {
					epaisseur1+="+1"+chant2;
				}else if(getChant4().getEpaisseur()==ep2) {
					epaisseur2+="+1"+chant2;
				}
			}
		//
		if(!epaisseur1.isEmpty()) {
			epaisseur1=(int)ep1+"/10("+epaisseur1+")";
		}
		if(!epaisseur2.isEmpty()) {
			epaisseur2=(int)ep2+"/10("+epaisseur2+")";
		}
		//
		if(ep1>ep2) {
			setChants(epaisseur1+ " " +epaisseur2);
		}else {
			setChants(epaisseur2+epaisseur1);
		}
	
	}
	public void convertwritablechantstest()
	{
		double l1=0;
		double l2=0;
		String chant1="";
		String chant2="";
		//
		l1=getLongchant1();
		l2=getLongchant2();
		//
		if(l1>l2) {
			chant1="L";
			chant2="l";
		}else {
			chant1="l";
			chant2="L";
		}
		//
		chants="";
		for(Chant chnt: ModelProvider.getListChant()) {
			String chntChants="";
			String chntChants1="";
			if(getChant1().equals(getChant3()) ) {
				if(getChant1().equals(chnt)) {
					chntChants1="2"+chant1;
				}
				
			}else {
				if(getChant1().equals(chnt)) {
					chntChants1="1"+chant1;
				}
				if(getChant3().equals(chnt)) {
					chntChants1="1"+chant1;
				}
			}
			
			String chntChants2="";
			if(getChant2().equals(getChant4()) ) {
				if(getChant2().equals(chnt)) {
					chntChants2="2"+chant2;
				}
				
			}else {
				if(getChant2().equals(chnt)) {
					chntChants2="1"+chant2;
				}
				if(getChant4().equals(chnt)) {
					chntChants2="1"+chant2;
				}
			}
			//
			if(!chntChants1.isEmpty()&& !chntChants2.isEmpty()) {
				chntChants=chnt.getName()+"("+chntChants1+"+"+chntChants2 +")";
			}else {
				if(!chntChants1.isEmpty()&& chntChants2.isEmpty() ) {
					chntChants=chnt.getName()+"("+chntChants1 +")";
				}else if(!chntChants2.isEmpty()&& chntChants1.isEmpty() ){
					chntChants=chnt.getName()+"("+chntChants2 +")";

				}
			}
			
			//
			if(!chntChants.isEmpty()) {
				chants+=chntChants+" ";
			}
		}
	
	}
	@Override
	public void initafterread() {
		// TODO Auto-generated method stub
		super.initafterread();
		if(getMaterial()!=null) {
			getMaterial().initafterread();
		}
	}
	public void update() throws DesignException, GeometricEngineException {
		
		
		
		propagateUpdateToChildrens(null);
		
	} public String getDXFLineEntetity(PlanUsinage persp )
	 {
		 return getDXFLineEntetity(persp, false);
	 }
	 public String getDXFLineEntetity(PlanUsinage persp ,boolean ishowLateral) {
		 return getDXFLineEntetity(persp, ishowLateral, Rotationangle.angleRotation0, false);
	 }
	 public String getDXFLineEntetity(PlanUsinage persp ,boolean ishowLateral,Rotationangle Rotationangle,boolean isRotatePiece )
	    {
	    	if(isRotatePiece) {
	    		 for(DesignObject3D des : getChilds()) {
	 	        	if(des instanceof Rainure) {
	 	        		Rainure rainure=(Rainure) des;
	 	        		Rotationangle =testerAngleRotation(rainure,persp,Rotationangle);
	 	        		break;
	 	        	}
	 	        	else continue;
	 	        	
	 	        }
	    	}
	       
	    	
	    	Piece2D parentpiece = new Piece2D();
	    	
	    	float width = (float) this.getWidth(persp);
	    	float height=(float) this.getHight(persp);
	    	
	 
	    	String s="";
	        PLineDXFEntity line1 = null;
	        PLineDXFEntity line2 = null;
	        PLineDXFEntity line3 = null;
	        PLineDXFEntity line4 = null;
	        PointDXF origin = new PointDXF(0,0);

	        //ligne 1 
	        PointDXF p1 = origin.getLocation();
	        PointDXF p2 = p1.getLocation();
	        p2.x += width;

	        //ligne2
	        PointDXF p3 = p2.getLocation();
	        p3.y += height;

	        //ligne 3 
	        PointDXF p4 = p1.getLocation();
	        p4.y += height;


	        if (DXF_STATIC_VALUE.USE_POLYLINE == false) {
	            line1 = new PLineDXFEntity(p1, p2);
	            line2 = new PLineDXFEntity(p2, p3);
	            line3 = new PLineDXFEntity(p1, p4);
	            line4 = new PLineDXFEntity(p4, p3);

	            //Create String seintity
	            s += line1.getDXFLineEntetity();
	            s += line2.getDXFLineEntetity();
	            s += line3.getDXFLineEntetity();
	            s += line4.getDXFLineEntetity();
	        }
	        else
	        {
	            PolyLineDXFEntity poly = new PolyLineDXFEntity(true);
	            poly.addVertices(p1);
	            poly.addVertices(p2);
	            poly.addVertices(p3);
	            poly.addVertices(p4);
	            poly.addVertices(p1);
	            
	            	 s +=  poly.getDXFEntity(Rotationangle);
	           
	        }
	        ArrayList<Rainure> listRainure = new ArrayList<Rainure>();
	        
	        
			for (DesignObject3D des : getChilds()) {

				if (des instanceof Trou) {
					Trou tr = (Trou) des;
					if (tr.isSolid(persp)) {
						parentpiece = (Piece2D) tr.getParentdesign();
						s += tr.getDXFLineEntetity(persp, parentpiece, Rotationangle);
					}
					if (tr.isLateral(persp) && ishowLateral) {
						s += tr.getDXFLineEntetityLateral(persp, this, Rotationangle);
					}
					// Imed bug 0001710 ajouter les rainure dans l'exportation dxf
				} else if (des instanceof Rainure) {
					Rainure rn = (Rainure) des;
					if (rn.isSolid(persp)) {
						// le cas assemblerainure true on vas collecter dans la listrainure les rainure
						// de piece et le traiter par la methode getDXFLineEntetityassemble.
						if (ReportingPreferences.getInstance().getProperty("DXF.AssembleRainure", true)) {
							parentpiece = (Piece2D) rn.getParentdesign();
							listRainure.add(rn);
						} else {

							s += rn.getDXFLineEntetity(persp, Rotationangle);
						}
					}
				} else if (des instanceof Cavity) {
					Cavity rn = (Cavity) des;
					if (rn.isSolid(persp)) {
						parentpiece = (Piece2D) rn.getParentdesign();
						s += rn.getDXFLineEntetity(persp, Rotationangle, parentpiece);
					}
				}

			}
	      if (listRainure.size()>0) {
	    	  s+=Rainure.getRainureinstance().getDXFLineEntetityassemble(persp,listRainure,parentpiece,Rotationangle);
	    	  
	      }

	        
	        return s;
	    }
		private Rotationangle testerAngleRotation(Rainure rainure, PlanUsinage persp,Rotationangle angledeRotation) {
			Piece2D parentpiece;
			parentpiece=(Piece2D) rainure.getParentdesign();
			Double largeur =parentpiece.getWidth(persp);
			Double hauteur =parentpiece.getHight(persp);
			PointDXF p =rainure.getOrigin(persp, parentpiece);
			Double X=(double) p.x;
			Double Y=(double) p.y;
				if(angledeRotation.equals(Rotationangle.angleRotation90)) {
				
					if (X>0.5*largeur) {
						return Rotationangle.angleRotationMoin90;
					}else
					{
					return Rotationangle.angleRotation90;
					}
				}
				else {
					if (Y<0.5*hauteur) {
						return Rotationangle.angleRotation180;
					}
					else
					{
					return Rotationangle.angleRotation0;
					}
				}
				
			}
	  
//	    public String getDXFLineEntetity(PlanUsinage persp)
//	    {
//	    	
//	    	float width = (float) this.getWidth(persp);
//	    	float height=(float) this.getHight(persp);
//	    	
//	 
//	    	String s="";
//	        PLineDXFEntity line1 = null;
//	        PLineDXFEntity line2 = null;
//	        PLineDXFEntity line3 = null;
//	        PLineDXFEntity line4 = null;
//	        PointDXF origin = new PointDXF(0,0);
//
//	        //ligne 1 
//	        PointDXF p1 = origin.getLocation();
//	        PointDXF p2 = p1.getLocation();
//	        p2.x += width;
//
//	        //ligne2
//	        PointDXF p3 = p2.getLocation();
//	        p3.y += height;
//
//	        //ligne 3 
//	        PointDXF p4 = p1.getLocation();
//	        p4.y += height;
//
//
//	        if (DXF_STATIC_VALUE.USE_POLYLINE == false) {
//	            line1 = new PLineDXFEntity(p1, p2);
//	            line2 = new PLineDXFEntity(p2, p3);
//	            line3 = new PLineDXFEntity(p1, p4);
//	            line4 = new PLineDXFEntity(p4, p3);
//
//	            //Create String seintity
//	            s += line1.getDXFLineEntetity();
//	            s += line2.getDXFLineEntetity();
//	            s += line3.getDXFLineEntetity();
//	            s += line4.getDXFLineEntetity();
//	        }
//	        else
//	        {
//	            PolyLineDXFEntity poly = new PolyLineDXFEntity(true);
//	            poly.addVertices(p1);
//	            poly.addVertices(p2);
//	            poly.addVertices(p3);
//	            poly.addVertices(p4);
//	            poly.addVertices(p1);
//	            s +=  poly.getDXFEntity();
//	        }
//	        
//	        for(DesignObject3D des : getChilds())
//	        {
//	        	if(des instanceof Trou)
//	        	{
//	        		Trou tr = (Trou) des;	
//	        		if(tr.isSolid(persp)) {
//		    	        s += tr.getDXFLineEntetity(persp,this);
//	        		}
//	    	      //Imed bug 0001710 ajouter les rainure dans l'exportation dxf
//	        	}else if(des instanceof Rainure) {
//	        		Rainure rn=(Rainure) des;
//	        		if(rn.isSolid(persp)) {
//	        			s+=rn.getDXFLineEntetity(persp);
//	        		}
//	        	}else if(des instanceof Cavity) {
//	        		Cavity rn=(Cavity) des;
//	        		if(rn.isSolid(persp)) {
//	        			s+=rn.getDXFLineEntetity(persp);
//	        		}
//	        	}
//	        }
//	      
//
//	        
//	        return s;
	  //  }

	public double getWidth(PlanUsinage pl) {
		// TODO Auto-generated method stub
		float width = 50;
		float height = 50;
		switch (pl) {
		case FRONT:
			width = (float) this.getLongeurext();
			height = (float) this.getHauteurext();
			break;
		case BACK:
			width = (float) this.getLongeurext();
			height = (float) this.getHauteurext();
			break;

		case RIGHT:
			width = (float) this.getProfondeurext();
			height = (float) this.getHauteurext();
			break;
		case LEFT:
			width = (float) this.getProfondeurext();
			height = (float) this.getHauteurext();
			break;
		case DOWN:
			width = (float) this.getLongeurext();
			height = (float) this.getProfondeurext();
			break;
		case TOP:
			width = (float) this.getLongeurext();
			height = (float) this.getProfondeurext();
			break;
		default:
			break;
		}
		return width;
	}

	public double getHight(PlanUsinage pl) {
		// TODO Auto-generated method stub
		// TODO Auto-generated method stub
		float width = 0;
		float height = 0;
		switch (pl) {
		case FRONT:
			width = (float) this.getLongeurext();
			height = (float) this.getHauteurext();
			break;
		case BACK:
			width = (float) this.getLongeurext();
			height = (float) this.getHauteurext();
			break;

		case RIGHT:
			width = (float) this.getProfondeurext();
			height = (float) this.getHauteurext();
			break;
		case LEFT:
			width = (float) this.getProfondeurext();
			height = (float) this.getHauteurext();
			break;
		case DOWN:
			width = (float) this.getLongeurext();
			height = (float) this.getProfondeurext();
			break;
		case TOP:
			width = (float) this.getLongeurext();
			height = (float) this.getProfondeurext();
			break;
		default:
			break;
		}

		return height;
	}

	/***
	 * Cette methode retourne le point par rapport au repore 2D
	 * @return
	 */
	public Point3D getConvertedPointIn2D(PlanUsinage persp)
	{
		Point3D p = new Point3D();
		switch (persp) {
		case FRONT:
			p.x = this.getXPosABS();
			p.y = - this.getYPosABS() - this.getHauteurext();
			p.z=0;
			break;

		default:
			
			break;
		}
		return p; 
		
		
	}
	
	@Override
	public void deleteUsinage() throws GeometricEngineException, DesignException {
		List<DesignObject3D>childstobeDeleted =new ArrayList<DesignObject3D>();
		List<DesignObject3D> babiestobeDeleted =new ArrayList<DesignObject3D>();
		
		//collecter les usinage qui référence sur cette piece comme parent 	
		for(DesignObject3D design:getChilds()) {
			
			if((design instanceof Usinage)|| (design instanceof Accessoire)) {
				childstobeDeleted.add(design);
			}
		}
		//collecter les usinage qui référence sur cette piece comme mother 
		if(getBabies()!=null) {
			for(DesignObject3D design:getBabies()) {
				
				if((design instanceof Usinage)|| (design instanceof Accessoire)) {
					babiestobeDeleted.add(design);
				}
			}	
		}
				
		//supprimer tout les usinage qui référence sur cette piece comme parent 	
		for(DesignObject3D design:childstobeDeleted) {	
			
			deletechild(design);
		}
		//supprimer tout les usinage qui référence sur cette piece comme mother 
		for(DesignObject3D design:babiestobeDeleted) {	
			
			removeBaby(design);
		}
		super.deleteUsinage();
	}
	@Override
	public void createUsinage() throws GeometricEngineException, DesignException {
		//	0001217: ajouter le calcul des rainure et les trous d'usinage
		//défalquer le calcul des trous pour que chaque type de trous calculer avec sa logique indépendament des autre
		//et puis le code soit lisible
		Space3D rootcaisson= (Space3D) getRootCaisson();
		if(rootcaisson instanceof CaissonCuisine) {
			CaissonCuisine caisson=(CaissonCuisine) rootcaisson;
			if(caisson.getCaissoncuisineType().equals(CuisineCaissonType.haut)) {
				createHautUsinageTrous();	
			}else {
				createBasUsinageTrous();
			}
		}else {
			createBasUsinageTrous();
		}

		createPersageTrous();
		createCharnieres();
		createCaissonBasSupportMeuble();
		createCaissonHautSupportMeuble();
		createSupportPorteBoteille();
		if(this instanceof Separator) {
			super.createUsinage();
		}
		createRairures();
		createBlocTiroirUsinage();
	}
	
	public void createBlocTiroirUsinage() throws DesignException, GeometricEngineException {
		Caisson caisson = (Caisson) getRootCaisson();
		if(caisson instanceof CaissonCuisine) {
			CaissonCuisine caissoncuisine=(CaissonCuisine)caisson;
			CuisineCaissonType type=caissoncuisine.getCaissoncuisineType();
			if(type.equals(CuisineCaissonType.Bloc_Tiroir)) {
				if(getPiecetype().equals(PieceType.DROITE_CUISSON)||getPiecetype().equals(PieceType.GAUCHE_CUISSON)) {
					List<Tirroir> tiroirs =new ArrayList<Tirroir>();
					for(DesignObject3D child:caissoncuisine.getChilds()) {
						if(child instanceof Tirroir) {
							tiroirs.add((Tirroir) child);
						}
					}
					for(Tirroir tr:tiroirs) {
						SupportBlocTiroir support1=new SupportBlocTiroir();
						if(getPiecetype().equals(PieceType.DROITE_CUISSON)) {
							support1.setDirection(Direction.XPLUS);
			
						}else if(getPiecetype().equals(PieceType.GAUCHE_CUISSON)) {
							support1.setDirection(Direction.XMINUS);
			
						}
						support1.setSupportType(tr.getTiroirType());
						
						support1.setName("Support "+tr.getName());
						
						support1.setParentdesign(this);
						
						support1.setMother(tr);
						
						support1.constructDebitage();
						support1.evaluate();
						
						addElement(support1);
						support1.createUsinage();
						
					}
					
					
				}
			}
		}
				
	}
	
	/**
	 * @author Imed 
	 * @Bug 0001217
	 * construction de les trous d'unisage entre les piece de la méme caisson 
	 * et puisque ce type de trous et le resultat de relation de tangente entre deux piece 
	 * et chercher ces piece et les parcourir pour deduire le caractéristiques des trous à créer 
	 * et en se basant sur la relation entre les deux dans l'espace 3D
	 * Direction: deduisé a partir de le plan d'intertion entre les deux pieces et avec le postion de la piece actuelle sur cette axe de tangente  
	 * father and mother types ( ParentType) pour deduire avec laquel regle en soit calculer , simplement dequisé de le type du parent si bande ou simple piece
	 * ParentDirection : pour deduire l'axe de calcul entre les diffent trous dans la branche de famille 
	 * et deduisé apartir la comparison entre les deux axe de plan d'intersection autre que l'axe d'intersection
	 * @throws DesignException
	 * @throws GeometricEngineException
	 */
	public void createHautUsinageTrous() throws DesignException, GeometricEngineException {
		if(!getPiecetype().equals(PieceType.DOS_EXTERIRUR)
				&&!getPiecetype().equals(PieceType.DOS_INTERIEUR)
				&&!getPiecetype().equals(PieceType.ETAGERE_MOBILE)
				&&!getPiecetype().equals(PieceType.PORTE)
				&&!getPiecetype().equals(PieceType.PORTE_DROITE)
				&&!getPiecetype().equals(PieceType.PORTE_GAUCHE)
				&&!getPiecetype().equals(PieceType.PORTE_BAS)
				&&!getPiecetype().equals(PieceType.PORTE_HAUT)) {
			List<Piece2D> tangentedPieces=gettangentedPieces(this, getRootCaisson());
			for(Piece2D frere:tangentedPieces) {
				if(!frere.getPiecetype().equals(PieceType.DOS_EXTERIRUR)
						&&!frere.getPiecetype().equals(PieceType.DOS_INTERIEUR)
						&&!frere.getPiecetype().equals(PieceType.ETAGERE_MOBILE)
						&&!frere.getPiecetype().equals(PieceType.PORTE)
						&&!frere.getPiecetype().equals(PieceType.PORTE_DROITE)
						&&!frere.getPiecetype().equals(PieceType.PORTE_GAUCHE)
						&&!frere.getPiecetype().equals(PieceType.PORTE_BAS)
						&&!frere.getPiecetype().equals(PieceType.PORTE_HAUT)) {
					
				Plan3D inter = getIntersect(frere);
				Direction dir=Direction.XMINUS;
				//create trous
				Trou tr1=new Trou(dir);
				Trou tr2=new Trou(dir);
				//set trous types
				tr1.setTrouType(TrouType.USINGAGE_BACK);
				tr2.setTrouType(TrouType.USINGAGE_FRONT);
				tr1.setName(getName()+" Trou usinage arière "+frere.getName() );
				tr2.setName(getName()+" Trou usinage avant "+frere.getName());

				//set father and mother types
				if(this instanceof Bande) {
					tr1.setFatherType(ParentType.BANDE);
					tr2.setFatherType(ParentType.BANDE);
				}else {
					tr1.setFatherType(ParentType.PIECE);
					tr2.setFatherType(ParentType.PIECE);
				}
				if(frere instanceof Bande) {
					tr1.setMotherType(ParentType.BANDE);
					tr2.setMotherType(ParentType.BANDE);
				}else {
					tr1.setMotherType(ParentType.PIECE);
					tr2.setMotherType(ParentType.PIECE);
				}
				//set father and mother
				tr1.setParentdesign(this);
				tr1.setMother(frere);
				tr2.setParentdesign(this);
				tr2.setMother(frere);
				
				//Compute trous direction and parent direction to conclude witch axe will move and be different from trou to trou 
				//witch mean if we conclude that the direction is on X and its XPLUS for exemple we may conclude the xposition for this trou is 0 relatively to its parent and if its Xminus then the xposition for this trou is its parent length
				//
				if(	inter.getXinter().isPoint()) {
					double ylong=inter.getYinter().getlong();
					double zlong=inter.getZinter().getlong();
					if(getXPosABS()<inter.getXinter().getMininter()) {
						dir=Direction.XMINUS;
					}else {
						dir=Direction.XPLUS;
					}
					tr1.setDirection(dir);
					tr2.setDirection(dir);
					if(ylong >zlong) {
						tr1.setParentDirection(ParentDirection.Y);
						tr2.setParentDirection(ParentDirection.Y);
					}else {
						tr1.setParentDirection(ParentDirection.Z);
						tr2.setParentDirection(ParentDirection.Z);
					}
					
				}else if(inter.getYinter().isPoint()) {
					double xlong=inter.getXinter().getlong();
					double zlong=inter.getZinter().getlong();
					if(getYPosABS()<inter.getYinter().getMininter()) {
						dir=Direction.YMINUS;
					}else {
						dir=Direction.YPLUS;
					}
					tr1.setDirection(dir);
					tr2.setDirection(dir);
					if(xlong >zlong) {
						tr1.setParentDirection(ParentDirection.X);
						tr2.setParentDirection(ParentDirection.X);
					}else {
						tr1.setParentDirection(ParentDirection.Z);
						tr2.setParentDirection(ParentDirection.Z);
					}
				}else if(inter.getZinter().isPoint()) {
					double xlong=inter.getXinter().getlong();
					double ylong=inter.getYinter().getlong();
					if(getZPosABS()<inter.getZinter().getMininter()) {
						dir=Direction.ZMINUS;
					}else {
						dir=Direction.ZPLUS;
					}
					tr1.setDirection(dir);
					tr2.setDirection(dir);
					if(ylong >xlong) {
						tr1.setParentDirection(ParentDirection.Y);
						tr2.setParentDirection(ParentDirection.Y);	
					}else {
						tr1.setParentDirection(ParentDirection.Z);
						tr2.setParentDirection(ParentDirection.Z);
						
					}
				}
				
				tr1.constructDebitage();
				tr1.evaluate();
				tr2.constructDebitage();
				tr2.evaluate();
				
				addElement(tr1);
				addElement(tr2);

			}
			}

		}
	}
	/**
	 * @author Imed 
	 * @Bug 0001217
	 * construction de les trous d'unisage entre les piece de la méme caisson 
	 * et puisque ce type de trous et le resultat de relation de tangente entre deux piece 
	 * et chercher ces piece et les parcourir pour deduire le caractéristiques des trous à créer 
	 * et en se basant sur la relation entre les deux dans l'espace 3D
	 * Direction: deduisé a partir de le plan d'intertion entre les deux pieces et avec le postion de la piece actuelle sur cette axe de tangente  
	 * father and mother types ( ParentType) pour deduire avec laquel regle en soit calculer , simplement dequisé de le type du parent si bande ou simple piece
	 * ParentDirection : pour deduire l'axe de calcul entre les diffent trous dans la branche de famille 
	 * et deduisé apartir la comparison entre les deux axe de plan d'intersection autre que l'axe d'intersection
	 * @throws DesignException
	 * @throws GeometricEngineException
	 */
	public void createBasUsinageTrous() throws DesignException, GeometricEngineException {
		if(!getPiecetype().equals(PieceType.DOS_EXTERIRUR)
				&&!getPiecetype().equals(PieceType.DOS_INTERIEUR)
				&&!getPiecetype().equals(PieceType.ETAGERE_MOBILE)
				&&!getPiecetype().equals(PieceType.PORTE)
				&&!getPiecetype().equals(PieceType.PORTE_DROITE)
				&&!getPiecetype().equals(PieceType.PORTE_GAUCHE)
				&&!getPiecetype().equals(PieceType.PORTE_BAS)
				&&!getPiecetype().equals(PieceType.PORTE_HAUT)
				&&!getPiecetype().equals(PieceType.BAS_TIROIR)
				&&!getPiecetype().equals(PieceType.DERIERE_TIROIR)
				&&!getPiecetype().equals(PieceType.FACADE_EXTERIEUR_TIROIR)
				&&!getPiecetype().equals(PieceType.FACADE_INTERIEUR_TIROIR)) {
			List<Piece2D> tangentedPieces=gettangentedPieces(this, getRootCaisson());
			for(Piece2D frere:tangentedPieces) {
				if(!frere.getPiecetype().equals(PieceType.DOS_EXTERIRUR)
						&&!frere.getPiecetype().equals(PieceType.DOS_INTERIEUR)
						&&!frere.getPiecetype().equals(PieceType.ETAGERE_MOBILE)
						&&!frere.getPiecetype().equals(PieceType.PORTE)
						&&!frere.getPiecetype().equals(PieceType.PORTE_DROITE)
						&&!frere.getPiecetype().equals(PieceType.PORTE_GAUCHE)
						&&!frere.getPiecetype().equals(PieceType.PORTE_BAS)
						&&!frere.getPiecetype().equals(PieceType.PORTE_HAUT)
						&&!frere.getPiecetype().equals(PieceType.BAS_TIROIR)
						&&!frere.getPiecetype().equals(PieceType.DERIERE_TIROIR)
						&&!frere.getPiecetype().equals(PieceType.FACADE_EXTERIEUR_TIROIR)
						&&!frere.getPiecetype().equals(PieceType.FACADE_INTERIEUR_TIROIR)) {
					
				Plan3D inter = getIntersect(frere);
				Direction dir=Direction.XMINUS;
				//create trous
				Trou tr1=new Trou(dir);
				Trou tr2=new Trou(dir);
				Trou tr3=new Trou(dir);

				//set trous types
				tr1.setTrouType(TrouType.USINGAGE_BACK);
				tr2.setTrouType(TrouType.USINGAGE_FRONT);
				tr3.setTrouType(TrouType.USINGAGE_MIDDLE);

				tr1.setName(getName()+" Trou usinage arière "+frere.getName() );
				tr2.setName(getName()+" Trou usinage avant "+frere.getName());
				tr3.setName(getName()+" Trou usinage melieu "+frere.getName());

				//set father and mother types
				if(this instanceof Bande) {
					tr1.setFatherType(ParentType.BANDE);
					tr2.setFatherType(ParentType.BANDE);
					tr3.setFatherType(ParentType.BANDE);

				}else {
					tr1.setFatherType(ParentType.PIECE);
					tr2.setFatherType(ParentType.PIECE);
					tr3.setFatherType(ParentType.PIECE);

				}
				if(frere instanceof Bande) {
					tr1.setMotherType(ParentType.BANDE);
					tr2.setMotherType(ParentType.BANDE);
					tr3.setMotherType(ParentType.BANDE);

				}else {
					tr1.setMotherType(ParentType.PIECE);
					tr2.setMotherType(ParentType.PIECE);
					tr3.setMotherType(ParentType.PIECE);

				}
				//set father and mother
				tr1.setParentdesign(this);
				tr1.setMother(frere);
				tr2.setParentdesign(this);
				tr2.setMother(frere);
				tr3.setParentdesign(this);
				tr3.setMother(frere);
				
				//Compute trous direction and parent direction to conclude witch axe will move and be different from trou to trou 
				//witch mean if we conclude that the direction is on X and its XPLUS for exemple we may conclude the xposition for this trou is 0 relatively to its parent and if its Xminus then the xposition for this trou is its parent length
				//
				if(	inter.getXinter().isPoint()) {
					double ylong=inter.getYinter().getlong();
					double zlong=inter.getZinter().getlong();
					if(getXPosABS()<inter.getXinter().getMininter()) {
						dir=Direction.XMINUS;
					}else {
						dir=Direction.XPLUS;
					}
					tr1.setDirection(dir);
					tr2.setDirection(dir);
					tr3.setDirection(dir);

					if(ylong >zlong) {
						tr1.setParentDirection(ParentDirection.Y);
						tr2.setParentDirection(ParentDirection.Y);						
						tr3.setParentDirection(ParentDirection.Y);
					}else {
						tr1.setParentDirection(ParentDirection.Z);
						tr2.setParentDirection(ParentDirection.Z);
						tr3.setParentDirection(ParentDirection.Z);

					}
					
				}else if(inter.getYinter().isPoint()) {
					double xlong=inter.getXinter().getlong();
					double zlong=inter.getZinter().getlong();
					if(getYPosABS()<inter.getYinter().getMininter()) {
						dir=Direction.YMINUS;
					}else {
						dir=Direction.YPLUS;
					}
					tr1.setDirection(dir);
					tr2.setDirection(dir);
					tr3.setDirection(dir);

					if(xlong >zlong) {
						tr1.setParentDirection(ParentDirection.X);
						tr2.setParentDirection(ParentDirection.X);
						tr3.setParentDirection(ParentDirection.X);

					}else {
						tr1.setParentDirection(ParentDirection.Z);
						tr2.setParentDirection(ParentDirection.Z);
						tr3.setParentDirection(ParentDirection.Z);

					}
				}else if(inter.getZinter().isPoint()) {
					double xlong=inter.getXinter().getlong();
					double ylong=inter.getYinter().getlong();
					if(getZPosABS()<inter.getZinter().getMininter()) {
						dir=Direction.ZMINUS;
					}else {
						dir=Direction.ZPLUS;
					}
					tr1.setDirection(dir);
					tr2.setDirection(dir);
					tr3.setDirection(dir);

					if(ylong >xlong) {
						tr1.setParentDirection(ParentDirection.Y);
						tr2.setParentDirection(ParentDirection.Y);	
						tr3.setParentDirection(ParentDirection.Y);	

					}else {
						tr1.setParentDirection(ParentDirection.Z);
						tr2.setParentDirection(ParentDirection.Z);
						tr3.setParentDirection(ParentDirection.Z);

					}
				}
				
				tr1.constructDebitage();
				tr1.evaluate();
				tr2.constructDebitage();
				tr2.evaluate();				
				addElement(tr1);
				addElement(tr2);
				if(tr3.getMotherType().equals(ParentType.PIECE)&&tr3.getFatherType().equals(ParentType.PIECE)) {
					tr3.constructDebitage();
					tr3.evaluate();
					addElement(tr3);

				}
			}
			}

		}
	}
	//0001217: ajouter le calcul des rainure et les trous d'usinage
	//créer les trous d'usinage statiquement , mathimatiquement avec la relation entre piece dans l'espace,
	//et pour le moment ce méthode obsolete
	public void createMathUsinageTrous() throws DesignException, GeometricEngineException {
		if(!getPiecetype().equals(PieceType.DOS_EXTERIRUR)
				&&!getPiecetype().equals(PieceType.SEPRATEUR_NORMAL)
				&&!getPiecetype().equals(PieceType.SEPRATEUR_TRANSVERSANT)) {
			
			List<Piece2D> tangentedPieces=gettangentedPieces(this, getRootCaisson());
			List<Trou> piecetrous=new ArrayList<Trou>();
			for(Piece2D frere:tangentedPieces) {
				Plan3D inter = getIntersect(frere);
				Direction dir=Direction.XMINUS;
				
				if(	inter.getXinter().isPoint()) {
					double posx=inter.getXinter().getMininter();
					double posy=inter.getYinter().getMininter();
					double posz=inter.getZinter().getMininter();
					double ylong=inter.getYinter().getlong();
					double zlong=inter.getZinter().getlong();
					if(getXPosABS()<inter.getXinter().getMininter()) {
						dir=Direction.XMINUS;
					}else {
						dir=Direction.XPLUS;
					}
					if(ylong >zlong) {
						
						double step=ylong/4;
						double start=ylong/8;
						Trou tr=new Trou(dir);
						tr.setXcenter(posx);
						tr.setYcenter(start);
						tr.setZcenter(posz+zlong/2);
						piecetrous.add(tr);
						for(int i=0;i<3;i++) {
							Trou tr1=tr.clone();
							tr1.setYcenter(start+((i+1)*step));
							piecetrous.add(tr1);
						}
					}else {
						double step=zlong/4;
						double start=zlong/8;
						Trou tr=new Trou(dir);
						
						tr.setXcenter(posx);
						tr.setYcenter(posy + ylong/2);
						tr.setZcenter(start);
						piecetrous.add(tr);
						for(int i=0;i<3;i++) {
							Trou tr1=tr.clone();
							tr1.setZcenter(start+((i+1)*step));
							piecetrous.add(tr1);
						}
					}
				}else if(inter.getYinter().isPoint()) {
					double posx=inter.getXinter().getMininter();
					double posy=inter.getYinter().getMininter();
					double posz=inter.getZinter().getMininter();
					double xlong=inter.getXinter().getlong();
					double zlong=inter.getZinter().getlong();
					if(getYPosABS()<inter.getYinter().getMininter()) {
						dir=Direction.YMINUS;
					}else {
						dir=Direction.YPLUS;
					}
					if(xlong >zlong) {
						double step=xlong/4;
						double start=xlong/8;
						Trou tr=new Trou(dir);
						
						tr.setXcenter(start);
						tr.setYcenter(posy);
						tr.setZcenter(posz+zlong/2);
						piecetrous.add(tr);
						
						for(int i=0;i<3;i++) {
							Trou tr1=tr.clone();
							tr1.setXcenter(start+((i+1)*step));
							piecetrous.add(tr1);
						}
					}else {
						double step=zlong/4;
						double start=zlong/8;
						Trou tr=new Trou(dir);						

						tr.setXcenter(posx + xlong/2);
						tr.setYcenter(posy);
						tr.setZcenter(start);
						piecetrous.add(tr);
						for(int i=0;i<3;i++) {
							Trou tr1=tr.clone();
							tr1.setZcenter(start+((i+1)*step));
							piecetrous.add(tr1);
						}	
					}
				}else if(inter.getZinter().isPoint()) {
					double posx=inter.getXinter().getMininter();
					double posy=inter.getYinter().getMininter();
					double posz=inter.getZinter().getMininter();
					double xlong=inter.getXinter().getlong();
					double ylong=inter.getYinter().getlong();
					if(getZPosABS()<inter.getZinter().getMininter()) {
						dir=Direction.ZMINUS;
					}else {
						dir=Direction.ZPLUS;
					}
					if(ylong >xlong) {
						double step=ylong/4;
						double start=ylong/8;
						Trou tr=new Trou(dir);
						
						tr.setXcenter(posx + xlong/2);
						tr.setYcenter(start);
						tr.setZcenter(posz);
						piecetrous.add(tr);
						
						for(int i=0;i<3;i++) {
							Trou tr1=tr.clone();
							tr1.setYcenter(start+((i+1)*step));
							piecetrous.add(tr1);
						}
					}else {
						double step=xlong/4;
						double start=xlong/8;
						Trou tr=new Trou(dir);
						

						tr.setXcenter(start);
						tr.setYcenter(posy + ylong/2);
						tr.setZcenter(posz);
						piecetrous.add(tr);
						for(int i=0;i<3;i++) {
							Trou tr1=tr.clone();
							tr1.setXcenter(start+((i+1)*step));
							piecetrous.add(tr1);
						}	
					}
				}
					
					
			}
			int i=0;
			for(Trou tr:piecetrous) {
				tr.setName(getName()+" Trou "+i);
					tr.setXcenter(tr.getXcenter()-getXPosABS());
					tr.setYcenter(tr.getYcenter()-getYPosABS());
					tr.setZcenter(tr.getZcenter()-getZPosABS());
					tr.setTrouType(TrouType.USINGAGE);
					if(!getPiecetype().equals(PieceType.DOS_INTERIEUR)) {
						addElement(tr);
					}
					if(debitage!=null)
						debitage.createupdateDebitage();
					else
						constructDebitage();
					
					evaluate();	
					propagateUpdateToChildrens(null);

				i++;
			}
		}
	}
	
	/**
	 * @author Imed 
	 * @bug 0001217 
	 * génèrer de trous de persage sur les côté, qui vas faire le rôle de laison entre les caisson 
	 * @throws DesignException
	 * @throws GeometricEngineException
	 */
	public void createPersageTrous() throws DesignException, GeometricEngineException {
		if(getPiecetype().equals(PieceType.GAUCHE_CUISSON)) {
			Trou tr1=new Trou(Direction.XMINUS);
			tr1.setTrouType(TrouType.PERSAGE_HAUT);
			Trou tr2 =new Trou(Direction.XMINUS);
			tr2.setTrouType(TrouType.PERSAGE_BAS);
			tr1.setName(" Trou 1 persage haut");
			tr2.setName(" Trou 2 persage bas");

			addElement(tr1);
			addElement(tr2);

			if(debitage!=null)
				debitage.createupdateDebitage();
			else
				constructDebitage();
			
			evaluate();	
			propagateUpdateToChildrens(null);
		}
		if(getPiecetype().equals(PieceType.DROITE_CUISSON)) {
			Trou tr1=new Trou(Direction.XPLUS);
			tr1.setTrouType(TrouType.PERSAGE_HAUT);
			Trou tr2 =new Trou(Direction.XPLUS);
			tr2.setTrouType(TrouType.PERSAGE_BAS);
			tr1.setName(" Trou 1 persage haut");
			tr2.setName(" Trou 2 persage bas");

			addElement(tr1);
			addElement(tr2);

			if(debitage!=null)
				debitage.createupdateDebitage();
			else
				constructDebitage();
			
			evaluate();	
			propagateUpdateToChildrens(null);
		}
	}
	
	/**
	 * créate les charniére des facades et ces trous sur les coté parent en particulier le piece courant
	 * @throws DesignException
	 * @throws GeometricEngineException
	 */
	public void createCharnieres() throws DesignException, GeometricEngineException {
		Caisson caisson= (Caisson) getRootCaisson();

		if(caisson instanceof CaissonCuisine) {
			CaissonCuisine caissoncuisine=(CaissonCuisine)caisson;
			CuisineCaissonType type=caissoncuisine.getCaissoncuisineType();
			if(type.equals(CuisineCaissonType.Bas)
					||type.equals(CuisineCaissonType.Bas_sousevier)
					||type.equals(CuisineCaissonType.haut)) {
			
				if(getPiecetype().equals(PieceType.DROITE_CUISSON) || getPiecetype().equals(PieceType.GAUCHE_CUISSON)) {
					Charniere ch1=new Charniere();
					Charniere ch2=new Charniere();
					if(getPiecetype().equals(PieceType.DROITE_CUISSON)) {
						ch1.setDirection(Direction.XPLUS);
						ch2.setDirection(Direction.XPLUS);
		
					}else if(getPiecetype().equals(PieceType.GAUCHE_CUISSON)) {
						ch1.setDirection(Direction.XMINUS);
						ch2.setDirection(Direction.XMINUS);
		
					}
					ch1.setCharniereType(CharniereType.BAS);
					ch2.setCharniereType(CharniereType.HAUT);
					
					ch1.setName("charniere bas "+getName());
					ch2.setName("charniere haut "+getName());
					
					ch1.setCalculAuto(true);
					ch2.setCalculAuto(true);
					
					ch1.setParentdesign(this);
					ch2.setParentdesign(this);
					ch1.constructDebitage();
					ch1.evaluate();
					ch2.constructDebitage();
					ch2.evaluate();
					
					addElement(ch1);
					addElement(ch2);
					ch1.createUsinage();
					ch2.createUsinage();
			
//					if(caisson instanceof CaissonCuisine) {
//						CaissonCuisine caissoncuisine=(CaissonCuisine)caisson;
//						if(caissoncuisine.getCaissoncuisineType().equals(CuisineCaissonType.colonne)) {
//							Charniere ch3=new Charniere();
//							if(getPiecetype().equals(PieceType.DROITE_CUISSON)) {
//								ch3.setDierection(Direction.XPLUS);
//		
//							}else if(getPiecetype().equals(PieceType.GAUCHE_CUISSON)) {
//								ch3.setDierection(Direction.XMINUS);
//		
//							}
//							ch3.setCharniereType(CharniereType.MILIEU);
//							ch3.setName("charniere milieu "+getName());
//		
//							ch3.setParentdesign(this);
//							
//							ch3.constructDebitage();
//							ch3.evaluate();
//							
//							addElement(ch3);
//							ch3.createUsinage();
//						}
//					}
				}
			}
		}
	}
	/**
	 * @author Imed 
	 * @Bug 0001866
	 * Créer les support bas pour les caisson bas 
	 * @throws DesignException
	 * @throws GeometricEngineException
	 */
	public void createCaissonBasSupportMeuble() throws DesignException, GeometricEngineException {
		if (getPiecetype().equals(PieceType.BAS_CUISSON) || getPiecetype().equals(PieceType.BAS_CUISSON_SOUSEVIER)) {
			
			if (getRootCaisson() instanceof CaissonCuisine) {
				
				CaissonCuisine caisson = (CaissonCuisine) getRootCaisson();
				
				if (caisson.getCaissoncuisineType().equals(CuisineCaissonType.Bas)
						|| caisson.getCaissoncuisineType().equals(CuisineCaissonType.Bas_sousevier)
						|| caisson.getCaissoncuisineType().equals(CuisineCaissonType.colonne)
						|| caisson.getCaissoncuisineType().equals(CuisineCaissonType.Bas_four)) {

					SupportMeubleBas s1 = new SupportMeubleBas();
					SupportMeubleBas s2 = new SupportMeubleBas();
					SupportMeubleBas s3 = new SupportMeubleBas();
					SupportMeubleBas s4 = new SupportMeubleBas();

					s1.setSupportType(SupportMeubleBasType.BACK_LEFT);
					s2.setSupportType(SupportMeubleBasType.BACK_RIGHT);
					s3.setSupportType(SupportMeubleBasType.FRONT_LEFT);
					s4.setSupportType(SupportMeubleBasType.FRONT_RIGHT);

					s1.setName("support meuble bas 1 " + getName());
					s2.setName("support meuble bas 2 " + getName());
					s3.setName("support meuble bas 3 " + getName());
					s4.setName("support meuble bas 4 " + getName());

					s1.setParentdesign(this);
					s2.setParentdesign(this);
					s3.setParentdesign(this);
					s4.setParentdesign(this);

					s1.constructDebitage();
					s1.evaluate();

					s2.constructDebitage();
					s2.evaluate();

					s3.constructDebitage();
					s3.evaluate();

					s4.constructDebitage();
					s4.evaluate();

					addElement(s1);
					addElement(s2);
					addElement(s3);
					addElement(s4);

					s1.createUsinage();
					s2.createUsinage();
					s3.createUsinage();
					s4.createUsinage();
				}
			}
		}
	}
	/**
	 * @author Imed 
	 * @Bug 0001866
	 * Créer les supports haut de fixation  pour les caisson haut
	 * @throws DesignException
	 * @throws GeometricEngineException
	 */
	public void createCaissonHautSupportMeuble() throws DesignException, GeometricEngineException {
		if (getPiecetype().equals(PieceType.DOS_INTERIEUR) || getPiecetype().equals(PieceType.DOS_EXTERIRUR)) {
			
			if (getRootCaisson() instanceof CaissonCuisine) {
				
				CaissonCuisine caisson = (CaissonCuisine) getRootCaisson();
				
				if (caisson.getCaissoncuisineType().equals(CuisineCaissonType.haut)) {
					DesignObject3D parent=getParentdesign();
					
					if(parent instanceof Space3D && !(parent instanceof CaissonCuisine)
							&&((Space3D)parent).getZonetype().equals(Zone3DType.ZONEBAS))
					{
						return;
					}
					SupportMeubleHaut s1 = new SupportMeubleHaut();
					SupportMeubleHaut s2 = new SupportMeubleHaut();

					s1.setSupportType(SupportMeubleHautType.LEFT);
					s2.setSupportType(SupportMeubleHautType.RIGHT);
				

					s1.setName("support meuble haut gauche " + getName());
					s2.setName("support meuble haut droite " + getName());

					s1.setParentdesign(this);
					s2.setParentdesign(this);

					s1.constructDebitage();
					s1.evaluate();

					s2.constructDebitage();
					s2.evaluate();

					addElement(s1);
					addElement(s2);

					s1.createUsinage();
					s2.createUsinage();

				}
			}
		}
	}
	public void createRairures() throws DesignException, GeometricEngineException {
		if(getPiecetype().equals(PieceType.DOS_INTERIEUR)) {
			List<Piece2D> intesectedPiece=getIntersectedPieces(this, getRootCaisson());
			for(Piece2D piece:intesectedPiece) {
				
				if (!((Piece2D) piece).getPiecetype().equals(PieceType.DOS_INTERIEUR)) {
					Rainure rainure = new Rainure();
					rainure.setName(piece.getName() + " Rainure");
					
					rainure.setMother(this);
					rainure.setParentdesign(piece);
					rainure.constructDebitage();
					rainure.evaluate();
					piece.addElement(rainure);
					addBaby(rainure);
				}
			}
		
		}
	}
	//0001875: créer l'accessoire ,supporte porte boteille
	public void createSupportPorteBoteille() throws DesignException, GeometricEngineException {
		Caisson caisson = (Caisson) getRootCaisson();
		if(caisson instanceof CaissonCuisine) {
			CaissonCuisine caissoncuisine=(CaissonCuisine)caisson;
			CuisineCaissonType type=caissoncuisine.getCaissoncuisineType();
			if(type.equals(CuisineCaissonType.Porte_Boteille)
					||type.equals(CuisineCaissonType.Porte_Pain)) {
				if(getPiecetype().equals(PieceType.DROITE_CUISSON)||getPiecetype().equals(PieceType.GAUCHE_CUISSON)) {
					SupportPorteBoteille support1=new SupportPorteBoteille();
					SupportPorteBoteille support2=new SupportPorteBoteille();
					if(getPiecetype().equals(PieceType.DROITE_CUISSON)) {
						support1.setDirection(Direction.XPLUS);
						support2.setDirection(Direction.XPLUS);
		
					}else if(getPiecetype().equals(PieceType.GAUCHE_CUISSON)) {
						support1.setDirection(Direction.XMINUS);
						support2.setDirection(Direction.XMINUS);
		
					}
					support1.setSupportType(SupportPorteBoteilleType.BAS);
					support2.setSupportType(SupportPorteBoteilleType.HAUT);
					
					support1.setName("Support Porte Boteille bas "+getName());
					support2.setName("Support Porte Boteille haut "+getName());
					
					support1.setParentdesign(this);
					support2.setParentdesign(this);
					
					support1.constructDebitage();
					support1.evaluate();
					
					support2.constructDebitage();
					support2.evaluate();
					
					addElement(support1);
					addElement(support2);
					
					support1.createUsinage();
					support2.createUsinage();
				}
			}
		}
		
	}
	public DesignObject3D getRootCaisson() {
		DesignObject3D parent= this.getParentdesign();
		while(parent!= null && !(parent instanceof Caisson) && !(parent instanceof Space3DFree)) {
			parent=parent.getParentdesign();
		}
		return parent;
		
	}
	public List<Piece2D> gettangentedPieces(Piece2D piece,DesignObject3D frere) {
		 List<Piece2D> tangentedPiece=new ArrayList<Piece2D>();
		for(DesignObject3D child:frere.getChilds()) {
			if(child instanceof Space3D || child instanceof Separator) {
				tangentedPiece.addAll(gettangentedPieces(piece, child)) ;
			}
			if(child instanceof Piece2D) {
				if(piece.isIntersect(child).equals(IntersectionType.TANGENT)) {
					tangentedPiece.add((Piece2D) child);
				}
			}
		}
		return tangentedPiece;
		
	}
	
	public List<Piece2D> getIntersectedPieces(Piece2D piece,DesignObject3D frere) {
		 List<Piece2D> intesectedPiece=new ArrayList<Piece2D>();
		for(DesignObject3D child:frere.getChilds()) {
			if(child instanceof Space3D || child instanceof Separator) {
				intesectedPiece.addAll(getIntersectedPieces(piece, child)) ;
			}
			if(child instanceof Piece2D && !piece.equals(child)) {
				if(piece.isIntersect(child).equals(IntersectionType.INTERSECTION)) {
					intesectedPiece.add((Piece2D) child);
				}
			}
		}
		return intesectedPiece;
		
	}

	/**
	 * Tester si cette piece est parellle de point de vue X
	 * c est a dire qui il sont tous les deux verticlae entre eux
	 * @param sld2 la deuxieme pièce
	 * @return
	 */
	public boolean isParallelAccordingtoX(Piece2D sld2) {
		// TODO Auto-generated method stub
		if(this.isVerticallPiece() && sld2.isVerticallPiece())
		{
			//deux pieces horizontales on teste si les y se chauvecheement
			return this.isIntersect(sld2).equals(IntersectionType.NOT_RELATED);
			
		}
		return false;
	}
	/**
	 * Tester si deux piece verticale on des y paratgé
	 * @param sld2
	 * @return
	 */
	public boolean isShareAccordingtoY(Piece2D sld2) {
		if(this.isVerticallPiece() && sld2.isVerticallPiece())
		{
			Plan3D plan1=new Plan3D(this);
			Plan3D plan2=new Plan3D(sld2);
			Plan3D intersection=plan1.getIntersection(plan2);
			if(intersection.getYinter()!=null && !intersection.getYinter().isPoint())
			{
				return true;
			}
		}
		return false;
	}
	
	public ArrayList<Vector3> getCornersList(){
		ArrayList<Vector3> corners = new ArrayList<Vector3>();
		Vector3 origin000 = new Vector3(0,0,0);
		Vector3 origin001 = new Vector3(0,0,(float) getProfondeurext());
		Vector3 origin010 = new Vector3(0,(float) getHauteurext(),0);
		Vector3 origin011 = new Vector3(0,(float) getHauteurext(),(float) getProfondeurext());
		Vector3 origin100 = new Vector3((float) getLongeurext(),0,0);
		Vector3 origin101 = new Vector3((float) getLongeurext(),0,(float) getProfondeurext());
		Vector3 origin110 = new Vector3((float) getLongeurext(),(float) getHauteurext(),0);
		Vector3 origin111 = new Vector3((float) getLongeurext(),(float) getHauteurext(),(float) getProfondeurext());
		corners.add(origin000);
		corners.add(origin001);
		corners.add(origin010);
		corners.add(origin011);
		corners.add(origin100);
		corners.add(origin101);
		corners.add(origin110);
		corners.add(origin111);
		return corners;
	}
	
	/**
	 * Tester si cette piece est parellle de point de vue y
	 * c est a dire qui il sont tous les deux horizontale entre eux
	 * @param sld2 la deuxieme pièce
	 * @return
	 */
	public boolean isParallelAccordingtoY(Piece2D sld2) {
		// TODO Auto-generated method stub
		if(this.isHorizontalePiece() && sld2.isHorizontalePiece())
		{
			//deux pieces horizontales on teste si les y se chauvecheement
			return this.isIntersect(sld2).equals(IntersectionType.NOT_RELATED);
			
		}
		return false;
	}
	public boolean isShareAccordingtoX(Piece2D sld2) {
		// TODO Auto-generated method stub
		if(this.isHorizontalePiece() && sld2.isHorizontalePiece())
		{
			Plan3D plan1=new Plan3D(this);
			Plan3D plan2=new Plan3D(sld2);
			Plan3D intersection=plan1.getIntersection(plan2);
			if(intersection.getXinter()!=null && !intersection.getXinter().isPoint())
			{
				return true;
			}
		}
		return false;
	}

	/**
	 * Si cette piece est verticale lorsque la plus faible cote est dans le X
	 * Comme les cote et les seprateurs verticlae
	 */
	public boolean isVerticallPiece()
	{
		return this.getLongeurext()<this.getHauteurext() && this.getLongeurext()<this.getProfondeurext();
	}
	/**
	 * Si cette piece est verticale lorsque la plus faible cote est dans le Y
	 * Comme les les etageres
	 */
	public boolean isHorizontalePiece()
	{
		return this.getHauteurext()<this.getLongeurext() && this.getHauteurext()<this.getProfondeurext();
	}
	/**
	 * Si cette piece est verticale lorsque la plus faible cote est dans le Z
	 * Comme le dos
	 */
	public boolean isProfondPiece()
	{
		return this.getProfondeurext()<this.getLongeurext() && this.getProfondeurext()<this.getHauteurext();
	}
	
	public  Orientation getPieceOrientation() {
		if (isHorizontalePiece()) {
			return Orientation.HORIZONTAL;
		} else if (isProfondPiece()) {
			return Orientation.PROUFOUND;
		} else {
			return Orientation.VERTICAL;
		}
	}
	public PlanUsinage getPrimaryPrespective() {
		Orientation orient = getPieceOrientation();
		switch (orient) {
		case HORIZONTAL:
			return PlanUsinage.TOP;
		case PROUFOUND:
			return PlanUsinage.FRONT;
			
		case VERTICAL:
			return PlanUsinage.RIGHT;
			
		default:
			return PlanUsinage.FRONT;
		}
	}
	public PlanUsinage getSecondaryPrespective() {
		Orientation orient = getPieceOrientation();
		switch (orient) {
		case HORIZONTAL:
			
			return PlanUsinage.DOWN;
			
		case PROUFOUND:
			
			return PlanUsinage.BACK;
		case VERTICAL:
			return PlanUsinage.LEFT;

		default:
			return PlanUsinage.BACK;
		}
	}
	@Override
	public String toString() {
		// TODO Auto-generated method stub
		return "Piece  "+getName()+"[posx=" + xpos + ", posy=" + ypos + ", posz=" + zpos + ", longeur=" + getLongeurext()
				+ ", hauteur=" + getHauteurext() + ", profondeur=" + getProfondeurext()  + "]";
	}

	@Override
	public DesignObject3D clone() {
		Piece2D space=new Piece2D();
		try {
			space=(Piece2D) this.copy((DesignObject3D)space);
		} catch (DesignException | GeometricEngineException | CloneNotSupportedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return space;
	}
	@Override
	public DesignObject3D copy(DesignObject3D object) throws DesignException, GeometricEngineException, CloneNotSupportedException {
		Piece2D piece=(Piece2D) object;
		 piece.setUsineparam(getUsineparam());
		 piece.setConstraintsparam(getConstraintsparam());
		 piece.setParams(getParams());
		 piece.setLongeurext(getLongeurext());
		 piece.setLongeurextfree(isLongeurextfree());
		 piece.setProfondeurext(getProfondeurext());
		 piece.setProfondeurextfree(isProfondeurextfree());
		 piece.setHauteurext(getHauteurext());
		 piece.setHauteurextfree(isHauteurextfree());
		 piece.setLongeurint(getLongeurint());
		 piece.setProfondeurint(getProfondeurint());
		 piece.setHauteurint(getHauteurint());
		 piece.setName(getName());
		 piece.setBasematerial(getBasematerial());
		 piece.setBasematerialfree(isBasematerialfree());
		 piece.setBackmaterial(getBackmaterial());
		 piece.setBackmaterialfree(isBackmaterialfree());
		 piece.setFacadeMaterial(getFacadeMaterial());
		 piece.setFacadematerialfree(isFacadematerialfree());
		 piece.setXpos(getXpos());
		 piece.setYpos(getYpos());
		 piece.setZpos(getZpos());
		 piece.setXPosABS(getXPosABS());
		 piece.setYPosABS(getYPosABS());
		 piece.setZPosABS(getZPosABS());		 
		piece.setPiecetype(getPiecetype());
		piece.setMaterial(getMaterial());
		piece.setEpaisseur(getEpaisseur());
		piece.setPieceL(getPieceL());
		piece.setPieceH(getPieceH());
		piece.setPositionetagere(getPositionetagere());
		piece.setLongchant1(getLongchant1());
		piece.setLongchant2(getLongchant2());
		piece.setLongchant3(getLongchant3());
		piece.setLongchant4(getLongchant4());
		piece.setChant1(getChant1());
		piece.setChant2(getChant2());
		piece.setChant3(getChant3());
		piece.setChant4(getChant4());
		piece.setChants(getChants());
		piece.setProps(getProps());
		piece.systemesequations=this.systemesequations;
		piece.systemesequationsasparent=this.systemesequationsasparent;
		piece.setID(getID());
		for(DesignObject3D design:getChilds() ) {
				DesignObject3D copy= design.clone();
				 piece.addElement(copy);	
		 }		
		return piece;
	}	
	
	@Override
	public DebitageFormulas getDebitageFormulas() {
		if(this instanceof Piece2D 
				&& (getPiecetype().equals(PieceType.BAS_TIROIR) ||getPiecetype().equals(PieceType.COTE_DROITE_TIROIR)
						||getPiecetype().equals(PieceType.COTE_GAUCHE_TIROIR)
						||getPiecetype().equals(PieceType.DERIERE_TIROIR))
						||getPiecetype().equals(PieceType.FACADE_EXTERIEUR_TIROIR)
						||getPiecetype().equals(PieceType.FACADE_INTERIEUR_TIROIR)){
			if(formulas==null|| !(formulas instanceof TiroirPieceDebitageFormulas)) {
				formulas = new TiroirPieceDebitageFormulas();
				return formulas;
			}
		}
		if(formulas==null|| !(formulas instanceof DebitageFormulas)) {
			formulas = new DebitageFormulas();
		}
		return formulas; 
	}
	@Override
	public ArrayList<Couple> getSystemEquationAsParent() {
		// TODO Auto-generated method stub
		systemesequationsasparent.clear();
		systemesequationsasparent.add(new Couple("@Parent.l@", ""+getLongeurext()));
		systemesequationsasparent.add(new Couple("@Parent.p@", ""+getProfondeurext()));
		systemesequationsasparent.add(new Couple("@Parent.h@", ""+getHauteurext()));
		systemesequationsasparent.add(new Couple("@Parent.li@", ""+getLongeurint()));
		systemesequationsasparent.add(new Couple("@Parent.pi@", ""+getProfondeurint()));
		systemesequationsasparent.add(new Couple("@Parent.hi@", ""+getHauteurint()));
		
		systemesequationsasparent.add(new Couple("@Parent.epaisseursecondaire@", ""+getBackmaterial().getEpaisseur()));
		systemesequationsasparent.add(new Couple("@Parent.epaisseurprincipale@", ""+getBasematerial().getEpaisseur()));

		systemesequationsasparent.add(new Couple("@Parent.posx@", ""+getXpos()));
		systemesequationsasparent.add(new Couple("@Parent.posy@", ""+getYpos()));
		systemesequationsasparent.add(new Couple("@Parent.posz@", ""+getZpos()));
		

		return systemesequationsasparent;
 	}
	public boolean isFacade() {
		if(this.piecetype== PieceType.PORTE || this.piecetype == PieceType.PORTE_GAUCHE  
			|| this.piecetype == PieceType.PORTE_DROITE || this.piecetype == PieceType.PORTE_BAS 
			|| this.piecetype == PieceType.PORTE_HAUT|| this.piecetype == PieceType.FACADE) {
			return true;
		}
		return false;
	}
	public List<Usinage> getusinage(){
		List<Usinage> usins=new ArrayList<Usinage>();
		for(DesignObject3D design:getChilds()) {
			if(design instanceof Usinage) {
				usins.add((Usinage) design);
			}
		}
		return usins;
	}
	public List<Trou> getTrous(){
		List<Trou> trous = new ArrayList<Trou>();
		for(DesignObject3D design:getChilds()) {
			if(design instanceof Trou) {
				trous.add((Trou) design);
			}
		}
		return trous;
	}
	
	public List<Usinage> getCavities(){
		List<Usinage> rainures = new ArrayList<Usinage>();
		for(DesignObject3D design:getChilds()) {
			if(!(design instanceof Trou)) {
				rainures.add((Usinage) design);
			}
		}
		return rainures;
	}
	public List<Cavity> getPiecesCavities(){
		List<Cavity> rainures = new ArrayList<Cavity>();
		for(DesignObject3D design:getChilds()) {
			if(design instanceof Cavity) {
				rainures.add((Cavity) design);
			}
		}
		return rainures;
	}
		

	
	@Override
	public void dispose() {
		// TODO Auto-generated method stub
		super.dispose();
		piecetype = null;
		material = null;
		chant1 = null;
		chant2 = null;
		chant3 = null;
		chant4 = null;
		chants = null;
		if (mechanicDesignElementDefinition != null)
			mechanicDesignElementDefinition.dispose();

		if (materialType != null)
			materialType.dispose();
		
		if (vitreMaterialType != null)
			materialType.dispose();
		
		mechanicDesignElementDefinition=null;
		materialType = null;
		vitreMaterialType = null;
	}

		
		public Box toSVGBox() {
			Box box =  new Box(getPosition().add(getSize().scl(0.5f)), getSize());
			Vector3 color = new Vector3();
			if(getPiecetype().isBack()) {
				color.set(226,187,123).scl(1.0f/255.0f);
			}else {
				color.set(164,116,73).scl(1.0f/255.0f);
			}
			box.setColor(color);
			return box;
		}
		public float getSurface(PlanUsinage face) {
			return (float) (getWidth(face) * getHight(face));
		}
//		public void setChilds(ArrayList<Usinage> listExtrusion) {
//			// TODO Auto-generated method stub
//			
//		}
		public Vector3 getCenter() {
			Vector3 halfSize = getSize().scl(0.5f);
			return getPosition().add(halfSize);
		}
}
