 
package dressing.handlers.gdx;

import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.widgets.Display;

import com.badlogic.gdx.utils.Array;

import dressing.model.ProjectManager;
import dressing.ui.Control.MultiObjectActionWidow;
import gdxapp.Commun.GroupSelection;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.Object2D;
import gdxapp.object3d.WorldObject;

import java.util.ArrayList;

import org.eclipse.e4.core.di.annotations.CanExecute;

public class UpdateMultiObject {
	@Execute
	public void execute() {
		MultiObjectActionWidow window = new MultiObjectActionWidow(Display.getDefault().getActiveShell());
		ArrayList<Object> selection=GroupSelection.getInstance().getSelection();
		if(selection!=null && selection.size()>0) {
			ArrayList<KitchenElement> targets=new ArrayList<KitchenElement>();
			for(Object object:selection) {
				if(object instanceof KitchenElement) {
					targets.add((KitchenElement)object);
	
				}else if(object instanceof Object2D) {
					targets.add(((Object2D)object).getWorldObject());
				}
			}
			window.create();
			window.setTargets(targets);
			window.open();
		}
		
		
	}
	
	
	@CanExecute
	public boolean canExecute() {
		
		return true;
	}
		
}