package dressing.controller;

import static org.junit.Assert.assertEquals;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;

import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Dressing;
import dressing.model.Materiaux;
import dressing.model.Piece2D;
import dressing.model.Separator;
import dressing.model.Space3D;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.PieceType;
import dressing.model.types.PortType;
import dressing.model.types.SeprationAxe;
import dressing.model.types.Zone3DType;

public class PorteCreator implements Creator{
	Materiaux material;
	DesignObject3D parent;
	PortType porteType=PortType.FRANCAISE;
	List<Piece2D> porteList=new ArrayList<Piece2D>();
	Piece2DCreator piece2dCreator = new Piece2DCreator();
	
	public Piece2DCreator getPiece2dCreator() {
		return piece2dCreator;
	}

	public void setPiece2dCreator(Piece2DCreator piece2dCreator) {
		Piece2DCreator oldValue = this.piece2dCreator;
		this.piece2dCreator = piece2dCreator;
		firePropertyChange("piece2dCreator", oldValue, piece2dCreator);
	}

	public Materiaux getMaterial() {
		return material;
	}

	public void setMaterial(Materiaux material) {
		
		Materiaux oldValue = this.material;
		this.material = material;
		firePropertyChange("material", oldValue, material);
	}

	public DesignObject3D getParent() {
		return parent;
	}

	public void setParent(DesignObject3D parent) {
		DesignObject3D oldValue = this.parent;
		this.parent = parent;
		setMaterial(parent.getBasematerial());
		firePropertyChange("parent", oldValue, parent);
	}

	public PortType getPorteType() {
		return porteType;
	}

	public void setPorteType(PortType porteType) {
		PortType oldValue = this.porteType;
		this.porteType = porteType;
		firePropertyChange("porteType", oldValue, porteType);
	}

public List<Piece2D> getPorteList() {
		return porteList;
	}

	public void setPorteList(List<Piece2D> porteList) {
		List<Piece2D> oldValue = this.porteList;
		this.porteList = porteList;
		firePropertyChange("porteList", oldValue, porteList);
	}

/**
 * ce method est créer pour invoker le firePropertyChange virtuellement a cause de faire le calcul a nouveaux
 */
	public void trigerChangeCalculation()
	{
		
		firePropertyChange("autotrigger", "2", "1");
	}
	
	
	/**
	 * @return the active
	 */
	
	public void create() throws DesignException, GeometricEngineException {
		// TODO Auto-generated method stub

		createSubElements();
	}

	public void check() throws DesignException {
		if (getMaterial() == null)
		{
			throw new DesignException("Le matérieaux de porte doit être rensigné");
		}
		if (getParent() == null)
			throw new DesignException("Le parent doit être renseigné");
		if (getPorteType() == null)
			throw new DesignException("Le type de porte doit être renseigné");
		if(((Space3D)getParent()).getPorttype().equals(PortType.COLISSANT))
			throw new DesignException("impossible d'ajoutée un porte francaise sur un espace de type collissant");
			DesignObject3D parent=getParent();
			while(parent !=null && !(parent instanceof Dressing)) {
				if(parent.getChilds()!=null) {
					for(DesignObject3D child:parent.getChilds()) {
						if(child instanceof Piece2D ) {
							if( ((Piece2D)child).getPiecetype().equals(PieceType.PORTE)
									|| ((Piece2D)child).getPiecetype().equals(PieceType.PORTE_DROITE)
									|| ((Piece2D)child).getPiecetype().equals(PieceType.PORTE_GAUCHE)
									|| ((Piece2D)child).getPiecetype().equals(PieceType.PORTE_HAUT)
									|| ((Piece2D)child).getPiecetype().equals(PieceType.PORTE_BAS)) {
								throw new DesignException("impossible d'ajoutée un porte. Le parent contient un autre porte");
							}
						}
					}
				}	
				if(parent.getParentdesign() instanceof Separator) {
					if(parent.getParentdesign()!=null) {
						parent=parent.getParentdesign().getParentdesign();
					}else {
						break;
					}
				}else {
					parent=parent.getParentdesign();
				}
			}
			checkchildporte(getParent());
		if( getParent()!=null && getParent() instanceof Space3D 
				&& getParent().getParentdesign()!= null && getParent().getParentdesign() instanceof Separator) {
			if(((Space3D)getParent()).getZonetype().equals(Zone3DType.ZONEBAS)&& 
					((Separator)getParent().getParentdesign()).getSepaxe().equals(SeprationAxe.ZAXIS)) {
				throw new DesignException("impossible d'ajoutée un porte dans un espace3D de type bas dans un separateur interieur");

			}
		}
		
	}

	public void createSubElements() throws DesignException, GeometricEngineException {
		check(); // On met le controle dans une seule fonction
			getPorteList().clear();
			
			piece2dCreator.setParent(getParent());
			piece2dCreator.setBasematerial(getParent().getBasematerial());
			piece2dCreator.setBackmaterial(getParent().getBackmaterial());
			piece2dCreator.setMaterial(getMaterial());
			
			if( getPorteType().equals(PortType.FRANCAISE))
			{
				piece2dCreator.setName("porte");
				piece2dCreator.setPorttype(PortType.FRANCAISE);
				piece2dCreator.setPiecetype(PieceType.PORTE);
				piece2dCreator.create();
				if(!(piece2dCreator.getPiece2DInstance() instanceof Piece2D)) {
					throw new GeometricEngineException("le porte doit étre un piece2d");
				}
				getPorteList().add((Piece2D)piece2dCreator.getPiece2DInstance());
			}
			else if(getPorteType().equals(PortType.FRANCAISE2V))
			{
				piece2dCreator.setName("Porte Droite");
				piece2dCreator.setPiecetype(PieceType.PORTE_DROITE);
				piece2dCreator.create();
				if(!(piece2dCreator.getPiece2DInstance() instanceof Piece2D)) {
					throw new GeometricEngineException("le porte doit étre un piece2d");
				}
				getPorteList().add((Piece2D)piece2dCreator.getPiece2DInstance());
				piece2dCreator.setName("Porte Gauche");
				piece2dCreator.setPiecetype(PieceType.PORTE_GAUCHE);
				piece2dCreator.create();
				if(!(piece2dCreator.getPiece2DInstance() instanceof Piece2D)) {
					throw new GeometricEngineException("le porte doit étre un piece2d");
				}
				getPorteList().add((Piece2D)piece2dCreator.getPiece2DInstance());
			}
			else if(getPorteType().equals(PortType.FRANCAISE2H)){
				piece2dCreator.setName("Porte Haut");
				piece2dCreator.setPiecetype(PieceType.PORTE_HAUT);
				piece2dCreator.create();
				if(!(piece2dCreator.getPiece2DInstance() instanceof Piece2D)) {
					throw new GeometricEngineException("le porte doit étre un piece2d");
				}
				getPorteList().add((Piece2D)piece2dCreator.getPiece2DInstance());
				piece2dCreator.setName("Porte Bas");
				piece2dCreator.setPiecetype(PieceType.PORTE_BAS);
				piece2dCreator.create();
				if(!(piece2dCreator.getPiece2DInstance() instanceof Piece2D)) {
					throw new GeometricEngineException("le porte doit étre un piece2d");
				}
				getPorteList().add((Piece2D)piece2dCreator.getPiece2DInstance());
			}
			else{
				throw new DesignException("Porte colissante non supporté");
			}			

	}

	transient protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

	public void addPropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(listener);
	}

	public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
	}

	public void removePropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(listener);
	}

	public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
	}

	protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
		propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
	}
	protected void checkchildporte(DesignObject3D parent) throws DesignException {
		for (DesignObject3D child : parent.getChilds()) {
			if(child instanceof Piece2D ) {
				if( ((Piece2D)child).getPiecetype().equals(PieceType.PORTE)
						|| ((Piece2D)child).getPiecetype().equals(PieceType.PORTE_DROITE)
						|| ((Piece2D)child).getPiecetype().equals(PieceType.PORTE_GAUCHE)
						|| ((Piece2D)child).getPiecetype().equals(PieceType.PORTE_HAUT)
						|| ((Piece2D)child).getPiecetype().equals(PieceType.PORTE_BAS)) {
					throw new DesignException("impossible d'ajoutée un porte. un des fils de Le parent contient un autre porte");
				}
			}
			checkchildporte(child);
		}	
	}
}
