package dressing.controller;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.Blob;

import dressing.model.BlocTirroir;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Materiaux;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.CaissonMontageType;
import dressing.model.types.CaissonType;
import dressing.model.types.CuisineCaissonType;
import dressing.model.types.DosType;
import dressing.model.types.PieceType;
import dressing.model.types.PortType;
import dressing.model.types.TiroireFacadeType;
import dressing.model.types.TirroirType;

public class BlocTirroirCreator implements Creator {
	BlocTirroir blocTirroir;
	public static double MIN_TIRROIR_HAUTEUR=100;
	String name="Bloc Tiroir";
	double longeur = 600;
	double hauteur = 720;
	double profondeur = 560;
	Materiaux basematerial=new Materiaux();
	Materiaux backmaterial=new Materiaux();
	Materiaux facadeMaterial=new Materiaux();
	DesignObject3D parent;
	CaissonType caissontype = CaissonType.MONO_CAISSON;
	CaissonMontageType caissonMontageType=CaissonMontageType.CAISSON_MONTAGE_L;
	DosType dostype = DosType.DOSINTERIEUR;
	int tirroirCount=1;
	boolean tirroirsEquals=true;
	boolean semiAuto=false;
	double firstTirroirhight=360;
	private TirroirType tiroirType=TirroirType.TENDENBOX;
	private TiroireFacadeType facadetype=TiroireFacadeType.FACADE_EXTERIEUR_TIROIR;

	/**
	 * @return the facadetype
	 */
	public TiroireFacadeType getFacadetype() {
		return facadetype;
	}

	/**
	 * @param facadetype the facadetype to set
	 */
	public void setFacadetype(TiroireFacadeType facadetype) {
		TiroireFacadeType oldValue=this.facadetype;
		this.facadetype = facadetype;
		firePropertyChange("facadetype", oldValue, this.facadetype);
		
	}
	public TirroirType getTiroirType() {
		return tiroirType;
	}
	
	public void setTiroirType(TirroirType tiroirType) {
		TirroirType oldValue=this.tiroirType;
		this.tiroirType = tiroirType;
		firePropertyChange("tiroirType", oldValue, this.tiroirType);	
	}
	
	public BlocTirroir getBlocTirroir() {
		return blocTirroir;
	}

	public void setBlocTirroir(BlocTirroir blocTirroir) {
		BlocTirroir oldValue = this.blocTirroir;
		this.blocTirroir = blocTirroir;
		firePropertyChange("blocTirroir", oldValue, blocTirroir);
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		String oldValue = this.name;
		this.name = name;
		firePropertyChange("name", oldValue, name);

	}

	public double getLongeur() {
		return longeur;
	}

	public void setLongeur(double longeur) {
		double oldValue = this.longeur;
		this.longeur = longeur;
		firePropertyChange("longeur", oldValue, longeur);
	}

	public double getHauteur() {
		return hauteur;
	}

	public void setHauteur(double hauteur) {
		double oldValue = this.hauteur;
		this.hauteur = hauteur;
		firePropertyChange("hauteur", oldValue, hauteur);
	}

	public double getProfondeur() {
		return profondeur;
	}

	public void setProfondeur(double profondeur) {
		double oldValue = this.profondeur;
		this.profondeur = profondeur;
		firePropertyChange("profondeur", oldValue, profondeur);
	}

	public Materiaux getFacadeMaterial() {
		return facadeMaterial;
	}

	public void setFacadeMaterial(Materiaux facadeMaterial) {
		Materiaux oldValue = this.facadeMaterial;
		this.facadeMaterial = facadeMaterial;
		firePropertyChange("facadeMaterial", oldValue, facadeMaterial);
	}

	public Materiaux getBasematerial() {
		return basematerial;
	}

	public void setBasematerial(Materiaux basematerial) {
		Materiaux oldValue = this.basematerial;
		this.basematerial = basematerial;
		firePropertyChange("basematerial", oldValue, basematerial);
	}

	public Materiaux getBackmaterial() {
		return backmaterial;
	}

	public void setBackmaterial(Materiaux backmaterial) {
		Materiaux oldValue = this.backmaterial;
		this.backmaterial = backmaterial;
		firePropertyChange("backmaterial", oldValue, backmaterial);
	}

	public DesignObject3D getParent() {
		return parent;
	}

	public void setParent(DesignObject3D parent) {
		DesignObject3D oldValue = this.parent;
		this.parent = parent;
		firePropertyChange("parent", oldValue, parent);
	}

	public CaissonType getCaissontype() {
		return caissontype;
	}

	public void setCaissontype(CaissonType cuissontype) {
		CaissonType oldValue = this.caissontype;
		this.caissontype = cuissontype;
		firePropertyChange("caissontype", oldValue, caissontype);
	}

	public CaissonMontageType getCaissonMontageType() {
		return caissonMontageType;
	}

	public void setCaissonMontageType(CaissonMontageType caissonMontageType) {
		CaissonMontageType oldValue = this.caissonMontageType;
		this.caissonMontageType = caissonMontageType;
		firePropertyChange("caissonMontageType", oldValue, caissonMontageType);
	}

	public DosType getDostype() {
		return dostype;
	}

	public void setDostype(DosType dostype) {
		DosType oldValue = this.dostype;
		this.dostype = dostype;
		firePropertyChange("dostype", oldValue, dostype);
	}

	public int getTirroirCount() {
		return tirroirCount;
	}

	public void setTirroirCount(int tirroirCount) {
		int oldValue = this.tirroirCount;
		this.tirroirCount = tirroirCount;
		firePropertyChange("tirroirCount", oldValue, tirroirCount);
	}

	public boolean isTirroirsEquals() {
		return tirroirsEquals;
	}

	public void setTirroirsEquals(boolean tirroirsEquals) {
		boolean oldValue = this.tirroirsEquals;
		this.tirroirsEquals = tirroirsEquals;
		firePropertyChange("TirroirsEquals", oldValue, tirroirsEquals);
	}

	public boolean isSemiAuto() {
		return semiAuto;
	}

	public void setSemiAuto(boolean semiAuto) {
		boolean oldValue = this.semiAuto;
		this.semiAuto = semiAuto;
		firePropertyChange("semiAuto", oldValue, semiAuto);
	}
	public double getFirstTirroirhight() {
		return firstTirroirhight;
	}

	public void setFirstTirroirhight(double firstTirroirhight) {
		double oldValue = this.firstTirroirhight;
		this.firstTirroirhight = firstTirroirhight;
		firePropertyChange("firstTirroirhight", oldValue, firstTirroirhight);
	}

	@Override
	public void check() throws DesignException {
		if (getName() == null || getName().isEmpty())
			throw new DesignException("Le nom de bloc tirroir est obligatoire");

		if (getBasematerial() == null)
			throw new DesignException("Le matérieaux de base doit être rensigné");

		if (getBackmaterial() == null)
			throw new DesignException("Le matérieaux de dos doit être rensigné");

		if (getBasematerial().getEpaisseur() <= 0)
			throw new DesignException("L'epaisseur de matérieaux de base doit être superieur à 1 mm");

		if (getBackmaterial().getEpaisseur() <= 0)
			throw new DesignException("L'epaisseur de matérieaux de dos doit être superieur à 1 mm");

		if (getTirroirCount() <= 0)
			throw new DesignException("Le nombre des tirroir doit être supérieur à 1");

		if(isTirroirsEquals()) {
			double tiroirHieght=getLongeur()/getTirroirCount();
			if(tiroirHieght<BlocTirroirCreator.MIN_TIRROIR_HAUTEUR) {
				throw new DesignException("L'epaisseur de matérieaux de base doit être superieur à 1 mm");

			}
		}
		if(isSemiAuto()) {
			if(getFirstTirroirhight()<BlocTirroirCreator.MIN_TIRROIR_HAUTEUR) {
				throw new DesignException("la hauteur de tiroir doit étre suprieur ou égale à la hauteur minimale des tiroir("+BlocTirroirCreator.MIN_TIRROIR_HAUTEUR+")");
			}
			if(getTirroirCount()>=2) {
				double tiroirHieght=(getHauteur()-getFirstTirroirhight())/(getTirroirCount()-1);
				if(tiroirHieght<BlocTirroirCreator.MIN_TIRROIR_HAUTEUR) {
					throw new DesignException("la hauteur des tiroirs doit étre suprieur ou égale à la hauteur minimale des tiroir("+BlocTirroirCreator.MIN_TIRROIR_HAUTEUR+")");

				}
			}else if(getTirroirCount()==1) {
				if(getFirstTirroirhight()<getHauteur()) {
					throw new DesignException("la hauteur de tiroir doit étre suprieur ou égale à la hauteur minimale des tiroir("+BlocTirroirCreator.MIN_TIRROIR_HAUTEUR+") et égale a la hauteur du parent");
				}
			}
			
		}
		if(getFacadetype().equals(TiroireFacadeType.FACADE_INTERIEUR_TIROIR)&& !getTiroirType().equals(TirroirType.CLASSIC)) {
			throw new DesignException("facade de tiroir interieur est non supporter avec les types de tiroir Tandembox et Metabox");
		}

	}

	@Override
	public void create() throws DesignException, GeometricEngineException {
		check();
		this.blocTirroir=new BlocTirroir();
		this.blocTirroir.setName(getName());

		
		this.blocTirroir.setBackmaterial(getBackmaterial());
		this.blocTirroir.setBasematerial(getBasematerial());
		this.blocTirroir.setFacadeMaterial(getFacadeMaterial());
		this.blocTirroir.setHauteurext(getHauteur());
		this.blocTirroir.setProfondeurext(getProfondeur());
		this.blocTirroir.setLongeurext(getLongeur());
		
		this.blocTirroir.setCaissonMontageType(getCaissonMontageType());
		this.blocTirroir.setDostype(getDostype());
		this.blocTirroir.setCuissontype(getCaissontype());
		this.blocTirroir.setCaissoncuisineType(CuisineCaissonType.Bloc_Tiroir);
		this.blocTirroir.setPorttype(PortType.FRANCAISE);
		this.blocTirroir.setTiroirType(getTiroirType());
		
		this.blocTirroir.setParentdesign(getParent());
		
		this.blocTirroir.constructDebitage();
		this.blocTirroir.evaluate();
		createSubElements();
	}

	@Override
	public void createSubElements() throws DesignException, GeometricEngineException {
		if(this.blocTirroir==null) {
			throw new DesignException("un problème est survenue lors de création de la bloc Tiroir");
		}
		
		Piece2DCreator piececreator = new Piece2DCreator();
		piececreator.setName("Bas");
		piececreator.setPiecetype(PieceType.BAS_CUISSON);
		piececreator.setBackmaterial(getBackmaterial());
		piececreator.setBasematerial(getBasematerial());
		piececreator.setMaterial(getBasematerial());
		piececreator.setParent(this.blocTirroir);		
		piececreator.create();
		this.blocTirroir.addElement(piececreator.getPiece2DInstance());		
		
		piececreator.setName("Bande Arriere");
		piececreator.setPiecetype(PieceType.BANDE_ARRIERE);
		piececreator.setMaterial(getBasematerial());
		piececreator.setParent(this.blocTirroir);	
		piececreator.create();
		this.blocTirroir.addElement(piececreator.getPiece2DInstance());
		
		piececreator.setName("Bande Avant");
		piececreator.setPiecetype(PieceType.BANDE_AVANT);
		piececreator.setMaterial(getBasematerial());
		piececreator.setParent(this.blocTirroir);	
		piececreator.create();
		this.blocTirroir.addElement(piececreator.getPiece2DInstance());

		
		piececreator.setName("Cote Droite");
		piececreator.setPiecetype(PieceType.DROITE_CUISSON);
		piececreator.setMaterial(getBasematerial());
		piececreator.create();
		this.blocTirroir.addElement(piececreator.getPiece2DInstance());

		
		
		piececreator.setName("Cote Gauche");
		piececreator.setPiecetype(PieceType.GAUCHE_CUISSON);
		piececreator.setMaterial(getBasematerial());
		piececreator.create();
		this.blocTirroir.addElement(piececreator.getPiece2DInstance());

		piececreator.setName("Dos");		
		piececreator.setPiecetype(PieceType.DOS_INTERIEUR);
		piececreator.setMaterial(getBackmaterial());
		piececreator.create();
		this.blocTirroir.addElement(piececreator.getPiece2DInstance());
		CreateTiroirs();
	}
	
	
	private void CreateTiroirs() throws DesignException, GeometricEngineException{
		TirroirCreator Tiroircreator = new TirroirCreator();

		if(isTirroirsEquals()) {
			double yPos=0;
			double hauteur=getHauteur()/getTirroirCount();
			for(int i=0;i<getTirroirCount();i++) {
				Tiroircreator.setName("Tiroir"+i);
				
				Tiroircreator.setBackmaterial(getBackmaterial());
				Tiroircreator.setBasematerial(getBasematerial());
				Tiroircreator.setFacadeMaterial(getFacadeMaterial());
				
				Tiroircreator.setProfondeur(getProfondeur());
				Tiroircreator.setLongeur(getLongeur());
				Tiroircreator.setHauteur(hauteur);
				
				Tiroircreator.setFacadetype(getFacadetype());
				Tiroircreator.setTiroirType(getTiroirType());
				
				Tiroircreator.setyPos(yPos);
				
				Tiroircreator.setParent(this.blocTirroir);		
				Tiroircreator.create();
				this.blocTirroir.addElement(Tiroircreator.getInstance());		
				yPos+=hauteur;
			}
		}else if(isSemiAuto()) {
			double firsthauteur=getFirstTirroirhight();
			double hauteur=(getHauteur()-firsthauteur)/(getTirroirCount()-1);
			double yPos=0;
			for(int i=0;i<getTirroirCount();i++) {
				Tiroircreator.setName("Tiroir"+i);
				
				Tiroircreator.setBackmaterial(getBackmaterial());
				Tiroircreator.setBasematerial(getBasematerial());
				Tiroircreator.setFacadeMaterial(getFacadeMaterial());
				
				Tiroircreator.setProfondeur(getProfondeur());
				Tiroircreator.setLongeur(getLongeur());
				Tiroircreator.setyPos(yPos);
				if(i==0) {
					Tiroircreator.setHauteur(firsthauteur);
					yPos+=firsthauteur;
	
				}else {
					Tiroircreator.setHauteur(hauteur);
					yPos+=hauteur;
				}
				Tiroircreator.setFacadetype(getFacadetype());
				Tiroircreator.setTiroirType(getTiroirType());
				
				Tiroircreator.setParent(this.blocTirroir);		
				Tiroircreator.create();
				this.blocTirroir.addElement(Tiroircreator.getInstance());
			}
		}
	}
	public BlocTirroir getInstance() {
		return blocTirroir;
	}
	
	
	
	transient protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

	public void addPropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(listener);
	}

	public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
	}

	public void removePropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(listener);
	}

	public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
	}

	protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
		propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
	}

}
