package api.ui;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;

import java.io.File;
import java.util.HashMap;

import org.apache.commons.collections.map.HashedMap;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.layout.GridData;
import org.eclipse.wb.swt.ResourceManager;

import api.event.EventBus;
import api.event.EventType;
import api.event.MepEvent;
import api.graphics.SelectionMode;
import api.provider.ModelProvider;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;

public class SelectionMenu extends Composite {

	
	private Button btnElements;
	private Button btnFaces;
	private Button btnVertices;
	private Button btnSurfaces;
	private Button btnObjects;

	public SelectionMenu(Composite parent, int style) {
		super(parent, style);
		GridLayout gridLayout = new GridLayout(1, false);
		gridLayout.marginLeft = 50;
		setLayout(gridLayout);
		
		Label label = new Label(this, SWT.NONE);
		label.setLayoutData(new GridData(SWT.LEFT, SWT.FILL, false, true, 1, 1));
		
		btnObjects = new Button(this, SWT.RADIO);
		btnObjects.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseDown(MouseEvent e) {
				selectionModeChanged(SelectionMode.OBJECTS);
			}
		});
		Image img1 = new Image(Display.getDefault(), ModelProvider.root + File.separator + "icons/icons8-kitchen-32.png" );
		btnObjects.setImage( img1);
		btnObjects.setText("Objects");
		
		btnElements = new Button(this,  SWT.RADIO);
		btnElements.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseDown(MouseEvent e) {
				selectionModeChanged(SelectionMode.PARTS);
			}
		});
		Image img2 = new Image(Display.getDefault(), ModelProvider.root + File.separator + "icons/icons8-object-32.png" );

		btnElements.setImage(img2);
		btnElements.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		btnElements.setText("elements");
		
		btnFaces = new Button(this, SWT.RADIO);
		btnFaces.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseDown(MouseEvent e) {
				selectionModeChanged(SelectionMode.FACES);
			}
		});
		Image img3 = new Image(Display.getDefault(), ModelProvider.root + File.separator + "icons/icons8-keydb-32.png" );
		btnFaces.setImage(img3);
		btnFaces.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		btnFaces.setText("triangles");
		
		btnSurfaces = new Button(this,  SWT.RADIO);
		btnSurfaces.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseDown(MouseEvent e) {
				selectionModeChanged(SelectionMode.EDGES);
			}
		});
		
		Image img4 = new Image(Display.getDefault(), ModelProvider.root + File.separator + "icons/icons8-front-view-32.png" );

		btnSurfaces.setImage(img4);
		btnSurfaces.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		btnSurfaces.setText("faces");
		
		btnVertices = new Button(this,  SWT.RADIO);
		btnVertices.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseDown(MouseEvent e) {
				selectionModeChanged(SelectionMode.VERTICES);
			}
		});
		Image img5 = new Image(Display.getDefault(), ModelProvider.root + File.separator + "icons/icons8-graph-clique-32.png");

		btnVertices.setImage(img5);
		btnVertices.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		btnVertices.setText("vertices");
		
		
		
		Label lblNewLabel = new Label(this, SWT.NONE);
		lblNewLabel.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, true, 1, 1));
	}
	
	public void selectionModeChanged(SelectionMode mode) {
		HashMap<String, Object> details = new HashMap<String,Object>();
		details.put("mode", mode);
		EventBus.getInstance().notify(new MepEvent(EventType.SELECTION_MODE_CHANGED, details));
	}

}
