package dressing.ui.bloctiroir;

import java.beans.PropertyChangeListener;

import javax.inject.Inject;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import dressing.controller.BlocTirroirCreator;
import dressing.model.ModelProvider;
import dressing.ui.util.SingleImageItemLabelProvider;

import dressing.model.types.*;
public class BlocTiroirWizardComposite extends Composite {
	@Inject
	IEclipseContext eclipsecontext;
	@Inject
	private ESelectionService selectionService;

	@Inject
	private EHandlerService handlerService;

	@Inject
	private ECommandService commandService;
	private DataBindingContext m_bindingContext;
	Text Name;
	private TableComboViewer tableComboViewermatprincipale;
	private TableComboViewer tableComboViewer_matdos;
	BlocTirroirCreator creator;
	PropertyChangeListener pcl;
	boolean errorfound=false;
	Label lblName;
	private ModelProvider modelprovider = new ModelProvider();
	private Spinner spnhauteur;
	private Spinner spnprofondeur;
	private Label lblLongeur;
	private Spinner spnlonguer;
	private Label lblNombreTiroir;
	private Spinner spnTiroirCount;
	private Button btnTiroirgeaux;
	private Button btnSemiAutomatique;
	private Label lblfirstTirroirhight;
	private Spinner spnfirstTirroirhight;
	private Label lblMatrieauxFacade;
	private TableCombo tableCombo;
	private TableComboViewer tableComboViewer_matfacade;
	private Label lblmatprincipale;
	private Label lblTypeTiroir;
	private Combo cbTiroirType;
	private ComboViewer cbViewerTiroirType;
	private Label lblTiroirFacadeType;
	private Combo combo;
	private ComboViewer cbViewerFacadeType;
	
	public BlocTirroirCreator getCreator() {
		return creator;
	}
	public void SetCreator(BlocTirroirCreator creator) {
		this.creator = creator;
	}

	/**
	 * Create the composite.
	 * @param parent
	 * @param style
	 */
	public BlocTiroirWizardComposite(Composite parent, int style,BlocTirroirCreator creator) {
		this(parent, style);
		SetCreator(creator);
		if(creator!=null) {
			m_bindingContext = initDataBindings();
		}
	}
	public BlocTiroirWizardComposite(Composite parent, int style) {
		super(parent, style);
		setLayout(new GridLayout(2, false));
		 lblName = new Label(this, SWT.NONE);
		lblName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblName.setText("Name");
		
		 Name = new Text(this, SWT.BORDER);
		Name.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		lblNombreTiroir = new Label(this, SWT.NONE);
		lblNombreTiroir.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNombreTiroir.setText("Nombre Tiroir");
		
		spnTiroirCount = new Spinner(this, SWT.BORDER);
		spnTiroirCount.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		spnTiroirCount.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		spnTiroirCount.setMaximum(1000000);
		
		Label lblmatDos;
		
		lblTypeTiroir = new Label(this, SWT.NONE);
		lblTypeTiroir.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblTypeTiroir.setText("Type Tiroir");
		
		cbViewerTiroirType = new ComboViewer(this, SWT.NONE);
		cbTiroirType = cbViewerTiroirType.getCombo();
		cbTiroirType.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		cbViewerTiroirType.setContentProvider((ArrayContentProvider.getInstance()));
		cbViewerTiroirType.setInput(TirroirType.values());
		
		lblTiroirFacadeType = new Label(this, SWT.NONE);
		lblTiroirFacadeType.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblTiroirFacadeType.setText("Tiroir Facade type");
		
		cbViewerFacadeType = new ComboViewer(this, SWT.NONE);
		combo = cbViewerFacadeType.getCombo();
		combo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		cbViewerFacadeType.setContentProvider((ArrayContentProvider.getInstance()));
		cbViewerFacadeType.setInput(TiroireFacadeType.values());
		
		lblmatprincipale = new Label(this, SWT.NONE);
		lblmatprincipale.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblmatprincipale.setText("Matérieaux principale");
		//
		tableComboViewermatprincipale = new TableComboViewer(this, SWT.READ_ONLY | SWT.BORDER);
		tableComboViewermatprincipale.getTableCombo().setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableComboViewermatprincipale.getTableCombo().setShowTableHeader(true);
		tableComboViewermatprincipale.getTableCombo().defineColumns(new String[] { "Texture","Epaisseur" });
		tableComboViewermatprincipale.getTableCombo().getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		// do not allow editable
		tableComboViewermatprincipale.getTableCombo().setEditable(false);
		// set the content provider
		tableComboViewermatprincipale.setContentProvider(ArrayContentProvider.getInstance());

		// set the label provider
		tableComboViewermatprincipale.setLabelProvider(new SingleImageItemLabelProvider(this));

		// load the data
		tableComboViewermatprincipale.setInput(modelprovider.getMateriallist());
		
		//
		
		
		//
		 lblmatDos = new Label(this, SWT.NONE);
		lblmatDos.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblmatDos.setText("Matérieaux dos");
		

		//
		tableComboViewer_matdos = new TableComboViewer(this, SWT.READ_ONLY | SWT.BORDER);
		tableComboViewer_matdos.getTableCombo().setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableComboViewer_matdos.getTableCombo().setShowTableHeader(true);
		tableComboViewer_matdos.getTableCombo().defineColumns(new String[] { "Texture", "Epaisseur" });

		tableComboViewer_matdos.getTableCombo().setDisplayColumnIndex(0);
		tableComboViewer_matdos.getTableCombo().getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		// do not allow editable
		tableComboViewer_matdos.getTableCombo().setEditable(false);
		// set the content provider
		tableComboViewer_matdos.setContentProvider(ArrayContentProvider.getInstance());
		
		// set the label provider
		tableComboViewer_matdos.setLabelProvider(new SingleImageItemLabelProvider(this));

		// load the data
		tableComboViewer_matdos.setInput(modelprovider.getMateriallist());
		
		lblMatrieauxFacade = new Label(this, SWT.NONE);
		lblMatrieauxFacade.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblMatrieauxFacade.setText("Matérieaux facade");
		
		tableComboViewer_matfacade = new TableComboViewer(this, SWT.BORDER);
		tableComboViewer_matfacade.getTableCombo().setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableComboViewer_matfacade.getTableCombo().setShowTableHeader(true);
		tableComboViewer_matfacade.getTableCombo().defineColumns(new String[] { "Texture", "Epaisseur" });

		tableComboViewer_matfacade.getTableCombo().setDisplayColumnIndex(0);
		tableComboViewer_matfacade.getTableCombo().getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		// do not allow editable
		tableComboViewer_matfacade.getTableCombo().setEditable(false);
		// set the content provider
		tableComboViewer_matfacade.setContentProvider(ArrayContentProvider.getInstance());
		
		// set the label provider
		tableComboViewer_matfacade.setLabelProvider(new SingleImageItemLabelProvider(this));

		// load the data
		tableComboViewer_matfacade.setInput(modelprovider.getMateriallist());
		
		
		Label lblhauteur = new Label(this, SWT.NONE);
		lblhauteur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblhauteur.setText("Hauteur");
		
		spnhauteur = new Spinner(this, SWT.BORDER);
		spnhauteur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		spnhauteur.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		spnhauteur.setMaximum(1000000);
		
		Label lblprofondeur = new Label(this, SWT.NONE);
		lblprofondeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblprofondeur.setText("Profondeur");
		
		spnprofondeur = new Spinner(this, SWT.BORDER);
		spnprofondeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		spnprofondeur.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		spnprofondeur.setMaximum(1000000);
		
		lblLongeur = new Label(this, SWT.NONE);
		lblLongeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblLongeur.setText("Longeur");
		
		spnlonguer = new Spinner(this, SWT.BORDER);
		spnlonguer.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		spnlonguer.setMaximum(1000000);
		spnlonguer.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		
		btnTiroirgeaux = new Button(this, SWT.RADIO);
		btnTiroirgeaux.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnTiroirgeaux.setText("Tiroir égeaux");
		new Label(this, SWT.NONE);
		
		btnSemiAutomatique = new Button(this, SWT.RADIO);
		btnSemiAutomatique.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnSemiAutomatique.setText("Semi Automatique");
		new Label(this, SWT.NONE);
		
		lblfirstTirroirhight = new Label(this, SWT.NONE);
		lblfirstTirroirhight.setLayoutData(new GridData(SWT.FILL, SWT.TOP, false, false, 1, 1));
		lblfirstTirroirhight.setText("Hauteur premier Tiroir");
		
		spnfirstTirroirhight = new Spinner(this, SWT.BORDER);
		spnfirstTirroirhight.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spnfirstTirroirhight.setMaximum(1000000);
		spnfirstTirroirhight.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		if(creator!=null) {
			m_bindingContext = initDataBindings();
		}
		
	}
	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeTextNameObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(Name);
		IObservableValue nameCreatorObserveValue = BeanProperties.value("name").observe(creator);
		bindingContext.bindValue(observeTextNameObserveWidget, nameCreatorObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionTableComboViewermatprincipale = ViewerProperties.singleSelection().observe(tableComboViewermatprincipale);
		IObservableValue basematerialCreatorObserveValue = BeanProperties.value("basematerial").observe(creator);
		bindingContext.bindValue(observeSingleSelectionTableComboViewermatprincipale, basematerialCreatorObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionTableComboViewer_matdos = ViewerProperties.singleSelection().observe(tableComboViewer_matdos);
		IObservableValue backmaterialCreatorObserveValue = BeanProperties.value("backmaterial").observe(creator);
		bindingContext.bindValue(observeSingleSelectionTableComboViewer_matdos, backmaterialCreatorObserveValue, null, null);
		//
		IObservableValue observeSelectionSpnhauteurObserveWidget = WidgetProperties.widgetSelection().observe(spnhauteur);
		IObservableValue hauteurCreatorObserveValue = BeanProperties.value("hauteur").observe(creator);
		bindingContext.bindValue(observeSelectionSpnhauteurObserveWidget, hauteurCreatorObserveValue, null, null);
		//
		IObservableValue observeSelectionSpnprofondeurObserveWidget = WidgetProperties.widgetSelection().observe(spnprofondeur);
		IObservableValue profondeurCreatorObserveValue = BeanProperties.value("profondeur").observe(creator);
		bindingContext.bindValue(observeSelectionSpnprofondeurObserveWidget, profondeurCreatorObserveValue, null, null);
		//
		IObservableValue observeSelectionSpnlonguerObserveWidget = WidgetProperties.widgetSelection().observe(spnlonguer);
		IObservableValue longeurCreatorObserveValue = BeanProperties.value("longeur").observe(creator);
		bindingContext.bindValue(observeSelectionSpnlonguerObserveWidget, longeurCreatorObserveValue, null, null);
		//
		IObservableValue observeSelectionSpnTiroirCountObserveWidget = WidgetProperties.widgetSelection().observe(spnTiroirCount);
		IObservableValue tirroirCountCreatorObserveValue = BeanProperties.value("tirroirCount").observe(creator);
		bindingContext.bindValue(observeSelectionSpnTiroirCountObserveWidget, tirroirCountCreatorObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnTiroirgeauxObserveWidget = WidgetProperties.widgetSelection().observe(btnTiroirgeaux);
		IObservableValue tirroirsEqualsCreatorObserveValue = BeanProperties.value("tirroirsEquals").observe(creator);
		bindingContext.bindValue(observeSelectionBtnTiroirgeauxObserveWidget, tirroirsEqualsCreatorObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnSemiAutomatiqueObserveWidget = WidgetProperties.widgetSelection().observe(btnSemiAutomatique);
		IObservableValue semiAutoCreatorObserveValue = BeanProperties.value("semiAuto").observe(creator);
		bindingContext.bindValue(observeSelectionBtnSemiAutomatiqueObserveWidget, semiAutoCreatorObserveValue, null, null);
		//
		IObservableValue observeSelectionSpnfirsttiroirheightObserveWidget = WidgetProperties.widgetSelection().observe(spnfirstTirroirhight);
		IObservableValue firstTirroirhightCreatorObserveValue = BeanProperties.value("firstTirroirhight").observe(creator);
		bindingContext.bindValue(observeSelectionSpnfirsttiroirheightObserveWidget, firstTirroirhightCreatorObserveValue, null, null);
		//
		IObservableValue observeVisibleSpnfirstTirroirhightObserveWidget = WidgetProperties.visible().observe(spnfirstTirroirhight);
		bindingContext.bindValue(observeVisibleSpnfirstTirroirhightObserveWidget, semiAutoCreatorObserveValue, null, null);
		//
		IObservableValue observeEnabledSpnfirstTirroirhightObserveWidget = WidgetProperties.enabled().observe(spnfirstTirroirhight);
		bindingContext.bindValue(observeEnabledSpnfirstTirroirhightObserveWidget, semiAutoCreatorObserveValue, null, null);
		//
		IObservableValue observeVisibleLblHObserveWidget = WidgetProperties.visible().observe(lblfirstTirroirhight);
		bindingContext.bindValue(observeVisibleLblHObserveWidget, semiAutoCreatorObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionTableComboViewer_matfacade = ViewerProperties.singleSelection().observe(tableComboViewer_matfacade);
		IObservableValue facadeMaterialCreatorObserveValue = BeanProperties.value("facadeMaterial").observe(creator);
		bindingContext.bindValue(observeSingleSelectionTableComboViewer_matfacade, facadeMaterialCreatorObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionCbViewerTiroirType = ViewerProperties.singleSelection().observe(cbViewerTiroirType);
		IObservableValue tiroirTypeCreatorObserveValue = BeanProperties.value("tiroirType").observe(creator);
		bindingContext.bindValue(observeSingleSelectionCbViewerTiroirType, tiroirTypeCreatorObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionCbViewerFacadeType = ViewerProperties.singleSelection().observe(cbViewerFacadeType);
		IObservableValue facadetypeCreatorObserveValue = BeanProperties.value("facadetype").observe(creator);
		bindingContext.bindValue(observeSingleSelectionCbViewerFacadeType, facadetypeCreatorObserveValue, null, null);
		//
		return bindingContext;
	}
}
