package dressing.handlers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

import javax.inject.Inject;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

import dressing.model.Kitchen;
import dressing.model.ProjectManager;
import dressing.model.persistence.mappers.MapperProvider;
import jakarta.xml.bind.JAXBException;
import modeljtree.ModelTree;
import modeljtree.TransformCadToCoup;

public class ExportKitchentoSuperCoupe {
	@Inject
	IEclipseContext  eclipsecontext;
	
	 String extension="scp2d";

	@Execute
	public void execute(Shell shell) {
		Kitchen kitchen =ProjectManager.getManager().getCurrentKitchen();
		ModelTree modele_tree=TransformCadToCoup.transformcuisineToModelTree(kitchen);
		
		FileDialog dialog = new FileDialog(shell,SWT.SAVE);
		dialog.setFilterExtensions(new String[] {extension});
		Preferences preferences = InstanceScope.INSTANCE.getNode("com.dressing");
		Preferences projectpref = preferences.node("project3d");
		String defaultpath=projectpref.get("directory", System.getProperty("user.home") + File.separator + "Desktop");
		String dirpath = projectpref.get("directoryWrite", defaultpath);
		
		dialog.setFilterPath(dirpath);
		String filepath = dialog.open();
		if(filepath!=null && !filepath.isEmpty())
		{
			
		      
			try {
				filepath +="."+extension;
				 File f = new File(filepath);
				 if(f.getParent()!=null)
				 {	
					 dirpath = f.getParent();
					 projectpref.put("directoryWrite", dirpath);
					 projectpref.flush();
					 savexml(filepath, modele_tree);
					 MessageDialog.openInformation(shell, "Success", "Cuisine exporté avec succèes");
				 }
				
			} catch (IOException |BackingStoreException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				MessageDialog.openInformation(shell, "Error", "il ya un problème dans l'exportation du cuisine");

			} 

		}
		
		
		
		
//		ExportModelXml exportModelXml = new ExportModelXml(modele_tree, "fedy test","");
//	    exportModelXml.ExportmodelTree();
	}

	private void savexml(String fichier,ModelTree modelTree) throws FileNotFoundException, IOException {
		File file = new File(fichier);
		MapperProvider.getXmlMapper().write(modelTree, file); 
	}
	@CanExecute
	public boolean canExecute() {
		return true;
	}
}
