package api.ui;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import api.event.EventBus;
import api.event.EventType;
import api.event.MepEvent;
import api.graphics.ModelInstance;
import api.input.MouseEventHandler;
import api.mep.ObjectSelector;

public class RightClickMenuManager implements MouseEventHandler{

	private Object target;
	private Shell parent;
	private Menu contextMenu;
	//components
	private MenuItem orthoProject;
	private MenuItem hideElement;
	private static RightClickMenuManager manager;
	
	private RightClickMenuManager() {}
	
	public void create(Shell parent) {
		contextMenu = new Menu(parent, SWT.POP_UP);
		orthoProject = new MenuItem(contextMenu, SWT.PUSH);
		orthoProject.setText("isoler");
		orthoProject.addListener(SWT.Selection, (e) -> {
			HashMap<String, Object> details = new HashMap<String, Object>();
			details.put("ortho", target);
			EventBus.getInstance().notify(new MepEvent(EventType.ORTHO_PROJECTION, details));
		});
		
		hideElement = new MenuItem(contextMenu, SWT.PUSH);
		hideElement.setText("cacher");
		hideElement.addListener(SWT.Selection, (e) -> {
			HashMap<String, Object> details = new HashMap<String, Object>();
			ArrayList<ModelInstance> elements = new ArrayList<ModelInstance>();
			elements.add((ModelInstance) target);
			details.put("elements", elements);
			EventBus.getInstance().notify(new MepEvent(EventType.HIDE_ELEMENT, details));
		});
	}

	public void displayForFaces(int x, int y) {}

	@Override
	public boolean mouseDoubleClick(MouseEvent e) {
		return false;
	}

	@Override
	public boolean mouseDown(MouseEvent e) {
		if(e.button == 3) {
			target = ObjectSelector.getSelector().getSelection();
			if(target != null) {
				contextMenu.setLocation(e.x, e.y);
				contextMenu.setVisible(true);				
				return true;
			}
		}
		return false;
	}

	@Override
	public boolean mouseUp(MouseEvent e) {
		return false;
	}

	@Override
	public boolean mouseMove(MouseEvent e) {
		return false;
	}

	@Override
	public boolean mouseScrolled(MouseEvent e) {
		return false;
	}

	@Override
	public boolean mouseDragged(MouseEvent e) {
		return false;
	}

	public static RightClickMenuManager getManager() {
		if(manager == null)
			manager = new RightClickMenuManager();
		return manager;
	}
}
