package org.frs.svg;

import java.util.ArrayList;
import java.util.Arrays;
import com.badlogic.gdx.math.*;
import com.badlogic.gdx.utils.GdxNativesLoader;

public class MeshBuilder {
	
	static {
		GdxNativesLoader.load();
	}
	
	private ProjectionCamera camera;
	private ArrayList<Triangle> faces;
	private ArrayList<Triangle> clipped = new ArrayList<Triangle>();
	public static Matrix4 toScreenSpace = new Matrix4(new Vector3(), new Quaternion(), new Vector3(1,1,0));
	public static int index = 0;
	

	
	public void scanMesh(ArrayList<Triangle> faces) {
		if(faces == this.faces) {
			removeNonOverlappingTriangles();
		}
		ArrayList<Triangle> badTriangles = new ArrayList<Triangle>();
		for(Triangle ttt: faces) {
			if(!ttt.cpy().transform(toScreenSpace).isValid())
				badTriangles.add(ttt);
		}
		if(badTriangles.size() >  0) {
			faces.removeAll(badTriangles);
			return;
		}
		boolean end = true;
		for (Triangle face: faces) {
			Triangle inScreenFace = face.cpy().transform(toScreenSpace);
			if(!inScreenFace.isValid())
				continue;
			for(Triangle faceX: faces) {
				if(faceX == face)
					continue;
				Triangle inScreenFaceX = faceX.cpy().transform(toScreenSpace);
				if(!inScreenFaceX.isValid())
					continue;
				if(inScreenFaceX.overlap(inScreenFace)) {
					System.err.println(SvgPrinter.writeTriangle(inScreenFace));
					System.err.println(SvgPrinter.writeTriangle(inScreenFaceX));
					if(inScreenFaceX.equals(inScreenFace)) {
						float d0 = face.getIsocenter().dst(camera.getPosition());
						float d1 = faceX.getIsocenter().dst(camera.getPosition());
						Triangle toRemove = d0<d1?faceX:face;
						faces.remove(toRemove);
						end = false;
						break;
					}
					Triangle[] slices = clip(face, faceX);
					float faceArea = inScreenFace.getArea();
					float faceXArea = inScreenFaceX.getArea();
					Triangle toKeep = faceArea < faceXArea?face:faceX;
					faces.remove(face);
					faces.remove(faceX);
					if(slices == null ) {
						System.out.println("ita7chalna!");
					}else {
						ArrayList<Triangle> subList = new ArrayList<Triangle>();
						subList.addAll(Arrays.asList(slices));
						subList.add(toKeep);
						if(++index < 4000)
							scanMesh(subList);
						faces.addAll(subList);
					}
					end = false;
					break;
				}
			}
			if(!end)
				break;
		}
		if(!end && ++index < 4000)
			scanMesh(faces);

	}
	
	public void removeNonOverlappingTriangles() {
		for(Triangle face: faces) {
			boolean overlaps = false;
			Triangle inScreenFace = face.cpy().transform(toScreenSpace);
			for(Triangle faceX: faces) {
				if(face == faceX)
					continue;
				Triangle inScreenFaceX = faceX.cpy().transform(toScreenSpace);
				if(inScreenFace.overlap(inScreenFaceX)) {
					overlaps = true;
					break;
				}
			}
			if(!overlaps)
				clipped.add(face);
		}
	}
	
	
	public void print() {
		for(Triangle t: faces) {
			System.out.println(SvgPrinter.writeTriangle(t));
		}
	}
	
	private Triangle[] clip(Triangle face, Triangle concurrent) {
		Triangle t0 = face.cpy().transform(new Matrix4(new Vector3(), new Quaternion(), new Vector3(1,1,0)));
		Triangle t1 = concurrent.cpy().transform(new Matrix4(new Vector3(), new Quaternion(), new Vector3(1,1,0)));

		Triangle large = t0.getArea()>t1.getArea()?t0:t1;
		Triangle largeAncestor = large==t0?face:concurrent;
		Triangle small = large==t0?t1:t0;
		Triangle smallAncestor = largeAncestor==face?concurrent:face;
		Triangle[] clips = null;
		if(large.contains(small, true)) {
			clips = triangleInsideTriangle( large, small, largeAncestor, smallAncestor);
		}
		else {
			for(LineSegment edge: small.getEdges()) {
				if(large.contains(edge) || large.isTangent(edge))
					continue;
//				System.err.println("ellotf");
				ArrayList<Vector3> intersection = large.intersect(edge);
 				if(intersection.size() == 1) {
					Vector3 vertexIn = edge.getV0();
					if(large.contains(edge.getV1(), true ))
						vertexIn = edge.getV1();
					clips = vertexInsideTriangle(large, edge, vertexIn, largeAncestor, smallAncestor);
					break;
				}else if(intersection.size() == 2) {
					clips = edgeCutThroughTriangle(large, edge, largeAncestor, smallAncestor);
					break;
				}
			}
		}
		return clips;
	}

	public static Triangle[] edgeCutThroughTriangle(Triangle triangle, LineSegment cut, Triangle ancestor, Triangle cutAncestor) {
		ArrayList<Vector3> cutPoints =  triangle.intersect(cut);
		if(cutPoints.size() !=2)
			return new Triangle[0];
		Vector3 triangleVertex = null;
		if(triangle.hasVertex(cutPoints.get(0)))
			triangleVertex = cutPoints.get(0);
		if(triangle.hasVertex(cutPoints.get(1))) {
			triangleVertex = cutPoints.get(1);
		}
		if(triangleVertex != null) {
			Vector3 secondCutPoint = triangleVertex==cutPoints.get(0)?cutPoints.get(1):cutPoints.get(0);
			ArrayList<Vector3> triangleWings = new  ArrayList<Vector3>();
			triangleWings.addAll(Arrays.asList(triangle.getVertices()));
			for(Vector3 vertex: triangleWings) {
				if(vertex.epsilonEquals(triangleVertex,1)) {
					triangleWings.remove(vertex);
					break;
				}
			}
			Vector3 v = ancestor.getEquivalentVertex(triangleVertex, toScreenSpace);
			Vector3 cutPoint = ancestor.getPointFromGeocentricCoords(triangle.getBarycentricCoords(secondCutPoint));
			Triangle t0 = null;
			try {
				t0 = new Triangle(v, cutPoint, ancestor.getEquivalentVertex(triangleWings.get(0), toScreenSpace), ancestor.getColor());
			}catch (Exception e) {
				System.out.println("ita7chalna!!!");
			}
			 
			Triangle t1 = new Triangle(v, cutPoint, ancestor.getEquivalentVertex(triangleWings.get(1), toScreenSpace), ancestor.getColor());
			
			return new Triangle[] {t0, t1};
		}
		
		LineSegment opposingEdge = null;
		for(LineSegment edge: triangle.getEdges()) {
			if(!(edge.contains(cutPoints.get(0)) || edge.contains(cutPoints.get(1)))) {
				opposingEdge = edge;
				break;
			}
		}
		
		Vector3 c0 = ancestor.getPointFromGeocentricCoords(triangle.getBarycentricCoords( cutPoints.get(0)));
		Vector3 c1 = ancestor.getPointFromGeocentricCoords(triangle.getBarycentricCoords( cutPoints.get(1)));
		Triangle t0, t1, t2;
		LineSegment opposingSeg = ancestor.getEquivalentEdge(opposingEdge, toScreenSpace);
		
		if(opposingSeg.getDirection(false).dot(c0.cpy().sub(c1)) > 0) {
			t0 = new Triangle(opposingSeg.getV0(), opposingSeg.getV1(), c0, ancestor.getColor());
			t1 = new Triangle(c0, c1, opposingSeg.getV0(), ancestor.getColor());
		}else {
			t0 = new Triangle(opposingSeg.getV0(), opposingSeg.getV1(), c0, ancestor.getColor());
			t1 = new Triangle(c0, c1, opposingSeg.getV1(), ancestor.getColor());
		}
		
		Vector3 vr = ancestor.getEquivalentVertex(triangle.getV0(), toScreenSpace);
		if(opposingSeg.startOrEndWith(vr, 0.01f))
				vr = ancestor.getEquivalentVertex(triangle.getV1(), toScreenSpace);
		if(opposingSeg.startOrEndWith(vr, 0.01f))
				vr = ancestor.getEquivalentVertex(triangle.getV2(), toScreenSpace);
		t2 = new Triangle(c0,  c1, vr, ancestor.getColor());
		return new Triangle[] {t0, t1, t2};
	}
	
	public static Triangle[] vertexInsideTriangle(Triangle container, LineSegment seg, Vector3 vertex, Triangle containerAncestor, Triangle vertexAncestor) {
		Vector3 cutPoint = container.intersect(seg).get(0);
		Vector3 a;
		Vector3 b;
		Vector3 c;
		Vector3 x = containerAncestor.getPointFromGeocentricCoords(container.getBarycentricCoords(vertex));
		if(container.hasVertex(cutPoint)) {
			a = containerAncestor.getEquivalentVertex(container.getV0(), toScreenSpace);
			b = containerAncestor.getEquivalentVertex(container.getV1(), toScreenSpace);
			c = containerAncestor.getEquivalentVertex(container.getV2(), toScreenSpace);
			Triangle t0 = new Triangle(x, a, b, containerAncestor.getColor());
			Triangle t1 = new Triangle(x, b, c, containerAncestor.getColor());
			Triangle t2 = new Triangle(x, c, a, containerAncestor.getColor());
			return new Triangle[] {t0, t1, t2};
		}else {
			LineSegment cutEdge = null;
			for(LineSegment edge: container.getEdges()) {
				if(edge.contains(cutPoint)) {
					cutEdge = edge;
					break;
				}
			}
			if(cutEdge == null) {
				System.out.println("error finding intersection point!");
				return null;
			}
			a = containerAncestor.getEquivalentVertex(cutEdge.getV0(), toScreenSpace);
			b = containerAncestor.getEquivalentVertex(cutEdge.getV1(), toScreenSpace);
			c = containerAncestor.getV0().cpy().add(containerAncestor.getV1()).add(containerAncestor.getV2()).sub(a).sub(b);
			Triangle t0 = new Triangle(x, a, c,containerAncestor.getColor());
			Triangle t1 = new Triangle(x, b, c,containerAncestor.getColor());
			Triangle t2 = new Triangle(x, a, cutPoint,containerAncestor.getColor());
			Triangle t3 = new Triangle(x, cutPoint, b,containerAncestor.getColor());
			return new Triangle[] {t0, t1, t2, t3};
		}
	}
	
	public static Triangle[] triangleInsideTriangle(Triangle container, Triangle contained, Triangle containerAncestor, Triangle smallAncestor) {
		
		ArrayList<Triangle> triangles = new ArrayList<Triangle>();
		for(Vector3 vertex: contained.getVertices())
		{
			for(LineSegment edge: container.getEdges()) {
				LineSegment seg1 = new LineSegment(vertex, edge.getV0());
				LineSegment seg2 = new LineSegment(vertex, edge.getV1());
				boolean seg1Cond = (contained.intersect(seg1) == null);
				seg1Cond ^= contained.intersect(seg1).get(0).epsilonEquals(vertex, 0.001f);
				boolean seg2Cond = (contained.intersect(seg2) == null);
				seg2Cond ^= contained.intersect(seg2).get(0).epsilonEquals(vertex);
				
				Vector3 v = container.getBarycentricCoords(vertex);
				v = containerAncestor.getPointFromGeocentricCoords(v);
				
				if(seg1Cond &&  seg2Cond) {
					triangles.add(new Triangle( container.getEquivalentVertex(edge.getV0(), toScreenSpace),
														container.getEquivalentVertex(edge.getV1(), toScreenSpace),
														contained.getEquivalentVertex(vertex, toScreenSpace), container.getColor()));
					
					triangles.add(new Triangle( container.getEquivalentVertex(edge.getV0(), toScreenSpace),
							container.getEquivalentVertex(edge.getV1(), toScreenSpace),
							v, container.getColor()));
					break;
				}
			}
		}
		for(LineSegment edge: contained.getEdges()) {
			for(Vector3 vertex: container.getVertices()) {
				LineSegment seg1 = new LineSegment(edge.getV0(), vertex);
				LineSegment seg2 = new LineSegment(edge.getV1(), vertex);
				
				boolean seg1Cond = (contained.intersect(seg1) == null);
				seg1Cond ^= contained.intersect(seg1).get(0).epsilonEquals(vertex, 0.001f);
				boolean seg2Cond = (contained.intersect(seg2) == null);
				seg2Cond ^= contained.intersect(seg2).get(0).epsilonEquals(vertex);
				
				if(seg1Cond && seg2Cond) {
					triangles.add(new Triangle( contained.getEquivalentVertex(edge.getV0(), toScreenSpace),
							contained.getEquivalentVertex(edge.getV1(), toScreenSpace),
							container.getEquivalentVertex(vertex, toScreenSpace),
							container.getColor()));
				}
			}
		}
		Triangle[] clipped = new Triangle[0];
		triangles.toArray(clipped);
		return clipped;
		
	}
	
	public ProjectionCamera getCamera() {
		return camera;
	}

	public void setCamera(ProjectionCamera camera) {
		this.camera = camera;
	}

	public ArrayList<Triangle> getFaces() {
		return faces;
	}

	public void setFaces(ArrayList<Triangle> faces) {
		this.faces = faces;
	}
	
	public ArrayList<Triangle> getClipped() {
		return clipped;
	}

	public void setClipped(ArrayList<Triangle> clipped) {
		this.clipped = clipped;
	}

	//test functions
	public static void oneVertexInsideOther() {
		Vector3 a = new Vector3(342.39444f,250.14374f,-8.40242f);
		Vector3 b = new Vector3(345.12634f,244.78036f,0.0f);
		Vector3 c = new Vector3(339.4602f,210.32022f,-8.066323f);
		Vector3 d = new Vector3(342.39444f,250.14372f,-7.426139f);
		Vector3 e = new Vector3(339.9937f,217.56084f,-7.239903f);
		Vector3 f = new Vector3(351.19724f,232.86183f,-7.2127438f);
						
		Triangle t0 = new Triangle(a, b, c, new Vector3(0,1,0));		
		Triangle t1 = new Triangle(d, e, f, new Vector3(1,0,0));
		
		float a0 = t0.getArea();
		float a1 = t1.getArea();
		
		System.out.println(Math.min(a0, a1));
		
		ProjectionCamera camera = new ProjectionCamera(1, 60, 720/480, 720);
		camera.setPosition(new Vector3(0,0,20));
		
		MeshBuilder builder = new MeshBuilder();
		ArrayList<Triangle> triangles = new ArrayList<Triangle>();
		triangles.add(t0);
		triangles.add(t1);
		builder.setFaces(triangles);
		builder.setCamera(camera);
		builder.scanMesh(triangles);
		System.out.println("results!");
		builder.print();
	}
	
	public static void main(String...args) {
		oneVertexInsideOther();
	}


}
