package dressing.ui.project;

import java.io.File;
import java.time.LocalDateTime;
import java.util.ArrayList;

import javax.inject.Inject;

import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

import dressing.io.IOUtilities;
import dressing.model.ProjectManager;
import dressing.model.SuperCadProject;

public class ProjectComposite extends Composite{
	
	
	private Text text;
	private Table table;
	private SuperCadProject[] projectlist;
	private SuperCadProject project;
	@Inject
	private IEventBroker eventBroker;
	TableViewer tableViewer;
	String[] types= {"Cuisine", "Dressing","Tous"}; 
	String[] columns= {"Nom", "Client","Commercial","Site","Date","Type"}; 

	String filterText="";
	ViewerFilter searchFilter;
	ComboViewer comboViewer;
	ComboViewer comboViewer_1;
	ViewerComparator columnNameSorter;
	ViewerComparator columnDateSorter;
	ViewerComparator columnTypeSorter;
	ViewerComparator columnSiteSorter;
	ViewerComparator columnClientSorter;
	ViewerComparator columnCommercialSorter;
	
	TableViewerColumn tblViewerClmnName;
	TableViewerColumn tblViewerClmnSite;
	TableViewerColumn tblViewerClmnCommercial;
	TableViewerColumn tblViewerClmnClt;
	TableViewerColumn tblViewerClmnDate;
	TableViewerColumn tblclmnViewerType;
	int[] sortDirections= {SWT.DOWN,SWT.UP};
	int sortdirection= SWT.DOWN;
	int index=0;
	Object sorterSelection=null;
	public ProjectComposite(Composite parent, int style) {
		super(parent, style);
		setLayout(new GridLayout(1, false));
		
		Composite composite = new Composite(this, SWT.NONE);
		composite.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 1, 1));
		composite.setLayout(new FillLayout(SWT.HORIZONTAL));
		
		Group grpSalesman = new Group(composite, SWT.NONE);
		grpSalesman.setText("Type");
		grpSalesman.setLayout(new FillLayout(SWT.HORIZONTAL));
		
		comboViewer = new ComboViewer(grpSalesman);
		Combo combo = comboViewer.getCombo();
		comboViewer.setContentProvider(ArrayContentProvider.getInstance());
		comboViewer.setSelection(new StructuredSelection(types[0]), true);
		comboViewer.setInput(types);
		final ISelection selection = new StructuredSelection(types[2]);

		comboViewer.setSelection(selection);
		comboViewer.addSelectionChangedListener(new ISelectionChangedListener() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				// TODO Auto-generated method stub
				tableViewer.refresh();
			}
		});
		Group grpSortBy = new Group(composite, SWT.NONE);
		grpSortBy.setText("Trier par");
		grpSortBy.setLayout(new FillLayout(SWT.HORIZONTAL));
		
		comboViewer_1 = new ComboViewer(grpSortBy);
		Combo combo_1 = comboViewer_1.getCombo();
		comboViewer_1.setContentProvider(ArrayContentProvider.getInstance());
		
				comboViewer_1.setInput(columns);
				comboViewer_1.setSelection(new StructuredSelection(columns[0]));
				comboViewer_1.addSelectionChangedListener(new ISelectionChangedListener() {


					@Override
					public void selectionChanged(SelectionChangedEvent event) {
						Object object = comboViewer_1.getStructuredSelection().getFirstElement();
						if (sorterSelection == null || object == null || object != sorterSelection) {
							index = 0;
						} else {
							index++;
						}
						if (object != null && object instanceof String) {
							String key = (String) object;
							sortdirection = sortDirections[index % 2];
							table.setSortDirection(sortdirection);

							switch (key) {
							case "Nom":
//								columnNameSorter.sort(tableViewer, (Object[]) tableViewer.getInput());;
								table.setSortColumn(tblViewerClmnName.getColumn());
//								table.setSortDirection( SWT.DOWN );
								tableViewer.setComparator(columnNameSorter);
								break;
							case "Client":
//								columnClientSorter.sort(tableViewer, (Object[]) tableViewer.getInput());;
								table.setSortColumn(tblViewerClmnClt.getColumn());
								tableViewer.setComparator(columnClientSorter);
								break;
							case "Commercial":
//								columnCommercialSorter.sort(tableViewer, (Object[]) tableViewer.getInput());;
								table.setSortColumn(tblViewerClmnCommercial.getColumn());
								tableViewer.setComparator(columnCommercialSorter);
								break;
							case "Site":
//								columnSiteSorter.sort(tableViewer, (Object[]) tableViewer.getInput());;
								table.setSortColumn(tblViewerClmnSite.getColumn());
								tableViewer.setComparator(columnSiteSorter);
								break;
							case "Date":
//								columnDateSorter.sort(tableViewer, (Object[]) tableViewer.getInput());;
								table.setSortColumn(tblViewerClmnDate.getColumn());
								tableViewer.setComparator(columnDateSorter);
								break;
							case "Type":
//								columnTypeSorter.sort(tableViewer, (Object[]) tableViewer.getInput());;
								table.setSortColumn(tblclmnViewerType.getColumn());
								tableViewer.setComparator(columnTypeSorter);
								break;
							default:
								break;
							}
							tableViewer.refresh();

						}

						sorterSelection = object;
					}
				});
				
		Group grpSerach = new Group(composite, SWT.NONE);
		grpSerach.setText("Reserche");
		grpSerach.setLayout(new FillLayout(SWT.HORIZONTAL));
		
		text = new Text(grpSerach, SWT.BORDER);
		text.addKeyListener(new KeyListener() {
			
			@Override
			public void keyReleased(KeyEvent e) {
				filterText=text.getText();
				tableViewer.refresh();
			}
			
			@Override
			public void keyPressed(KeyEvent e) {
				// TODO Auto-generated method stub
				
			}
		});
		Composite composite_1 = new Composite(this, SWT.NONE);
		composite_1.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		composite_1.setLayout(new FillLayout(SWT.HORIZONTAL));
		
		Group grpListeDesProjets = new Group(composite_1, SWT.NONE);
		grpListeDesProjets.setLayout(new FillLayout(SWT.HORIZONTAL));
		grpListeDesProjets.setText("Liste des projets");
		
		tableViewer = new TableViewer(grpListeDesProjets, SWT.BORDER | SWT.FULL_SELECTION);
		table = tableViewer.getTable();
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		table.addKeyListener(new KeyListener() {
			
			@Override
			public void keyReleased(KeyEvent e) {
				
			}
			
			@Override
			public void keyPressed(KeyEvent e) {
				if(e.keyCode == 127) {
					MessageDialog dialog = new MessageDialog(parent.getShell(), "Warning", null,
					    "voulez vous vraiment suprimer le projet de votre disque!", MessageDialog.WARNING, new String[] { "OK",
					    "Cancel" }, 1);
					if(dialog.open() == 0) {
						Object selection = table.getSelection()[0].getData();
						if(selection instanceof SuperCadProject) {
							File dir = new File(((SuperCadProject)selection).getProjectDirectory());
							IOUtilities.deleteFolder(dir);
							table.remove(table.getSelectionIndex());
						}
					}
				}
			}
			
		});
		
		
		tblViewerClmnName = new TableViewerColumn(tableViewer, SWT.NONE);
		columnNameSorter =new ViewerComparator() {

			@Override
			public int compare(Viewer viewer, Object e1, Object e2) {
				String obj1=((SuperCadProject) e1).getName();
				String obj2=((SuperCadProject) e2).getName();
				if(sortdirection==SWT.DOWN) {
					if (obj1 == obj2) {
				        return 0;
				    }
				    if (obj1 == null) {
				        return -1;
				    }
				    if (obj2 == null) {
				        return 1;
				    }
				    
				    return obj1.compareTo(obj2);
				}else {
					if (obj1 == obj2) {
				        return 0;
				    }
				    if (obj1 == null) {
				        return 1;
				    }
				    if (obj2 == null) {
				        return -1;
				    }
				    
				    return obj2.compareTo(obj1);	
				}
			}
			
		};
		TableColumn tblclmnNomProjet = tblViewerClmnName.getColumn();
		tblclmnNomProjet.setMoveable(true);
		tblclmnNomProjet.setWidth(71);
		tblclmnNomProjet.setText("Nom projet");
		
		tblViewerClmnName.setLabelProvider(new ColumnLabelProvider() {
			@Override
			public String getText(Object element) {
				if(element instanceof SuperCadProject)
					return ((SuperCadProject)element).getName();
				return "undefined";
			}
		});
		
		tblViewerClmnSite = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnSite = tblViewerClmnSite.getColumn();
		tblclmnSite.setMoveable(true);
		tblclmnSite.setWidth(52);
		tblclmnSite.setText("Site");
		tblViewerClmnSite.setLabelProvider(new ColumnLabelProvider() {
			@Override
			public String getText(Object element) {
				if(element instanceof SuperCadProject)
					return ((SuperCadProject)element).getSite();
				return "undefined";
			}
		});
		tblViewerClmnClt = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnClient = tblViewerClmnClt.getColumn();
		tblclmnClient.setMoveable(true);
		tblclmnClient.setWidth(44);
		tblclmnClient.setText("Client");
		tblViewerClmnClt.setLabelProvider(new ColumnLabelProvider() {
			@Override
			public String getText(Object element) {
				if(element instanceof SuperCadProject)
					return ((SuperCadProject)element).getClient();
				return "undefined";
			}
		});
		tblViewerClmnCommercial = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnCommercial = tblViewerClmnCommercial.getColumn();
		tblclmnCommercial.setMoveable(true);
		tblclmnCommercial.setWidth(100);
		tblclmnCommercial.setText("Commercial");
		tblViewerClmnCommercial.setLabelProvider(new ColumnLabelProvider() {
			@Override
			public String getText(Object element) {
				if(element instanceof SuperCadProject)
					return ((SuperCadProject)element).getCommercial();
				return "undefined";
			}
		});
		tblViewerClmnDate = new TableViewerColumn(tableViewer, SWT.NONE);
		columnDateSorter = new ViewerComparator() {
			@Override
			public int compare(Viewer viewer, Object e1, Object e2) {
				LocalDateTime obj1=((SuperCadProject) e1).getCreationDate();
				LocalDateTime obj2=((SuperCadProject) e2).getCreationDate();

				if(sortdirection==SWT.DOWN) {
					if (obj1 == obj2) {
				        return 0;
				    }
				    if (obj1 == null) {
				        return -1;
				    }
				    if (obj2 == null) {
				        return 1;
				    }
				    
				    return obj1.compareTo(obj2);
				}else {
					if (obj1 == obj2) {
				        return 0;
				    }
				    if (obj1 == null) {
				        return 1;
				    }
				    if (obj2 == null) {
				        return -1;
				    }
				    
				    return obj2.compareTo(obj1);	
				}
			}
			
		};
		TableColumn tblclmnDateDeCration = tblViewerClmnDate.getColumn();
		tblclmnDateDeCration.setMoveable(true);
		tblclmnDateDeCration.setWidth(79);
		tblclmnDateDeCration.setText("Date de création");
		
		tblViewerClmnDate.setLabelProvider(new ColumnLabelProvider() {

			@Override
			public String getText(Object element) {
				if(element instanceof SuperCadProject)
					return ((SuperCadProject)element).getCreationDate().toString();
				return "undefined";
			}
			
		});
		
		tblclmnViewerType = new TableViewerColumn(tableViewer, SWT.NONE);
		columnTypeSorter = new ViewerComparator() {
			@Override
			public int compare(Viewer viewer, Object e1, Object e2) {
				String obj1=((SuperCadProject) e1).getType().name();
				String obj2=((SuperCadProject) e2).getType().name();

				if(sortdirection==SWT.DOWN) {
					if (obj1 == obj2) {
				        return 0;
				    }
				    if (obj1 == null) {
				        return -1;
				    }
				    if (obj2 == null) {
				        return 1;
				    }
				    
				    return obj1.compareTo(obj2);
				}else {
					if (obj1 == obj2) {
				        return 0;
				    }
				    if (obj1 == null) {
				        return 1;
				    }
				    if (obj2 == null) {
				        return -1;
				    }
				    
				    return obj2.compareTo(obj1);	
				}
			}
			
		};
		columnClientSorter =new ViewerComparator() {
			@Override
			public int compare(Viewer viewer, Object e1, Object e2) {
				String obj1=((SuperCadProject) e1).getClient();
				String obj2=((SuperCadProject) e2).getClient();

				if(sortdirection==SWT.DOWN) {
					if (obj1 == obj2) {
				        return 0;
				    }
				    if (obj1 == null) {
				        return -1;
				    }
				    if (obj2 == null) {
				        return 1;
				    }
				    
				    return obj1.compareTo(obj2);
				}else {
					if (obj1 == obj2) {
				        return 0;
				    }
				    if (obj1 == null) {
				        return 1;
				    }
				    if (obj2 == null) {
				        return -1;
				    }
				    
				    return obj2.compareTo(obj1);	
				}
			}
			
		};
		columnCommercialSorter =new ViewerComparator() {
			@Override
			public int compare(Viewer viewer, Object e1, Object e2) {
				String obj1=((SuperCadProject) e1).getCommercial();
				String obj2=((SuperCadProject) e2).getCommercial();

				if(sortdirection==SWT.DOWN) {
					if (obj1 == obj2) {
				        return 0;
				    }
				    if (obj1 == null) {
				        return -1;
				    }
				    if (obj2 == null) {
				        return 1;
				    }
				    
				    return obj1.compareTo(obj2);
				}else {
					if (obj1 == obj2) {
				        return 0;
				    }
				    if (obj1 == null) {
				        return 1;
				    }
				    if (obj2 == null) {
				        return -1;
				    }
				    
				    return obj2.compareTo(obj1);	
				}
			}
			
		};
		tableViewer.setComparator(columnDateSorter);
		columnSiteSorter =new ViewerComparator() {
			@Override
			public int compare(Viewer viewer, Object e1, Object e2) {
				String obj1=((SuperCadProject) e1).getSite();
				String obj2=((SuperCadProject) e2).getSite();

				if(sortdirection==SWT.DOWN) {
					if (obj1 == obj2) {
				        return 0;
				    }
				    if (obj1 == null) {
				        return -1;
				    }
				    if (obj2 == null) {
				        return 1;
				    }
				    
				    return obj1.compareTo(obj2);
				}else {
					if (obj1 == obj2) {
				        return 0;
				    }
				    if (obj1 == null) {
				        return 1;
				    }
				    if (obj2 == null) {
				        return -1;
				    }
				    
				    return obj2.compareTo(obj1);	
				}
			}
			
		};
		TableColumn tblclmnType = tblclmnViewerType.getColumn();
		tblclmnType.setMoveable(true);
		tblclmnType.setWidth(41);
		tblclmnType.setText("Type");
		
		tblclmnViewerType.setLabelProvider(new ColumnLabelProvider() {
			@Override
			public String getText(Object element) {
				if(element instanceof SuperCadProject)
					return ((SuperCadProject)element).getType().toString();
				return "undefined";
			}
			
		});
		ArrayList<SuperCadProject> projects = (ArrayList<SuperCadProject>) ProjectManager.getManager().getProjects();
		searchFilter = createListFilter();

		tableViewer.setContentProvider(ArrayContentProvider.getInstance());
		tableViewer.setInput(projects);
		tableViewer.addFilter(searchFilter);
		ControlAdapter cal= new ControlAdapter() {
			
		    public void controlResized(ControlEvent e) {
		    	
		      org.eclipse.swt.graphics.Rectangle area = grpListeDesProjets.getClientArea();
		      org.eclipse.swt.graphics.Point preferredSize = table.computeSize(SWT.DEFAULT, SWT.DEFAULT);
		      int width = area.width ;
		      if (preferredSize.y > area.height + table.getHeaderHeight()) {
		        // Subtract the scrollbar width from the total column width
		        // if a vertical scrollbar will be required
		        org.eclipse.swt.graphics.Point vBarSize = table.getVerticalBar().getSize();
		        width -= vBarSize.x;
		      }
		      org.eclipse.swt.graphics.Point oldSize = table.getSize();
		      if (oldSize.x > area.width) {
		        // table is getting smaller so make the columns 
		        // smaller first and then resize the table to
		        // match the client area width
		    	int columnWidth=(width)/6;
		        tblclmnNomProjet.setWidth(columnWidth);
		        tblclmnClient.setWidth(columnWidth);
		        tblclmnCommercial.setWidth(columnWidth);
		        tblclmnDateDeCration.setWidth(columnWidth);
		        tblclmnSite.setWidth(columnWidth);
		        tblclmnType.setWidth(columnWidth);
		        table.setSize(area.width, area.height);
		      } else {
		        // table is getting bigger so make the table 
		        // bigger first and then make the columns wider
		        // to match the client area width
		    	int columnWidth=(width)/6;
		        table.setSize(area.width, area.height);
		        tblclmnNomProjet.setWidth(columnWidth);
		        tblclmnClient.setWidth(columnWidth);
		        tblclmnCommercial.setWidth(columnWidth);
		        tblclmnDateDeCration.setWidth(columnWidth);
		        tblclmnSite.setWidth(columnWidth);
		        tblclmnType.setWidth(columnWidth);
		      }
		    }};
		
		  
		grpListeDesProjets.addControlListener(cal);
		this.addControlListener(cal);
		table.addControlListener(cal);
	}

	public ViewerFilter createListFilter() {
		return new ViewerFilter() {
			@Override
			public boolean select(Viewer arg0, Object parantElement, Object element) {
				SuperCadProject project =((SuperCadProject) element);
				String name =project.getName();
				String client =project.getClient();
				String commercial =project.getCommercial();
				String site =project.getSite();

				boolean iscontainTxtFilter = filterText.equals("")
						||(name!=null&& name.toUpperCase().contains(filterText.toUpperCase()))
						||(client!=null&& client.toUpperCase().contains(filterText.toUpperCase()))
						||(commercial!=null&& commercial.toUpperCase().contains(filterText.toUpperCase()))
						|| (site!=null&& site.toUpperCase().contains(filterText.toUpperCase()));
				String type=(String) comboViewer.getStructuredSelection().getFirstElement();
				
				boolean istype=type=="Tous"?true:type.contentEquals(((SuperCadProject) element).getType().toString());
				
				if (iscontainTxtFilter && istype ) {
					return true;
				}

				return false;
			}
		};
	}
	
	public SuperCadProject[] getProjectlist() {
		return projectlist;
	}

	public void setProjectlist(SuperCadProject[] projectlist) {
		this.projectlist = projectlist;
	}
	public SuperCadProject getProject() {
		return project;
	}
	public void setProject(SuperCadProject project) {
		this.project = project;
	}

	public TableViewer getTableViewer() {
		return tableViewer;
	}

	
}
