package dressing.ui.porte;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import dressing.model.ModelProvider;
import dressing.model.types.PortType;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.LabelProvider;
import dressing.controller.PorteCreator;
import dressing.model.Materiaux;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;

public class PorteCompositeWizard extends Composite {

	private DataBindingContext m_bindingContext;
	private PorteCreator porteCreator=new PorteCreator();
	private ComboViewer comboViewertypePorte;
	private ModelProvider modelprovider = new ModelProvider();
	private ComboViewer comboViewer_matporte;
	public PorteCompositeWizard(Composite parent, int style, PorteCreator newportefactory) {
		this(parent, style);
		setPorteCreator(newportefactory);
	}

	public PorteCompositeWizard(Composite parent, int style) {
		super(parent, style);
		setLayout(new GridLayout(1, false));
		
		Group grpPorte = new Group(this, SWT.NONE);
		grpPorte.setText("Porte");
		grpPorte.setLayout(new GridLayout(2, false));
		GridData gd_grpPorte = new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1);
		gd_grpPorte.heightHint = 97;
		gd_grpPorte.widthHint = 440;
		grpPorte.setLayoutData(gd_grpPorte);
		
		Label lblTypeDePorte = new Label(grpPorte, SWT.NONE);
		lblTypeDePorte.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblTypeDePorte.setText("Type de porte");
		
		comboViewertypePorte = new ComboViewer(grpPorte, SWT.READ_ONLY);
		Combo combo = comboViewertypePorte.getCombo();
		combo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblMarieuax = new Label(grpPorte, SWT.NONE);
		lblMarieuax.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblMarieuax.setText("Matérieaux");
		
		comboViewer_matporte = new ComboViewer(grpPorte, SWT.READ_ONLY);
		Combo combo_matporte = comboViewer_matporte.getCombo();
		combo_matporte.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		comboViewertypePorte.setContentProvider((ArrayContentProvider.getInstance()));
		comboViewertypePorte.setInput(PortType.values());

		comboViewer_matporte.setLabelProvider(new LabelProvider() {
		     @Override
		     public String getText(Object element) {
		         if (element instanceof Materiaux) {
		        	 Materiaux mat = (Materiaux) element;
		             return mat.getName();
		         }
		         return super.getText(element);
		     }
		 });
		comboViewer_matporte.setContentProvider((ArrayContentProvider.getInstance()));
		comboViewer_matporte.setInput(ModelProvider.getMateriallist());
		if (porteCreator != null) {
			m_bindingContext = initDataBindings();
		}
	}

	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}

	public PorteCreator getPorteCreator() {
		return porteCreator;
	}

	public void setPorteCreator(PorteCreator porteCreator) {
		setPorteCreator(porteCreator,true);
	}
	public void setPorteCreator(PorteCreator newporteCreator, boolean update) {
		porteCreator = newporteCreator;
		if (update) {
			if (m_bindingContext != null) {
				m_bindingContext.dispose();
				m_bindingContext = null;
			}
			if (porteCreator != null) {
				m_bindingContext = initDataBindings();
			}
		}
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeSingleSelectionComboViewer = ViewerProperties.singleSelection().observe(comboViewertypePorte);
		IObservableValue porteTypePorteCreatorObserveValue = BeanProperties.value("porteType").observe(porteCreator);
		bindingContext.bindValue(observeSingleSelectionComboViewer, porteTypePorteCreatorObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionComboViewer_matporte = ViewerProperties.singleSelection().observe(comboViewer_matporte);
		IObservableValue materialPorteCreatorObserveValue = BeanProperties.value("material").observe(porteCreator);
		bindingContext.bindValue(observeSingleSelectionComboViewer_matporte, materialPorteCreatorObserveValue, null, null);
		//
		return bindingContext;
	}
}