package dressing.ui.parts;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.inject.Named;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.PrinterResolution;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.services.IServiceConstants;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.e4.ui.workbench.modeling.ISelectionListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.widgets.Composite;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.ImageComponent;
import org.jogamp.java3d.ImageComponent2D;
import org.jogamp.java3d.Screen3D;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.utils.geometry.ColorCube;
import org.jogamp.java3d.utils.universe.SimpleUniverse;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Vector3d;
import org.naanab.JPrintPreview.JPrintPreviewPane;

import dressing.model.Caisson;
import dressing.model.DesignObject3D;
import dressing.model.Dressing;
import dressing.ui.util.ConversionUtility;
import net.coobird.thumbnailator.Thumbnails;
import tech.frsdev.j3d.ArmoioreCanvasReporting;
import tech.frsdev.j3d.DressingDrawer;
import tech.frsdev.solids.Solide3D;

public class ReportingPart {

	@Inject ESelectionService selectionService;
	PageFormat pageformat = new PageFormat();
	private  int  counter=0;
	 JPanel drawingPanel = new JPanel();
	Solide3D solidparent= null;
	 JPanel scrollpanbe;
	 Pageable  printpages;
	public ReportingPart() {
	}
	/**
	 * Create contents of the view part.
	 */
	@PostConstruct
	public void createControls(Composite parent) {		
		Composite holder = new Composite(parent, SWT.EMBEDDED);
		java.awt.Frame fileTableFrame = SWT_AWT.new_Frame(holder);
	    java.awt.Panel panel = new java.awt.Panel(new java.awt.BorderLayout());
	    fileTableFrame.add(panel);

	    printpages  = new Pageable() {
			
			@Override
			public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
				// TODO Auto-generated method stub

				Printable p = new Printable() {
					
					@Override
					public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
						// TODO Auto-generated method stub
						if(pageIndex==0)
						{
							if(solidparent!=null)
							{
								DressingDrawer drdrawer = new DressingDrawer(solidparent);
								drdrawer.draw((Graphics2D) graphics);			
								return PAGE_EXISTS;
							}
							
						}
						else if(pageIndex>0)
						{
							return NO_SUCH_PAGE;
						}
						try
						{
							Graphics2D g2 = (Graphics2D)graphics;
							g2.setColor(Color.BLACK);
							g2.drawRect(50, 60, 450, 320);
							g2.translate((int)pageformat.getImageableX(), (int)pageformat.getImageableY());						
							g2.drawString("Hello", 100, 100);
							
							ArmoioreCanvasReporting canvasarm = new ArmoioreCanvasReporting(solidparent);
						       // create universe
							Canvas3D canvas  = canvasarm.getCanvas();	
							
							SimpleUniverse simpleU = canvasarm.getUniv();

							 Transform3D         viewingTransform = new Transform3D();
							 TransformGroup viewingTransformGroup= simpleU.getViewingPlatform().getViewPlatformTransform();

							 DesignObject3D parent  = (DesignObject3D) solidparent;
							 double xpos = parent.getXPosABS();
							 double ypos = parent.getYPosABS();
							 double zpos = parent.getZPosABS();
							 
							 float eyeposx = (float) ((2* xpos + parent.getLongeurext())/canvasarm.getRefSize());
							 float eyeposy = (float) ((ypos + 2*  parent.getHauteurext())/canvasarm.getRefSize());
						     viewingTransform.lookAt(new Point3d( eyeposx,eyeposy,2.5f ), new Point3d(eyeposx,eyeposy,0f), new Vector3d(0, 1, 0));
						     viewingTransform.invert();
						     viewingTransformGroup.setTransform(viewingTransform);
						     
						     boolean usepaint=false;
						     if(usepaint)
						     {
						    	 canvas.print(g2);
						     }
						     else 
						     {
//									canvas.getView().setProjectionPolicy(View.PARALLEL_PROJECTION);   //si on veut une projection parelle 

							        // set off screen size
							        Screen3D sOff = canvas.getScreen3D();
							        sOff.setSize(new Dimension(2000,2000));
							        sOff.setPhysicalScreenWidth(3);
							        sOff.setPhysicalScreenHeight(3);
									
							        
							        // render to off screen
							        BufferedImage bImage = new BufferedImage(2000, 2000, BufferedImage.TYPE_INT_ARGB);
							        ImageComponent2D buffer = new ImageComponent2D(ImageComponent.FORMAT_RGBA, bImage);
							        
							      
							        buffer.setCapability(ImageComponent2D.ALLOW_IMAGE_READ);
							        canvas.setOffScreenBuffer(buffer);
							        canvas.renderOffScreenBuffer();
							        canvas.waitForOffScreenRendering();
							        
							        BufferedImage rendredimage= canvas.getOffScreenBuffer().getImage();
							        
//							        AffineTransform t2d = new AffineTransform();
//							        t2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
//							        double xscale = pageFormat.getImageableWidth() / (double) rendredimage.getWidth();
//							        double yscale = pageFormat.getImageableHeight() / (double) rendredimage.getHeight();
//							        double scale = Math.min(xscale, yscale);
//							        t2d.scale(scale, scale);
							        int imhigh = (int)pageFormat.getImageableHeight();
							        BufferedImage scaled = Thumbnails.of(rendredimage).size((int)pageFormat.getImageableHeight(), (int)pageFormat.getImageableHeight()).asBufferedImage();
//							        BufferedImage scaled = ImageUtils.resizewithscalar(rendredimage, (int)pageFormat.getImageableHeight(), (int)pageFormat.getImageableHeight());
							        try {
							        	g2.drawImage(scaled, null, 0,0);
							        } catch (Exception ex) {
							          ex.printStackTrace();
							          return Printable.NO_SUCH_PAGE;
							        }
							        // write to file
							        File output = new File(counter+"imgxY.png");
							        try {
							            ImageIO.write((BufferedImage)rendredimage, "png", output);
							        } catch (IOException e) {
							            e.printStackTrace();
							        }
							        counter++;
								      //must be called to remove the canvass ID from java3d driver 
							        //si ce clean ne se passe pas alors l univers ne peut plus supporter plus que 32 canvass et l'application crashes
							        simpleU.cleanup(); 
							        System.out.println(output.getAbsolutePath());
						     }

						}
						catch(Exception exp)
						{
							exp.printStackTrace();
						}
						if(pageIndex>0)
						{
							return NO_SUCH_PAGE;
						}
						
						return PAGE_EXISTS ;
					}
				};
				return p;
			}
			
			@Override
			public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
				// TODO Auto-generated method stub
				
				Paper paper = new Paper();
		        paper.setImageableArea( ConversionUtility.cmtopixel(0.5),
                        ConversionUtility.cmtopixel(0.5),
                        ConversionUtility.cmtopixel(21),
                        ConversionUtility.cmtopixel(29));

		        paper.setSize(ConversionUtility.cmtopixel(21),    ConversionUtility.cmtopixel(29));

				pageformat.setOrientation(PageFormat.LANDSCAPE);
				pageformat.setPaper(paper);
				
				return pageformat;
			}
			
			@Override
			public int getNumberOfPages() {
				// TODO Auto-generated method stub
				return 1;
			}
		};
	    scrollpanbe = new JPrintPreviewPane(printpages);
	   
		drawingPanel.setLayout(new BorderLayout());
		drawingPanel.setPreferredSize(new Dimension(1000, 800));
		JButton printbtn = new JButton("Print");
		drawingPanel.add(printbtn,"North");
		drawingPanel.add(scrollpanbe,"Center");
	    panel.add(drawingPanel);
	    
	    printbtn.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				// TODO Auto-generated method stub
//				    double cmPx300 = 300.0 / 2.54;
//				    Paper paper = new Paper();
//				    paper.setSize(29.7 * cmPx300,21.3 * cmPx300 );
//				    paper.setImageableArea(0, 29.7 * cmPx300,0, 21.3 * cmPx300 );
//				    PageFormat format = new PageFormat();
//				    format.setOrientation(PageFormat.LANDSCAPE);
//				    format.setPaper(paper);
//				    
		         PrinterJob job = PrinterJob.getPrinterJob();
		         job.setPrintable(printpages.getPrintable(0));
//		         job.setPageable(printpages);
		         boolean ok = job.printDialog();
		         if (ok) {
		             try {
//		                 HashPrintRequestAttributeSet set = new HashPrintRequestAttributeSet();
//		                 PrinterResolution pr = new PrinterResolution((int) (300), (int) (300), ResolutionSyntax.DPI);
//		                 set.add(pr);
		                 
		                 PrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
		                 aset.add(MediaSizeName.ISO_A4);
		                 aset.add(new PrinterResolution(300, 300, PrinterResolution.DPI));
		                 aset.add(new MediaPrintableArea(2, 2, 210 - 4, 297 - 4, MediaPrintableArea.MM));
		                 job.setJobName("Samif");
		                 job.print(aset);
		             } catch (PrinterException ex) {
		              /* The job did not successfully complete */
		            	 ex.printStackTrace();
		             }
		         }
			}
		});

	    selectionService.addSelectionListener("dressing.part.tree",new ISelectionListener() {
			
			@Override
			public void selectionChanged(MPart part, Object selection) {
				// TODO Auto-generated method stub
//				if(selection instanceof Caisson || selection instanceof Dressing)
				if( selection instanceof Dressing || selection instanceof Caisson)
				{
					solidparent  = (Solide3D) selection;
				}
			}
	    });
 

	}

	@PreDestroy
	public void dispose() {
	}

	@Focus
	public void setFocus() {
		// TODO	Set the focus to control
	}
	public void setSelection(@Optional @Named(IServiceConstants.ACTIVE_SELECTION) Dressing contact) {
		  if (contact == null) {
		    /* implementation not shown */
		  } else {
		    /* implementation not shown */
		  }
	}

	
	private void printdemocube(Graphics graphics)
	{
		try
		{
			Graphics2D g2 = (Graphics2D)graphics;
			g2.setColor(Color.BLACK);
			g2.drawRect(50, 60, 450, 320);
			g2.translate((int)pageformat.getImageableX(), (int)pageformat.getImageableY());						
			g2.drawString("Hello", 100, 100);

			Canvas3D canvas = new Canvas3D(SimpleUniverse.getPreferredConfiguration(),true);
			
//			ArmoireCanvas canvas = new ArmoireCanvas(solidparent);
		       // create universe
	        SimpleUniverse simpleU = new SimpleUniverse(canvas);
	        simpleU.getViewingPlatform().setNominalViewingTransform();

	        // create scene
	        BranchGroup scene = new BranchGroup();
	        scene.addChild(new ColorCube(0.4));
	        scene.compile();
	        simpleU.addBranchGraph(scene);



	        // set off screen size
	        Screen3D sOff = canvas.getScreen3D();
	        sOff.setSize(new Dimension(400, 400));
	        sOff.setPhysicalScreenWidth(1);
	        sOff.setPhysicalScreenHeight(1);
	        
	        
	        // render to off screen
	        BufferedImage bImage = new BufferedImage(2400, 2400, BufferedImage.TYPE_INT_ARGB);
	        ImageComponent2D buffer = new ImageComponent2D(ImageComponent.FORMAT_RGBA, bImage);
	        buffer.setCapability(ImageComponent2D.ALLOW_IMAGE_READ);
	        canvas.setOffScreenBuffer(buffer);
	        canvas.renderOffScreenBuffer();
	        canvas.waitForOffScreenRendering();
	        
	        
	        g2.scale(0.3, 0.3);
	        g2.drawImage(canvas.getOffScreenBuffer().getImage(), 0, 0, Color.CYAN, null);
	        g2.scale(1/0.3, 1/0.3);

	        // write to file
	        File output = new File(counter+"imgxY.png");
	        try {
	            ImageIO.write(bImage, "png", output);
	        } catch (IOException e) {
	            e.printStackTrace();
	        }
	        counter++;
		      //must be called to remove the canvass ID from java3d driver 
	        //si ce clean ne se passe pas alors l univers ne peut plus supporter plus que 32 canvass et l'application crashes
	        simpleU.cleanup(); 
	        System.out.println(output.getAbsolutePath());
		}
		catch(Exception exp)
		{
			exp.printStackTrace();
		}
	}
}

