package dressing.ui.design.PublicParam;

import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

import param.MechanicPublicParam;
import param.PublicParamGroup;
import param.TypeDefElement;
import param.impl.MechanicDesignImpl;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.swt.widgets.Text;

import org.eclipse.swt.widgets.Combo;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;

public class PublicParamComposite extends Composite {
	private DataBindingContext m_bindingContext;

	MechanicPublicParam param;
	PublicParamGroup group;
	MechanicDesignImpl design;
	private Text text;
	private Label lblNewLabel;
	private Combo combo;
	private ComboViewer comboViewer;
	public PublicParamComposite(MechanicPublicParam param,Composite parent, int style) {
		super(parent, style);
		setLayout(new GridLayout(3, false));	
		setParam(param);
		CreateControl();
	}
	
	private void CreateControl() {
		GridData gd_text = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		gd_text.heightHint = 50;
		gd_text.widthHint = 104;
		gd_text.minimumHeight=100;
		this.setLayoutData(gd_text);
		lblNewLabel = new Label(this, SWT.NONE);
		lblNewLabel.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false,false, 1, 1));
		lblNewLabel.setText("New Label");
		if(this.param!= null) {
			if(this.param.getDefaultvalue()!= null && !this.param.getDefaultvalue().isEmpty()) {
				text = new Text(this, SWT.BORDER);				
				text.setLayoutData(gd_text);
			}else {
				comboViewer = new ComboViewer(this, SWT.READ_ONLY);
				combo = comboViewer.getCombo();
				combo.setLayoutData(gd_text);
				comboViewer.setContentProvider(ArrayContentProvider.getInstance());
				comboViewer.setLabelProvider(new LabelProvider() {

					@Override
					public String getText(Object element) {
						if(element instanceof TypeDefElement ) {
							return ((TypeDefElement) element).getName();
						}
						return super.getText(element);
					}
					
				});
				comboViewer.setInput(this.param.getTypedef().getTypedefelement());
			}
			m_bindingContext = initCustomDataBindings();
		}
		ControlAdapter cal= new ControlAdapter() {
			
		    public void controlResized(ControlEvent e) {
		    	
		      Rectangle area = PublicParamComposite.this.getClientArea();
		      Point preferredSize = PublicParamComposite.this.computeSize(SWT.DEFAULT, SWT.DEFAULT);
		      int width = area.width - 2*PublicParamComposite.this.getBorderWidth();
		      int height=area.height - 2*PublicParamComposite.this.getBorderWidth();
		     // PublicParamComposite.this.setSize(width, 100);
		      Point oldSize = PublicParamComposite.this.getSize();
		      if (oldSize.x > area.width) {
		        // table is getting smaller so make the columns 
		        // smaller first and then resize the table to
		        // match the client area width
		    	  lblNewLabel.setSize(width*(2/5),190);
		    	  if(text!=null) {
			    	  text.setSize(width*(3/5),190); 
		    	  }
		    	  if(combo!=null) {
		    		  combo.setSize(width*(3/5),190);
		    	  }	  
		      } else {
		        // table is getting bigger so make the table 
		        // bigger first and then make the columns wider
		        // to match the client area width
		    	  lblNewLabel.setSize(width*(2/5),190);
		    	  if(text!=null) {
			    	  text.setSize(width*(3/5),190); 
		    	  }
		    	  if(combo!=null) {
		    		  combo.setSize(width*(3/5),190);
		    	  }	  
		      }
		    }};
		    this.addControlListener(cal);
	}
	public MechanicPublicParam getParam() {
		return param;
	}
	public void setParam(MechanicPublicParam param) {
		this.param = param;
	}
	public MechanicDesignImpl getDesign() {
		return design;
	}
	public void setDesign(MechanicDesignImpl design) {
		this.design = design;
	}
	protected DataBindingContext initCustomDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		IObservableValue changeableParamObserveValue = BeanProperties.value("changeable").observe(param);
		if(text!=null) {
		IObservableValue observeTextTextObserveWidget = WidgetProperties.text(SWT.Modify).observe(text);
		IObservableValue defaultvalueParamObserveValue = BeanProperties.value("defaultvalue").observe(param);
		bindingContext.bindValue(observeTextTextObserveWidget, defaultvalueParamObserveValue, null, null);
		//
		IObservableValue observeEditableTextObserveWidget = WidgetProperties.editable().observe(text);
		bindingContext.bindValue(observeEditableTextObserveWidget, changeableParamObserveValue, null, null);
		//
		}
		IObservableValue observeTextLblNewLabelObserveWidget_1 = WidgetProperties.text().observe(lblNewLabel);
		IObservableValue userlabelParamObserveValue = BeanProperties.value("userlabel").observe(param);
		bindingContext.bindValue(observeTextLblNewLabelObserveWidget_1, userlabelParamObserveValue, null, null);
		//
		
		if(comboViewer !=null) {
			IObservableValue observeEnabledComboObserveWidget = WidgetProperties.enabled().observe(combo);
			bindingContext.bindValue(observeEnabledComboObserveWidget, changeableParamObserveValue, null, null);
			//
			IObservableValue observeSingleSelectionComboViewer = ViewerProperties.singleSelection().observe(comboViewer);
			IObservableValue typedefelementParamObserveValue = BeanProperties.value("typedefelement").observe(param);
			bindingContext.bindValue(observeSingleSelectionComboViewer, typedefelementParamObserveValue, null, null);
			//
		}
		return bindingContext;
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
	
		
		return bindingContext;
	}
}
