package dressing.ui.caisson;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

import dressing.controller.CaissonCreator;
import dressing.model.Caisson;
import dressing.model.DesignException;
import dressing.model.Dressing;
import dressing.model.evalutor.GeometricEngineException;

public class CaissonWizardPage extends WizardPage{

	CaissonCreator caisson ;
	PropertyChangeListener pcl;
	boolean errorfound=true;
	protected CaissonWizardPage(String pageName,CaissonCreator caisson) {
		super(pageName);
		this.caisson = caisson;
		setTitle("Definir le cuisson "+caisson.getName());
		setDescription("Veuillez renseigner les propriet�s de votre caisson");
		
		// TODO Auto-generated constructor stub
	}


	@Override
	public void createControl(Composite parent) {
		// TODO Auto-generated method stub
		CaissonCompositeWizard compo1 = new CaissonCompositeWizard(parent, SWT.NONE,caisson,UpdateValueStrategy.POLICY_UPDATE);
		setControl(compo1);
		pcl = new PropertyChangeListener() {
			
			@Override
			public void propertyChange(PropertyChangeEvent evt) {
				// TODO Auto-generated method stub
				if(!evt.getPropertyName().startsWith("project.")) //seulemnt les proprietes de javabean
				{
					try {
						caisson.create();

						setErrorMessage(null);	
						errorfound = false;
						setMessage("Vous pouvez ajouter votre caisson", WizardPage.INFORMATION);
					} catch (DesignException | GeometricEngineException e) {
						setErrorMessage(e.getMessage());	
						errorfound = true;					}
					getWizard().getContainer().updateButtons();
				}

			}
		};
		caisson.addPropertyChangeListener(pcl);
	}
@Override
public boolean isPageComplete() {
	// TODO Auto-generated method stub
	return !errorfound;
}
public void clearlistners() {
	caisson.removePropertyChangeListener(pcl);
}
}