package dressing.model;


import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import javax.script.ScriptException;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

import dressing.cam.model.Tool;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.evalutor.GeomtericEngine;
import dressing.model.stock.ModelAccessoire;
import dressing.model.stock.ModelQuincaillerie;
import dressing.model.types.DesignType;
import dressing.model.types.IntersectionType;
import dressing.model.types.TrouType;
import dressing.model.usinage.Direction;
import dressing.model.usinage.Trou;
import dressing.model.usinage.Usinage;
import param.AccessoireInstance;
import param.Cavity;
import param.DesignMaterialType;
import param.FunctionDef;
import param.Material;
import param.MaterialType;
import param.MaterialTypeInstance;
import param.MechanicDesign;
import param.MechanicDesignElment;
import param.MechanicPrivateParam;
import param.MechanicPublicParam;
import param.ModelRoot;
import param.Operation;
import param.PieceType;
import param.PublicParamGroup;
import param.QuincaillerieInstance;
import param.Rainure;
import param.ToolProps;
import param.UsinageTrou;
import param.impl.ParamFactoryImpl;

public class MechanicDesignCreator {
	public static int create=1;
	public static int open=2;
	public static int update=3;
	public static int preview=4;

	private static MechanicDesignCreator instance ;
	public static MechanicDesignCreator getInstance() {
		synchronized(MechanicDesignCreator.class) {
			if (instance == null) {
				instance = new MechanicDesignCreator();
			}
			return instance;
		}
	}
	
	public MechanicDesignCreator() {}

	public DesignObject3D constructObject(ModelRoot modelRoot,MechanicDesign mechanicdesign,DesignObject3D parent) throws DesignException, GeometricEngineException
	{
		return constructObject( modelRoot, mechanicdesign,parent, null);
	}
	public DesignObject3D constructObject(ModelRoot modelRoot,MechanicDesign mechanicdesign,DesignObject3D parent,DesignObject3D rootspace) throws DesignException, GeometricEngineException
	{
		return constructObject(modelRoot,parent, rootspace,mechanicdesign,MechanicDesignCreator.create, false);
	}
	public DesignObject3D constructObject(ModelRoot modelRoot, DesignObject3D parent , DesignObject3D rootspace 
			, MechanicDesign mechanicdesign,int update,boolean createUsinage) throws DesignException, GeometricEngineException {

		EList<MechanicPrivateParam> privateparams = null;
		EList<MechanicPublicParam>  publicparams = null;
		// build global function
		buildGlobalFunctions(modelRoot);
		
		//build design
		if(mechanicdesign.getType().equals(PieceType.SPACE3D))
		{
			privateparams = mechanicdesign.getPrivateparamgroup().getMechanicprivateparam();
			publicparams = mechanicdesign.getPublicparamgroup().getMechanicpublicparam();
			if(rootspace==null|| !(rootspace instanceof Space3DFree)) {
				rootspace = new Space3DFree();	
			}
			//si en cas d'update en n'initialiser pas les la definition et le positions
			if(update!=MechanicDesignCreator.update && rootspace!=null) {
				rootspace.setMechanicDesignDefinition(mechanicdesign);
				rootspace.setParentdesign(parent);
				rootspace.setXpos(0);
				rootspace.setYpos(0);
				rootspace.setZpos(0);
				rootspace.setDesignType(DesignType.GENERIC);
			}
			
			
			if(mechanicdesign.getId()==null|| update==MechanicDesignCreator.create) {
				UUID id=UUID.randomUUID();
				mechanicdesign.setId(id);
				rootspace.setID(id);
			}else {
				rootspace.setID(mechanicdesign.getId());
			}
			setDefaultMaterialifNull(mechanicdesign);
			//
			Materiaux principalMaterial=ModelProvider.getDefintionmaterialMap().get(mechanicdesign.getPrincipalmaterial());
			Materiaux facadeMaterial=ModelProvider.getDefintionmaterialMap().get(mechanicdesign.getFacadeMaterial());
			Materiaux backmaterial=ModelProvider.getDefintionmaterialMap().get(mechanicdesign.getSecondmaterial());
			if(principalMaterial==null && mechanicdesign.getPrincipalmaterial()!=null) {
				principalMaterial = new Materiaux();
				principalMaterial.setName(mechanicdesign.getPrincipalmaterial().getName());
				principalMaterial.setEpaisseur(mechanicdesign.getPrincipalmaterial().getEpaisseur());
				principalMaterial.setMotif(mechanicdesign.getPrincipalmaterial().getImage());
				ModelProvider.getMateriallist().add(principalMaterial);
				ModelProvider.getCadMaterialMap().put(principalMaterial, mechanicdesign.getPrincipalmaterial());
				ModelProvider.getDefintionmaterialMap().put(mechanicdesign.getPrincipalmaterial(), principalMaterial);
			}
			if(facadeMaterial==null && mechanicdesign.getFacadeMaterial()!=null) {
				facadeMaterial = new Materiaux();
				facadeMaterial.setName(mechanicdesign.getFacadeMaterial().getName());
				facadeMaterial.setEpaisseur(mechanicdesign.getFacadeMaterial().getEpaisseur());
				facadeMaterial.setMotif(mechanicdesign.getFacadeMaterial().getImage());
				ModelProvider.getMateriallist().add(facadeMaterial);
				ModelProvider.getCadMaterialMap().put(facadeMaterial, mechanicdesign.getFacadeMaterial());
				ModelProvider.getDefintionmaterialMap().put(mechanicdesign.getFacadeMaterial(), facadeMaterial);
			}
			if(backmaterial==null && mechanicdesign.getSecondmaterial()!=null) {
				backmaterial = new Materiaux();
				backmaterial.setName(mechanicdesign.getSecondmaterial().getName());
				backmaterial.setEpaisseur(mechanicdesign.getSecondmaterial().getEpaisseur());
				backmaterial.setMotif(mechanicdesign.getSecondmaterial().getImage());
				ModelProvider.getMateriallist().add(backmaterial);
				ModelProvider.getCadMaterialMap().put(backmaterial, mechanicdesign.getSecondmaterial());
				ModelProvider.getDefintionmaterialMap().put(mechanicdesign.getSecondmaterial(), backmaterial);
			}
			rootspace.setBasematerial(principalMaterial);
			rootspace.setBackmaterial(backmaterial);
			//
			rootspace.setFacadeMaterial(facadeMaterial);
			
			rootspace.setName(mechanicdesign.getName());
			rootspace.constructGenericDebitage(privateparams,publicparams,mechanicdesign,parent);
			rootspace.evaluategeneric();
			
			//build elements (pieces)
			try {
				buildDesignElements(rootspace, mechanicdesign, privateparams, publicparams,update,createUsinage);
			}
			catch(Exception e) {
				throw new GeometricEngineException("error with: " + mechanicdesign.getName(),e);
			}
			//ajout les designs child pour ce design 
			for(MechanicDesign mcdesign : mechanicdesign.getMechanicdesign())
			{
				MechanicDesignCreator.getInstance().constructObject(modelRoot, rootspace, null, mcdesign, update,createUsinage);
			}
			
			if(parent!=null && update !=MechanicDesignCreator.update)
			{
				parent.addElement(rootspace);
//				if(parent instanceof Space3DFree && parent.getMechanicDesignDefinition()!=null ) {
//					((MechanicDesign)parent.getMechanicDesignDefinition()).getMechanicdesign().add(rootdesign);
//				}
			}
//			buildAccessoiresAndQuincailleries(rootspace, mechanicdesign, privateparams, publicparams, update);
			
			rootspace.firePropertyChange("element.modify", 5, 6);
			return rootspace;
			
		}
				
		return null;
	}
	public void setDefaultMaterialifNull( MechanicDesign mechanicdesign) {
		//tester si les matireaux d'affichage son null insérer la default material
		MaterialTypeInstance defaultmaterialType =getdefaultMaterialTypeInstance();
		MaterialTypeInstance faceTypeInstance=mechanicdesign.getFacadeMaterialType();
		MaterialTypeInstance principalTypeInstance=mechanicdesign.getPrincipalMaterialType();
		MaterialTypeInstance secondTypeInstance=mechanicdesign.getSecondMaterialType();
		if(faceTypeInstance==null) {
			faceTypeInstance=EcoreUtil.copy(defaultmaterialType);
			mechanicdesign.setFacadeMaterialType(faceTypeInstance);

		}
		if(principalTypeInstance==null) {
			principalTypeInstance=EcoreUtil.copy(defaultmaterialType);
			mechanicdesign.setPrincipalMaterialType(principalTypeInstance);

		}
		if(secondTypeInstance==null) {		
			secondTypeInstance=EcoreUtil.copy(defaultmaterialType);;
			mechanicdesign.setSecondMaterialType(secondTypeInstance);
		}
		//affecter material d'affuchage du vitre a l'element
		if(mechanicdesign.getDefaultVitreMaterialType()==null) {
			MaterialTypeInstance materialType =EcoreUtil.copy(defaultmaterialType);
			materialType.setMaterial(getMaterialType("Verre claire"));
			materialType.setColor(EcoreUtil.copy(materialType.getColor()));
			mechanicdesign.setDefaultVitreMaterialType(materialType);		
		}
	}
	public void updateMaterialFromKitchen(Kitchen kitchen, MechanicDesign mechanicdesign) {
		Material faceMat=	ModelProvider.getCadMaterialMap().get(kitchen.getFaceMaterial());
		Material baseMat=	ModelProvider.getCadMaterialMap().get(kitchen.getPrimaryMaterial());
		Material backMat=	ModelProvider.getCadMaterialMap().get(kitchen.getBackMaterial());
		
		if(baseMat!=null)
		{
			mechanicdesign.setPrincipalmaterial(baseMat);
		}
		if(faceMat!=null)
		{
			mechanicdesign.setFacadeMaterial(faceMat);
		}
		if(backMat!=null)
		{
			mechanicdesign.setSecondmaterial(backMat);
		}
		PublicParamGroup publicparams = mechanicdesign.getPublicparamgroup();

		MechanicPublicParam ep;
		try {
			ep = publicparams.getParam("global.ep");
			if(ep!=null) {
				ep.setDefaultvalue(String.valueOf(mechanicdesign.getPrincipalmaterial().getEpaisseur()));
			}
			
			MechanicPublicParam epback = publicparams.getParam("global.epback");	
			if(epback!=null) {
				epback.setDefaultvalue(String.valueOf(mechanicdesign.getSecondmaterial().getEpaisseur()));
			}
			
			MechanicPublicParam epface = publicparams.getParam("global.epface");
			if(epface!=null) {
				epface.setDefaultvalue(String.valueOf(mechanicdesign.getFacadeMaterial().getEpaisseur()));
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		setDefaultMaterialifNull(mechanicdesign);
		MaterialTypeInstance faceTypeInstance=mechanicdesign.getFacadeMaterialType();
		MaterialTypeInstance principalTypeInstance=mechanicdesign.getPrincipalMaterialType();
		MaterialTypeInstance secondTypeInstance=mechanicdesign.getSecondMaterialType();
		if(faceTypeInstance!=null) {
			if(faceTypeInstance.getTexture()==null &&kitchen.getScene()!=null
					&&kitchen.getScene().getPreferences()!=null &&kitchen.getScene().getPreferences().getFacadeMtl().getAlbedoMapPath()!=null) {
				faceTypeInstance.setTexture(kitchen.getScene().getPreferences().getFacadeMtl().getAlbedoMapPath());
				faceTypeInstance.setIsColor(false);
				faceTypeInstance.setMaterial(ModelProvider.getMaterialTypeByName(kitchen.getScene().getPreferences().getFacadeMtl().getName()));
			}
		}
		if(principalTypeInstance!=null) {
			if(principalTypeInstance.getTexture()==null &&kitchen.getScene()!=null
					&&kitchen.getScene().getPreferences()!=null &&kitchen.getScene().getPreferences().getBoxMtl().getAlbedoMapPath()!=null) {
				principalTypeInstance.setTexture(kitchen.getScene().getPreferences().getBoxMtl().getAlbedoMapPath());
				principalTypeInstance.setIsColor(false);
				principalTypeInstance.setMaterial(ModelProvider.getMaterialTypeByName(kitchen.getScene().getPreferences().getBoxMtl().getName()));
			}
		}
		if(secondTypeInstance!=null) {
			if(secondTypeInstance.getTexture()==null &&kitchen.getScene()!=null
					&&kitchen.getScene().getPreferences()!=null &&kitchen.getScene().getPreferences().getBackMtl().getAlbedoMapPath()!=null) {
				secondTypeInstance.setTexture(kitchen.getScene().getPreferences().getBoxMtl().getAlbedoMapPath());
				secondTypeInstance.setIsColor(false);
				secondTypeInstance.setMaterial(ModelProvider.getMaterialTypeByName(kitchen.getScene().getPreferences().getBackMtl().getName()));
			}
		}
	}
	public void updateAccessoiresAndQuincailleries(DesignObject3D rootspace ,MechanicDesign mechanicdesign,DesignObject3D parentDesign) throws DesignException, GeometricEngineException {
		if(rootspace==null || mechanicdesign==null) {
			return;
		}
		DesignObject3D childsparent=null;
		
		if(mechanicdesign.getType().equals(PieceType.DRESSING)
				||mechanicdesign.getType().equals(PieceType.CAISSON)
				||mechanicdesign.getType().equals(PieceType.SPACE3D)) {
			((Space3DFree) rootspace).getAccessoires().clear();
			((Space3DFree) rootspace).getQuincailleries().clear();
		}
		
		if(mechanicdesign.getType().equals(PieceType.PIECE2D)) {
			childsparent=parentDesign;
		}else if(rootspace instanceof Space3D &&(mechanicdesign.getType().equals(PieceType.SPACE3D) 
				|| mechanicdesign.getType().equals(PieceType.CAISSON)
				|| mechanicdesign.getType().equals(PieceType.DRESSING)
				|| mechanicdesign.getType().equals(PieceType.OBSTACLE)) ) {
			childsparent =rootspace;
		}
		
		buildAccessoiresAndQuincailleries(rootspace, mechanicdesign, mechanicdesign.getPrivateparamgroup().getMechanicprivateparam(),mechanicdesign.getPublicparamgroup().getMechanicpublicparam());

		List<MechanicDesign> childs=new ArrayList<MechanicDesign>();
		childs.addAll(mechanicdesign.getMechanicdesign());
		for(MechanicDesign mcdesign :childs)
		{
			updateAccessoiresAndQuincailleries(rootspace, mcdesign, rootspace);
		}
		
	}
	public void buildAccessoiresAndQuincailleries(DesignObject3D rootspace ,MechanicDesign mechanicdesign,List<MechanicPrivateParam> privateparams, List<MechanicPublicParam> publicparams) throws DesignException, GeometricEngineException {

		if (mechanicdesign.getAccessoires() != null) {
			if (mechanicdesign.getAccessoires().getAccessoires() != null && mechanicdesign.getAccessoires().getAccessoires().size() > 0) {
				for (AccessoireInstance accessoire : mechanicdesign.getAccessoires().getAccessoires()) {
					if (accessoire != null && accessoire.getAccessoire() != null) {
						ModelAccessoire model = new ModelAccessoire(accessoire);
						model.setId(accessoire.getAccessoire().getModelId());
						model.setName(accessoire.getAccessoire().getName());
						model.constructGenericDebitage(privateparams, publicparams, accessoire, rootspace);
						if ((Boolean) model.get("EXIST")) {
							if (accessoire.isStatic()) {
								model.setNumber(accessoire.getNombreFix());
								((Space3DFree) rootspace.getRoot()).addAccessoire(model);
							} else {
								((Space3DFree) rootspace.getRoot()).addAccessoire(model);
							}
							
							if (accessoire.getAccessoire().getQuincailleries() != null&& accessoire.getAccessoire().getQuincailleries().getQuincailleries() != null&& accessoire.getAccessoire().getQuincailleries().getQuincailleries().size() > 0) {
								EList<QuincaillerieInstance> quincailleries = accessoire.getAccessoire().getQuincailleries().getQuincailleries();
								for (QuincaillerieInstance quincaillerie : quincailleries) {
									if (quincaillerie != null && quincaillerie.getQuincaillerie() != null) {
										ModelQuincaillerie modelquincaillerie = new ModelQuincaillerie(quincaillerie,model);
										modelquincaillerie.setId(quincaillerie.getQuincaillerie().getModelId());
										modelquincaillerie.setName(quincaillerie.getName());
										modelquincaillerie.setNumber(quincaillerie.getNombreFix()*model.getNumber());
										((Space3DFree) rootspace.getRoot()).addQuincaillerie(modelquincaillerie);


									}
								}
							}
						}
					}
				}
			}
		}

		if (mechanicdesign.getQuincailleries() != null) {
			if (mechanicdesign.getQuincailleries().getQuincailleries() != null
					&& mechanicdesign.getQuincailleries().getQuincailleries().size() > 0) {
				for (QuincaillerieInstance quincaillerie : mechanicdesign.getQuincailleries().getQuincailleries()) {
					if (quincaillerie != null && quincaillerie.getQuincaillerie() != null) {
						ModelQuincaillerie model = new ModelQuincaillerie(quincaillerie);
						model.setId(quincaillerie.getQuincaillerie().getModelId());
						model.setName(quincaillerie.getQuincaillerie().getName());
						model.constructGenericDebitage(privateparams, publicparams, quincaillerie, rootspace);
						if((Boolean)model.get("EXIST"))
						{
							if (quincaillerie.isStatic()) {
								model.setNumber(quincaillerie.getNombreFix());
								((Space3DFree) rootspace.getRoot()).addQuincaillerie(model);
							} else {
								((Space3DFree) rootspace.getRoot()).addQuincaillerie(model);
							}

						}
					}
				}
			}
		}
	}
	
	
	public void buildDesignElements(DesignObject3D rootspace ,MechanicDesign mechanicdesign,List<MechanicPrivateParam> privateparams, List<MechanicPublicParam> publicparams, int update2, boolean createUsinage) throws DesignException, GeometricEngineException {
		
		List< Trou> trous =new ArrayList<Trou>();
		List< dressing.model.usinage.Rainure> rainures =new ArrayList<dressing.model.usinage.Rainure>();
		
		//build elements (pieces)
		if(mechanicdesign.getMechanicelementgroup()!=null) // scho 1953 
		{
			for(MechanicDesignElment mechaelment : mechanicdesign.getMechanicelementgroup().getMechanicdesignelment())
			{
				if(mechaelment.getType().equals(PieceType.PIECE2D))
				{
					Piece2D p2 = new Piece2D();
					p2.setBasematerial(rootspace.getBasematerial());
					p2.setBackmaterial(rootspace.getBackmaterial());	
					p2.setMechanicDesignElementDefinition(mechaelment);
					updateDesignElement(mechanicdesign, mechaelment, p2);
					////////
					p2.setParentdesign(rootspace);
					p2.setXpos(0);
					p2.setZpos(0);
					p2.setYpos(0);
					//p2.setPiecetype(dressing.model.types.PieceType.GENERIC);
					dressing.model.types.PieceType type = dressing.model.types.PieceType.GENERIC;;
					if(mechaelment.getTypedef()!=null&& mechaelment.getTypedef().getKey().contentEquals("PieceType")&&
							mechaelment.getTypedefelement()!=null&& mechaelment.getTypedefelement().getKey()!=null 
							&& !mechaelment.getTypedefelement().getKey().isEmpty() ) {
						String typedefElment=mechaelment.getTypedefelement().getKey();
						try {
							type = dressing.model.types.PieceType.valueOf(typedefElment);
						}catch (Exception e) {
							type = dressing.model.types.PieceType.valueOf(mechaelment.getName());
						}
					}else {
					
						try {
							type = dressing.model.types.PieceType.valueOf(mechaelment.getName());
						}catch (Exception e) {
						}	
					}
					p2.setPiecetype(type);
					p2.setName(mechaelment.getName());					
					if(mechaelment.getId()==null) {
						UUID id=UUID.randomUUID();
						mechaelment.setId(id);
						p2.setID(id);
					}else{
						p2.setID(mechaelment.getId());
					}
					///////
					p2.constructGenericDebitage(privateparams,publicparams,mechaelment,rootspace);
					if((Boolean)p2.get("EXIST"))
					{
						p2.evaluategeneric();				
						if(mechaelment.getUsinagenode()!=null)
						{
							//we avoid creating the usins in case of preview to minimize resource consumption unnicessarly
							if (createUsinage &&p2.getMaterialType()!=null&&p2.getMaterialType().getMaterial()!=null
									&& p2.getMaterialType().getMaterial().isProduction()) {
								// build trous
								List<Trou> trs = buildTrous(p2, mechaelment.getUsinagenode().getUsinagetrou(),
										privateparams, publicparams);
								trous.addAll(trs);

								// build rainures
								List<dressing.model.usinage.Rainure> rns = buildRainures(p2,
										mechaelment.getUsinagenode().getUsinageRainure(), privateparams, publicparams);
								rainures.addAll(rns);
							}

							if (update2 != MechanicDesignCreator.preview) {
								// build cavities
								List<dressing.model.Cavity> cvs = buildCavities(p2,
										mechaelment.getUsinagenode().getCavities(), privateparams, publicparams);

							}
						}
						rootspace.addElement(p2);
						
					}

				}
			}
			//fix les trous et les rainures et modifier ces pieces qui le contient si necessaire 
			if (createUsinage) {
				fixTrous(rootspace, trous);
				fixRainures(rootspace, rainures);
			}
		}
	}
	public void updateDesignElement(MechanicDesign mechanicdesign ,MechanicDesignElment mechanicelment, Piece2D p2) {
		MaterialTypeInstance defaultmaterialType =getdefaultMaterialTypeInstance();
		
		if(mechanicelment.isFaceMaterial()) {
			mechanicelment.setMaterial(mechanicdesign.getFacadeMaterial());
			mechanicelment.setMaterialType(EcoreUtil.copy(mechanicdesign.getFacadeMaterialType()));
		}
		if(mechanicelment.isPrimaryMaterial()) {
			mechanicelment.setMaterial(mechanicdesign.getPrincipalmaterial());
			mechanicelment.setMaterialType(EcoreUtil.copy(mechanicdesign.getPrincipalMaterialType()));
		}
		if(mechanicelment.isBackMaterial()) {
			mechanicelment.setMaterial(mechanicdesign.getSecondmaterial());
			mechanicelment.setMaterialType(EcoreUtil.copy(mechanicdesign.getSecondMaterialType()));
		}
		//
		if(mechanicelment.isFreeMaterial()) {
			if(mechanicelment.getMaterialType()==null) {
				MaterialTypeInstance material=EcoreUtil.copy(defaultmaterialType);
				mechanicelment.setMaterialType(material);
			}
		}else {
			if(mechanicdesign.getMaterialTypes()!=null && mechanicdesign.getMaterialTypes().getDesignMaterialTypes()!=null
					 && !mechanicdesign.getMaterialTypes().getDesignMaterialTypes().isEmpty()) {
				for(DesignMaterialType materialType:mechanicdesign.getMaterialTypes().getDesignMaterialTypes()) {
					if(materialType.getMaterialType()==null) {
						MaterialTypeInstance materialTypeinstance =getdefaultMaterialTypeInstance();
						materialTypeinstance.setMaterial(getMaterialType("MDF"));
						materialType.setMaterialType(materialTypeinstance);
					}
					if(materialType.getPieceType()!=null) {
						if(materialType.getPieceType().contains(mechanicelment.getTypedefelement())) {
							MaterialTypeInstance material=EcoreUtil.copy(materialType.getMaterialType());
							mechanicelment.setMaterialType(material);
						}
					}
				}
			}
		}
		//
		
		//set material des panneau dans la piece
		p2.setMaterial(ModelProvider.getDefintionmaterialMap().get(mechanicelment.getMaterial()));
		//set material d'affichage dans la piece
		p2.setMaterialType(mechanicelment.getMaterialType());
		
	
		if(!mechanicelment.isVitreMaterialTypeFree()||mechanicelment.getVitreMaterialType()==null) {
			mechanicelment.setVitreMaterialType(EcoreUtil.copy(mechanicdesign.getDefaultVitreMaterialType()));
		}
		//set material du vitre d'affichage dans la piece
		p2.setVitreMaterialType(mechanicelment.getVitreMaterialType());
		//
	}
	public MaterialTypeInstance getdefaultMaterialTypeInstance() {
		MaterialTypeInstance defaultmaterialType =ParamFactoryImpl.eINSTANCE.createMaterialTypeInstance();
		defaultmaterialType.setMaterial(ModelProvider.getModelroot().getMaterialType().getMaterialTypes().get(0));
		defaultmaterialType.setIsColor(true);
		defaultmaterialType.setColor(EcoreUtil.copy(defaultmaterialType.getMaterial().getAlbedo()));
		return defaultmaterialType;
	}
	public MaterialType getMaterialType(String name) {
		EList<MaterialType> materials=ModelProvider.getModelroot().getMaterialType().getMaterialTypes();
		for(MaterialType material:materials) {
			if(material.getName().toUpperCase().contentEquals(name.toUpperCase())) {
				return material;
			}
		}
		return getdefaultMaterialTypeInstance().getMaterial();
	}
	public void buildGlobalFunctions(ModelRoot modelRoot) throws DesignException {
		if (modelRoot.getFunctiongroup() != null) {
			for (FunctionDef func : modelRoot.getFunctiongroup().getFunctiondef()) {
				String s = "function " + func.getName() + "{" + func.getCorps() + "}";
				try {
					GeomtericEngine.getLogicalEngine().eval(s);
					GeomtericEngine.getEngine().eval(s);
				} catch (ScriptException e) {
					throw new DesignException(
							"Cannot evaluate global function" + func.getName() + " a cause de:" + e.getMessage());
				}
			}

		}
	}
	public void fixTrous(DesignObject3D rootspace,List< Trou> trous  ) throws DesignException, GeometricEngineException {
		if (trous != null && trous.size() > 0) {
			trousLoup:
			for (Trou tr : trous) {
				Cylindre cyl = new Cylindre(tr);
				Piece2D pp = (Piece2D) tr.getParentdesign();
				Plan3D plan = new Plan3D(pp);
//				boolean transformed=false;
				double maxInter=0;
				Piece2D father=pp;
//				if (!plan.isIntersect(cyl).equals(IntersectionType.INTERSECTION)) {
					piecesLoop:
					for (Piece2D piece : rootspace.getListPieces()) {
						boolean intersectwithcavity=false;
						List<dressing.model.Cavity> cavities=piece.getPiecesCavities();
						if(cavities !=null && !cavities.isEmpty()) {
							for(dressing.model.Cavity cavity:cavities) {
								plan = new Plan3D(cavity);
								Plan3D intersection=plan.getIntersection(cyl);
								
								if (Plan3D.getPlan3DType(intersection).equals(IntersectionType.INTERSECTION)) {
									intersectwithcavity=true;
								}
							}
							
						}
						if(!intersectwithcavity) {
							plan = new Plan3D(piece);
							Plan3D intersection=plan.getIntersection(cyl);
							
							if (Plan3D.getPlan3DType(intersection).equals(IntersectionType.INTERSECTION)) {
//								transformed=true;
								double intersectionSize=intersection.getSize();
								if(intersectionSize>maxInter) {
									maxInter=intersectionSize;
									father=piece;
								}
								
							}
						}
						
					}
//				}else
//				if(!transformed) {
//					tr.transformtoParentCords();
//				}
				if(father!=null) {
					pp.deletechild(tr);
					father.addElement(tr);
					tr.setParentdesign(father);
					tr.setMother(pp);
					tr.transformtoParentCords();
				}

			}
		}
	}
	public void fixRainures(DesignObject3D rootspace,List< dressing.model.usinage.Rainure> rainures  ) throws DesignException, GeometricEngineException {
		if (rainures != null && rainures.size() > 0) {
			for(dressing.model.usinage.Rainure rn:rainures) {
				Plan3D child=new Plan3D(rn);
				Piece2D pp=(Piece2D) rn.getParentdesign();
					Pieces:
					for(Piece2D piece:rootspace.getListPieces()) {
						if(!pp.equals(piece)) {
							Plan3D plan=new Plan3D(piece);
							if(plan.contains(child)) {
								pp.deletechild(rn);
								piece.addElement(rn);
								rn.setMother(pp);
								rn.transformtoParentCords();
								break Pieces;
							}
						}
						
					}				
				
			}
		}
	}	
	
	public List<Trou> buildTrous(Piece2D piece, EList<UsinageTrou> trouss,List<MechanicPrivateParam> privateparams, List<MechanicPublicParam> publicparams) throws DesignException, GeometricEngineException {
		List< Trou> trous =new ArrayList<Trou>();
		if (trouss != null && trouss.size() > 0) {
			for (UsinageTrou usintrou : trouss) {
				Trou tr = new Trou();
				tr.setName(usintrou.getName());
				tr.setDirection(Direction.valueOf(usintrou.getDirection().getLiteral()));
				tr.setTrouType(TrouType.GENERIC);
				tr.setDesignType(DesignType.GENERIC);
				tr.setParentdesign(piece);
				tr.setMother(piece);
				if (usintrou.getId() == null) {
					UUID id = UUID.randomUUID();
					usintrou.setId(id);
					tr.setID(id);
				} else {
					tr.setID(usintrou.getId());
				}
				tr.constructGenericDebitage(privateparams, publicparams, usintrou, piece);

				if ((Boolean) tr.get("EXIST")) {
					tr.evaluategeneric();
					piece.addElement(tr);
					trous.add(tr);
					fixOperations(usintrou, tr);
					boolean hasOpposite=tr.get("HAS_OPPOSITE")!=null?(Boolean) tr.get("HAS_OPPOSITE"):usintrou.isHaveopposite();
					if (hasOpposite) {
						Trou tr1 = new Trou();
						tr1.setName(usintrou.getName() + " " + piece.getName());
						tr1.setDirection(tr.getOppositeDirection());
						tr1.setTrouType(TrouType.GENERIC);
						tr1.setDesignType(DesignType.GENERIC);
						tr1.setParentdesign(piece);
						tr1.setMother(piece);
						if (usintrou.getId() == null) {
							UUID id = UUID.randomUUID();
							usintrou.setId(id);
							tr1.setID(id);
						} else {
							tr.setID(usintrou.getId());
						}
						tr1.constructGenericDebitage(privateparams, publicparams, usintrou, piece);
						tr1.evaluategeneric();
						tr1.setDepth(tr.getOppositeTrouDepth());
						tr1.setDiameter(tr.getOppositeDiameter());
						piece.addElement(tr1);
						trous.add(tr1);
						fixOperations(usintrou, tr1);

					}
				}

			}
		}
		return trous;
	}
	
	public List<dressing.model.usinage.Rainure> buildRainures(Piece2D piece, EList<Rainure> rainures,List<MechanicPrivateParam> privateparams, List<MechanicPublicParam> publicparams) throws DesignException, GeometricEngineException {
		List<dressing.model.usinage.Rainure> rns =new ArrayList<dressing.model.usinage.Rainure>();
		if (rainures != null && rainures.size() > 0) {

			for (Rainure rn : rainures) {
				dressing.model.usinage.Rainure rainure = new dressing.model.usinage.Rainure();
				rainure.setName(rn.getName());
				rainure.setDesignType(DesignType.GENERIC);
				rainure.setParentdesign(piece);
				rainure.setMother(piece);
				if (rn.getId() == null) {
					UUID id = UUID.randomUUID();
					rn.setId(id);
					rainure.setID(id);
				} else {
					rainure.setID(rn.getId());
				}
				rainure.constructGenericDebitage(privateparams, publicparams, rn, piece);
				if ((Boolean) rainure.get("EXIST")) {
					rainure.evaluategeneric();
					piece.addElement(rainure);
					fixOperations(rn, rainure);
					if (!rn.isIsparentcontainement()) {
						rns.add(rainure);
					}
				}
				
				//

			}

		}
		return rns;
	}
	
	public List<dressing.model.Cavity> buildCavities(Piece2D piece, EList<Cavity> cavities,List<MechanicPrivateParam> privateparams, List<MechanicPublicParam> publicparams) throws DesignException, GeometricEngineException {
		List<dressing.model.Cavity> cvs =new ArrayList<dressing.model.Cavity>();
		if (cavities != null && cavities.size() > 0) {
			for(Cavity  cv : cavities)
			{
				dressing.model.Cavity cavity = new dressing.model.Cavity();
				cavity.setName(cv.getName());
				cavity.setDesignType(DesignType.GENERIC);
				cavity.setParentdesign(piece);
				cavity.setMother(piece);
				if(cv.getId()==null) {
					UUID id=UUID.randomUUID();
					cv.setId(id);
					cavity.setID(id);
				}else {
					cavity.setID(cv.getId());
				}
				cavity.constructGenericDebitage(privateparams, publicparams, cv,piece);
				if((Boolean)cavity.get("EXIST"))
				{
					cavity.evaluategeneric();
					piece.addElement(cavity);
					fixOperations(cv, cavity);
				}								
			}
		}
		return cvs;
	}	
	public void fixOperations(EObject object, Usinage usin) {
		EList<Operation> operations = null;
		if (object == null || usin == null) {
			return;
		}
		if (object instanceof Rainure) {
			operations = ((Rainure) object).getOperations();
		} else if (object instanceof Cavity) {
			operations = ((Cavity) object).getOperations();
		} else if (object instanceof UsinageTrou) {
			operations = ((UsinageTrou) object).getOperations();
		} else {
			return;
		}
		if (operations != null) {

			for (Operation op : operations) {
				param.Tool tool = op.getTool();
				Tool cadTool = new Tool(tool.getName(), tool.getCode());
				cadTool.setCutter_diameter(tool.getCutterDiameter());
				cadTool.setCutter_length(tool.getCutterLength());
				cadTool.setFeed(tool.getFeed());
				cadTool.setFlute_diameter(tool.getFluteDiameter());
				cadTool.setFlute_length(tool.getFluteLength());
				cadTool.setSpindleSpeed(tool.getSpindleSpeed());
				if(tool.getProperties()!=null&& tool.getProperties().getProps()!=null) {
					EList<ToolProps> toolprops=tool.getProperties().getProps();
					for(ToolProps props:toolprops) {
						cadTool.put(props.getCode(), props.getValue());
					}
				}
				
				dressing.cam.model.Operation ops = new dressing.cam.model.Operation(cadTool, usin);
				ops.setCode(op.getCode());
				ops.setName(op.getName());
				ops.setStep(op.getStep());
				ops.setStart(op.getStart());
				ops.setDepth(op.getDepth());
				ops.setEnd(op.getEnd());
				usin.addOperation(ops);
			}
		}
	}
}
