/*
 * Decompiled with CFR 0.152.
 */
package org.frs.resources.downloder;

import info.clearthought.layout.TableLayout;
import info.clearthought.layout.TableLayoutConstraints;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import org.frs.resources.downloder.DownloadObserver;
import org.frs.resources.downloder.HttpFileDownloader;
import org.frs.supercad.config.ConfigurationManager;

public class DownloaderUI
extends JFrame {
    private DefaultTableModel tableModel;
    private List<String> urls = new ArrayList<String>();
    private List<Long> fileSizes;
    private List<HttpFileDownloader> downloaders = new ArrayList<HttpFileDownloader>();
    private long totalSize = 0L;
    private boolean paused = false;
    private int currentDownloadIndex = 0;
    private List<Long> downloadedBytesPerFile = new ArrayList<Long>();
    private boolean isDownloading = false;
    private int completedDownloads = 0;
    private JLabel label2;
    private JButton buttonDownloder;
    private JButton buttonPause;
    private JScrollPane scrollPane1;
    private JTextArea textArea;
    private JScrollPane scrollPane2;
    private JTable table;
    private JProgressBar progressBar;

    public DownloaderUI() {
        this.initComponents();
        ImageIcon labelIcon = new ImageIcon(this.getClass().getResource("/icons/supercad.png"));
        this.label2.setIcon(labelIcon);
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/icons/icon-supercad32.jpg"));
        this.setIconImage(icon.getImage());
        this.setSize(530, 580);
        this.setLocationRelativeTo(null);
        this.initDownloadList();
        this.initEvents();
        this.buttonPause.addActionListener(this::togglePause);
        this.setDefaultCloseOperation(3);
    }

    private void initDownloadList() {
        String urlsStr = ConfigurationManager.getProperty((String)"URL_RESOURCES");
        if (urlsStr != null && !urlsStr.isEmpty()) {
            this.urls = Arrays.stream(urlsStr.split(";")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        } else {
            System.err.println("La propri\u00e9t\u00e9 URL_RESOURCES est vide ou non d\u00e9finie.");
        }
        this.fileSizes = new ArrayList<Long>();
        this.downloadedBytesPerFile = new ArrayList<Long>();
        this.tableModel = new DefaultTableModel(new String[]{"Nom du fichier", "\u00c9tat", "Progression"}, 0){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.table.setModel(this.tableModel);
        this.urls.forEach(url -> {
            String fileName = url.substring(url.lastIndexOf("/") + 1);
            this.tableModel.addRow(new Object[]{fileName, "En attente", "0%"});
        });
        this.computeTotalSize();
    }

    private void computeTotalSize() {
        new Thread(() -> {
            try {
                for (String urlStr : this.urls) {
                    URL url = new URL(urlStr);
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod("HEAD");
                    long size = conn.getContentLengthLong();
                    System.out.println("URL: " + urlStr + " => Taille: " + size + " octets (" + size / 0x100000L + " Mo)");
                    this.fileSizes.add(size);
                    this.totalSize += size;
                    conn.disconnect();
                }
                System.out.println("totalSize: " + this.totalSize);
                System.out.println("Nombre d'URLs : " + this.urls.size());
            }
            catch (Exception e) {
                this.appendToConsole("Erreur lors du calcul des tailles : " + e.getMessage());
            }
        }).start();
    }

    private void initEvents() {
        this.buttonDownloder.addActionListener(this::startDownloads);
    }

    private void startDownloads(ActionEvent e) {
        this.currentDownloadIndex = 0;
        this.downloaders.clear();
        this.downloadedBytesPerFile = new ArrayList<Long>(Collections.nCopies(this.urls.size(), 0L));
        System.out.println("downloadedBytesPerFile" + String.valueOf(this.downloadedBytesPerFile));
        this.buttonDownloder.setEnabled(false);
        this.progressBar.setValue(0);
        new Thread(() -> this.startNextDownload()).start();
    }

    private void startNextDownload() {
        if (this.isDownloading || this.currentDownloadIndex >= this.urls.size()) {
            return;
        }
        this.isDownloading = true;
        if (this.currentDownloadIndex <= this.urls.size()) {
            boolean downloadExists;
            String url = this.urls.get(this.currentDownloadIndex);
            String fileName = url.substring(url.lastIndexOf("/") + 1);
            Object outputPath = System.getProperty("user.dir") + File.separator + fileName;
            File targetFile = new File((String)outputPath);
            File downloadFile = new File((String)outputPath + ".download");
            long expectedSize = this.fileSizes.get(this.currentDownloadIndex);
            System.out.println("fileSizes" + String.valueOf(this.fileSizes));
            boolean targetExists = targetFile.exists() && targetFile.length() == expectedSize;
            boolean bl = downloadExists = downloadFile.exists() && downloadFile.length() == expectedSize;
            if (targetExists || downloadExists) {
                String message = targetExists && downloadExists ? "Deux versions du fichier existent :\n- " + fileName + " (t\u00e9l\u00e9chargement complet)\n- " + fileName + ".download (t\u00e9l\u00e9chargement complet)\nQue souhaitez-vous faire ?" : (targetExists ? "Le fichier " + fileName + " existe d\u00e9j\u00e0 (t\u00e9l\u00e9chargement complet).\nQue souhaitez-vous faire ?" : "Le fichier " + fileName + ".download existe d\u00e9j\u00e0 (t\u00e9l\u00e9chargement complet).\nQue souhaitez-vous faire ?");
                int choice = JOptionPane.showOptionDialog(this, message, "Fichier existant", 1, 3, null, new String[]{"Remplacer", "T\u00e9l\u00e9charger", "Ignorer"}, "Remplacer");
                if (choice == 0) {
                    targetFile.delete();
                    downloadFile.delete();
                } else if (choice == 1) {
                    outputPath = this.renameFile((String)outputPath);
                } else {
                    this.updateTableStatus(this.currentDownloadIndex, "Ignor\u00e9", " ");
                    this.downloadedBytesPerFile.set(this.currentDownloadIndex, this.fileSizes.get(this.currentDownloadIndex));
                    System.out.println(String.valueOf(this.downloadedBytesPerFile) + " new");
                    this.updateGlobalProgress();
                    ++this.currentDownloadIndex;
                    this.isDownloading = false;
                    this.startNextDownload();
                    return;
                }
            }
            this.startSingleDownload(this.currentDownloadIndex, url, (String)outputPath);
        }
    }

    private void startSingleDownload(int rowIndex, String url, String outputPath) {
        HttpFileDownloader downloader = new HttpFileDownloader(url, outputPath);
        this.downloaders.add(downloader);
        final int finalRowIndex = rowIndex;
        downloader.addObserver(new DownloadObserver(){

            @Override
            public void onProgress(int percent) {
                SwingUtilities.invokeLater(() -> {
                    DownloaderUI.this.updateTableProgress(finalRowIndex, percent);
                    DownloaderUI.this.tableModel.setValueAt("En cours", finalRowIndex, 1);
                    long fileSize = DownloaderUI.this.fileSizes.get(finalRowIndex);
                    long downloadedBytes = (long)percent * fileSize / 100L;
                    DownloaderUI.this.downloadedBytesPerFile.set(finalRowIndex, downloadedBytes);
                    System.out.println(String.valueOf(DownloaderUI.this.downloadedBytesPerFile) + "final");
                    DownloaderUI.this.updateGlobalProgress();
                });
            }

            @Override
            public void onStatus(String message) {
                SwingUtilities.invokeLater(() -> DownloaderUI.this.appendToConsole(message));
            }

            @Override
            public void onCompleted() {
                SwingUtilities.invokeLater(() -> {
                    DownloaderUI.this.updateTableStatus(finalRowIndex, "Termin\u00e9", "100%");
                    DownloaderUI.this.downloadedBytesPerFile.set(finalRowIndex, DownloaderUI.this.fileSizes.get(finalRowIndex));
                    DownloaderUI.this.updateGlobalProgress();
                    ++DownloaderUI.this.currentDownloadIndex;
                    DownloaderUI.this.isDownloading = false;
                    DownloaderUI.this.startNextDownload();
                    ++DownloaderUI.this.completedDownloads;
                    if (DownloaderUI.this.completedDownloads == DownloaderUI.this.downloaders.size()) {
                        JOptionPane.showMessageDialog(null, "Tous les fichiers ont \u00e9t\u00e9 t\u00e9l\u00e9charg\u00e9s avec succ\u00e8s !");
                    }
                });
            }

            @Override
            public void onErreur(String errorMsg) {
                SwingUtilities.invokeLater(() -> {
                    DownloaderUI.this.appendToConsole("Erreur: " + errorMsg);
                    DownloaderUI.this.updateTableStatus(finalRowIndex, "Erreur", "0%");
                    ++DownloaderUI.this.currentDownloadIndex;
                    DownloaderUI.this.startNextDownload();
                });
            }
        });
        new Thread(downloader).start();
        this.updateTableStatus(rowIndex, "En cours", "0%");
    }

    private void updateTableStatus(int rowIndex, String status, String progress) {
        this.tableModel.setValueAt(status, rowIndex, 1);
        this.tableModel.setValueAt(progress, rowIndex, 2);
    }

    private void updateTableProgress(int rowIndex, int percent) {
        this.tableModel.setValueAt(percent + "%", rowIndex, 2);
    }

    private void updateGlobalProgress() {
        long totalDownloaded = this.downloadedBytesPerFile.stream().mapToLong(Long::longValue).sum();
        System.out.println(String.valueOf(this.downloadedBytesPerFile) + "pro");
        int globalPercent = (int)(totalDownloaded * 100L / this.totalSize);
        this.progressBar.setValue(globalPercent);
    }

    private void togglePause(ActionEvent e) {
        this.paused = !this.paused;
        for (HttpFileDownloader downloader : this.downloaders) {
            downloader.togglePause();
        }
        this.buttonPause.setText(this.paused ? "Reprendre" : "Pause");
        int i = 0;
        while (i < this.tableModel.getRowCount()) {
            String etat = (String)this.tableModel.getValueAt(i, 1);
            if (this.paused && "En cours".equalsIgnoreCase(etat)) {
                this.tableModel.setValueAt("En pause", i, 1);
            } else if (!this.paused && "En pause".equalsIgnoreCase(etat)) {
                this.tableModel.setValueAt("En cours", i, 1);
            }
            ++i;
        }
    }

    private void appendToConsole(String text) {
        this.textArea.append(text + "\n");
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
    }

    private String renameFile(String originalPath) {
        File newFile;
        File file = new File(originalPath);
        String name = file.getName();
        String baseName = name.contains(".") ? name.substring(0, name.lastIndexOf(".")) : name;
        String extension = name.contains(".") ? name.substring(name.lastIndexOf(".")) : "";
        int count = 1;
        do {
            newFile = new File(file.getParent(), baseName + "(" + count + ")" + extension);
            ++count;
        } while (newFile.exists());
        return newFile.getAbsolutePath();
    }

    private void initComponents() {
        this.label2 = new JLabel();
        this.buttonDownloder = new JButton();
        this.buttonPause = new JButton();
        this.scrollPane1 = new JScrollPane();
        this.textArea = new JTextArea();
        this.scrollPane2 = new JScrollPane();
        this.table = new JTable();
        this.progressBar = new JProgressBar();
        this.setTitle("Downloader Resources SuperCad");
        Container contentPane = this.getContentPane();
        contentPane.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0, -1.0, -1.0}, {121.0, 51.0, 130.0, -1.0, 50.0}}));
        ((TableLayout)contentPane.getLayout()).setHGap(7);
        ((TableLayout)contentPane.getLayout()).setVGap(7);
        this.label2.setHorizontalTextPosition(10);
        contentPane.add((Component)this.label2, new TableLayoutConstraints(0, 0, 1, 0, 2, 2));
        this.buttonDownloder.setText("T\u00e9l\u00e9charger");
        this.buttonDownloder.setBackground(Color.white);
        contentPane.add((Component)this.buttonDownloder, new TableLayoutConstraints(0, 1, 0, 1, 2, 1));
        this.buttonPause.setText("Pause");
        this.buttonPause.setBackground(Color.white);
        contentPane.add((Component)this.buttonPause, new TableLayoutConstraints(1, 1, 1, 1, 2, 1));
        this.textArea.setEditable(false);
        this.scrollPane1.setViewportView(this.textArea);
        contentPane.add((Component)this.scrollPane1, new TableLayoutConstraints(0, 2, 2, 2, 2, 2));
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[]{"Nom du fichier", "\u00c9tat", "Progression"}){
            boolean[] columnEditable;
            {
                this.columnEditable = new boolean[3];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.columnEditable[columnIndex];
            }
        });
        this.scrollPane2.setViewportView(this.table);
        contentPane.add((Component)this.scrollPane2, new TableLayoutConstraints(0, 3, 2, 3, 2, 2));
        this.progressBar.setStringPainted(true);
        contentPane.add((Component)this.progressBar, new TableLayoutConstraints(0, 4, 2, 4, 2, 1));
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new DownloaderUI().setVisible(true));
    }

    public void open() {
        SwingUtilities.invokeLater(() -> this.setVisible(true));
    }
}

