<?xml version="1.0"?>

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:output method="text" />

	<xsl:template match="TestCases">
	
<xsl:text>	
package model.caisson;
import static org.junit.Assert.assertEquals;

import org.junit.Test;

import dressing.model.DesignException;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.CaissonMontageType;
import dressing.model.types.DosType;
import dressing.model.types.PortType;
import dressing.model.types.PositionCalculationType;
import dressing.model.types.PositionReferenceType;
import dressing.model.types.SeprationAxe;
import utils.ParametersUtils;
</xsl:text>
		<xsl:text>
public class CaissonCreatorTestCases extends CheckCaisson {
</xsl:text>
<xsl:text>
</xsl:text>
		<xsl:for-each select="Function">
			<xsl:variable name="function" select="@name" />

			<xsl:for-each select="TestCase">
				<xsl:text>
	@Test
	public void test_</xsl:text>
				<xsl:value-of select="$function" />
				<xsl:text>_</xsl:text>
				<xsl:value-of select="@id" />
				<xsl:text>()</xsl:text>
				<xsl:text> {
</xsl:text>

				<xsl:variable name="creator"
					select="Has[@name='creator']/@value" />
					<xsl:variable name="assert"
					select="Has[@name='assert']/@value" />
				<xsl:variable name="shapeName"
					select="Input/Var[@name='Type']/Has[@name='varName']/@value" />
					
						
				<xsl:for-each select="Input/Var">
					<xsl:text>    	</xsl:text>
					<xsl:if test ="@value !=''">
					<xsl:text>    	</xsl:text>
					<xsl:value-of select="Has[@name='varType']/@value" />
					<xsl:text> </xsl:text>
					<xsl:value-of select="Has[@name='varName']/@value" />
					<xsl:text> = </xsl:text>
					<xsl:choose>
						<xsl:when test="Has[@name='varEval']">
							<xsl:value-of select="Has[@name='varEval']/@value" />
							<xsl:text>(</xsl:text>
							<xsl:value-of select="@value" />
							<xsl:text>)</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="Has[@name='varType']/@value='String'">
									<xsl:text>"</xsl:text>
									<xsl:value-of select="@value" />
									<xsl:text>"</xsl:text>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="@value" />
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>

					</xsl:choose>
					<xsl:text>;
</xsl:text>
					<xsl:if test="Has[@name='varApply']">
						<xsl:text>		</xsl:text>
						<xsl:value-of select="$creator" />
				<xsl:text>.</xsl:text>
						<xsl:value-of select="Has[@name='varApply']/@value" />
						<xsl:text>(</xsl:text>
						<xsl:value-of select="Has[@name='varName']/@value" />
						<xsl:text>);
                        </xsl:text>
					</xsl:if>
<xsl:text>  
		</xsl:text><xsl:value-of select="$assert" />
						<xsl:text>(</xsl:text>
						<xsl:value-of select="Has[@name='varName']/@value" /> <xsl:text>,</xsl:text>
						<xsl:value-of select="$creator" />
				<xsl:text>.</xsl:text>
						<xsl:value-of select="Has[@name='varApplyget']/@value" />
						<xsl:text>(</xsl:text>
						<xsl:text>)</xsl:text><xsl:if test="Has[@name='varApplyget']/@value='getSeparationposition'">,ParametersUtils.epsilon</xsl:if>
						<xsl:if test="Has[@name='varApplyget']/@value='getSepRetrait'">,ParametersUtils.epsilon</xsl:if>
						<xsl:if test="Has[@name='varApplyget']/@value='getSepretraitderiere'">,ParametersUtils.epsilon</xsl:if><xsl:text>);
                        </xsl:text>
					
					<xsl:text>
</xsl:text>
</xsl:if>
				</xsl:for-each>

				<xsl:text>    
		try {
		</xsl:text>
			<xsl:value-of select="$creator" />
					<xsl:text>.</xsl:text>
					<xsl:value-of select="$function" />
					<xsl:text>(</xsl:text>
					<xsl:text>);
</xsl:text>
<xsl:text>
	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	</xsl:text>
				
<xsl:text>  
	}
</xsl:text>
			</xsl:for-each>

		</xsl:for-each>
		<xsl:text>}
</xsl:text>
	</xsl:template>

</xsl:stylesheet>
