package dressing.ui.project;



import javax.inject.Inject;

import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

import dressing.model.ProjectManager;
import dressing.model.SuperCadProject;

public class OpenProjectPage extends WizardPage {
	
	private IEventBroker eventBroker;
	ProjectComposite compos;
	private boolean isProjectSelected;

	public  SuperCadProject project;
	@Inject
	protected OpenProjectPage(SuperCadProject iproject) {
		super("Import project");
		setDescription("Séléctionner un projet puis clicker Terminer");
		this.project = iproject;
		
	}

	@Override
	public void createControl(Composite parent) {
		compos = new ProjectComposite(parent, SWT.NONE);
		compos.setProject(this.project);

		setControl(compos);
		if(project!=null) {
			compos.getTableViewer().setSelection(new StructuredSelection(project),true);
		}
		compos.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener() {
		    @Override
		    public void selectionChanged(SelectionChangedEvent event) {
		    	   IStructuredSelection selection = (IStructuredSelection) event.getSelection();
			  	      Object selectionobj=  selection.getFirstElement() ;
			        project = (SuperCadProject)selectionobj;
			        if(isCurrentPage()) {
						getWizard().getContainer().updateButtons();
					}
		    }
		 });
	}

	@Override
	public boolean isPageComplete() {
		return (this.project!=null && this.project.getCreationDate() != null);
	}

	public SuperCadProject getProject() {
		return project;
	}

	public void setProject(SuperCadProject project) {
		this.project = project;
	}

	
	
	
	
	
	

}
