package dressing.ui.configuration;

import java.beans.PropertyChangeListener;
import java.util.List;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

import dressing.model.DesignObject3D;
import dressing.model.Parameters;
import dressing.ui.util.DoubleCellEditor;
import dressing.ui.util.SpinnerCellEditor;
import dressing.ui.util.SwtTextFilter;

public class CustomParametersComposite extends Composite {
	public static final String NAME = "Name";
	public DesignObject3D designObject3d = null;
	public static final String DEFAULT_VALUE= "Valeur par defaut";
	public static final String CODE = "Code";
	public static final String VALEUR = "Valeur";
	public static final String[] PROPS = { NAME, DEFAULT_VALUE,CODE,VALEUR };
	private Table table;
	private TableViewer tableViewer;
	PropertyChangeListener pcl;
	/**
	 * Create the composite.
	 * @param parent
	 * @param style
	 */
	public CustomParametersComposite(Composite parent, int style, DesignObject3D designObject3d) {
		super(parent, style);
		setDesignObject3d(designObject3d);
		initTable();
	}

	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}

	public DesignObject3D getDesignObject3d() {
		return designObject3d;
	}

	public void setDesignObject3d(DesignObject3D designObject3d) {
		this.designObject3d = designObject3d;
		if(tableViewer !=null && !this.isDisposed())
		{
			tableViewer.setInput(this.designObject3d.getParams());
			tableViewer.refresh();

		}

	}
	private void initTable()
	{
		setLayout(new GridLayout(1, false));
		tableViewer = new TableViewer(this, SWT.BORDER | SWT.FULL_SELECTION|SWT.FILL);
		tableViewer.setContentProvider(new ParametersContentProvider());
		tableViewer.setLabelProvider(new ParametersLabelProvider(tableViewer,this.designObject3d));
		tableViewer.setInput(this.designObject3d.getParams());

		table = tableViewer.getTable();
		GridData gd_table = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		gd_table.widthHint = 590;
//		GridLayout gl_table= new GridLayout(4, true);
//		table.setLayout(gl_table);
		table.setLayoutData(gd_table);

		TableColumn tblClmn=  new TableColumn(table, SWT.LEFT);
	    tblClmn.setText(NAME);
	    tblClmn.setWidth(126);
//	    tblClmn.setWidth(tblClmn.getDisplay().getClientArea().width);
//	    System.out.println(tblClmn.getDisplay().getClientArea().width+ "  "+tblClmn.getDisplay().getClass());
	    TableColumn tblClmn1=  new TableColumn(table, SWT.LEFT);
	    tblClmn1.setText(DEFAULT_VALUE);
	    tblClmn1.setWidth(85);
	    
	    TableColumn tblClmn2=  new TableColumn(table, SWT.LEFT);
	    tblClmn2.setText(CODE);
	    tblClmn2.setWidth(266);	
	    tblClmn2.setMoveable(true);
	    TableColumn tblClmn3=  new TableColumn(table, SWT.LEFT);
	    tblClmn3.setText(VALEUR);
	    tblClmn3.setWidth(109);	
		for (int i = 0, n = table.getColumnCount(); i < n; i++) {
			table.getColumn(i).pack();
		}
		for (int i = 0, n = table.getItemCount(); i < n; i++) {
			table.getItem(i).setGrayed(false);
		}
		ControlAdapter cal= new ControlAdapter() {
		
		    public void controlResized(ControlEvent e) {
		    	
		      Rectangle area = CustomParametersComposite.this.getClientArea();
		      Point preferredSize = table.computeSize(SWT.DEFAULT, SWT.DEFAULT);
		      int width = area.width - 2*table.getBorderWidth();
		      if (preferredSize.y > area.height + table.getHeaderHeight()) {
		        // Subtract the scrollbar width from the total column width
		        // if a vertical scrollbar will be required
		        Point vBarSize = table.getVerticalBar().getSize();
		        width -= vBarSize.x;
		      }
		      Point oldSize = table.getSize();
		      if (oldSize.x > area.width) {
		        // table is getting smaller so make the columns 
		        // smaller first and then resize the table to
		        // match the client area width
		        tblClmn.setWidth(width/3-2*table.getBorderWidth());
		        tblClmn1.setWidth(width/6-2*table.getBorderWidth());
		        tblClmn2.setWidth(width/3-2*table.getBorderWidth());
		        tblClmn3.setWidth(width/6-2*table.getBorderWidth());
		        table.setSize(area.width, area.height);
		      } else {
		        // table is getting bigger so make the table 
		        // bigger first and then make the columns wider
		        // to match the client area width
		        table.setSize(area.width, area.height);
		        tblClmn.setWidth(width/3-2*table.getBorderWidth());
		        tblClmn1.setWidth(width/6-2*table.getBorderWidth());
		        tblClmn2.setWidth(width/3-2*table.getBorderWidth());
		        tblClmn3.setWidth(width/6-2*table.getBorderWidth());
		      }
		    }};
		
		  
		this.addControlListener(cal);
		table.addControlListener(cal);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		tableViewer.refresh();

		CellEditor[] editors = new CellEditor[4];
		editors[0] = new TextCellEditor(table);
		editors[0].getControl().setEnabled(false);
		editors[1] = new TextCellEditor(table);
		editors[1].getControl().setEnabled(false);
		editors[2]=new TextCellEditor(table);
		editors[2].getControl().setEnabled(false);
//		editors[2].getControl().setTextDirection(SWT.LEFT_TO_RIGHT);
//		editors[3]=new TextCellEditor(table);
		editors[3]=new DoubleCellEditor(table);
//		editors[3]=new SpinnerCellEditor(table);
		editors[3].getControl().setEnabled(true);
		editors[3].getControl().setTextDirection(SWT.LEFT_TO_RIGHT);
		((DoubleCellEditor)editors[3]).setMaximum(10000, 3);

		tableViewer.setColumnProperties(PROPS);
		tableViewer.setCellModifier(new ParametersCellModifier(tableViewer));
		tableViewer.setCellEditors(editors);
	
	}
	public void clearlistners() {
		designObject3d.removePropertyChangeListener(pcl);
	}
	
	private ColumnLabelProvider createLabelProviderFor(final TableViewer viewer) {
		return new ColumnLabelProvider() {
			boolean isEvenIdx = true;

			@Override
			public Color getBackground(Object element) {
				Parameters param=((Parameters)element);
				Color grayColor = viewer.getTable().getDisplay()
						.getSystemColor(SWT.COLOR_GRAY);

				return (param.getDefaultValue()==param.getValue() ? null : grayColor);
			}

			@Override
			public void update(ViewerCell cell) {
				super.update(cell);
			}
		};
	}
	private TableViewerColumn createColumnFor(TableViewer viewer, String label) {
		TableViewerColumn column;
		column = new TableViewerColumn(viewer, SWT.NONE);
		column.getColumn().setWidth(200);
		column.getColumn().setText(label);
		column.setLabelProvider(createLabelProviderFor(viewer));
		return column;
	}
}
class ParametersContentProvider implements IStructuredContentProvider {
	/**
	 * Returns the Person objects
	 */
	public Object[] getElements(Object inputElement) {
		return ((List) inputElement).toArray();
	}
}

/**
 * This class provides the content for the FoodList application
 */
class ParametersCellModifier implements ICellModifier {
	private TableViewer viewer;

	public ParametersCellModifier(TableViewer viewer) {
		this.viewer = viewer;
	}

	/**
	 * Returns whether the property can be modified
	 * 
	 * @param element
	 *            the element
	 * @param property
	 *            the property
	 * @return boolean
	 */
	public boolean canModify(Object element, String property) {
		// Allow editing of all values
		if (element instanceof Item)
			element = ((Item) element).getData();

		if (CustomParametersComposite.VALEUR.equals(property)) {
			return true;
		}
		else 
		{
			return false;
		}
		
	}

	/**
	 * Returns the value for the property
	 * 
	 * @param element
	 *            the element
	 * @param property
	 *            the property
	 * @return Object
	 */
	public Object getValue(Object element, String property) {
		if (element instanceof Item)
			element = ((Item) element).getData();

		Parameters p = (Parameters) element;
		if (CustomParametersComposite.NAME.equals(property))
			return p.getName();
		else if (CustomParametersComposite.DEFAULT_VALUE.equals(property))
		{			
			return p.getDefaultValue();						
		}else if(CustomParametersComposite.CODE.equals(property)) {
			return p.getCode();
		}else if (CustomParametersComposite.VALEUR.equals(property))
		{			
			return p.getValue();						
		}
			return null;
		
		
	}

	/**
	 * Modifies the element
	 * 
	 * @param element
	 *            the element
	 * @param property
	 *            the property
	 * @param value
	 *            the value
	 */
	public void modify(Object element, String property, Object value) {
		if (element instanceof Item)
			element = ((Item) element).getData();

		Parameters p = (Parameters) element;
		if (CustomParametersComposite.NAME.equals(property))
			p.setName((String) value);
		else if (CustomParametersComposite.VALEUR.equals(property))
		{			
			p.setValue((String) value);						
		}else if(CustomParametersComposite.CODE.equals(property)) {
			p.setCode((String)value);
		}else if(CustomParametersComposite.DEFAULT_VALUE.equals(property)) {
			p.setCode((String)value);
		}
		
		// Force the viewer to refresh
		viewer.refresh();
		
	}
}

class ParametersLabelProvider extends CustomParametersColorProvider implements ITableLabelProvider {
	/**
	 * Returns the image
	 * 
	 * @param element
	 *            the element
	 * @param columnIndex
	 *            the column index
	 * @return Image
	 */
	
	public Image getColumnImage(Object element, int columnIndex) {
//		((Item)element).getImage().setBackground(((Item)element).getDisplay().getSystemColor(SWT.COLOR_YELLOW));	
		return null;
	}

	public ParametersLabelProvider(TableViewer viewer, DesignObject3D designObject3d ) {
		super(viewer,designObject3d);
		// TODO Auto-generated constructor stub
	}

	/**
	 * Returns the column text
	 * 
	 * @param element
	 *            the element
	 * @param columnIndex
	 *            the column index
	 * @return String
	 */
	public String getColumnText(Object element, int columnIndex) {
		Parameters p = (Parameters) element;
		switch (columnIndex) {
		case 0:
			return p.getName();
		case 1:
			return p.getDefaultValue();
		case 2:
			return p.getCode();
		case 3:
			return p.getValue();
		}
		return null;
	}

	/**
	 * Adds a listener
	 * 
	 * @param listener
	 *            the listener
	 */
	public void addListener(ILabelProviderListener listener) {
		// Ignore it
	}

	/**
	 * Disposes any created resources
	 */
	public void dispose() {
		// Nothing to dispose
	}

	/**
	 * Returns whether altering this property on this element will affect the label
	 * 
	 * @param element
	 *            the element
	 * @param property
	 *            the property
	 * @return boolean
	 */
	public boolean isLabelProperty(Object element, String property) {
		return false;
	}

	/**
	 * Removes a listener
	 * 
	 * @param listener
	 *            the listener
	 */
	public void removeListener(ILabelProviderListener listener) {
		// Ignore
	}

}
class CustomParametersColorProvider implements ITableColorProvider{
TableViewer viewerr;
DesignObject3D designObject3d;
	public CustomParametersColorProvider(TableViewer viewer, DesignObject3D designObject3d) {
		viewerr=viewer;
		this.designObject3d=designObject3d;
		// TODO Auto-generated constructor stub
	}

	@Override
	public Color getForeground(Object element, int columnIndex) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Color getBackground(Object element, int columnIndex) {
		// TODO Auto-generated method stub
		if (element instanceof Item)
		{
			element = ((Item) element).getData();
		}
		if(element instanceof Parameters) {
			Parameters p = (Parameters) element;
			if(designObject3d.getParam(p)!=null && designObject3d.getParentdesign() != null && designObject3d.getParentdesign().getParam(p)!=null ){
				Parameters param1=designObject3d.getParentdesign().getParam(p);
				Parameters param2=designObject3d.getParam(p);							
				if(!param2.getDefaultValue().equals(param1.getValue())) {
					Color color=new Color(viewerr.getTable().getDisplay(),232, 144, 66);
					return color;
				}
			}
			if(!(p.getDefaultValue().equals(p.getValue()))) {
				Color color=new Color(viewerr.getTable().getDisplay(),232, 244, 66);
				return color;	
				}
			
		}

		return null;
	}
	
}
